<?php
/**
 * Post Content Template
 *
 * This template is the default page content template. It is used to display the content of the
 * `single.php` template file, contextually, as well as in archive lists or search results.
 *
 * @package WooFramework
 * @subpackage Template
 */

/**
 * Settings for this template file.
 *
 * This is where the specify the HTML tags for the title.
 * These options can be filtered via a child theme.
 *
 * @link http://codex.wordpress.org/Plugin_API#Filters
 */
 global $woo_options;
 
 $title_before = '<h1 class="title">';
 $title_after = '</h1>';
 
 if ( ! is_single() ) {
 
 	$title_before = '<h3 class="blog-title">';
 	$title_after = '</h3>';
 
	$title_before = $title_before . '<a href="' . get_permalink( get_the_ID() ) . '" rel="bookmark" title="' . the_title_attribute( array( 'echo' => 0 ) ) . '">';
	$title_after = '</a>' . $title_after;
 
 }
 
 $page_link_args = apply_filters( 'woothemes_pagelinks_args', array( 'before' => '<div class="page-link">' . __( 'Pages:', 'woothemes' ), 'after' => '</div>' ) );
 
 woo_post_before();
?>
<article <?php post_class(); ?>>
<?php
	if ( !is_singular() ){
		echo '<a href="' . get_permalink( get_the_ID() ) . '" rel="bookmark" title="">';
		the_post_thumbnail('thumbnail-full-blog');
		echo '</a>';
	}
?>
<?php
	// woo_post_meta();
?>
<div class="blog_full">
<?php echo '<div class="blog-post-meta">
      <span class="small"> '.do_shortcode( '[post_date after=" /"]' ) . do_shortcode( '[post_comments]' ) .'</span></div>'; ?>
	<header>
		<?php the_title( $title_before, $title_after ); ?>
	</header>

	<section class="entry">
	    <?php
	    	if ( isset($woo_options['woo_post_content']) &&  $woo_options['woo_post_content'] == 'content' || is_single() ) { the_content(__('Continue Reading &rarr;', 'woothemes') ); } else { the_excerpt(); }
	    	if ( isset($woo_options['woo_post_content']) && $woo_options['woo_post_content'] == 'content' || is_singular() ) wp_link_pages( $page_link_args );
	    ?>
	</section><!-- /.entry -->
</div>
	<div class="fix"></div>
<?php
	// woo_post_inside_after();
?>
</article><!-- /.post -->
<?php
	woo_post_after();

	$comm = '';
	if ( isset( $woo_options[ 'woo_comments' ] ) ) $comm = $woo_options[ 'woo_comments' ];
	if ( ( $comm == 'post' || $comm == 'both' ) && is_single() ) { comments_template(); }
?>