<?php
/**
 * Post Content Template
 *
 * This template is the default page content template. It is used to display the content of the
 * `single.php` template file, contextually, as well as in archive lists or search results.
 *
 * @package WooFramework
 * @subpackage Template
 */

/**
 * Settings for this template file.
 *
 * This is where the specify the HTML tags for the title.
 * These options can be filtered via a child theme.
 *
 * @link http://codex.wordpress.org/Plugin_API#Filters
 */
 global $woo_options;
 
 $title_before = '<h1 class="title">';
 $title_after = '</h1>';
 
 if ( ! is_single() ) {
 
 	$title_before = '<h3 class="blog-title">';
 	$title_after = '</h3>';
 
	$title_before = $title_before . '<a href="' . get_permalink( get_the_ID() ) . '" rel="bookmark" title="' . the_title_attribute( array( 'echo' => 0 ) ) . '">';
	$title_after = '</a>' . $title_after;
 
 }
 
 $page_link_args = apply_filters( 'woothemes_pagelinks_args', array( 'before' => '<div class="page-link">' . __( 'Pages:', 'woothemes' ), 'after' => '</div>' ) );
 
 woo_post_before();
?>
 

 

<?php	
	   $woo_options['woo_blog_grid_thumb_width'] = 308;
  

?>

<div class="blog-item-grid ">

  <div class="view view-sixth banner">
    <?php
  if ( !is_singular() ){
    echo '<div class="image-grid-man-post">';
    echo '<a href="' . get_permalink( get_the_ID() ) . '" rel="bookmark" title="">';
    the_post_thumbnail('full');
    echo '</a>';
    echo '</div>';
  }
    ?>
     
    <div class="mask-blog">
      <div class="overlay-blog custom_back custom_bor"></div>
    </div>
        <div class="borderbanner-blog">
          <span> <a  href="<?php the_permalink(); ?>" title="<?php get_the_title(); ?>" class="blog-link">
          <?php _e('READ MORE','woothemes');?> </a>  
          </span>
        </div>
    </div> 

    <div class="blog-item-description">
      <div class="blog-post-meta">
      <?php echo '<div class="blog-post-meta">
      <span class="small"> '.do_shortcode( '[post_date after=" /"]' ) . do_shortcode( '[post_comments]' ) .'</span></div>'; ?>
      </div>
        
            <a href="<?php the_permalink(); ?>" title="<?php get_the_title(); ?>"> 
                <?php the_title( $title_before, $title_after ); ?>
            </a>
        
          <div class="blog-list-item-excerpt">
            <p> 
             <?php echo  labomba_word_trim(get_the_excerpt(), '20', '...'); ?>
            </p> 
          </div>
    </div>

 


</div><!-- / content post -->
<?php
	woo_post_after();

	$comm = '';
	if ( isset( $woo_options[ 'woo_comments' ] ) ) $comm = $woo_options[ 'woo_comments' ];
	if ( ( $comm == 'post' || $comm == 'both' ) && is_single() ) { comments_template(); }
?>