<?php

/*-----------------------------------------------------------------------------------*/
/* Start WooThemes Functions - Please refrain from editing this section */
/*-----------------------------------------------------------------------------------*/

// Set path to WooFramework and theme specific functions
$functions_path = get_template_directory() . '/functions/';
$includes_path = get_template_directory() . '/includes/';

// Don't load alt stylesheet from WooFramework
if ( ! function_exists( 'woo_output_alt_stylesheet' ) ) {
	function woo_output_alt_stylesheet () {}
}
// Don't load shortcode stylesheet from WooFramework
if ( ! function_exists( 'woo_shortcode_stylesheet' ) ) {
	function woo_shortcode_stylesheet () {}
}
// WooFramework
require_once ( $functions_path . 'admin-init.php' );	// Framework Init

/*-----------------------------------------------------------------------------------*/
/* Load the theme-specific files, with support for overriding via a child theme.
/*-----------------------------------------------------------------------------------*/

$includes = array(
	'includes/theme-options.php', 			// Options panel settings and custom settings
	'includes/theme-functions.php', 		// Custom theme functions
	'includes/theme-actions.php', 			// Theme actions & user defined hooks
	'includes/theme-comments.php', 			// Custom comments/pingback loop
	'includes/theme-js.php', 				// Load JavaScript via wp_enqueue_script
	'includes/sidebar-init.php', 			// Initialize widgetized areas
	'includes/theme-widgets.php',			// Theme widgets
	'includes/theme-advanced.php',			// Advanced Theme Functions
	'includes/theme-shortcodes.php',	 	// Custom theme shortcodes
);

// Allow child themes/plugins to add widgets to be loaded.
$includes = apply_filters( 'woo_includes', $includes );

foreach ( $includes as $i ) {
	locate_template( $i, true );
}

// Load WooCommerce functions, if applicable.
if ( is_woocommerce_activated() ) {
	locate_template( 'includes/theme-woocommerce.php', true );
}

/*-----------------------------------------------------------------------------------*/
/* You can add custom functions below */
/*-----------------------------------------------------------------------------------*/







/*-----------------------------------------------------------------------------------*/
/* Don't add any code below here or the sky will fall down */
/*-----------------------------------------------------------------------------------*/
?>