<?php
/**
 * Header Template
 *
 * Here we setup all logic and XHTML that is required for the header section of all screens.
 *
 * @package WooFramework
 * @subpackage Template
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php echo esc_attr( get_bloginfo( 'charset' ) ); ?>" />
<title><?php woo_title(); ?></title>
<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>" />
<?php woo_head(); ?>
<?php wp_head(); ?>
</head>
<body id="body" <?php body_class(); ?>>
	<?php
    global $woo_options;

	$page_transition = isset( $woo_options['woo_page_loader'] ) ? $woo_options['woo_page_loader'] : '';
	$loading_animation_image = isset( $woo_options['woo_page_loader_image'] ) ? $woo_options['woo_page_loader_image'] : '';


	if( isset( $page_transition ) && $page_transition == 'true' ) { ?>
	    <div class="ajax_loader">
	        <div class="ajax_loader_1">
	            <?php if($loading_animation_image != ""){ ?>
	            <div class="ajax_loader_2">
	                <img src="<?php echo $loading_animation_image; ?>" alt="" />
	            </div><?php } else{ df_loading_spinners(); } ?>
	        </div>
	    </div>
	<?php } ?>

		<?php
	$settings = woo_get_dynamic_values(array( 'header_layout' => '' ));
	if($settings['header_layout']) {
		if(is_page('header-2')) {
			include_once('includes/headers/header-v2.php');
		} elseif(is_page('header-3')) {
			include_once('includes/headers/header-v3.php');
		} elseif(is_page('header-4')) {
			include_once('includes/headers/header-v4.php');
		} else {
			include_once('includes/headers/header-'.$settings['header_layout'].'.php');
		}
	} else {
		if(is_page('header-2')) {
			include_once('includes/headers/header-v2.php');
		} elseif(is_page('header-3')) {
			include_once('includes/headers/header-v3.php');
		} elseif(is_page('header-4')) {
			include_once('includes/headers/header-v4.php');
		} else {
			include_once('includes/headers/header-v1.php');
		}
	}

	?>