/*-------------------------------------------------------------------------------------

FILE INFORMATION

Description: Custom toggle logic for "Meta Options".
Date Created: 2011-07-06.
Author: Cobus, Matty.
Since: 4.3.0


TABLE OF CONTENTS

- Logic for toggling of the "Slide Page" option, depending on page template.

-------------------------------------------------------------------------------------*/

jQuery(document).ready(function(){

/*-----------------------------------------------------------------------------------*/
/* - Logic for toggling of the "Slide Page" option, depending on page template. */
/*-----------------------------------------------------------------------------------*/

	var showValue = 'template-lookbook.php';
	var elementName = 'select#page_template';
	var toggleElements = 'select[name="lookbook_category"] ';

	var showHome = 'template-home.php';
	var toggleHome = 'input[name="_banner"]:radio, select[name="_flexslide-group"], select[name="_revolutionslider"] ';
	
	// Hide elements to be hidden.
	jQuery( toggleElements ).parents( 'tr' ).hide();
	jQuery( toggleHome ).parents( 'tr' ).hide();
	
	// Toggle the main elements on load.
	if ( jQuery( elementName ).val() == showValue ) {
		jQuery( toggleElements ).parents( 'tr' ).show();
	} else {
		if ( jQuery( elementName ).val() == showHome ) {
		jQuery( toggleHome ).parents( 'tr' ).show();
		}
	}
	
	// Toggle the "Slide Page" option on change.
	jQuery( elementName ).change( function ( e ) {
		if ( jQuery( elementName ).val() == showValue ) {
			jQuery( toggleElements ).parents( 'tr' ).show();
		} else {
			jQuery( toggleElements ).parents( 'tr' ).hide();
		}
	});

	jQuery( elementName ).change( function ( e ) {
		if ( jQuery( elementName ).val() == showHome ) {
			jQuery( toggleHome ).parents( 'tr' ).show();
		} else {
			jQuery( toggleHome ).parents( 'tr' ).hide();
		}
	});

}); // End jQuery()