<?php
/*-----------------------------------------------------------------------------------*/
/* Theme Frontend JavaScript */
/*-----------------------------------------------------------------------------------*/

if ( ! is_admin() ) { add_action( 'wp_enqueue_scripts', 'woothemes_add_javascript' ); }

if ( ! function_exists( 'woothemes_add_javascript' ) ) {
	function woothemes_add_javascript() {
		global $woo_options;
		wp_enqueue_script('jquery-ui','https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js', array( 'jquery' ),'1.10.3', true);
		wp_enqueue_script( 'third-party', THEME_URI . '/includes/js/third-party.js', array( 'jquery' ),'', true );

		wp_register_script( 'responsive-tab', THEME_URI . '/includes/js/easyResponsiveTabs.js', array( 'jquery' ),'', true );
		wp_register_script( 'elevate-zoom', THEME_URI . '/includes/js/jquery.elevatezoom.min.js', array( 'jquery' ),'', true );
		wp_register_script( 'owlcarousel', THEME_URI . '/includes/js/owl.carousel.min.js', array( 'jquery' ) ,'', true);
		wp_register_script( 'swiper', THEME_URI . '/includes/js/idangerous.swiper.min.js', array( 'jquery' ),'', true );
		wp_register_script( 'owl-main', THEME_URI . '/includes/js/owl-main.min.js', array( 'jquery' ) ,'', true);
		wp_register_script( 'magnific-popup', THEME_URI . '/includes/js/jquery.magnific-popup.min.js', array( 'jquery' ), '' , true);
		wp_register_script( 'scripts-qv', THEME_URI . '/includes/js/scripts-qv.min.js', array( 'jquery' ), '', true );
		wp_register_script( 'float-menu', THEME_URI . '/includes/js/float-menu.min.js', array('jquery'), '', true );

		wp_enqueue_script( 'modernizr', THEME_URI . '/includes/js/modernizr.js', array( 'jquery' ), '2.7.0');

		wp_enqueue_script( 'script', THEME_URI . '/includes/js/script.min.js', array( 'jquery' ),'', true );
		wp_localize_script( 'script', 'woocommercetext', array(
		    'itemAdded' => __(' Item Added To Your Shopping Cart', 'woothemes'),
		    'itemAdded2' => __(' Items Added To Your Shopping Cart', 'woothemes'),
		    'continueShopping' => __( 'Continue Shopping', 'woothemes' ),
		    'checkoutItem' => __( 'Checkout', 'woothemes' ),
		    'Quantity' => __( 'Qty', 'woothemes' ),
		    'Error' => __('Something Wrong', 'woothemes')
        ) );

		do_action( 'woothemes_add_javascript' );

		wp_enqueue_script( 'general', THEME_URI . '/includes/js/general.js', array( 'jquery', 'third-party' ), '', true );

	} // End woothemes_add_javascript()
}
/*-----------------------------------------------------------------------------------*/
/* Float Menu */
/*-----------------------------------------------------------------------------------*/
if( !function_exists('LabombafloatMenu') ):
	function LabombafloatMenu(){
		global $woo_options;
		if (isset($woo_options['woo_float_menu']) && $woo_options['woo_float_menu'] == 'true' ) {
	 		wp_enqueue_script('float-menu');
		} /*if woo float menu*/
	}
	add_action( 'wp_enqueue_scripts', 'LabombafloatMenu' );
endif;
/*-----------------------------------------------------------------------------------*/
/* Theme Frontend CSS */
/*-----------------------------------------------------------------------------------*/

if ( ! is_admin() ) { add_action( 'wp_print_styles', 'woothemes_add_css' ); }

if ( ! function_exists( 'woothemes_add_css' ) ) {
	function woothemes_add_css() {
		global $woo_options;
		wp_register_style( 'non-responsive', THEME_URI . '/css/non-responsive.css' );
		wp_register_style( 'swiper', THEME_URI . '/includes/css/idangerous.swiper.css' );

		// Conditionally load the Portfolio CSS, where needed.
		$load_portfolio_css = false;

		if ( is_page_template( 'template-portfolio.php' ) || ( is_singular() && ( get_post_type() == 'portfolio' ) ) ||	is_post_type_archive( 'portfolio' )|| is_tax( 'portfolio-gallery' ) || is_page() ) {
			$load_portfolio_css = true;
		}

		// Allow child themes/plugins to load the portfolio CSS when they need it.
		$load_portfolio_css = apply_filters( 'woo_load_portfolio_css', $load_portfolio_css );



		do_action( 'woothemes_add_css' );
	} // End woothemes_add_css()
}
/*-----------------------------------------------------------------------------------*/
/* Page Loader JavaScript */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'df_page_loader_js_enqueue' ) ) :
	function df_page_loader_js_enqueue() {
	    global $woo_options;
		$page_transition = isset( $woo_options['woo_page_loader'] ) ? $woo_options['woo_page_loader'] : '';
		if( isset($page_transition) && $page_transition == 'true'){
			wp_enqueue_script( 'page-loader', THEME_URI . '/includes/js/page-loader.min.js', array( 'jquery' ),'', true );
		}
	}
		add_action( 'wp_enqueue_scripts', 'df_page_loader_js_enqueue' );
endif;
/*-----------------------------------------------------------------------------------*/
/* Theme Admin JavaScript */
/*-----------------------------------------------------------------------------------*/

if ( is_admin() ) { add_action( 'admin_enqueue_scripts', 'woothemes_add_admin_javascript' ); }

if ( ! function_exists( 'woothemes_add_admin_javascript' ) ) {
	function woothemes_add_admin_javascript() {
		global $pagenow;

		if ( ( $pagenow == 'post.php' || $pagenow == 'post-new.php' ) && ( get_post_type() == 'page' ) ) {
			wp_enqueue_script( 'woo-postmeta-options-custom-toggle', THEME_URI . '/includes/js/meta-options-custom-toggle.js', array( 'jquery' ), '1.0.0' );
		}

	} // End woothemes_add_admin_javascript()
}

/* ----------------------------------------------------------------------------------- */
/* GLobal Localize                                 */
/* ----------------------------------------------------------------------------------- */
if ( ! function_exists('df_global_localize') ) :

    function df_global_localize(){

    	$image_url_infiscr = get_template_directory_uri() . "/images/loading.gif";
        wp_localize_script( 'script', 'infinite_scroll', array(
            'image_url_infi' => $image_url_infiscr,
            'all_load' => __('All Blog Loaded','woothemes'),
        ) );

    }
endif;
add_action('woothemes_add_javascript', 'df_global_localize', 99 );