<?php
// File Security Check
if ( ! empty( $_SERVER['SCRIPT_FILENAME'] ) && basename( __FILE__ ) == basename( $_SERVER['SCRIPT_FILENAME'] ) ) {
    die ( 'You do not have sufficient permissions to access this page' );
}
?>
<?php

if (!function_exists('woo_options')) {
function woo_options() {

// THEME VARIABLES
$themename = "LaBomba";
$themeslug = "labomba";

// STANDARD VARIABLES. DO NOT TOUCH!
$shortname = "woo";
$manualurl = 'http://labomba.dahztheme.com/documentation/';

//Access the WordPress Categories via an Array
$woo_categories = array();
$woo_categories_obj = get_categories('hide_empty=0');
foreach ($woo_categories_obj as $woo_cat) {
    $woo_categories[$woo_cat->cat_ID] = $woo_cat->cat_name;}
$categories_tmp = array_unshift($woo_categories, "Select a category:");

//Access the WordPress Pages via an Array
$woo_pages = array();
$woo_pages_obj = get_pages('sort_column=post_parent,menu_order');
foreach ($woo_pages_obj as $woo_page) {
    $woo_pages[$woo_page->ID] = $woo_page->post_name; }
$woo_pages_tmp = array_unshift($woo_pages, "Select a page:");

//Stylesheets Reader
$alt_stylesheet_path = get_template_directory() . '/styles/';
$alt_stylesheets = array();

if ( is_dir($alt_stylesheet_path) ) {
    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) {
        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) {
            if(stristr($alt_stylesheet_file, ".css") !== false) {
                $alt_stylesheets[] = $alt_stylesheet_file;
            }
        }
    }
}


// More Options


//Revolution Slider
$revolutionslider = array();
$revolutionslider[0] = __('No Slider', 'woothemes');

if(class_exists('RevSlider')){
    $slider = new RevSlider();
    $arrSliders = $slider->getArrSliders();
    foreach($arrSliders as $revSlider) {
        $revolutionslider[$revSlider->getAlias()] = $revSlider->getTitle();
    }
} else {
		$revolutionslider[0] = __('Install RevolutionSlider Plugin First!', 'woothemes');
	}

$revslider_options = $revolutionslider;


$options_pixels = array("0px","1px","2px","3px","4px","5px","6px","7px","8px","9px","10px","11px","12px","13px","14px","15px","16px","17px","18px","19px","20px");
$other_entries = array("Select a number:","0","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
$other_entries_2 = array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
$options_opacity = array("Select a number:","0.1","0.2","0.3","0.4","0.5","0.6","0.7","0.8","0.9","1");
$tumblog_options = array("Disabled","Before","After");
$options_image_link_to = array("image" => __( 'The Image', 'woothemes' ),"post" => __( 'The Post', 'woothemes' ) );

// Below are the various theme options.
/* General Settings */
$options = array();

$options[] = array( "name" => __( 'General Settings', 'woothemes' ),
					"icon" => "general",
                    "type" => "heading");

$options[] = array( 'name' => __( 'Quick Start', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Custom Logo', 'woothemes' ),
					"desc" => __( 'Change your Logo here, upload or enter the URL to your logo image.', 'woothemes' ),
					"id" => $shortname."_logo",
					"std" => THEME_URI."/images/logo.png",
					"type" => "upload");
// Retina Logo
$options[] = array( "name" => __( 'Custom Retina Logo', 'woothemes' ),
					"desc" => __( 'Upload your Retina Logo. This should be your Logo in double size (If your logo is 100 x 20px, it should be 200 x 40px)', 'woothemes' ),
					"id" => $shortname."_retina_logo",
					"std" => '',
					"type" => "upload");
$options[] = array( "name" => __( 'Original Logo Width', 'woothemes' ),
					"desc" => __( 'If Retina Logo uploaded, please enter the width of the Standard Logo you\'ve uploaded (not the Retina Logo)', 'woothemes' ),
					"id" => $shortname."_width_logo",
					"std" => '',
					"type" => "text");
$options[] = array( "name" => __( 'Original Logo Height', 'woothemes' ),
					"desc" => __( 'If Retina Logo uploaded, please enter the height of the Standard Logo you\'ve uploaded (not the Retina Logo)', 'woothemes' ),
					"id" => $shortname."_height_logo",
					"std" => '',
					"type" => "text");
// Mobile Logo
$options[] = array( "name" => __( 'Custom Mobile Logo ', 'woothemes' ),
					"desc" => __( 'Change your mobile logo here, upload or enter the URL to your logo image.', 'woothemes' ),
					"id" => $shortname."_mom_logo",

					"type" => "upload");

$options[] = array( "name" => __( 'Upload Back To Top Image ', 'woothemes' ),
					"desc" => __( 'Change your back to top image.', 'woothemes' ),
					"id" => $shortname."_btt_image",

					"type" => "upload");

$options[] = array( "name" => __( 'Custom Favicon', 'woothemes' ),
					"desc" => __( 'A favicon is a 16x16 pixel icon that represents your site; upload your custom Favicon here.', 'woothemes' ),
					"id" => $shortname."_custom_favicon",
					"std" => THEME_URI."/images/favicon-16x16.png",
					"type" => "upload");

$options[] = array( "name" => __( 'Custom Favicon iPhone', 'woothemes' ),
					"desc" => __( 'Upload a custom favicon for iPhone (57x57 pixel png).', 'woothemes' ),
					"id" => $shortname."_custom_favicon_iphone",
					"std" => THEME_URI."/images/favicon-57x57.png",
					"type" => "upload");
$options[] = array( "name" => __( 'Custom Favicon iPhone Retina', 'woothemes' ),
					"desc" => __( 'Upload a custom favicon for iPhone retina (114x114 pixel png).', 'woothemes' ),
					"id" => $shortname."_custom_favicon_iphone_retina",
					"std" => THEME_URI."/images/favicon-114x114.png",
					"type" => "upload");
$options[] = array( "name" => __( 'Custom Favicon iPad', 'woothemes' ),
					"desc" => __( 'Upload a custom favicon for iPad  (72x72 pixel png).', 'woothemes' ),
					"id" => $shortname."_custom_favicon_ipad",
					"std" => THEME_URI."/images/favicon-72x72.png",
					"type" => "upload");
$options[] = array( "name" => __( 'Custom Favicon iPad Retina', 'woothemes' ),
					"desc" => __( 'Upload a custom favicon for iPhone retina (144x144 pixel png).', 'woothemes' ),
					"id" => $shortname."_custom_favicon_ipad_retina",
					"std" => THEME_URI."/images/favicon-144x144.png",
					"type" => "upload");

$options[] = array( "name" => __( 'Tracking Code', 'woothemes' ),
					"desc" => __( 'Paste your web analytics\' tracking code here.', 'woothemes' ),
					"id" => $shortname."_google_analytics",
					"std" => "",
					"type" => "textarea");

$options[] = array( 'name' => __( 'Subscription Settings', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'RSS URL', 'woothemes' ),
					"desc" => __( 'Enter your preferred RSS URL. (Feedburner or other)', 'woothemes' ),
					"id" => $shortname."_feed_url",
					"std" => "",
					"type" => "text");

$options[] = array( 'name' => __( 'Display Options', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Custom CSS', 'woothemes' ),
                    "desc" => __( 'Quickly add some CSS to your theme by adding it to this block.', 'woothemes' ),
                    "id" => $shortname."_custom_css",
                    "std" => "",
                    "type" => "textarea");

$options[] = array( "name" => __( 'Post/Page Comments', 'woothemes' ),
					"desc" => __( 'Choose where users are allowed to post comment in your website.', 'woothemes' ),
					"id" => $shortname."_comments",
					"type" => "select2",
					"options" => array( "post" => __( 'Posts Only', 'woothemes' ), "page" => __( 'Pages Only', 'woothemes' ), "both" => __( 'Pages / Posts', 'woothemes' ), "none" => __( 'None', 'woothemes' ) ) );

$options[] = array( "name" => __( 'Display Breadcrumbs', 'woothemes' ),
					"desc" => __( 'Display dynamic breadcrumbs on each page of your website.', 'woothemes' ),
					"id" => $shortname."_breadcrumbs_show",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Pagination Style', 'woothemes' ),
					"desc" => __( 'Choose the pagination style you would like to use.', 'woothemes' ),
					"id" => $shortname."_pagination_type",
					"type" => "select2",
					"options" => array(
						"paginated_links" => __( 'Numbers', 'woothemes' ),
						"simple" => __( 'Next/Previous', 'woothemes' ),
						// "custom" => __( 'Next/Previous + Numbers', 'woothemes' ),
						"custom2" => __( 'Next (infinite scroll)', 'woothemes' ),
						) );

$options[] = array( "name" => __( 'Enable Page Loader', 'woothemes' ),
					"id" => $shortname."_page_loader",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Enable Loading Animation', 'woothemes' ),
					"id" => $shortname."_page_loader_animation",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Select Loading Animation Style', 'woothemes' ),
					"id" => $shortname."_page_loader_type",
					"type" => "select2",
					"options" => array(
						"pulse" => __( 'Pulse', 'woothemes' ),
						"double_pulse" => __( 'Double Pulse', 'woothemes' ),
						"cube" => __( 'Cube', 'woothemes' ),
						"rotating_cubes" => __( 'Rotating Cubes', 'woothemes' ),
						"stripes" => __( 'Stripes', 'woothemes' ),
						"wave" => __( 'Wave', 'woothemes' ),
						"two_rotating_circles" => __( 'Two Rotating Circles', 'woothemes' ),
						"five_rotating_circles" => __( 'Five Rotating Circles', 'woothemes' ),
						) );
$options[] = array( "name" =>  __( 'Loading Animation Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for loading animation color or add a hex color code e.g. #e6e6e6', 'woothemes' ),
					"id" => $shortname."_page_loader_type_color",
					"std" => "",
					"type" => "color");

$options[] = array( "name" =>  __( 'Loading Page Background', 'woothemes' ),
					"desc" => __( 'Pick a custom color for loading background color or add a hex color code e.g. #e6e6e6', 'woothemes' ),
					"id" => $shortname."_page_loader_color",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Loading Image', 'woothemes' ),
					"desc" => __( 'Upload a background image, or specify the image address of your image. (http://yoursite.com/image.png)', 'woothemes' ),
					"id" => $shortname."_page_loader_image",
					"std" => "",
					"type" => "upload");

/* General Styling */

$options[] = array( "name" => __( 'Styling &amp; Layout', 'woothemes' ),
					"icon" => "styling",
					"type" => "heading");

$options[] = array( 'name' => __( 'General Styling', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Disable ALL Custom Styling', 'woothemes' ),
					"desc" => __( 'Disable output of all custom styling (CSS) from the theme options and use default styles from the stylesheet.', 'woothemes' ),
					"id" => $shortname."_style_disable",
					"std" => "true",
					"type" => "checkbox");

$options[] = array( "name" =>  __( 'Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for site background or add a hex color code e.g. #e6e6e6', 'woothemes' ),
					"id" => $shortname."_style_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Background Image', 'woothemes' ),
					"desc" => __( 'Upload a background image, or specify the image address of your image. (http://yoursite.com/image.png)', 'woothemes' ),
					"id" => $shortname."_style_bg_image",
					"std" => "",
					"type" => "upload");

$options[] = array( "name" => __( 'Background Image Repeat', 'woothemes' ),
					"desc" => __( 'Choose how you want your background to appear in your website.', 'woothemes' ),
					"id" => $shortname."_style_bg_image_repeat",
					"type" => "select",
					"options" => array( "No Repeat" => "no-repeat", "Repeat" => "repeat","Repeat Horizontally" => "repeat-x", "Repeat Vertically" => "repeat-y" ) );

$options[] = array( 'name' => __( 'Background image position', 'woothemes' ),
					'desc' => __( 'Choose the position of your background image in your website.', 'woothemes' ),
					'id' => $shortname . '_style_bg_image_pos',
					'std' => 'top left',
					'type' => 'select',
					'options' => array( "top left", "top center", "top right", "center left", "center center", "center right", "bottom left", "bottom center", "bottom right" ) );

$options[] = array( "name" => __( 'Background Attachment', 'woothemes' ),
            		"desc" => __( 'Choose whether the background should be fixed or move when the user scrolls.', 'woothemes' ),
            		"id" => $shortname."_style_bg_image_attach",
            		"std" => "scroll",
            		"type" => "select",
            		"options" => array( "scroll","fixed" ) );

$options[] = array( "name" => __( 'Top Border', 'woothemes' ),
					"desc" => __( 'Specify border properties for the top border.', 'woothemes' ),
					"id" => $shortname."_border_top",
					"std" => array('width' => '0','style' => 'solid','color' => '#000000'),
					"type" => "border");
/*
$options[] = array( 'name' => __( 'Links', 'woothemes' ),
					'type' => 'subheading' );
*/
$options[] = array( "name" => __( 'Link Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for links or add a hex color code e.g. #697e09', 'woothemes' ),
					"id" => $shortname."_link_color",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Link Hover Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for links hover or add a hex color code e.g. #697e09', 'woothemes' ),
					"id" => $shortname."_link_hover_color",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Button Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for buttons or add a hex color code e.g. #697e09', 'woothemes' ),
					"id" => $shortname."_button_color",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Button Hover Color', 'woothemes' ),
					"desc" => __( 'Pick a custom hover color for buttons or add a hex color code e.g. #697e09', 'woothemes' ),
					"id" => $shortname."_button_hover_color",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'General Border Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for general border colors or add a hex color code e.g. #e6e6e6', 'woothemes' ),
					"id" => $shortname."_style_border",
					"std" => "",
					"type" => "color");

$options[] = array( "name" =>  __( 'Background Color For Masking Portfolio And Blog', 'woothemes' ),
                    "desc" => __( 'Pick a custom color or add a hex color code e.g. #e6e6e6', 'woothemes' ),
                    "id" => $shortname."_style_mask_bg",
                    "std" => "",
                    "type" => "color");

$options[] = array( "name" => __( 'Opacity For Background Masking', 'woothemes' ),
					"desc" => __( 'Set amount of opacity.', 'woothemes' ),
					"id" => $shortname."_opa_mask",
					"type" => "select",
					"std" => "",
					"options" => $options_opacity);

$options[] = array( "name" => __( 'Border For Background Masking', 'woothemes' ),
					"desc" => __( 'Specify border properties for the background masking.', 'woothemes' ),
					"id" => $shortname."_mask_border",
					"std" => array('width' => '1','style' => 'solid','color' => '#fff'),
					"type" => "border");

$options[] = array( "name" => __( 'Font Style Masking', 'woothemes' ),
					"desc" => __( 'Select typography.', 'woothemes' ),
					"id" => $shortname."_mask_font",
					"std" => array('size' => '13','unit' => 'px', 'face' => 'Open Sans','style' => 'thin','color' => '#999'),
					"type" => "typography");
// general layout
$options[] = array( 'name' => __( 'General Layout', 'woothemes' ),
					'type' => 'subheading' );

$images_dir =  THEME_URI . '/functions/images/';

$options[] = array( "name" => __( 'Main Layout', 'woothemes' ),
						"desc" => __( 'Select main content and sidebar alignment. Choose between 1, 2 or 3 column layout.', 'woothemes' ),
						"id" => $shortname . "_layout",
						"std" => "two-col-left",
						"type" => "images",
						"options" => array(
							'one-col' => $images_dir . '1c.png',
							'two-col-left' => $images_dir . '2cl.png',
							'two-col-right' => $images_dir . '2cr.png')
						);


$url =  THEME_URI . '/functions/images/';
$options[] = array( "name" => __( 'Footer Widget Areas', 'woothemes' ),
					"desc" => __( 'Select how many footer widget areas you want to display.', 'woothemes' ),
					"id" => $shortname."_footer_sidebars",
					"std" => "4",
					"type" => "images",
					"options" => array(
						'0' => $url . 'footer-widgets-0.png',
						'1' => $url . 'footer-widgets-1.png',
						'2' => $url . 'footer-widgets-2.png',
						'3' => $url . 'footer-widgets-3.png',
						'4' => $url . 'footer-widgets-4.png')
					);

$options[] = array( "name" => __( 'Extra Footer Widget Areas', 'woothemes' ),
					"desc" => __( 'Select how many extra footer widget areas you want to display.', 'woothemes' ),
					"id" => $shortname."_extra_footer_sidebars",
					"std" => "6",
					"type" => "images",
					"options" => array(
						'0' =>  $url . 'footer-widgets-0.png',
						'1' =>  $url . 'footer-widgets-1.png',
						'2' =>  $url . 'footer-widgets-2.png',
						'3' =>  $url . 'footer-widgets-3.png',
						'4' =>  $url . 'footer-widgets-4.png',
						'5' =>  $url . 'footer-widgets-5.png',
						'6' =>  $url . 'footer-widgets-6.png')
					);

// $options[] = array( "name" => __( 'Enable Fixed Mobile Layout', 'woothemes' ),
// 					"desc" => __( 'Canvas is responsive, meaning it adapts its layout on mobile devices. Enabling Fixed Layout will remove the responsive layout on mobile devices.', 'woothemes' ),
// 					"id" => $shortname."_remove_responsive",
// 					"std" => "false",
// 					"type" => "checkbox");

$options[] = array( "name" => __( 'Category Exclude - Homepage', 'woothemes' ),
					"desc" => __( 'Choose which category(s) you\'d like to exclude from your homepage(Separate categories with commas).', 'woothemes' ),
					"id" => $shortname."_exclude_cats_home",
					"std" => "",
					"type" => "text" );

$options[] = array( "name" => __( 'Category Exclude - Blog Page Template', 'woothemes' ),
					"desc" => __( 'Choose which category(s) you\'d like to exclude from your \'Blog\' page. Separate categories with commas.', 'woothemes' ),
					"id" => $shortname."_exclude_cats_blog",
					"std" => "",
					"type" => "text" );

/* Boxed Layout */
$options[] = array( 'name' => __( 'Boxed Layout', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Boxed Layout Style', 'woothemes' ),
					"desc" => __( 'Enable the boxed layout style.', 'woothemes' ),
					"id" => $shortname."_layout_boxed",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Box Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the boxed background or add a hex color code e.g. #ffffff', 'woothemes' ),
					"id" => $shortname."_style_box_bg",
					"std" => "#ffffff",
					"type" => "color");

$options[] = array( "name" => __( 'Box Margin', 'woothemes' ),
					"desc" => __( 'Enter an integer value i.e. 20 for the desired top and bottom margin.', 'woothemes' ),
					"id" => $shortname."_box_margin",
					"std" => "",
					"type" => array(
									array(  'id' => $shortname. '_box_margin_top',
											'type' => 'text',
											'std' => '0',
											'meta' => __( 'Top', 'woothemes' ) ),
									array(  'id' => $shortname. '_box_margin_bottom',
											'type' => 'text',
											'std' => '0',
											'meta' => __( 'Bottom', 'woothemes' ) )
								  ));

$options[] = array( "name" => __( 'Box Border Top/Bottom', 'woothemes' ),
					"desc" => __( 'Specify border properties for the boxed layout.', 'woothemes' ),
					"id" => $shortname."_box_border_tb",
					"std" => array('width' => '1','style' => 'solid','color' => '#dbdbdb'),
					"type" => "border");

$options[] = array( "name" => __( 'Box Border Left/Right', 'woothemes' ),
					"desc" => __( 'Specify border properties for the boxed layout.', 'woothemes' ),
					"id" => $shortname."_box_border_lr",
					"std" => array('width' => '1','style' => 'solid','color' => '#dbdbdb'),
					"type" => "border");

$options[] = array( "name" => __( 'Box Rounded Corners', 'woothemes' ),
					"desc" => __( 'Set amount of pixels for border radius (rounded corners). Will only show in CSS3 compatible browser.', 'woothemes' ),
					"id" => $shortname."_box_border_radius",
					"type" => "select",
					"std" => "0px",
					"options" => $options_pixels);

$options[] = array( "name" => __( 'Box Shadow', 'woothemes' ),
					"desc" => __( 'Enable box shadow. Will only show in CSS3 compatible browser.', 'woothemes' ),
					"id" => $shortname."_box_shadow",
					"std" => "true",
					"type" => "checkbox");

/* Full width Layout */

$options[] = array( 'name' => __( 'Full Width Layout', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Full Width Layout', 'woothemes' ),
					"desc" => "",
					"id" => $shortname."_full_width_notice",
					"std" => __( 'Below you can enable full width header and footer areas and set the background. You can set the styling options for the full width navigation under the Primary Navigation options. Please note that Boxed Layout must be disabled.', 'woothemes' ),
					"type" => "info");

$options[] = array( "name" => __( 'Enable Full Width Header', 'woothemes' ),
					"desc" => __( 'Set header container to display full width.', 'woothemes' ),
					"id" => $shortname."_header_full_width",
					"std" => "false",
					"type" => "checkbox" );

$options[] = array( "name" => __( 'Header Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for header background or add a hex color code e.g. #e6e6e6.', 'woothemes' ),
					"id" => $shortname."_full_header_full_width_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Header Background Image', 'woothemes' ),
					"desc" => __( 'Upload a background image for your header, or specify the image address of your image. (http://yoursite.com/image.png). note: Image should have the same width with your website\'s', 'woothemes' ),
					"id" => $shortname."_full_header_bg_image",
					"std" => "",
					"type" => "upload");

$options[] = array( "name" => __( 'Header Background Image Repeat', 'woothemes' ),
					"desc" => __( 'Choose how you want your background image to appear in your website.', 'woothemes' ),
					"id" => $shortname."_full_header_bg_image_repeat",
					"type" => "select",
					"options" => array("No Repeat" => "no-repeat", "Repeat" => "repeat","Repeat Horizontally" => "repeat-x", "Repeat Vertically" => "repeat-y",) );

$options[] = array( "name" => __( 'Enable Full Width Footer', 'woothemes' ),
					"desc" => __( 'Set footer widget area and footer container to display full width.', 'woothemes' ),
					"id" => $shortname."_footer_full_width",
					"std" => "true",
					"type" => "checkbox" );

$options[] = array( "name" => __( 'Footer Widget Area Background Color', 'woothemes' ),
					"desc" => __( 'Select the background color you want for your full width widget area.', 'woothemes' ),
					"id" => $shortname."_foot_full_width_widget_bg",
					"std" => "#ffffff",
					"type" => "color");

$options[] = array( "name" => __( 'Footer Background Color', 'woothemes' ),
					"desc" => __( 'Select the background color you want for your full width footer.', 'woothemes' ),
					"id" => $shortname."_footer_full_width_bg",
					"std" => "#fafafa",
					"type" => "color");

/* Top Navigation */
$options[] = array( 'name' => __( 'Top Navigation', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Top Navigation - Background Color', 'woothemes' ),
					"desc" => sprintf( __( 'Pick a custom color for the top navigation background or add a hex color code e.g. #000.<br />Top Navigation can be added with <a href="%s">WP Menus</a>', 'woothemes' ), admin_url( 'nav-menus.php' ) ),
					"id" => $shortname."_top_nav_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Top Navigation - Background Color Hover', 'woothemes' ),
					"desc" => sprintf( __( 'Pick a custom color for the top navigation background hover or add a hex color code e.g. #000.<br />Top Navigation can be added with <a href="%s">WP Menus</a>', 'woothemes' ), admin_url( 'nav-menus.php' ) ),
					"id" => $shortname."_top_nav_bg_hover",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Top Navigation - Hover Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the top navigation hover text color or add a hex color code e.g. #000', 'woothemes' ),
					"id" => $shortname."_top_nav_hover",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Top Navigation - Hover Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the top navigation hover background color or add a hex color code e.g. #000', 'woothemes' ),
					"id" => $shortname."_top_nav_hover_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Top Navigation Font Style', 'woothemes' ),
					"desc" => __( 'Select typography for navigation.', 'woothemes' ),
					"id" => $shortname."_top_nav_font",
					"std" => array('size' => '11','unit' => 'px', 'face' => 'Open Sans','style' => 'thin','color' => '#999'),
					"type" => "typography");

$options[] = array( "name" => __( 'Top Bar Welcome Message Font Style', 'woothemes' ),
					"desc" => __( 'Select typography for navigation.', 'woothemes' ),
					"id" => $shortname."_top_callus_font",
					"std" => array('size' => '11','unit' => 'px', 'face' => 'Playfair Display','style' => 'thin','color' => '#999'),
					"type" => "typography");

$options[] = array( "name" => __( 'Enable Float Menu', 'woothemes' ),
					"desc" => __( 'Enable float menu in top navigation.', 'woothemes' ),
					"id" => $shortname."_float_menu",
					"std" => "false",
					"type" => "checkbox");

/* Header Styling */
$options[] = array( 'name' => __( 'Header Style', 'woothemes' ),
					'type' => 'subheading' );

// $options[] = array( "name" => __( 'Header Background Color', 'woothemes' ),
// 					"desc" => __( 'Pick a custom color for header background or add a hex color code e.g. #e6e6e6', 'woothemes' ),
// 					"id" => $shortname."_header_bg",
// 					"std" => "",
// 					"type" => "color");

// $options[] = array( "name" => __( 'Header Background Image', 'woothemes' ),
// 					"desc" => __( 'Upload a background image, or specify the image address of your image (http://yoursite.com/image.png). <br/>Image should be same width as your site width.', 'woothemes' ),
// 					"id" => $shortname."_header_bg_image",
// 					"std" => "",
// 					"type" => "upload");

// $options[] = array( "name" => __( 'Header Background Image Repeat', 'woothemes' ),
// 					"desc" => __( 'Select how you want your background image to display.', 'woothemes' ),
// 					"id" => $shortname."_header_bg_image_repeat",
// 					"type" => "select",
// 					"options" => array("No Repeat" => "no-repeat", "Repeat" => "repeat","Repeat Horizontally" => "repeat-x", "Repeat Vertically" => "repeat-y",) );

// $options[] = array( "name" => __( 'Header Border', 'woothemes' ),
// 					"desc" => __( 'Specify border properties for the header.', 'woothemes' ),
// 					"id" => $shortname."_header_border",
// 					"std" => array('width' => '0','style' => 'solid','color' => ''),
// 					"type" => "border");

// $options[] = array( "name" => __( 'Header Margin Top/Bottom', 'woothemes' ),
// 					"desc" => __( 'Enter an integer value i.e. 20 for the desired header margin.', 'woothemes' ),
// 					"id" => $shortname."_header_margin_tb",
// 					"std" => "",
// 					"type" => array(
// 									array(  'id' => $shortname. '_header_margin_top',
// 											'type' => 'text',
// 											'std' => '0',
// 											'meta' => __( 'Top', 'woothemes' ) ),
// 									array(  'id' => $shortname. '_header_margin_bottom',
// 											'type' => 'text',
// 											'std' => '0',
// 											'meta' => __( 'Bottom', 'woothemes' ) )
// 								  ));
// $options[] = array( "name" => __( 'Header Padding Top/Bottom', 'woothemes' ),
// 					"desc" => __( 'Enter an integer value i.e. 20 for the desired header padding.', 'woothemes' ),
// 					"id" => $shortname."_header_padding_tb",
// 					"std" => "",
// 					"type" => array(
// 									array(  'id' => $shortname. '_header_padding_top',
// 											'type' => 'text',
// 											'std' => '40',
// 											'meta' => __( 'Top', 'woothemes' ) ),
// 									array(  'id' => $shortname. '_header_padding_bottom',
// 											'type' => 'text',
// 											'std' => '40',
// 											'meta' => __( 'Bottom', 'woothemes' ) )
// 								  ));

// $options[] = array( "name" => __( 'Header Padding Left/Right', 'woothemes' ),
// 					"desc" => __( 'Enter an integer value i.e. 20 for the desired header padding.', 'woothemes' ),
// 					"id" => $shortname."_header_padding_lr",
// 					"std" => "",
// 					"type" => array(
// 									array(  'id' => $shortname. '_header_padding_left',
// 											'type' => 'text',
// 											'std' => '',
// 											'meta' => __( 'Left', 'woothemes' ) ),
// 									array(  'id' => $shortname. '_header_padding_right',
// 											'type' => 'text',
// 											'std' => '',
// 											'meta' => __( 'Right', 'woothemes' ) )
// 								  ));

$options[] = array( "name" => __( 'Site Title Font Style', 'woothemes' ),
					"desc" => __( 'Select typography for site title.', 'woothemes' ),
					"id" => $shortname."_font_logo",
					"std" => array('size' => '40','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'Site Description Font Style', 'woothemes' ),
					"desc" => __( 'Select typography for site description.', 'woothemes' ),
					"id" => $shortname."_font_desc",
					"std" => array('size' => '13','unit' => 'px', 'face' => 'Playfair Display','style' => 'thin','color' => '#999999'),
					"type" => "typography");


/* Navigation Styling */
$options[] = array( 'name' => __( 'Primary Navigation', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the navigation background or add a hex color code e.g. #cccccc', 'woothemes' ),
					"id" => $shortname."_nav_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Navigation Font Style', 'woothemes' ),
					"desc" => __( 'Select typography for navigation.', 'woothemes' ),
					"id" => $shortname."_nav_font",
					"std" => array('size' => '14','unit' => 'px', 'face' => 'Open Sans','style' => '','color' => '#666666'),
					"type" => "typography");

$options[] = array( "name" => __( 'Hover Text Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the navigation hover text color or add a hex color code e.g. #eeeeee', 'woothemes' ),
					"id" => $shortname."_nav_hover",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Hover Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the navigation hover background color or add a hex color code e.g. #eeeeee', 'woothemes' ),
					"id" => $shortname."_nav_hover_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Current Item Text Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the text color of the current menu item in the navigation, or add a hex color code e.g. #eeeeee', 'woothemes' ),
					"id" => $shortname."_nav_currentitem",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Current Item Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the background of the current menu item in the navigation, or add a hex color code e.g. #eeeeee', 'woothemes' ),
					"id" => $shortname."_nav_currentitem_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Dropdown menu border', 'woothemes' ),
					"desc" => __( 'Specify border properties for the navigation dropdown menu.', 'woothemes' ),
					"id" => $shortname."_nav_dropdown_border",
					"std" => array('width' => '1','style' => 'solid','color' => '#dbdbdb'),
					"type" => "border");

$options[] = array( "name" => __( 'Border Bottom', 'woothemes' ),
					"desc" => __( 'Specify border properties for the navigation.', 'woothemes' ),
					"id" => $shortname."_nav_border_bot",
					"std" => array('width' => '1','style' => 'solid','color' => '#dbdbdb'),
					"type" => "border");

/* Post Styling */
$options[] = array( 'name' => __( 'Posts / Pages', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Post/Page Title Font Style', 'woothemes' ),
					"desc" => __( 'Specify typography for post/page title text.', 'woothemes' ),
					"id" => $shortname."_font_post_title",
					"std" => array('size' => '28','unit' => 'px', 'face' => 'Playfair Display','style' => 'normal','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'Post Meta Font Style', 'woothemes' ),
					"desc" => __( 'Specify typography for post meta.', 'woothemes' ),
					"id" => $shortname."_font_post_meta",
					"std" => array('size' => '12','unit' => 'px', 'face' => 'Helvetica, Arial, sans-serif','style' => 'thin','color' => '#999999'),
					"type" => "typography");

$options[] = array( "name" => __( 'Post/Page Text Font Style', 'woothemes' ),
					"desc" => __( 'Specify typography for post/page content text.', 'woothemes' ),
					"id" => $shortname."_font_post_text",
					"std" => array('size' => '15','unit' => 'px', 'face' => 'Open Sans','style' => '300','color' => '#555555'),
					"type" => "typography");

$options[] = array( "name" => __( 'Post Author Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom background color for the post author section or add a hex color code e.g. #fafafa', 'woothemes' ),
					"id" => $shortname."_post_author_bg",
					"std" => "#fafafa",
					"type" => "color");

$options[] = array( "name" => __( 'Post Author Border Top', 'woothemes' ),
					"desc" => __( 'Specify border properties for post author section.', 'woothemes' ),
					"id" => $shortname."_post_author_border_top",
					"std" => array('width' => '1','style' => 'solid','color' => '#e6e6e6'),
					"type" => "border");

$options[] = array( "name" => __( 'Post Author Border Bottom', 'woothemes' ),
					"desc" => __( 'Specify border properties for post author section.', 'woothemes' ),
					"id" => $shortname."_post_author_border_bottom",
					"std" => array('width' => '1','style' => 'solid','color' => '#e6e6e6'),
					"type" => "border");

$options[] = array( "name" => __( 'Post Author Border Left/Right', 'woothemes' ),
					"desc" => __( 'Specify border properties for the navigation.', 'woothemes' ),
					"id" => $shortname."_post_author_border_lr",
					"std" => array('width' => '1','style' => 'solid','color' => '#e6e6e6'),
					"type" => "border");

$options[] = array( "name" => __( 'Post Author Rounded Corners', 'woothemes' ),
					"desc" => __( 'Set amount of pixels for border radius (rounded corners). Will only show in CSS3 compatible browser.', 'woothemes' ),
					"id" => $shortname."_post_author_border_radius",
					"type" => "select",
					"std" => "5px",
					"options" => $options_pixels);

$options[] = array( "name" => __( 'Disable Post Author', 'woothemes' ),
					"desc" => __( 'Disable post author below post?', 'woothemes' ),
					"id" => $shortname."_disable_post_author",
					"std" => "false",
					"type" => "checkbox");
// edit adit 8-11-2013

// $options[] = array( "name" => __( 'Comments Background Color (even threads)', 'woothemes' ),
// 					"desc" => __( 'Pick a custom background color for the post comments even threads or add a hex color code e.g. #fafafa', 'woothemes' ),
// 					"id" => $shortname."_post_comments_bg",
// 					"std" => "",
// 					"type" => "color");


$options[] = array( "name" => __( 'Page Navigation Font Style', 'woothemes' ),
					"desc" => __( 'Select typography for Page Navigation text.', 'woothemes' ),
					"id" => $shortname."_pagenav_font",
					"std" => array('size' => '13','unit' => 'px', 'face' => 'Helvetica, Arial, sans-serif','style' => 'thin','color' => '#888'),
					"type" => "typography");

$options[] = array( "name" => __( 'Page Navigation Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the Page Navigation background or add a hex color code e.g. #fafafa', 'woothemes' ),
					"id" => $shortname."_pagenav_bg",
					"std" => "",
					"type" => "color");

 $options[] = array( "name" => __( 'Page Navigation Background Color hover', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the Page Navigation background color hover or add a hex color code e.g. #fafafa', 'woothemes' ),
					"id" => $shortname."_pagenav_bg_hov",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Page Navigation Border Top', 'woothemes' ),
					"desc" => __( 'Specify border properties for Page Navigation section.', 'woothemes' ),
					"id" => $shortname."_pagenav_border_top",
					"std" => array('width' => '0','style' => 'solid','color' => '#e6e6e6'),
					"type" => "border");

$options[] = array( "name" => __( 'Page Navigation Border Bottom', 'woothemes' ),
					"desc" => __( 'Specify border properties for Page Navigation section.', 'woothemes' ),
					"id" => $shortname."_pagenav_border_bottom",
					"std" => array('width' => '0','style' => 'solid','color' => '#e6e6e6'),
					"type" => "border");

$options[] = array( 'name' => __( 'Archives', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Archive Header Font Style', 'woothemes' ),
					"desc" => __( 'Select typography for Archive header.', 'woothemes' ),
					"id" => $shortname."_archive_header_font",
					"std" => array('size' => '20','unit' => 'px', 'face' => 'Playfair display','style' => 'normal','color' => '#000000'),
					"type" => "typography");

$options[] = array( "name" => __( 'Archive Header Border Bottom', 'woothemes' ),
					"desc" => __( 'Specify border properties for Archive header', 'woothemes' ),
					"id" => $shortname."_archive_header_border_bottom",
					"std" => array('width' => '1','style' => 'solid','color' => '#e6e6e6'),
					"type" => "border");

$options[] = array( "name" => __( 'Disable Archive Header RSS link', 'woothemes' ),
					"desc" => __( 'Disable RSS link in Archive header', 'woothemes' ),
					"id" => $shortname."_archive_header_disable_rss",
					"std" => "false",
					"type" => "checkbox");

/* Widget Styling */
$options[] = array( 'name' => __( 'Widgets', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Widget Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the widget background or add a hex color code e.g. #cccccc', 'woothemes' ),
					"id" => $shortname."_widget_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Widget Border', 'woothemes' ),
					"desc" => __( 'Specify border properties for widgets.', 'woothemes' ),
					"id" => $shortname."_widget_border",
					"std" => array('width' => '0','style' => 'solid','color' => '#dbdbdb'),
					"type" => "border");

$options[] = array( "name" => __( 'Widget Padding', 'woothemes' ),
					"desc" => __( 'Enter an integer value i.e. 20 for the desired widget padding.', 'woothemes' ),
					"id" => $shortname."_widget_padding",
					"std" => "",
					"type" => array(
									array(  'id' => $shortname. '_widget_padding_tb',
											'type' => 'text',
											'std' => '',
											'meta' => __( 'Top/Bottom', 'woothemes' ) ),
									array(  'id' => $shortname. '_widget_padding_lr',
											'type' => 'text',
											'std' => '',
											'meta' => __( 'Left/Right', 'woothemes' ) )
								  ));

$options[] = array( "name" => __( 'Widget Title', 'woothemes' ),
					"desc" => __( 'Select the typography you want for the widget title.', 'woothemes' ),
					"id" => $shortname."_widget_font_title",
					"std" => array('size' => '14','unit' => 'px', 'face' => 'Open Sans','style' => 'bold','color' => '#555555'),
					"type" => "typography");

$options[] = array( "name" => __( 'Widget Title Bottom Border', 'woothemes' ),
					"desc" => __( 'Specify border property for the widget title.', 'woothemes' ),
					"id" => $shortname."_widget_title_border",
					"std" => array('width' => '0','style' => 'solid','color' => '#e6e6e6'),
					"type" => "border");

$options[] = array( "name" => __( 'Widget Text', 'woothemes' ),
					"desc" => __( 'Select the typography you want for the widget text.', 'woothemes' ),
					"id" => $shortname."_widget_font_text",
					"std" => array('size' => '13','unit' => 'px', 'face' => 'Open Sans','style' => 'thin','color' => '#555555'),
					"type" => "typography");

$options[] = array( "name" => __( 'Widget Rounded Corners', 'woothemes' ),
					"desc" => __( 'Set amount of pixels for border radius (rounded corners). Will only show in CSS3 compatible browser.', 'woothemes' ),
					"id" => $shortname."_widget_border_radius",
					"type" => "select",
					"options" => $options_pixels);

$options[] = array( "name" => __( 'Tabs Widget Background color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the tabs widget or add a hex color code e.g. #cccccc', 'woothemes' ),
					"id" => $shortname."_widget_tabs_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Tabs Widget Inside Background Color', 'woothemes' ),
					"desc" => __( 'Pick a custom color for the tabs widget or add a hex color code e.g. #cccccc', 'woothemes' ),
					"id" => $shortname."_widget_tabs_bg_inside",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Tabs Widget Title', 'woothemes' ),
					"desc" => __( 'Select the typography you want for the widget text.', 'woothemes' ),
					"id" => $shortname."_widget_tabs_font",
					"std" => array('size' => '12','unit' => 'px', 'face' => 'Open Sans','style' => 'bold','color' => '#555555'),
					"type" => "typography");

$options[] = array( "name" => __( 'Tabs Widget Meta / Tabber Font', 'woothemes' ),
					"desc" => __( 'Select the typography you want for the widget text.', 'woothemes' ),
					"id" => $shortname."_widget_tabs_font_meta",
					"std" => array('size' => '11','unit' => 'px', 'face' => 'Open Sans','style' => 'thin','color' => '#999999'),
					"type" => "typography");

$options[] = array( 'name' => __( 'Footer', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Footer Font Style', 'woothemes' ),
					"desc" => __( 'Select typography for footer.', 'woothemes' ),
					"id" => $shortname."_footer_font",
					"std" => array('size' => '13','unit' => 'px', 'face' => 'Open Sans','style' => 'thin','color' => '#999999'),
					"type" => "typography");

$options[] = array( "name" => __( 'Footer Background', 'woothemes' ),
					"desc" => __( 'Select the background color you want for your footer.', 'woothemes' ),
					"id" => $shortname."_footer_bg",
					"std" => "",
					"type" => "color");

$options[] = array( "name" => __( 'Footer Border Top', 'woothemes' ),
					"desc" => __( 'Specify top border properties for the footer.', 'woothemes' ),
					"id" => $shortname."_footer_border_top",
					"std" => array('width' => '1','style' => 'solid','color' => '#dbdbdb'),
					"type" => "border");

$options[] = array( "name" => __( 'Footer Border Bottom', 'woothemes' ),
					"desc" => __( 'Specify bottom border properties for the footer.', 'woothemes' ),
					"id" => $shortname."_footer_border_bottom",
					"std" => array('width' => '0','style' => 'solid','color' => ''),
					"type" => "border");

$options[] = array( "name" => __( 'Footer Border Left/Right', 'woothemes' ),
					"desc" => __( 'Specify left/right border properties for the footer.', 'woothemes' ),
					"id" => $shortname."_footer_border_lr",
					"std" => array('width' => '0','style' => 'solid','color' => ''),
					"type" => "border");

$options[] = array( "name" => __( 'Footer Rounded Corners', 'woothemes' ),
					"desc" => __( 'Set amount of pixels for border radius (rounded corners). Will only show in CSS3 compatible browser.', 'woothemes' ),
					"id" => $shortname."_footer_border_radius",
					"type" => "select",
					"options" => $options_pixels);
/*
$options[] = array( "name" => __( 'Footer Customisation', 'woothemes' ),
					"icon" => "footer",
					"type" => "subheading");
*/
$options[] = array( "name" => __( 'Custom Affiliate Link', 'woothemes' ),
					"desc" => __( 'Add an affiliate link to the WooThemes logo in the footer of the theme.', 'woothemes' ),
					"id" => $shortname."_footer_aff_link",
					"std" => "",
					"type" => "text");

$options[] = array( "name" => __( 'Enable Custom Footer (Left)', 'woothemes' ),
					"desc" => __( 'Activate to add the custom text below to the theme footer.', 'woothemes' ),
					"id" => $shortname."_footer_left",
					"class" => "collapsed",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Custom Text (Left)', 'woothemes' ),
					"desc" => __( 'Custom HTML and Text that will appear in the footer of your theme.', 'woothemes' ),
					"id" => $shortname."_footer_left_text",
					"class" => "hidden last",
					"std" => "<p></p>",
					"type" => "textarea");

$options[] = array( "name" => __( 'Enable Custom Footer (Right)', 'woothemes' ),
					"desc" => __( 'Activate to add the custom text below to the theme footer.', 'woothemes' ),
					"id" => $shortname."_footer_right",
					"class" => "collapsed",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Custom Text (Right)', 'woothemes' ),
					"desc" => __( 'Custom HTML and Text that will appear in the footer of your theme.', 'woothemes' ),
					"id" => $shortname."_footer_right_text",
					"class" => "hidden last",
					"std" => "<p></p>",
					"type" => "textarea");

/* Misc Typography */
$options[] = array( 'name' => __( 'Misc Typography', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Misc Typography', 'woothemes' ),
					"desc" => "",
					"id" => $shortname."_general_font_notice",
					"std" => __( 'The misc typography options below only control typography not covered by other typography options. You can control specific typography on post title, post content, widget titles etc. in the other sections in the options panel.', 'woothemes' ),
					"type" => "info");

$options[] = array( "name" => __( 'General Text Font Style', 'woothemes' ),
					"desc" => __( 'Select typography for general text.', 'woothemes' ),
					"id" => $shortname."_font_text",
					"std" => array('size' => '13','unit' => 'px', 'face' => 'Open Sans','style' => 'normal','color' => '#555555'),
					"type" => "typography");


$options[] = array( "name" => __( 'H1 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H1.', 'woothemes' ),
					"id" => $shortname."_font_h1",
					"std" => array('size' => '28','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H2 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H2.', 'woothemes' ),
					"id" => $shortname."_font_h2",
					"std" => array('size' => '24','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H3 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H3.', 'woothemes' ),
					"id" => $shortname."_font_h3",
					"std" => array('size' => '20','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H4 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H4.', 'woothemes' ),
					"id" => $shortname."_font_h4",
					"std" => array('size' => '16','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H5 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H5.', 'woothemes' ),
					"id" => $shortname."_font_h5",
					"std" => array('size' => '14','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H6 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H6.', 'woothemes' ),
					"id" => $shortname."_font_h6",
					"std" => array('size' => '12','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

/* Shortcode Typography */
$options[] = array( 'name' => __( 'Shortcode Typography', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Shortcode Typography', 'woothemes' ),
					"desc" => "",
					"id" => $shortname."_general_font_notice",
					"std" => __( 'The Shortcode typography options below only control typography not covered by other typography options. You can control specific typography on title', 'woothemes' ),
					"type" => "info");

$options[] = array( "name" => __( 'H1 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H1.', 'woothemes' ),
					"id" => $shortname."_font_h1_sc",
					"std" => array('size' => '28','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H2 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H2.', 'woothemes' ),
					"id" => $shortname."_font_h2_sc",
					"std" => array('size' => '24','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H3 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H3.', 'woothemes' ),
					"id" => $shortname."_font_h3_sc",
					"std" => array('size' => '20','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H4 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H4.', 'woothemes' ),
					"id" => $shortname."_font_h4_sc",
					"std" => array('size' => '16','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H5 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H5.', 'woothemes' ),
					"id" => $shortname."_font_h5_sc",
					"std" => array('size' => '14','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'H6 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H6.', 'woothemes' ),
					"id" => $shortname."_font_h6_sc",
					"std" => array('size' => '12','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

/* Header Custom Layout */
$options[] = array( "name" => __( 'Header', 'woothemes' ),
						"icon" => "header",
						"type" => "heading");

$header_images = THEME_URI .'/includes/images/headers/';
// Header Layout
$options[] = array( "name" => __( 'Header Layout', 'woothemes' ),
					"id" => $shortname."_header_layout",
					"std" => "v1",
					"type" => "images",
					"options" => array(	"v1" => $header_images."header_01.jpg",
								 		"v2" => $header_images."header_02.jpg",
								 		"v3" => $header_images."header_03.jpg",
								 		"v4" => $header_images."header_04.jpg"));

$options[] = array( "name" => __( 'Top Bar Options', 'woothemes' ),
					"desc" => "",
					"id" => $shortname."_header_topbar_notice",
					"std" => __( 'This function appear in every Top Bar Options', 'woothemes' ),
					"type" => "info");

$options[] = array( 'name' => __( 'Show Topbar', 'woothemes' ),
                                                    'desc' => __( 'Check to show topbar', 'woothemes' ),
                                                     'id' => $shortname . '_check_topbar',
                                                     'std' => 'true',
                                                    'type' => 'checkbox' );

$options[] = array( 'name' => __( 'Show Welcome Message Text on Topbar', 'woothemes' ),
                                                    'desc' => __( 'Check to show Welcome Message Text ', 'woothemes' ),
                                                     'id' => $shortname . '_check_callus',
                                                     'std' => 'false',
                                                     'class' => 'collapsed',
                                                    'type' => 'checkbox' );

$options[] = array( 'name' => __( 'Welcome Message Text', 'woothemes' ),
                                                    'desc' => __( 'Enter your Welcome Message Text (HTML allowed)', 'woothemes' ),
                                                     'id' => $shortname . '_text_callus',
                                                     'std' => '',
                                                     'class' => 'hidden last',
                                                    'type' => 'textarea' );

$options[] = array( "name" => __( 'Header V1 Options', 'woothemes' ),
					"desc" => "",
					"id" => $shortname."_header_v1_notice",
					"std" => __( 'This function appear in every Top Bar Options', 'woothemes' ),
					"type" => "info");
$options[] = array( 'name' => __( 'Custom Header Text', 'woothemes' ),
                                                    'desc' => __( 'Enter your Welcome Message Text (HTML allowed)', 'woothemes' ),
                                                     'id' => $shortname . '_custom_header_text',
                                                     'std' => '',
                                                    'type' => 'textarea' );
$options[] = array( "name" => __( 'Header V4 Options', 'woothemes' ),
					"desc" => "",
					"id" => $shortname."_header_v4_notice",
					"std" => __( 'This function appear in every Top Bar Options', 'woothemes' ),
					"type" => "info");

$options[] = array( 'name' => __( 'Header v4 Background Color', 'woothemes' ),
                                                    'desc' => __( 'Pick a custom color for header v4 background or add a hex color code e.g. #e6e6e6.', 'woothemes' ),
                                                     'id' => $shortname . '_headerv4_background',
                                                     'std' => '',
                                                    'type' => 'color' );

$options[] = array( 'name' => __('Header Background Opacity', 'woothemes'),
               'desc' => __('Specify the opacity choose from 0.3 (3) - 0.9 (9)', 'woothemes'),
                'id' => $shortname . '_headerv4_opacity',
               'type' => 'slider',
               'min' => '3',
               'max' => '9',
               'increment' => '1',
               'std' => '8');

if ( is_woocommerce_activated() ) {

	$options[] = array( "name" => __( 'WooCommerce', 'woothemes' ),
                   	 	"icon" => "woocommerce",
						"type" => "heading");

	 $options[] = array( 'name' => __( 'Products Content', 'woothemes' ),
                    'type' => 'subheading' );

$options[] = array( "name" => __( 'WooCommerce Page Layout', 'woothemes' ),
						"desc" => __( 'Select main content and sidebar alignment. Choose between 1 or 2 column layout.', 'woothemes' ),
						"id" => $shortname . "_wc_layout",
						"std" => "two-col-right",
						"type" => "images",
						"options" => array(
							'one-col' => $images_dir . '1c.png',
							'two-col-left' => $images_dir . '2cl.png',
							'two-col-right' => $images_dir . '2cr.png'	)
						);
	$options[] = array( "name" => __( 'Search scope', 'woothemes' ),
						"desc" => __( 'Select whether you want the search widget to search for products or posts', 'woothemes' ),
						"id" => $shortname."_header_search_scope",
						"type" => "select2",
						"options" => array( 'products' => __( 'Products', 'woothemes' ), 'posts' => __( 'Posts', 'woothemes' ) ) );

	 $options[] = array( 'name' => __( 'Products per page', 'woothemes' ),
                        'desc' => __( 'How many products do you want to display on product archive pages?', 'woothemes' ),
                        'id' => $shortname.'commerce_products_per_page',
                        'std' => '12',
                        'type' => 'text' );

             $options[] = array( 'name' => __( 'Products per column', 'woothemes' ),
                        'desc' => __( 'How many products Column do you want to display on product archive pages?', 'woothemes' ),
                        'id' => $shortname.'commerce_products_per_column',
                        'std' => '3',
                        'type' => 'select2',
                        'options' => array(
                            '2' => __('Two Columns', 'woothemes'),
                            '3' => __('Three Columns', 'woothemes'),
                            '4' => __('Four Columns', 'woothemes')  ) );

             $options[] = array( 'name' => __( 'Shop Banner', 'woothemes' ),
            				'desc' => __( 'Upload a banner for your shop page, or specify an image URL directly.', 'woothemes' ),
            				'id' => $shortname . '_headbanner_shop',
            				'std' => '',
            				'type' => 'upload' );

                $options[] = array( 'name' => __( 'Enable Quickview Product Catalog ?', 'woothemes' ),
                        'desc' => __( 'Enable this to have a quickview in your product catalog.', 'woothemes' ),
                        'id' => $shortname.'_enable_quickview',
                        'std' => 'true',
                        'type' => 'checkbox' );

                 $options[] = array( 'name' => __( 'Enable Image Hover Product Catalog ?', 'woothemes' ),
                        'desc' => __( 'Enable this to have an Image Hover in your product catalog.', 'woothemes' ),
                        'id' => $shortname.'_enable_imghov',
                        'std' => 'false',
                        'type' => 'checkbox' );

             $options[] = array( 'name' => __( 'Header Cart Link', 'woothemes' ),
                        'desc' => __( 'Display item and amount totals in the main navigation shopping cart.', 'woothemes' ),
                        'id' => $shortname.'_header_cart_link',
                        'std' => 'true',
                        'type' => 'checkbox' );

             $options[] = array( 'name' => __( 'Header Cart Totals', 'woothemes' ),
                        'desc' => __( 'Display item and amount totals in the cart in the main navigation', 'woothemes' ),
                        'id' => $shortname.'_header_cart_total',
                        'std' => 'false',
                        'type' => 'checkbox' );
			if(class_exists( 'YITH_WCWL_UI' )){
              $options[] = array( 'name' => __( 'Display Wishlist on Topbar Menu?', 'woothemes' ),
                        'desc' => __( 'Display Wishlist', 'woothemes' ),
                        'id' => $shortname.'_wishlist_topbar',
                        'std' => 'false',
                        'type' => 'checkbox' );
          	}

             //Login & Register Options
             if (get_option('woocommerce_enable_myaccount_registration')=='yes') {
             $options[] = array( "name" => __( 'Account Registration Settings ', 'woothemes' ),
					"desc" => "",
					"id" => $shortname."_account_reg_notice",
					"std" => __( 'This Setting are available if you checklist <strong>Allow Registration on The "My Account" Page</strong> on <a href=" '.admin_url('admin.php?page=woocommerce_settings').' ">woocommerce settings</a>', 'woothemes' ),
					"type" => "info");
             $options[] = array( 'name' => __( 'Heading Login', 'woothemes' ),
                        'desc' => __( 'Display Heading login in the MyAccount Shop Page', 'woothemes' ),
                        'id' => $shortname.'_acc_head_login',
                        'std' => '',
                        'type' => 'text' );
             $options[] = array( 'name' => __( 'Subheading Login', 'woothemes' ),
                        'desc' => __( 'Display SubHeading login in the MyAccount Shop Page', 'woothemes' ),
                        'id' => $shortname.'_acc_subhead_login',
                        'std' => '',
                        'type' => 'text' );
             $options[] = array( 'name' => __( 'Content Login', 'woothemes' ),
                        'desc' => __( 'Display Content login in the MyAccount Shop Page', 'woothemes' ),
                        'id' => $shortname.'_acc_content_login',
                        'std' => '',
                        'type' => 'textarea' );
              $options[] = array( 'name' => __( 'Button Login', 'woothemes' ),
                        'desc' => __( 'Display Content login in the MyAccount Shop Page', 'woothemes' ),
                        'id' => $shortname.'_acc_button_login',
                        'std' => '',
                        'type' => 'text' );

              $options[] = array( 'name' => __( 'Heading Register', 'woothemes' ),
                        'desc' => __( 'Display Heading Register in the MyAccount Shop Page', 'woothemes' ),
                        'id' => $shortname.'_acc_head_reg',
                        'std' => '',
                        'type' => 'text' );
             $options[] = array( 'name' => __( 'Subheading Register', 'woothemes' ),
                        'desc' => __( 'Display SubHeading Register in the MyAccount Shop Page', 'woothemes' ),
                        'id' => $shortname.'_acc_subhead_reg',
                        'std' => '',
                        'type' => 'text' );
             $options[] = array( 'name' => __( 'Content Register', 'woothemes' ),
                        'desc' => __( 'Display Content Register in the MyAccount Shop Page', 'woothemes' ),
                        'id' => $shortname.'_acc_content_reg',
                        'std' => '',
                        'type' => 'textarea' );
              $options[] = array( 'name' => __( 'Button Register', 'woothemes' ),
                        'desc' => __( 'Display Content Register in the MyAccount Shop Page', 'woothemes' ),
                        'id' => $shortname.'_acc_button_reg',
                        'std' => '',
                        'type' => 'text' );
               $options[] = array( 'name' => __( 'Enable Facebook Button', 'woothemes' ),
                        'desc' => 'This works fine if you install (Nextend Facebook Connect Plugin)',
                        'id' => $shortname.'_fb_login_enable',
                        'std' => 'false',
                        'class' => 'collapsed',
                        'type' => 'checkbox' );
              $options[] = array( 'name' => __( 'Facebook Text Button', 'woothemes' ),
                        'desc' => '',
                        'id' => $shortname.'_fb_login_text',
                        'std' => '',
                        'class' => 'hidden last',
                        'type' => 'text' );
          }



             $options[] = array( 'name' => __( 'Single Product Content', 'woothemes' ),
                    'type' => 'subheading' );

             $productpage_images = THEME_URI.'/includes/images/';

             $options[] = array( 'name' => __( 'Single Product Style Mode', 'woothemes' ),
             			//'desc' => __( 'Display Layout Classic Style or Modern Style', 'woothemes' ),
              			'id' => $shortname.'_single_product_mode_layout',
              			'std' => 'modern',
              			'type' => 'images',
              			'options' => array(
              				'classic' => $productpage_images . 'shop_standard.jpg',
              				'modern' => $productpage_images . 'shop_modern.jpg'
              				));
              $options[] = array( 'name' => __( 'Enable Ajax Add to cart?', 'woothemes' ),
             			'desc' => __( 'Display Pop Up Add to cart ( NOTE: Header Cart Link options MUST Active  )', 'woothemes' ),
              			'id' => $shortname.'_atc_ajax',
              			'std' => 'true',
              			'type' => 'checkbox' );

             $options[] = array( 'name' => __( 'Display recently viewed products', 'woothemes' ),
             			'desc' => __( 'Display recently viewed products on the product details page', 'woothemes' ),
              			'id' => $shortname.'commerce_recent_view_products',
              			'std' => 'true',
              			'type' => 'checkbox' );

             $options[] = array( 'name' => __( 'Display related products', 'woothemes' ),
             			'desc' => __( 'Display related products on the product details page', 'woothemes' ),
              			'id' => $shortname.'commerce_related_products',
              			'std' => 'true',
              			'type' => 'checkbox' );

	$options[] = array( 'name' => __( 'Custom Placeholder', 'woothemes' ),
                        'desc' => __( 'Upload a custom placeholder to be displayed when there is no product image.', 'woothemes' ),
                        'id' => $shortname . '_placeholder_url',
                        'std' => '',
                        'type' => 'upload' );

    $options[] = array( 'name' => __( 'Enable Share?', 'woothemes' ),
                        'desc' => __( 'Display share button on single product', 'woothemes' ),
                        'id' => $shortname.'_enable_share_single_product',
                        'std' => 'false',
                        'type' => 'checkbox' );

if(!class_exists('jck_wt')){
     $options[] = array( 'name' => __( 'Enable Single Product Zoom?', 'woothemes' ),
                        'desc' => __( 'Enable to have zoom in your product\'s main image.', 'woothemes' ),
                        'id' => $shortname.'_enable_cloud_zoom',
                        'std' => 'false',
                        'type' => 'checkbox' );
 }

    $options[] = array( 'name' => __( 'Hide add to cart button on product pages', 'woothemes' ),
                        'desc' => __( 'Global setting to show / hide button like catalog on <em>all</em> product pages', 'woothemes' ),
                        'id' => $shortname.'commerce_button_atc',
                        'std' => 'false',
                        'type' => 'checkbox' );
}

/* Testimonials */

$options[] = array( "name" => __( 'Components', 'woothemes' ),
                    "icon" => "misc",
					"type" => "heading");


// blog
$options[] = array( 'name' => __( 'Blog', 'woothemes' ),
					'type' => 'subheading' );

 $options[] = array( 'name' => __( 'Enable infinite scroll?', 'woothemes' ),
                        'desc' => __( 'Enable infinite scroll when users scroll to the bottom of the page.', 'woothemes' ),
                        'id' => $shortname.'_blog_infinite_scroll',
                        'std' => 'true',
                        'type' => 'checkbox' );

$options[] = array( "name" => __( 'H3 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H3.', 'woothemes' ),
					"id" => $shortname."_font_h3_blog",
					"std" => array('size' => '20','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'Enable Slider', 'woothemes' ),
                "desc" => __( 'Enable the slider in the blog page template.', 'woothemes' ),
                "id" => $shortname."_slider_blog",
                "std" => "false",
                "type" => "checkbox");

// $options[] = array( "name" => __( 'Number Of Posts To Display In Slider Blog', 'woothemes' ),
//                         "desc" => __( 'Select the number of entries that should appear in the Slider.', 'woothemes' ),
//                         "id" => $shortname."_slider_number",
//                         "std" => "4",
//                         "type" => "select",
//                         "options" => $other_entries);


 $options[] = array( "name" => __( 'Enable Caption Slider', 'woothemes' ),
                "desc" => __( 'Enable the caption slider in the blog page template.', 'woothemes' ),
                "id" => $shortname."_slider_button",
                "std" => "false",
                "type" => "checkbox");


$options[] = array( "name" => __( 'Blog Editor Category Slug', 'woothemes' ),
						"desc" => sprintf( __( 'Type which category you want to show in editor pic.', 'woothemes' ), '<a href="' . admin_url( 'options-permalink.php' ) . '">' . __( 'Settings- Permalinks', 'woothemes' ) . '</a>' ),
						"id" => $shortname."_editor_pic_blog_cat",
						"std" => "",
						"type" => "text");
$options[] = array( "name" => __( 'Enable Editor Pick', 'woothemes' ),
                "desc" => __( 'Enable the slider in the blog page template.', 'woothemes' ),
                "id" => $shortname."_editor_pic_blog",
                "std" => "false",
                "type" => "checkbox");
 // $options[] = array( "name" => __( 'Number Of Posts To Display in Editor Pick', 'woothemes' ),
 //                        "desc" => __( 'Select the number of entries that should appear in the Slider.', 'woothemes' ),
 //                        "id" => $shortname."_editor_pic_blog_num",
 //                        "std" => "3",
 //                        "type" => "select",
 //                        "options" => $other_entries);

   $options[] = array( "name" => __( 'Enable Related Post in Blog', 'woothemes' ),
                "desc" => __( 'Enable the related post in the blog single post.', 'woothemes' ),
                "id" => $shortname."_rel_single_post",
                "std" => "false",
                "type" => "checkbox");

   // $options[] = array( "name" => __( 'Number Of Related Posts To Display in Blog', 'woothemes' ),
   //                      "desc" => __( 'Select the number of entries that should appear in blog single post.', 'woothemes' ),
   //                      "id" => $shortname."_rel_single_post_num",
   //                      "std" => "3",
   //                      "type" => "select",
   //                      "options" => $other_entries);

   $options[] = array( "name" => __( 'Enable Share Media Post in Blog', 'woothemes' ),
                "desc" => __( 'Enable the share media post in the blog single post.', 'woothemes' ),
                "id" => $shortname."_share_single_post",
                "std" => "false",
                "type" => "checkbox");

   $options[] = array( "name" => __( 'Include Blog Post in Ajax Search', 'woothemes' ),
					"desc" => __( 'Include Blog Post in Ajax Search on Top of your site.', 'woothemes' ),
					"id" => $shortname."_search_blog_post",
					"std" => "true",
					"type" => "checkbox");

   $options[] = array( "name" => __( 'Display Thumbnail on search?', 'woothemes' ),
					"desc" => '',
					"id" => $shortname."_search_thumb",
					"std" =>'true',
					"type" => "checkbox");
/* Portfolio */

$options[] = array( 'name' => __( 'Portfolio', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Portfolio Manager', 'woothemes' ),
					"desc" => "",
					"id" => $shortname."_portfolio_notice",
					"std" => sprintf( __( 'Below you can setup and enable/disable the portfolio settings. When modifying the portfolio settings, please visit the <a href="%s">Settings- Permalinks</a> screen to refresh your WordPress URLs.', 'woothemes' ), admin_url( 'options-permalink.php' ) ),
					"type" => "info");


$options[] = array( "name" => __( 'H3 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H3.', 'woothemes' ),
					"id" => $shortname."_font_h3_portfolio",
					"std" => array('size' => '20','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");


$options[] = array( "name" => __( 'Portfolio page style', 'woothemes' ),
					"desc" => __( 'Check to enable masonry in your portfolio', 'woothemes' ),
					"id" => $shortname."_portfolio_page_ver",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Portfolio Items URL Base', 'woothemes' ),
						"desc" => sprintf( __( 'The base of all portfolio item URLs (visit the %s screen after changing this setting).', 'woothemes' ), '<a href="' . admin_url( 'options-permalink.php' ) . '">' . __( 'Settings- Permalinks', 'woothemes' ) . '</a>' ),
						"id" => $shortname."_portfolioitems_rewrite",
						"std" => "portfolio-items",
						"type" => "text");

$options[] = array( "name" => __( 'Exclude Galleries from the Portfolio Navigation', 'woothemes' ),
						"desc" => __( 'Optionally exclude portfolio galleries from the portfolio gallery navigation switcher. Place the gallery slugs here, separated by commas <br />(eg: one,two,three)', 'woothemes' ),
						"id" => $shortname."_portfolio_excludenav",
						"std" => "",
						"type" => "text");

// $options[] = array( "name" => __( 'Portfolio Thumbnail Dimensions', 'woothemes' ),
// 						"desc" => __( 'Enter an integer value i.e. 250 for the image size.', 'woothemes' ),
// 						"id" => $shortname."_portfolio_thumb_dimensions",
// 						"std" => "",
// 						"type" => array(
// 										array(  'id' => $shortname. '_portfolio_thumb_width',
// 												'type' => 'text',
// 												'std' => 210,
// 												'meta' => __( 'Width', 'woothemes' ) ),
// 										array(  'id' => $shortname. '_portfolio_thumb_height',
// 												'type' => 'text',
// 												'std' => 157,
// 												'meta' => __( 'Height', 'woothemes' ) )
// 									  ));

$options[] = array( "name" => __( 'Portfolio Galleries Page Layout', 'woothemes' ),
						"desc" => __( 'Select main content and sidebar alignment. Choose between 1, 2 or 3 column layout.', 'woothemes' ),
						"id" => $shortname . "_portfolio_layout",
						"std" => "one-col",
						"type" => "images",
						"options" => array(
							'one-col' => $images_dir . '1c.png',
							'two-col-left' => $images_dir . '2cl.png',
							'two-col-right' => $images_dir . '2cr.png')
						);

$options[] = array( "name" => __( 'Portfolio Single Post Layout', 'woothemes' ),
						"desc" => __( 'Select main content and sidebar alignment. Choose between 1, 2 or 3 column layout.', 'woothemes' ),
						"id" => $shortname . "_portfolio_layout_single",
						"std" => "one-col",
						"type" => "images",
						"options" => array(
							'one-col' => $images_dir . '1c.png',
							'two-col-left' => $images_dir . '2cl.png',
							'two-col-right' => $images_dir . '2cr.png')
						);

$options[] = array( "name" => __( 'Exclude Portfolio Items from Search Results', 'woothemes' ),
					"desc" => __( 'Exclude portfolio items from results when searching your website.', 'woothemes' ),
					"id" => $shortname."_portfolio_excludesearch",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Portfolio Items Link To', 'woothemes' ),
                    "desc" => __( 'Choose whether portfolio items should open in a lightbox or link to the Portfolio item page when clicked.', 'woothemes' ),
                    "id" => $shortname."_portfolio_linkto",
                    "std" => "lightbox",
					"type" => "select2",
					"options" => array( 'lightbox' => __( 'Lightbox', 'woothemes' ), 'post' => __( 'Portfolio Item', 'woothemes' ) ) );

$options[] = array( "name" => __( 'Portfolio Related Projects', 'woothemes' ),
					"desc" => __( 'Enable or Disable Portfolio Related Projects.', 'woothemes' ),
					"id" => $shortname."_rel_proj",
					"std" => "false",
					"type" => "checkbox");

// $options[] = array( "name" => __( 'Number Of Portfolio Related Projects To Display', 'woothemes' ),
// 					"desc" => __( 'Select the number of entries that should appear in the single portfolio.', 'woothemes' ),
// 					"id" => $shortname."_post_related_proj",
// 					"std" => "4",
// 					"type" => "select",
// 					"options" => $other_entries_2);

 // $options[] = array( "name" => __( 'Portfolio Related Project Thumbnail Dimensions', 'woothemes' ),
	// 					"desc" => __( 'Enter an integer value i.e. 250 for the image size.', 'woothemes' ),
	// 					"id" => $shortname."_portfolio_related_thumb_dimensions",
	// 					"std" => "",
	// 					"type" => array(
	// 									array(  'id' => $shortname. '_portfolio_related_thumb_width',
	// 											'type' => 'text',
	// 											'std' => 210,
	// 											'meta' => __( 'Width', 'woothemes' ) ),
	// 									array(  'id' => $shortname. '_portfolio_related_thumb_height',
	// 											'type' => 'text',
	// 											'std' => 157,
	// 											'meta' => __( 'Height', 'woothemes' ) )
	// 								  ));


/* Dynamic Images */
$options[] = array( "name" => __( 'Dynamic Images', 'woothemes' ),
					"icon" => "image",
				    "type" => "heading");

$options[] = array( 'name' => __( 'Resizer Settings', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Dynamic Image Resizing', 'woothemes' ),
					"desc" => "",
					"id" => $shortname."_wpthumb_notice",
					"std" => __( 'dynamically resizing the thumbnails in the theme, <strong>WP Post Thumbnail</strong> .', 'woothemes' ),
					"type" => "info");

$options[] = array( "name" => __( 'WP Post Thumbnail', 'woothemes' ),
					"desc" => __( 'Use WordPress post thumbnail to assign a post thumbnail. Will enable the <strong>Featured Image panel</strong> in your post sidebar where you can assign a post thumbnail.', 'woothemes' ),
					"id" => $shortname."_post_image_support",
					"std" => "true",
					"class" => "collapsed",
					"type" => "checkbox" );

$options[] = array( "name" => __( 'WP Post Thumbnail - Dynamic Image Resizing', 'woothemes' ),
					"desc" => __( 'The post thumbnail will be dynamically resized using native WP resize functionality. <em>(Requires PHP 5.2+)</em>', 'woothemes' ),
					"id" => $shortname."_pis_resize",
					"std" => "true",
					"class" => "hidden",
					"type" => "checkbox" );

$options[] = array( "name" => __( 'WP Post Thumbnail - Hard Crop', 'woothemes' ),
					"desc" => __( 'The post thumbnail will be cropped to match the target aspect ratio (only used if <em>Dynamic Image Resizing</em> is enabled).', 'woothemes' ),
					"id" => $shortname."_pis_hard_crop",
					"std" => "true",
					"class" => "hidden last",
					"type" => "checkbox" );

// $options[] = array( "name" => __( 'TimThumb', 'woothemes' ),
// 					"desc" => __( 'This will enable the <a href="http://code.google.com/p/timthumb/">TimThumb</a> (thumb.php) script which dynamically resizes images added through the <strong>custom settings panel</strong>  below the post editor. Make sure your themes <em>cache</em> folder is writable.', 'woothemes' ),
// 					"id" => $shortname."_resize",
// 					"std" => "false",
// 					"type" => "checkbox" );

// $options[] = array( "name" => __( 'Automatic Image Thumbnail', 'woothemes' ),
// 					"desc" => __( 'If no thumbnail is specified then the first uploaded image in the post is used.', 'woothemes' ),
// 					"id" => $shortname."_auto_img",
// 					"std" => "false",
// 					"type" => "checkbox" );

$options[] = array( 'name' => __( 'Thumbnail Settings', 'woothemes' ),
					'type' => 'subheading' );

$options[] = array( "name" => __( 'Thumbnail Dimensions', 'woothemes' ),
					"desc" => __( 'Enter an integer value i.e. 250 for the desired size which will be used when dynamically creating the images.', 'woothemes' ),
					"id" => $shortname."_image_dimensions",
					"std" => "",
					"type" => array(
									array(  'id' => $shortname. '_thumb_w',
											'type' => 'text',
											'std' => "100",
											'meta' => __( 'Width', 'woothemes' ) ),
									array(  'id' => $shortname. '_thumb_h',
											'type' => 'text',
											'std' => 100,
											'meta' => __( 'Height', 'woothemes' ) )
								  ));

$options[] = array( "name" => __( 'Thumbnail Alignment', 'woothemes' ),
					"desc" => __( 'Select how to align your thumbnails with posts.', 'woothemes' ),
					"id" => $shortname."_thumb_align",
					"std" => "alignleft",
					"type" => "radio",
					"options" => array("alignleft" => "Left","alignright" => "Right","aligncenter" => "Center"));

$options[] = array( "name" => __( 'Single Post - Show Thumbnail', 'woothemes' ),
					"desc" => __( 'Show the thumbnail in the single post page.', 'woothemes' ),
					"id" => $shortname."_thumb_single",
					"std" => "true",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Single Post - Thumbnail Dimensions', 'woothemes' ),
					"desc" => __( 'Enter an integer value i.e. 250 for the image size.', 'woothemes' ),
					"id" => $shortname."_image_dimensions",
					"std" => "",
					"type" => array(
									array(  'id' => $shortname. '_single_w',
											'type' => 'text',
											'std' => 200,
											'meta' => __( 'Width', 'woothemes' ) ),
									array(  'id' => $shortname. '_single_h',
											'type' => 'text',
											'std' => 200,
											'meta' => __( 'Height', 'woothemes' ) )
								  ));

$options[] = array( "name" => __( 'Single Post - Thumbnail Alignment', 'woothemes' ),
					"desc" => __( 'Select how to align your thumbnails with single posts.', 'woothemes' ),
					"id" => $shortname."_thumb_align_single",
					"std" => "alignright",
					"type" => "radio",
					"options" => array( "alignleft" => "Left","alignright" => "Right","aligncenter" => "Center" ) );


$options[] = array( "name" => __( 'Add Featured Image to RSS feed', 'woothemes' ),
					"desc" => __( 'Add the featured image to your RSS feed', 'woothemes' ),
					"id" => $shortname."_rss_thumb",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => __( 'Enable Lightbox', 'woothemes' ),
					"desc" => __( 'Enable the PrettyPhoto lightbox script on images within your website\'s content.', 'woothemes' ),
					"id" => $shortname."_enable_lightbox",
					"std" => "false",
					"type" => "checkbox" );

/* Tumblog Settings - will be depreceated. Hide if not already active. */
if ( get_option( $shortname . '_woo_tumblog_switch' ) == "true" ) {

	$options[] = array( "name" => __( 'Tumblog', 'woothemes' ),
						"icon" => "tumblog",
						"type" => "heading");

	$options[] = array( 'name' => __( 'Tumblog Setup', 'woothemes' ),
					'type' => 'subheading' );

	$options[] = array( "name" => __( 'Tumblog Functionality', 'woothemes' ),
						"desc" => "",
						"id" => $shortname."_woo_tumblog_notice",
						"std" => sprintf( __( 'Tumblog will allow you to publish content using the WooTumblog functionality, including the Express for WordPress iPhone App. If you would like to use the iPhone app, you will need to enable XML-RPC publishing under Settings->Writing. Find out more at %s.', 'woothemes' ), '<a href="http://express-app.com/" target="_blank">Express-App.com</a>' ),
						"type" => "info");

	$options[] = array( "name" => __( 'Enable Tumblog Functionality', 'woothemes' ),
						"desc" => __( 'Enable Tumblog functionality in Canvas.', 'woothemes' ),
						"id" => $shortname."_woo_tumblog_switch",
						"std" => "false",
						"type" => "checkbox");

	$content_option_array = array( 	'taxonomy' 	=> __( 'Taxonomy', 'woothemes' ),
								'post_format' => __( 'Post Formats', 'woothemes' )
									);

	$options[] = array( "name" => __( 'Tumblog Content Method', 'woothemes' ),
					"desc" => __( 'Select if you would like to use a Taxonomy of Post Formats to categorize your Tumblog content.', 'woothemes' ),
					"id" => $shortname."_tumblog_content_method",
					"std" => "post_format",
					"type" => "select2",
					"options" => $content_option_array);

	$options[] = array( "name" => __( 'Use Custom Tumblog RSS Feed', 'woothemes' ),
						"desc" => __( 'Replaces the default WordPress RSS feed output with Tumblog RSS output.', 'woothemes' ),
						"id" => $shortname."_custom_rss",
						"std" => "true",
						"type" => "checkbox");

	$options[] = array( "name" => __( 'Tumblog Media Widths on the "Magazine" Page Template\'s Grid', 'woothemes' ),
						"desc" => __( 'The output width for Tumblog media (images, videos, audio) on the "Magazine" page template\'s grid.', 'woothemes' ),
						"id" => $shortname."_tumblog_magazine_media_width",
						"std" => "300",
						"type" => "text");

	$options[] = array( 'name' => __( 'Content Formats', 'woothemes' ),
					'type' => 'subheading' );

	$options[] = array( "name" => __( 'Images Link to', 'woothemes' ),
						"desc" => __( 'Select where your Tumblog Images will link to when clicked.', 'woothemes' ),
						"id" => $shortname."_image_link_to",
						"std" => "post",
						"type" => "radio",
						"options" => $options_image_link_to);

	$options[] = array( "name" => __( 'Tumblog Images Width', 'woothemes' ),
						"desc" => __( 'The output width for Tumblog image post images.', 'woothemes' ),
						"id" => $shortname."_tumblog_image_width",
						"std" => "610",
						"type" => "text");

	$options[] = array( "name" => __( 'Tumblog Content Position: Images', 'woothemes' ),
						"desc" => __( 'Select where you would like the Tumblog Specific content to be output around the standard content.', 'woothemes' ),
						"id" => $shortname."_woo_tumblog_images_content",
						"std" => 'Before',
						"type" => "select",
						"options" => $tumblog_options);

	$options[] = array( "name" => __( 'Tumblog Audio Width', 'woothemes' ),
						"desc" => __( 'The output width for Tumblog Audio player.', 'woothemes' ),
						"id" => $shortname."_tumblog_audio_width",
						"std" => "440",
						"type" => "text");

	$options[] = array( "name" => __( 'Tumblog Content Position: Audio', 'woothemes' ),
						"desc" => __( 'Select where you would like the Tumblog Specific content to be output around the standard content.', 'woothemes' ),
						"id" => $shortname."_woo_tumblog_audio_content",
						"std" => 'Before',
						"type" => "select",
						"options" => $tumblog_options);

	$options[] = array( "name" => __( 'Tumblog Video Width', 'woothemes' ),
						"desc" => __( 'The output width for Tumblog Videos.', 'woothemes' ),
						"id" => $shortname."_tumblog_video_width",
						"std" => "610",
						"type" => "text");

	$options[] = array( "name" => __( 'Tumblog Content Position: Video', 'woothemes' ),
						"desc" => __( 'Select where you would like the Tumblog Specific content to be output around the standard content.', 'woothemes' ),
						"id" => $shortname."_woo_tumblog_videos_content",
						"std" => "Before",
						"type" => "select",
						"options" => $tumblog_options);

	$options[] = array( "name" => __( 'Tumblog Content Position: Quotes', 'woothemes' ),
						"desc" => __( 'Select where you would like the Tumblog Specific content to be output around the standard content.', 'woothemes' ),
						"id" => $shortname."_woo_tumblog_quotes_content",
						"std" => "Before",
						"type" => "select",
						"options" => $tumblog_options);

} // ENDIF Tumblog section

/* Subscribe & Connect */

	$options[] = array( "name" => __( 'Subscribe & Connect', 'woothemes' ),
						"type" => "heading",
						"icon" => "connect");

	$options[] = array( 'name' => __( 'S&C Setup', 'woothemes' ),
					'type' => 'subheading' );

	$options[] = array( "name" => __( 'Enable Subscribe & Connect - Single Post', 'woothemes' ),
						"desc" => sprintf( __( 'Enable the subscribe & connect area on single posts. You can also add this as a <a href="%s">widget</a> in your sidebar.', 'woothemes' ), admin_url( 'widgets.php' ) ),
						"id" => $shortname."_connect",
						"std" => 'true',
						"type" => "checkbox");

	$options[] = array( "name" => __( 'Subscribe Title', 'woothemes' ),
						"desc" => __( 'Enter the title to show in your subscribe & connect area.', 'woothemes' ),
						"id" => $shortname."_connect_title",
						"std" => '',
						"type" => "text");

	$options[] = array( "name" => __( 'Text', 'woothemes' ),
						"desc" => __( 'Change the default text in this area.', 'woothemes' ),
						"id" => $shortname."_connect_content",
						"std" => '',
						"type" => "textarea");

	$options[] = array( "name" => __( 'Enable Related Posts', 'woothemes' ),
						"desc" => __( 'Enable related posts in the subscribe area. Uses posts with the same <strong>tags</strong> to find related posts. Note: Will not show in the Subscribe widget.', 'woothemes' ),
						"id" => $shortname."_connect_related",
						"std" => 'true',
						"type" => "checkbox");

	$options[] = array( 'name' => __( 'Subscribe', 'woothemes' ),
					'type' => 'subheading' );

	$options[] = array( "name" => __( 'Subscribe By E-mail ID (Feedburner)', 'woothemes' ),
						"desc" => sprintf( __( 'Enter your <a href="%s">Feedburner ID</a> for the e-mail subscription form.', 'woothemes' ), 'http://www.woothemes.com/tutorials/how-to-find-your-feedburner-id-for-email-subscription/' ),
						"id" => $shortname."_connect_newsletter_id",
						"std" => '',
						"type" => "text");

	$options[] = array( "name" => __( 'Subscribe By E-mail to MailChimp', 'woothemes' ),
						"desc" => sprintf( __( 'If you have a MailChimp account you can enter the <a href="%s" target="_blank">MailChimp List Subscribe URL</a> to allow your users to subscribe to a MailChimp List.', 'woothemes' ), 'http://woochimp.heroku.com' ),
						"id" => $shortname."_connect_mailchimp_list_url",
						"std" => '',
						"type" => "text");

	$options[] = array( 'name' => __( 'Connect', 'woothemes' ),
					'type' => 'subheading' );

	$options[] = array( "name" => __( 'Enable RSS', 'woothemes' ),
						"desc" => __( 'Enable the subscribe and RSS icon.', 'woothemes' ),
						"id" => $shortname."_connect_rss",
						"std" => 'true',
						"type" => "checkbox");

	$options[] = array( "name" => __( 'Twitter URL', 'woothemes' ),
						"desc" => __( 'Enter your  <a href="http://www.twitter.com/">Twitter</a> URL e.g. http://www.twitter.com/woothemes', 'woothemes' ),
						"id" => $shortname."_connect_twitter",
						"std" => '',
						"type" => "text");

	$options[] = array( "name" => __( 'Facebook URL', 'woothemes' ),
						"desc" => __( 'Enter your  <a href="http://www.facebook.com/">Facebook</a> URL e.g. http://www.facebook.com/woothemes', 'woothemes' ),
						"id" => $shortname."_connect_facebook",
						"std" => '',
						"type" => "text");

	$options[] = array( "name" => __( 'YouTube URL', 'woothemes' ),
						"desc" => __( 'Enter your  <a href="http://www.youtube.com/">YouTube</a> URL e.g. http://www.youtube.com/woothemes', 'woothemes' ),
						"id" => $shortname."_connect_youtube",
						"std" => '',
						"type" => "text");

	$options[] = array( "name" => __( 'Flickr URL', 'woothemes' ),
						"desc" => __( 'Enter your  <a href="http://www.flickr.com/">Flickr</a> URL e.g. http://www.flickr.com/woothemes', 'woothemes' ),
						"id" => $shortname."_connect_flickr",
						"std" => '',
						"type" => "text");

	$options[] = array( "name" => __( 'LinkedIn URL', 'woothemes' ),
						"desc" => __( 'Enter your  <a href="http://www.www.linkedin.com.com/">LinkedIn</a> URL e.g. http://www.linkedin.com/in/woothemes', 'woothemes' ),
						"id" => $shortname."_connect_linkedin",
						"std" => '',
						"type" => "text");

	$options[] = array( "name" => __( 'Delicious URL', 'woothemes' ),
						"desc" => __( 'Enter your <a href="http://www.delicious.com/">Delicious</a> URL e.g. http://www.delicious.com/woothemes', 'woothemes' ),
						"id" => $shortname."_connect_delicious",
						"std" => '',
						"type" => "text");

	$options[] = array( "name" => __( 'Google+ URL', 'woothemes' ),
						"desc" => __( 'Enter your <a href="http://plus.google.com/">Google+</a> URL e.g. https://plus.google.com/104560124403688998123/', 'woothemes' ),
						"id" => $shortname."_connect_googleplus",
						"std" => '',
						"type" => "text" );

	$options[] = array( 'name' => __( 'Dribbble', 'woothemes' ),
	    				'desc' => sprintf( __( 'Enter your %1$s URL e.g. http://dribbble.com/woothemes', 'woothemes' ), '<a href="http://dribbble.com/">'.__( 'Dribbble', 'woothemes' ).'</a>' ),
	    				'id' => $shortname . '_connect_dribbble',
	    				'std' => '',
	    				'type' => 'text' );

	$options[] = array( 'name' => __( 'Instagram', 'woothemes' ),
	    				'desc' => sprintf( __( 'Enter your %1$s URL e.g. http://instagram.com/woothemes', 'woothemes' ), '<a href="http://instagram.com">'.__( 'Instagram', 'woothemes' ).'</a>' ),
	    				'id' => $shortname . '_connect_instagram',
	    				'std' => '',
	    				'type' => 'text' );

	$options[] = array( 'name' => __( 'Vimeo', 'woothemes' ),
	    				'desc' => sprintf( __( 'Enter your %1$s URL e.g. http://vimeo.com/woothemes', 'woothemes' ), '<a href="http://vimeo.com/">'.__( 'Vimeo', 'woothemes' ).'</a>' ),
	    				'id' => $shortname . '_connect_vimeo',
	    				'std' => '',
	    				'type' => 'text' );

	$options[] = array( 'name' => __( 'Pinterest', 'woothemes' ),
	    				'desc' => sprintf( __( 'Enter your %1$s URL e.g. http://pinterest.com/woothemes', 'woothemes' ), '<a href="http://pinterest.com/">'.__( 'Pinterest', 'woothemes' ).'</a>' ),
	    				'id' => $shortname . '_connect_pinterest',
	    				'std' => '',
	    				'type' => 'text' );

/* 404 Template page settings */

$options[] = array( 'name' => __( '404 Page', 'woothemes' ),
                   			 'icon' => 'error404',
                   			 'type' => 'heading');

$options[] = array( "name" => __( '404 Image Location ( 400 x 250 )', 'woothemes' ),
                                                                "desc" => __( 'Upload a banner for your 404 page, or specify an image URL directly.', 'woothemes' ),
                                                                "id" => $shortname."_content_error_image",
                                                                "std" => "",
                                                                "type" => "upload");

$options[] = array( "name" => __( '404 Text', 'woothemes' ),
                                                                 "desc" => __( 'Enter the text you want to show in your 404 page here.', 'woothemes' ),
                                                                 "id" => $shortname."_content_error_page",
                                                                 "std" => "",
                                                                 "type" => "textarea");


/* Contact Template Settings */

$options[] = array( 'name' => __( 'Contact Page', 'woothemes' ),
					'icon' => 'maps',
				    'type' => 'heading');

$options[] = array( 'name' => __( 'Contact Information', 'woothemes' ),
					'type' => 'subheading');

$options[] = array( "name" => __( 'H3 Font Style', 'woothemes' ),
					"desc" => __( 'Select the typography you want for header H3.', 'woothemes' ),
					"id" => $shortname."_font_h3_contact",
					"std" => array('size' => '20','unit' => 'px', 'face' => 'Playfair Display','style' => 'bold','color' => '#222222'),
					"type" => "typography");

$options[] = array( "name" => __( 'Contact Information Panel', 'woothemes' ),
					"desc" => __( 'Enable the contact information panel on your contact page template.', 'woothemes' ),
					"id" => $shortname."_contact_panel",
					"std" => "false",
					"class" => 'collapsed',
					"type" => "checkbox" );

$options[] = array( 'name' => __( 'Location Name', 'woothemes' ),
					'desc' => __( 'Enter the location name. Example: London Office', 'woothemes' ),
					'id' => $shortname . '_contact_title',
					'std' => '',
					'class' => 'hidden',
					'type' => 'text' );

$options[] = array( 'name' => __( 'Location Address', 'woothemes' ),
					'desc' => __( 'Enter your company\'s address', 'woothemes' ),
					'id' => $shortname . '_contact_address',
					'std' => '',
					'class' => 'hidden',
					'type' => "textarea" );

$options[] = array( 'name' => __( 'Telephone', 'woothemes' ),
					'desc' => __( 'Enter your telephone number', 'woothemes' ),
					'id' => $shortname . '_contact_number',
					'std' => '',
					'class' => 'hidden',
					'type' => 'text' );

$options[] = array( 'name' => __( 'Fax', 'woothemes' ),
					'desc' => __( 'Enter your fax number', 'woothemes' ),
					'id' => $shortname . '_contact_fax',
					'std' => '',
					'class' => 'hidden last',
					'type' => 'text' );

$options[] = array( "name" => __( 'Contact Form E-Mail', 'woothemes' ),
					"desc" => __( 'Enter your E-mail address to use on the "Contact Form" page Template.', 'woothemes' ),
					"id" => $shortname."_contactform_email",
					"std" => "",
					"type" => "text" );


$options[] = array( "name" => __( 'Enable Subscribe and Connect', 'woothemes' ),
					"desc" => __( 'Enable the subscribe and connect functionality on the contact page template', 'woothemes' ),
					"id" => $shortname."_contact_subscribe_and_connect",
					"std" => "false",
					"type" => "checkbox" );

$options[] = array( 'name' => __( 'Maps', 'woothemes' ),
					'type' => 'subheading');

$options[] = array( 'name' => __( 'Contact Form Google Maps Coordinates', 'woothemes' ),
					'desc' => sprintf( __( 'Enter your Google Map coordinates to display a map on the Contact Form page template. You can get these details from %sGoogle Maps%s e.g: 51.523704, -0.158553' , 'woothemes' ), '<a href="' . esc_url( 'http://itouchmap.com/latlong.html' ) . '" target="_blank">', '</a>' ),
					'id' => $shortname . '_contactform_map_coords',
					'std' => '',
					'type' => 'text' );

$options[] = array( 'name' => __( 'Disable Mousescroll', 'woothemes' ),
					'desc' => __( 'Turn off the mouse scroll action for all the Google Maps on the site. This could improve usability on your site.', 'woothemes' ),
					'id' => $shortname . '_maps_scroll',
					'std' => '',
					'type' => 'checkbox');

$options[] = array( 'name' => __( 'Map Height', 'woothemes' ),
					'desc' => __( 'Set the height in pixel for the map displayed on your contact page, e.g: 480', 'woothemes' ),
					'id' => $shortname . '_maps_single_height',
					'std' => "480",
					'type' => 'text');

$options[] = array( 'name' => __( 'Default Map Zoom Level', 'woothemes' ),
					'desc' => __( 'Set a default zoom level for the map.', 'woothemes' ),
					'id' => $shortname . '_maps_default_mapzoom',
					'std' => "9",
					'type' => 'select2',
					'options' => $other_entries);

$options[] = array( 'name' => __( 'Default Map Type', 'woothemes' ),
					'desc' => __( 'Set a default map type in use.', 'woothemes' ),
					'id' => $shortname . '_maps_default_maptype',
					'std' => 'G_NORMAL_MAP',
					'type' => 'select2',
					'options' => array( 'G_NORMAL_MAP' => __( 'Normal', 'woothemes' ), 'G_SATELLITE_MAP' => __( 'Satellite', 'woothemes' ), 'G_HYBRID_MAP' => __( 'Hybrid', 'woothemes' ), 'G_PHYSICAL_MAP' => __( 'Terrain', 'woothemes' ) ) );

$options[] = array( "name" => __( 'Custom Marker', 'woothemes' ),
					"desc" => __( 'Upload a custom marker for your Maps, or specify an image URL directly.', 'woothemes' ),
					"id" => $shortname."_cat_custom_marker_pages",
					"std" => THEME_URI."/images/map-icon.png",
					"type" => "upload");

$options[] = array( 'name' => __( 'Map Callout Text', 'woothemes' ),
					'desc' => __( 'Enter Text or HTML that will be displayed when you click on the map marker.', 'woothemes' ),
					'id' => $shortname . '_maps_callout_text',
					'std' => "",
					'type' => 'textarea');


// Add extra options through function
if ( function_exists("woo_options_add") )
	$options = woo_options_add($options);

if ( get_option('woo_template') != $options) update_option('woo_template',$options);
if ( get_option('woo_themename') != $themename) update_option('woo_themename',$themename);
if ( get_option('woo_shortname') != $shortname) update_option('woo_shortname',$shortname);
if ( get_option('woo_manual') != $manualurl) update_option('woo_manual',$manualurl);

// Woo Metabox Options
$woo_metaboxes = array();

if( get_post_type() == 'post' || !get_post_type() ){

	// TimThumb is enabled in options
	if ( get_option( 'woo_resize') == 'true' ) {

		$woo_metaboxes[] = array (	'name' => 'image',
									'label' => __( 'Image', 'woothemes' ),
									'type' => 'upload',
									'desc' => __( 'Upload an image or enter an URL.', 'woothemes' ) );

		$woo_metaboxes[] = array (	'name' => '_image_alignment',
									'std' => __( 'Center', 'woothemes' ),
									'label' => __( 'Image Crop Alignment', 'woothemes' ),
									'type' => 'select2',
									'desc' => __( 'Select crop alignment for resized image', 'woothemes' ),
									'options' => array(	'c' => 'Center',
														't' => 'Top',
														'b' => 'Bottom',
														'l' => 'Left',
														'r' => 'Right'));
	}

	$url =  THEME_URI . '/functions/images/';
	$woo_metaboxes[] = array (	"name" => "layout",
								"label" => __( 'Layout', 'woothemes' ),
								"type" => "images",
								"desc" => __( 'Select a specific layout for this post/page. Overrides default site layout.', 'woothemes' ),
								"options" => array(	'' => $url . 'layout-off.png',
													'one-col' => $url . '1c.png',
													'two-col-left' => $url . '2cl.png',
													'two-col-right' => $url . '2cr.png'));

	$woo_metaboxes[] = array (	"name" => "embed",
								"label" => __( 'Embed', 'woothemes' ),
								"type" => "textarea",
								"desc" => __( 'Enter embed code for use on single posts and with the Video widget.', 'woothemes' ) );

	if (get_option('woo_woo_tumblog_switch') == 'true') {

		$woo_metaboxes[] = array (	"name" => "video-embed",
									"label" => __( 'Tumblog : Embed Code (Videos)', 'woothemes' ),
									"type" => "textarea",
									"desc" => __( 'Add embed code for video services like Youtube or Vimeo - Tumblog only.', 'woothemes' ) );

    	$woo_metaboxes[] = array (	"name" => "quote-author",
									"std" => "Unknown",
									"label" => __( 'Tumblog : Quote Author', 'woothemes' ),
									"type" => "text",
									"desc" => __( 'Enter the name of the Quote Author.', 'woothemes' ) );

    	$woo_metaboxes[] = array (	"name" => "quote-url",
									"std" => "http://",
									"label" => __( 'Tumblog : Link to Quote', 'woothemes' ),
									"type" => "text",
									"desc" => __( 'Enter the url/web address of the Quote if available.', 'woothemes' ) );

    	$woo_metaboxes[] = array (	"name" => "quote-copy",
    								"std"  => "Unknown",
									"label" => __( 'Tumblog : Quote', 'woothemes' ),
									"type" => "textarea",
									"desc" => __( 'Enter the Quote.', 'woothemes' ) );

		$woo_metaboxes[] = array (	"name" => "audio",
									"std" => "http://",
									"label" => __( 'Tumblog : Audio URL', 'woothemes' ),
									"type" => "text",
									"desc" => __( 'Enter the url/web address of the Audio file.', 'woothemes' ) );

    	$woo_metaboxes[] = array (	"name" => "link-url",
									"std" => "http://",
									"label" => __( 'Tumblog : Link URL', 'woothemes' ),
									"type" => "text",
									"desc" => __( 'Enter the url/web address of the Link.', 'woothemes' ) );

	}

} // End post

if( get_post_type() == 'slide' || ! get_post_type() ) {

	// TimThumb is enabled in options
	if ( get_option( 'woo_resize') == 'true' ) {

		$woo_metaboxes[] = array (	"name" => "image",
									"label" => __( 'Image', 'woothemes' ),
									"type" => "upload",
									"desc" => __( 'Upload an image to be used as background of this slide. (optional)', 'woothemes' ) );

	}

	$woo_metaboxes[] = array (	"name" => "url",
								"label" => __( 'URL', 'woothemes' ),
								"type" => "text",
								"desc" => __( 'Enter URL if you want to add a link to the uploaded image. (optional)', 'woothemes' ) );

	    $woo_metaboxes[] = array (
                                    'name'  => 'embed',
                                    'std'  => '',
                                    'label' => __( 'Embed Code', 'woothemes' ),
                                    'type' => 'textarea',
                                    'desc' => __( 'Enter the video embed code for your video (YouTube, Vimeo or similar)', 'woothemes' )
                                    );

} // End slide

// lookbook
if ( get_post_type() == 'lookbook' || !get_post_type() ) {

	$woo_metaboxes[] = array (	"name" => "url_product",
								"label" => __( 'URL', 'woothemes' ),
								"type" => "text",
								"desc" => __( 'Enter URL of your product. (optional)', 'woothemes' ) );

}

/* "portfolio" Custom Post Type. */

if ( get_post_type() == 'portfolio' || !get_post_type() ) {
$woo_metaboxes[] = array (	"name" => "style_single_port",
								"label" => __( 'Style Single Portfolio', 'woothemes' ),
								"type" => "images",
								"desc" => __( 'Select a specific layout for this porfolio post.', 'woothemes' ),
								"options" => array(	'1' => $url . 'porto_side.png',
													'2' => $url . 'porto_center.png',
													'3' => $url . 'porto_fullcenter.png',
													'4' => $url . 'porto_blank.png'));

	$woo_metaboxes[] = array (  "name"  => "embed",
					            "std"  => "",
					            "label" => __( 'Video Embed Code', 'woothemes' ),
					            "type" => "textarea",
					            "desc" => __( 'Enter the video embed code for your video (YouTube, Vimeo or similar). Will show instead of your image.', 'woothemes' ) );



	$woo_metaboxes['testimonial'] = array (
								"name" => "testimonial",
								"label" => __( 'Testimonial', 'woothemes' ),
								"type" => "textarea",
								"desc" => __( 'Enter a testimonial from your client to be displayed on the single portfolio page', 'woothemes' ) );

	$woo_metaboxes['testimonial_author'] = array (
								"name" => "testimonial_author",
								"label" => __( 'Testimonial Author', 'woothemes' ),
								"type" => "text",
								"desc" => __( 'Enter the name of the author of the testimonial e.g. Joe Bloggs', 'woothemes' ) );




		$woo_metaboxes['client_name'] = array (
								"name" => "client_name",
								"label" => __( 'Client Name', 'woothemes' ),
								"type" => "text",
								"desc" => __( 'Enter name of your clients. (optional)', 'woothemes' ) );

	$woo_metaboxes[] = array (	"name" => "url",
								"label" => __( 'URL', 'woothemes' ),
								"type" => "text",
								"desc" => __( 'Enter URL of your clients site. (optional)', 'woothemes' ) );


	$woo_metaboxes['date_project'] = array (
								"name" => "date_project",
								"label" => __( 'Date Projects', 'woothemes' ),
								"type" => "calendar",
								"desc" => __( 'Enter date of your projects. (optional)', 'woothemes' ) );

} //End portfolio

if( get_post_type() == 'feedback' || !get_post_type()){

	$woo_metaboxes['feedback_author'] = array (
								"name" => "feedback_author",
								"label" => __( 'Feedback Author', 'woothemes' ),
								"type" => "text",
								"desc" => __( 'Enter the name of the author of the feedback e.g. Joe Bloggs', 'woothemes' )
			);

	$woo_metaboxes['feedback_url'] = array (
								"name" => "feedback_url",
								"label" => __( 'Feedback URL', 'woothemes' ),
								"type" => "text",
								"desc" => __( '(optional) Enter the URL to the feedback author e.g. http://www.woothemes.com', 'woothemes' )
			);


} // End feedback

// Page fields.
if( get_post_type() == 'page' || ! get_post_type() ) {

	// Create an array of the available "Slide Pages".
	// $slide_pages = array(
	// 					'all' => __( 'All', 'woothemes' )
	// 					);

	// $terms = get_terms( 'slide-page' );

	// if ( is_array( $terms ) && ( count( $terms ) > 0 ) ) {
	// 	foreach ( $terms as $k => $v ) {
	// 		$slide_pages[$v->slug] = $v->name;
	// 	}
	// }

	// $woo_metaboxes[] = array (	"name" => "_slide-page",
	// 								"std" => "",
	// 								"label" => __( 'Slide Group', 'woothemes' ),
	// 								"type" => "select2",
	// 								"desc" => __( 'Optionally select a "Slide Group" to show slides from only that "Slide Group".', 'woothemes' ),
	// 								"options" => $slide_pages );

	$woo_metaboxes[] = array(
		'name' 		=> '_banner',
		'std' 		=> true,
		'label' 	=> __( 'Display Homepage Slider', 'woothemes' ),
		'type' 		=> 'checkbox',
		'desc' 		=> __( 'Enable Revolution Slider ?', 'woothemes' ),
    );

	$woo_metaboxes[] = array(
		"name" 		=> "_revolutionslider",
		"label" 	=> __( "Revolution Slider", "woothemes" ),
		"type" 		=> "select2",
		"desc" 		=> __( 'Select a Slider Homepage from Revolution Slider. ', 'woothemes' ),
		"std" 		=> "0",
		"options" 	=> $revslider_options
	);

} // End slide

// Show layout option on all pages
if ( get_post_type() != 'post' && get_post_type() != 'slide' && get_post_type() != 'feedback' && get_post_type() != 'product' && get_post_type() != 'lookbook' && get_post_type() != 'size' && get_post_type() != 'portfolio')  {

	$url =  THEME_URI . '/functions/images/';
	$woo_metaboxes[] = array (	"name" => "layout",
								"label" => __( 'Layout', 'woothemes' ),
								"type" => "images",
								"desc" => __( 'Select a specific layout for this post/page. Overrides default site layout.', 'woothemes' ),
								"options" => array(	'' => $url . 'layout-off.png',
													'one-col' => $url . '1c.png',
													'two-col-left' => $url . '2cl.png',
													'two-col-right' => $url . '2cr.png'));
	$loo_pages = '';
	$terms = get_terms( 'lookbook-category' );

	if ( is_array( $terms ) && ( count( $terms ) > 0 ) ) {
		foreach ( $terms as $k => $v ) {
			$loo_pages[$v->slug] = $v->name;
		}
	}
		$woo_metaboxes[] = array ( "name" => "lookbook_category",
                                                    "label" => __( "Lookbook Category", "woothemes" ),
                                                    "type" => "select2",
                                                     "desc" => __( 'Select a Category From Lookbook (if you are using page template lookbook). ', 'woothemes' ),
                                                    "std" => "0",
                                                    "options" => $loo_pages
                                                 );



}

if( class_exists('woocommerce') && get_post_type() == 'product' ) {
	$woo_metaboxes[] = array ( "name" => "_enable_size_guide",
                                                    "label" => __( "Size Guide", "woothemes" ),
                                                    "type" => "checkbox",
                                                     "std" => "false",
                                                     "desc" => __( ' Enable Size Guide On This Product. ', 'woothemes' ),
                                                 );
		$sg_pages ='';

	$terms = get_terms( 'size-category' );

	if ( is_array( $terms ) && ( count( $terms ) > 0 ) ) {
		foreach ( $terms as $k => $v ) {
			$sg_pages[$v->slug] = $v->name;
		}
	}
		$woo_metaboxes[] = array ( "name" => "_category_size_guide",
                                                    "label" => __( "Size Guide Category", "woothemes" ),
                                                    "type" => "select2",
                                                     "desc" => __( 'Select a Category From Size Guide. ', 'woothemes' ),
                                                    "std" => "0",
                                                    "options" => $sg_pages
                                                 );

	$woo_metaboxes[] = array ( "name" => "_custom_tab_heading",
                                                    "label" => __( "Header Tab", "woothemes" ),
                                                    "type" => "text",
                                                     "desc" => __( 'Text Header For Custom Tab. ', 'woothemes' ),
                                                 );
	$woo_metaboxes[] = array ( "name" => "_custom_tab_text_content",
                                                    "label" => __( "Text content custom tab one", "woothemes" ),
                                                    "type" => "textarea",
                                                     "desc" => __( 'Text content for custom tab. ', 'woothemes' ),
                                                 );
	$woo_metaboxes[] = array ( "name" => "_custom_tab_heading_two",
                                                    "label" => __( "Header Tab 2", "woothemes" ),
                                                    "type" => "text",
                                                     "desc" => __( 'Text Header For Custom Tab. ', 'woothemes' ),
                                                 );
	$woo_metaboxes[] = array ( "name" => "_custom_tab_text_content_two",
                                                    "label" => __( "Text content custom tab two", "woothemes" ),
                                                    "type" => "textarea",
                                                     "desc" => __( 'Text content for custom tab. ', 'woothemes' ),
                                                 );
}


// Add extra metaboxes through function
if ( function_exists("woo_metaboxes_add") )
	$woo_metaboxes = woo_metaboxes_add($woo_metaboxes);

if ( get_option('woo_custom_template') != $woo_metaboxes) update_option('woo_custom_template',$woo_metaboxes);

} // END woo_options()
} // END function_exists()

// Add options to admin_head
add_action( 'admin_head','woo_options' );

//Enable WooSEO on these Post types
$seo_post_types = array( 'post','page' );
define( "SEOPOSTTYPES", serialize($seo_post_types));

//Global options setup
add_action( 'init','woo_global_options' );
function woo_global_options(){
	// Populate WooThemes option in array for use in theme
	global $woo_options;
	$woo_options = get_option( 'woo_options' );
}

?>