<?php

// Display related products?
add_action( 'wp_head','wooframework_related_products' );
if ( ! function_exists( 'wooframework_related_products' ) ) {
	function wooframework_related_products() {
		global $woo_options;
		if ( isset( $woo_options['woocommerce_related_products'] ) &&  'false' == $woo_options['woocommerce_related_products'] ) {
			remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
		}
	} // End wooframework_related_products()
}

if ( ! function_exists( 'wc_related_products' ) ) {
    add_filter( 'woocommerce_output_related_products_args', 'wc_related_products' );
	function wc_related_products() {
		$products_max 	= 4;
		$products_cols 	= 4;
		$args = apply_filters( 'labomba_related_products_args', array(
			'posts_per_page' => $products_max,
			'columns'        => $products_cols,
		) );
		return $args;
	}
	
}

// Change columns in upsells to 4
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
add_action( 'woocommerce_after_single_product_summary', 'woo_wc_upsell_display', 15 );
if (!function_exists('woo_wc_upsell_display')) {
	function woo_wc_upsell_display() {
	    woocommerce_upsell_display( -1, 4 );
	}
}

add_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_recently_products', 25 );
if(!function_exists( 'woocommerce_output_recently_products' )) {
	function woocommerce_output_recently_products() {
		global $woo_options;
		if(isset($woo_options['woocommerce_recent_view_products']) && 'true' == $woo_options['woocommerce_recent_view_products'] ){

		echo '<div class="recently-viewed products">
		<header><h4><span>'.__('Recently Viewed', 'woothemes').'</span></h4></header>';
		echo do_shortcode( '[woocommerce_recently_viewed_products per_page="6"]' );
		echo '</div>';
		}
	}

}

// Change thumbs on the single page to 5 per column
add_filter( 'woocommerce_product_thumbnails_columns', 'woocommerce_custom_product_thumbnails_columns' );
if (!function_exists('woocommerce_custom_product_thumbnails_columns')) {
	function woocommerce_custom_product_thumbnails_columns() {
		return 5;
	}
}

// Display the ratings on the single page
add_action( 'woocommerce_single_product_summary', 'woocommerce_single_product_rating_overview', 10);
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
// Remove default review stuff - the theme overrides it
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );


if (!function_exists('woocommerce_single_product_rating_overview')) {
	function woocommerce_single_product_rating_overview() {
		global $product;
		$review_total = get_comments_number();
		if ( $review_total > 0 && get_option( 'woocommerce_enable_review_rating' ) !== 'no' ) {
			echo '<div class="rating-wrap" itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">';
				echo $product->get_rating_html();
				echo '<span class="review-count"><a href="#reviews">';
					comments_number( '', __('1 customer review', 'woothemes'), __('% customer reviews', 'woothemes') );
				echo '</a></span>';
			echo '</div>';
		}
		
	}
}

//Remove Data Tabs Add to Product Summary
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
add_action( 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 55);

//Remove single product title summary and add to top 
remove_action('woocommerce_single_product_summary' ,'woocommerce_template_single_title', 5);
add_action('woocommerce_before_single_product_summary' ,'woocommerce_template_single_title', 5);

//Price
// remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
// add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 25);

//Remove Loop & Single Product Add To Cart Button
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
// Remove coupon form
remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );

//Catalog Mode
function woo_hide_atcbutton_single_product(){
global $woo_options;
if(isset($woo_options['woocommerce_button_atc']) && $woo_options['woocommerce_button_atc'] == 'true' ){
remove_action('woocommerce_single_product_summary','woocommerce_template_single_add_to_cart', 30 );
remove_action('custom_single_product_summary','woocommerce_template_single_add_to_cart', 10);
	} else {
		add_action('custom_single_product_summary','woocommerce_template_single_add_to_cart', 10);
	}
}
add_action('wp_head','woo_hide_atcbutton_single_product' );

//Remove Meta TAG and Add to below main product Images
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);

if(get_option('woo_single_product_mode_layout') == 'classic'){
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 60);
}

//Remove Share
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
add_action( 'woocommerce_custom_sharethis','woocommerce_template_single_sharing' );

function woocommerce_custom_sharethis(){
	global $post;
	$src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), false, '' );
	?>
	<ul>
			    <li><a href="mailto:?subject=<?php the_title(); ?>&body=<?php echo strip_tags(apply_filters( 'woocommerce_short_description', $post->post_excerpt )); ?> <?php the_permalink(); ?>" class="product_share_email"><i class="ico-mail"></i><?php _e('Email A friend', 'woothemes'); ?></a></li>
			    <li><a href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>" target="_blank" class="product_share_facebook"><i class="ico-facebook"></i> Facebook</a></li>
			    <li><a href="https://twitter.com/share?url=<?php the_permalink(); ?>" target="_blank" class="product_share_twitter"><i class="ico-twitter"></i> Twitter</a></li>   
			    <li><a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" onclick="javascript:window.open(this.href,
			      '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="ico-google-plus"></i> Google Plus</a></li>
			    <li><a href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo $src[0]; ?>&description=<?php the_title(); ?>" target="_blank" class="product_share_pinterest"><i class="ico-pinterest"></i> Pinterest</a></li>
			</ul> 
			<?php 
}

//add SKU 
if (!function_exists('woocommerce_custom_sku')) {
	add_action('woocommerce_single_product_summary', 'woocommerce_custom_sku', 10);
	add_action( 'woocommerce_single_product_skuquickview_summary', 'woocommerce_custom_sku', 10);
	function woocommerce_custom_sku(){	
global $post, $product;
 if ( $product->is_type( array( 'simple', 'variable' ) ) && get_option( 'woocommerce_enable_sku' ) == 'yes' && $product->get_sku() ) : ?>
		<span itemprop="productID" class="sku_wrapper"><?php _e( 'SKU:', 'woothemes' ); ?> <span class="sku"><?php echo $product->get_sku(); ?></span>.</span>
	<?php endif; 
	}
}
//add custom stock availability
if (!function_exists('woocommerce_custom_stock_availability')) {
	add_action('woocommerce_single_product_summary', 'woocommerce_custom_availability', 10);
	add_action( 'woocommerce_single_product_skuquickview_summary', 'woocommerce_custom_availability', 10);
	function woocommerce_custom_availability(){	
global $woocommerce, $product;
// Availability
	$availability = $product->get_availability();

	if ($availability['availability'] ) :
		echo apply_filters( 'woocommerce_stock_html', '<p class="stock ' . esc_attr( $availability['class'] ) . '">' . esc_html( $availability['availability'] ) . '</p>', $availability['availability'] );
    endif;
	}
}

// Hook in 
// add_filter( 'woocommerce_get_availability', 'custom_override_get_availability', 1, 2);
// Our hooked in function $availablity is passed via the filter!
// function custom_override_get_availability( $availability, $product ) {
// if ( $product->is_in_stock() ) $availability['availability'] = __('In Stocks', 'woothemes');
// return $availability;
// }

//Customize Single Product
add_action('init', 'woocommerce_product_single_mode');
function woocommerce_product_single_mode(){
$settings = woo_get_dynamic_values(array( 'single_product_mode_layout' => 'modern' ));
if('modern' == $settings['single_product_mode_layout']){
add_action('woocommerce_single_product_summary','woocommerce_before_product_description_wrap', 0 );
add_action('woocommerce_single_product_summary','woocommerce_after_product_description_wrap', 22 );
add_action('woocommerce_single_product_summary','woocommerce_before_product_quantity_wrap', 24 );
add_action('woocommerce_single_product_summary','woocommerce_after_product_quantity_wrap', 40 );

//Price
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 25);

if(!function_exists('woocommerce_before_product_description_wrap')){
	function woocommerce_before_product_description_wrap(){
		echo '<div class="woocommerce-summary-wrap">';
	}
}

if(!function_exists('woocommerce_after_product_description_wrap')){
	function woocommerce_after_product_description_wrap(){
		echo '</div>';
	}
}

if(!function_exists('woocommerce_before_product_quantity_wrap')){
	function woocommerce_before_product_quantity_wrap(){
		echo '<div class="woocommerce-qty-wrap">';
	}
}

if(!function_exists('woocommerce_after_product_quantity_wrap')){
	function woocommerce_after_product_quantity_wrap(){
		echo '</div>';
	}
}
		}
}

//Enable item Product Size Guide 
add_action( 'woocommerce_single_product_summary','woocommerce_output_size_guide', 21 );
if(!function_exists('woocommerce_output_size_guide')) {
function woocommerce_output_size_guide() {
	global $woo_options;
	if ( get_post_meta( get_the_ID(), '_enable_size_guide', true ) == 'true' ){	
		?>

		 <script>
		 (function($) {
$(document).ready(function() {

	 	$("a[data-rel^='prettyPhoto-sg']").prettyPhoto({
			social_tools: false,
			theme: 'pp_woocommerce',
			horizontal_padding: 40,
			opacity: 0.9,
			deeplinking: true
		});
		 	});
})(jQuery);
		 </script>
		 <a href="#inline-1" data-rel="prettyPhoto-sg" style="float:left;display:block;"><p><span class="size-guide"><i class="fa fa-cut"></i>  <?php _e('Size Guide', 'woothemes'); ?></span></p></a>
		 <div class="clear"></div>
	<div id="inline-1" class="hide" >
		 <?php  get_template_part('includes/size');?>
	</div>
		<?php
	}
       }
}