<?php
if ( ! defined( 'ABSPATH' ) ) exit;
/*====================================================================================
 TABLE OF CONTENTS - WOOCOMMERCE-MOD/WC-CUSTOM-METABOXES.PHP
 =====================================================================================
 - Add extra textarea on single product below product summary
 =====================================================================================*/

//Add extra textarea on single product below product summary
function wooframework_product_display_area_meta_box($post) {

	//global $post;
 
    wp_nonce_field( 'wptt_save_extra_editor', 'product_extra_description_nonce' );

      $content = get_post_meta( $post->ID, '_product_extra_description', true );
 
    if( empty( $content ) ) $content = '';   

	wp_editor( wp_kses_post( $content ), 'displayarea' );
}

function wooframework_woocommerce_meta_boxes() {
		add_meta_box( 'extradescarea', __( 'Product Description', 'woothemes' ), 'wooframework_product_display_area_meta_box', 'product', 'normal' );
}
add_action( 'add_meta_boxes', 'wooframework_woocommerce_meta_boxes' );

function wptt_save_extra_textarea( $post_id ){
    if( ! isset( $post ) ) global $post;
  	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return ; 
  	if ( is_int( wp_is_post_revision( $post_id ) ) ) return;
	if ( is_int( wp_is_post_autosave( $post_id ) ) ) return;
    // check nonce before proceeding
    if ( ! isset( $_POST[ 'product_extra_description_nonce' ] ) || ! wp_verify_nonce( $_POST[ 'product_extra_description_nonce' ], 'wptt_save_extra_editor' ) ) return ; 
    // check the user

    if ( !current_user_can( 'edit_post' )) return;
	if ( $post->post_type != 'product' && $post->post_type != 'shop_order' && $post->post_type != 'shop_coupon' ) return; 
    // check sanitize and save the data
    $extra_editor   = empty( $_POST['displayarea'] ) ? delete_post_meta( $post_id, '_product_extra_description' ) : update_post_meta( $post_id, '_product_extra_description', wp_kses_post( $_POST[ 'displayarea' ] ) );
 
}
add_action( 'save_post', 'wptt_save_extra_textarea');

// Output extra description
function woocommerce_single_product_extra_desc(){
	global $post;
	echo '<div id="product-extra-description" class="col-full" style="clear:both;margin-bottom: 3em;">';
	the_content();
	echo '</div>';
}
add_action('woocommerce_after_single_product_summary', 'woocommerce_single_product_extra_desc', 10);