<?php

//Custom mini Cart Widget
class Woo_WooCommerce_Widget_Cart extends WP_Widget {

	/** Variables to setup the widget. */
	var $woo_widget_cssclass;
	var $woo_widget_description;
	var $woo_widget_idbase;
	var $woo_widget_name;

	/** constructor */
	function Woo_WooCommerce_Widget_Cart() {

		/* Widget variable settings. */
		$this->woo_widget_cssclass 		= 'woo_woocommerce_widget_cart';
		$this->woo_widget_description 	= __( "Display the user's Cart in the sidebar.", 'woothemes' );
		$this->woo_widget_idbase 		= 'woo_woocommerce_widget_cart';
		$this->woo_widget_name 			= __( 'WooCommerce Cart', 'woothemes' );

		/* Widget settings. */
		$widget_ops = array( 'classname' => $this->woo_widget_cssclass, 'description' => $this->woo_widget_description );

		/* Create the widget. */
		WP_Widget::__construct( 'shopping_cart', $this->woo_widget_name, $widget_ops );
	}

	/** @see WP_Widget */
	function widget( $args = array(), $instance = array() ) {
		global $woocommerce;
		
		extract( $args );

		$title = apply_filters('widget_title', empty( $instance['title'] ) ? __('Shopping Cart', 'woothemes') : $instance['title'], $instance, $this->id_base );
		$hide_if_empty = empty( $instance['hide_if_empty'] )  ? 0 : 1;


?>
    <div class="cart-popup" >
        <?php
		
		if ( sizeof( WC()->cart->get_cart() ) > 0 ) {
		  ?>
            <p class="recently-added"><?php echo __('Recently added item(s)', 'woothemes'); ?></p>
    
                  <!--start scroll container -->
    <div id="jp-container" class="jp-container">
            <div class="products-small">
          <?php
            $counter = 0;
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
			
                // if($counter > 3) continue;
			

				$_product = $cart_item['data'];

				if ( ! apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) 
					continue;
				
				if ( $_product->exists() && $cart_item['quantity'] > 0 ) {
			
	   				$product_price = get_option( 'woocommerce_display_cart_prices_excluding_tax' ) == 'yes' || WC()->customer->is_vat_exempt() ? $_product->get_price_excluding_tax() : $_product->get_price();
							
					$product_price = apply_filters( 'woocommerce_cart_item_price_html', woocommerce_price( $product_price ), $cart_item, $cart_item_key ); 	
								
				?>
                    <div class="product-item">    
						<?php 
						
							echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf('<a href="%s" class="delete-btn" title="%s"><em class="ico-cross-1"></em></a>', esc_url( WC()->cart->get_remove_url( $cart_item_key ) ), __('Remove this item', 'woocommerce') ), $cart_item_key ); 
						

						?>
                        <a href="<?php echo get_permalink( $cart_item['product_id'] ); ?>" class="product-image">
                            <?php echo get_the_post_thumbnail( $cart_item['product_id'], array(90,90) ); ?>
                        </a>
                        <h5><a href="<?php echo get_permalink( $cart_item['product_id'] ); ?>"><?php echo apply_filters('woocommerce_widget_cart_product_title', $_product->get_title(), $_product ) ?></a></h5>
                        <div class="qty">
                            <span class="meta"><?php echo __('Quantity:', 'woothemes'); ?> <?php echo $cart_item['quantity']; ?></span>
                            <br>
                            <span class="price"><span class="pricedisplay"><?php echo $product_price; ?></span></span> 
                        </div>
                        <div class="clear"></div>
                    </div> 
                

                <?php
                }
                $counter++;
			}

    	?>
    	    </div> 
        </div>

        <?php	
		} else {
			$cart_empty = get_template_directory_uri() .'/images/cart-icon.png';
			echo '<p class="empty"><img src=" '. $cart_empty .' " style="margin-right:10px;">' . __('No products in the cart.', 'woothemes') . '</p>';
		}
		

		if ( sizeof( WC()->cart->get_cart() ) > 0 ) {
		  ?>
            <div class="totals ">
             <?php echo __('Cart Subtotal', 'woocommerce'); ?> <span class="price"><span class="pricedisplay"><?php echo WC()->cart->get_cart_subtotal(); ?></span></span>
            </div>
            <div class="clear"></div>
          <?php

			do_action( 'woocommerce_widget_shopping_cart_before_buttons' );
            ?>
                <a href="<?php echo WC()->cart->get_cart_url(); ?>" class="button cart fl"><span><?php echo __('View Shopping Cart', 'woothemes'); ?></span></a>
                
                <a href="<?php echo WC()->cart->get_checkout_url(); ?>" class="button checkout fl"><span><?php echo __('Proceed To Checkout', 'woothemes'); ?></span></a>   
            
            <?php

		}
		?>
    </div> 
        <?php

	}

	/** @see WP_Widget->update */
	function update( $new_instance, $old_instance ) {
		$instance['title'] = strip_tags( stripslashes( $new_instance['title'] ) );
		$instance['hide_if_empty'] = empty( $new_instance['hide_if_empty'] ) ? 0 : 1;
		return $instance;
	}

	/** @see WP_Widget->form */
	function form( $instance ) {
		$hide_if_empty = empty( $instance['hide_if_empty'] ) ? 0 : 1;
		?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'woocommerce') ?></label>
		<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" value="<?php if (isset ( $instance['title'])) {echo esc_attr( $instance['title'] );} ?>" /></p>

		<p><input type="checkbox" class="checkbox" id="<?php echo esc_attr( $this->get_field_id('hide_if_empty') ); ?>" name="<?php echo esc_attr( $this->get_field_name('hide_if_empty') ); ?>"<?php checked( $hide_if_empty ); ?> />
		<label for="<?php echo $this->get_field_id('hide_if_empty'); ?>"><?php _e( 'Hide if cart is empty', 'woocommerce' ); ?></label></p>
		<?php
	}

} // class WooCommerce_Widget_Cart

add_filter('woocommerce_add_to_cart_fragments', 'header_add_to_cart_fragment');
function header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
    $settings = array( 'header_cart_link' => 'false', 'header_cart_total' => 'false' );
	$settings = woo_get_dynamic_values( $settings );
	ob_start();
?>
<a class="cart-contents" href="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'woothemes' ); ?>">

<?php if ( $settings['header_cart_total'] == 'true' ) { echo sprintf( _n('%d item', '%d items', WC()->cart->cart_contents_count, 'woothemes' ), WC()->cart->cart_contents_count ); ?> - <?php echo WC()->cart->get_cart_total(); } ?>
    			
 </a> 

<?php
	$fragments['a.cart-contents'] = ob_get_clean();

	return $fragments;

}