<?php
if ( ! defined( 'ABSPATH' ) ) exit;
/*====================================================================================
 TABLE OF CONTENTS - WOOCOMMERCE-MOD/WC-QUICKVIEW.PHP
 =====================================================================================
 =====================================================================================*/
 
//Quickview Class 
class wooframework_woocommerce_quickview {

/* 	=============================
   	Front-end Scripts & Styles 
   	============================= */

   	function quickview_add_script() {
	global $woo_options;
   	if(isset( $woo_options['woo_enable_quickview'] ) && 'true' == $woo_options['woo_enable_quickview']){
		wp_enqueue_script('magnific-popup');
		wp_enqueue_script('scripts-qv');
		wp_enqueue_style( 'magnific-popup-style', THEME_URI . '/includes/css/magnific-popup.css' );
		
		$woo_globals = array( 
			'url' => home_url(),
			'plugin_url' => plugins_url(), 
			'gallery_enabled' => '1', 
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
			'nonce' => wp_create_nonce( 'jck_quickview_ajax' )
		);
		wp_localize_script( 'scripts-qv', 'jck_qv_globals', $woo_globals );
        
        		
     	}
	}   

	
/* 	=============================
   	Template Redirects 
   	============================= */
   	
	
	function quickview_template() {
		if ( ! isset( $_REQUEST['nonce'] ) || ! wp_verify_nonce( $_REQUEST['nonce'], 'jck_quickview_ajax' ) ) { die ( 'Invalid Nonce' ); }
	    	
	    	global $post, $product, $woocommerce ;
	    	$post = get_post($_GET['id']);
	    	$product = get_product( $post->ID );
	    	$settings = woo_get_dynamic_values( array('single_product_mode_layout' => '') );

	   	    	
	    	echo '<div class="woo_woocommerce_quickview">';
	    		echo '<div class="inner-quickview">';
				
				echo '<div class="mobView product">';
					echo '<h1 class="product_title entry-title">'.$post->post_title.'</h1>';
					do_action( 'woo_woocommerce_quickview_mobView_price' );
				echo '</div>';
	    
			    echo '<div class="images qv-main-image">';
				
					if ( has_post_thumbnail() ) :
							echo get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ) );
					else :
						echo '<img src="'.woocommerce_placeholder_img_src().'" alt="Placeholder" class="attachment-shop_single wp-post-image" />';
					endif;

				
				echo '</div>'; // .images
				
				echo '<div class="product summary entry-summary"><div class="woocommerce-summary-wrap">';
					
						
					
				echo '<h1 itemprop="name" class="product_title entry-title">' . $post->post_title.'</h1>';    

				            $review_total = get_comments_number();
		if ( $review_total > 0 && get_option( 'woocommerce_enable_review_rating' ) !== 'no' ) {
			echo '<div class="rating-wrap">';
				echo $product->get_rating_html();
				echo '<span class="review-count"><a href="#reviews">';
					comments_number( '', __('1 customer review', 'woothemes'), __('% customer reviews', 'woothemes') );
				echo '</a></span>';
			echo '</div>';
		}

		do_action('woocommerce_single_product_skuquickview_summary' );
				       
				            echo '<div itemprop="description">
				              	<p>'.do_shortcode( $post->post_excerpt ).'</p>
                           			         </div>
                           </div>';				
		
					echo '<div  class="woocommerce-qty-wrap">';
					
					echo '<p class="price">'. $product->get_price_html() .'</p>'; 
					
					 global $woo_options;
					if($woo_options['woocommerce_button_atc'] == 'false'){

					 do_action( 'woocommerce_' . $product->product_type . '_add_to_cart'  ); 
					 } 
					 

					if( class_exists( 'YITH_WCWL' ) ) { echo do_shortcode( '[yith_wcwl_add_to_wishlist]' ); } 
					echo '</div>				
				<div class="clear"></div>';

					 echo '<a href="'.get_permalink($post->ID).'" rel="nofollow" class="viewProduct">&raquo; '.__('Go To Full Details', 'woothemes').'</a>'; 
		
				echo '</div>'; // .summary
	    	     echo '</div>'; //.inner-quickview
	    	echo '</div>'; // .woo_woocommerce_quickview
			?>

				<script>

<?php $assets_path = str_replace( array( 'http:', 'https:' ), '', $woocommerce->plugin_url() ) . '/assets/'; ?>

/* <![CDATA[ */
<?php
$wc_add_to_cart_params = apply_filters( 'wc_add_to_cart_params', array(
	'ajax_url'                => $woocommerce->ajax_url(),
	'ajax_loader_url'         => apply_filters( 'woocommerce_ajax_loader_url', $assets_path . 'images/ajax-loader@2x.gif' ),
	'i18n_view_cart'          => esc_attr__( 'View Cart', 'woocommerce' ),
	'cart_url'                => get_permalink( wc_get_page_id( 'cart' ) ),
	'is_cart'                 => is_cart(),
	'cart_redirect_after_add' => get_option( 'woocommerce_cart_redirect_after_add' )
) );
?>
var wc_add_to_cart_params = <?php echo json_encode($wc_add_to_cart_params); ?>;

<?php 
$wc_single_product_params = apply_filters( 'wc_single_product_params', array(
	'i18n_required_rating_text' => esc_attr__( 'Please select a rating', 'woocommerce' ),
	'review_rating_required'    => get_option( 'woocommerce_review_rating_required' ),
) );
?>
var wc_single_product_params = <?php echo json_encode($wc_single_product_params); ?>;

<?php 
$woocommerce_params = apply_filters( 'woocommerce_params', array(
	'ajax_url'        => $woocommerce->ajax_url(),
	'ajax_loader_url' => apply_filters( 'woocommerce_ajax_loader_url', $assets_path . 'images/ajax-loader@2x.gif' ),
) );
?>
var woocommerce_params = <?php echo json_encode($wc_add_to_cart_params); ?>;

<?php 
$wc_cart_fragments_params = apply_filters( 'wc_cart_fragments_params', array(
	'ajax_url'      => $woocommerce->ajax_url(),
	'fragment_name' => apply_filters( 'woocommerce_cart_fragment_name', 'wc_fragments' )
) );
?>
var wc_cart_fragments_params = <?php echo json_encode($wc_add_to_cart_params); ?>;

<?php 
$wc_add_to_cart_variation_params = apply_filters( 'wc_add_to_cart_variation_params', array(
	'i18n_no_matching_variations_text' => esc_attr__( 'Sorry, no products matched your selection. Please choose a different combination.', 'woocommerce' ),
	'i18n_unavailable_text'            => esc_attr__( 'Sorry, this product is unavailable. Please choose a different combination.', 'woocommerce' ),
) );
?>
var wc_add_to_cart_variation_params = <?php echo json_encode($wc_add_to_cart_params); ?>;
/* ]]> */

<?php
$suffix               = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
$assets_path          = str_replace( array( 'http:', 'https:' ), '', $woocommerce->plugin_url() ) . '/assets/';
$frontend_script_path = $assets_path . 'js/frontend/';
?>

jQuery(document).ready(function($) {
	$.getScript("<?php echo $frontend_script_path . 'add-to-cart' . $suffix . '.js'; ?>");
	$.getScript("<?php echo $frontend_script_path . 'single-product' . $suffix . '.js'; ?>");
	$.getScript("<?php echo $frontend_script_path . 'woocommerce' . $suffix . '.js'; ?>");
	$.getScript("<?php echo $frontend_script_path . 'add-to-cart-variation' . $suffix . '.js'; ?>");
});
</script>


				<?php
	    	
	    	exit;

	}

/* 	=============================
   	Quickview Functions 
   	============================= */
   	
   	/** The Quickview Button **/
   	function woo_woocommerce_quickview_button() {
   		global $woo_options, $post;
   		if(isset( $woo_options['woo_enable_quickview'] ) && 'true' == $woo_options['woo_enable_quickview']){
		echo '<span title="Quick Look" class="quickview-button" data-id="'.$post->ID.'">'.__('Quick View', 'woothemes').'</span>';
		}
	}
 

/* 	=============================
   	PHP 5 Constructor 
   	============================= */
   	
	function __construct() {	

		 add_action( 'wp_ajax_nopriv_quickview_template', array( &$this, 'quickview_template') );
		 add_action( 'wp_ajax_quickview_template', array( &$this, 'quickview_template') );	
		
		add_action( 'wp_enqueue_scripts', array( &$this, 'quickview_add_script') );

		add_action( 'woocommerce_before_shop_loop_item_title', array( &$this, 'woo_woocommerce_quickview_button'), 10 );		
		add_action( 'woo_woocommerce_quickview_single_product_summary', 'woocommerce_template_single_price', 10 ); 
		add_action( 'woo_woocommerce_quickview_mobView_price', 'woocommerce_template_single_price', 10 ); 
		
	}

  
} // End wooframework_woocommerce_quickview Class

$wooframework_woocommerce_quickview = new wooframework_woocommerce_quickview; // Start an instance of the plugin class