<?php
if ( ! defined( 'ABSPATH' ) ) exit;
/*====================================================================================
 TABLE OF CONTENTS - WOOCOMMERCE-MOD/WC-SETUP.PHP
 =====================================================================================
 - Load Woocommerce CSS
 - Insert HTML5 Shiv
 - Hook in on activation
 - install theme woocomerce thumbnails
 - Check WooCommerce is installed first
 - Disable WooCommerce styles
 =====================================================================================*/


/*-----------------------------------------------------------------------------------*/
/* Load WooCommerce stylesheet */
/*-----------------------------------------------------------------------------------*/
if ( ! is_admin() ) { add_action( 'get_header', 'woo_load_woocommerce_css', 20 ); }

if ( ! function_exists( 'woo_load_woocommerce_css' ) ) {
	function woo_load_woocommerce_css () {
		wp_register_style( 'woocommerce', THEME_URI . '/css/woocommerce.css' );
		wp_enqueue_style( 'woocommerce' );
	}
}

/*-----------------------------------------------------------------------------------*/
/* Insert HTML5 Shiv */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woocommerce_html5' ) ) {
	add_action('wp_head', 'woocommerce_html5');

	function woocommerce_html5() {
		echo '<!--[if lt IE 9]><script src="https://html5shiv.googlecode.com/svn/trunk/html5.js"></script><![endif]-->';
	}
}

/*-----------------------------------------------------------------------------------*/
/* Hook in on activation */
/*-----------------------------------------------------------------------------------*/

global $pagenow;
if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) add_action( 'init', 'woo_install_theme', 1 );

/*-----------------------------------------------------------------------------------*/
/* Install */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_install_theme' ) ) {
  function woo_install_theme() {

	  	update_option( 'woocommerce_thumbnail_image_width', '93' );
		update_option( 'woocommerce_thumbnail_image_height', '124' );
		update_option( 'woocommerce_single_image_width', '600' ); // Single
		update_option( 'woocommerce_single_image_height', '440' ); // Single
		update_option( 'woocommerce_catalog_image_width', '480' ); // Catalog
		update_option( 'woocommerce_catalog_image_height', '640' ); // Catlog
		
  }
}

class WC_ProductClassic{

	public function __construct() {


		add_action( 'init', array( &$this, 'on_init') );
		add_filter( 'woocommerce_product_settings', array( &$this, 'classic_image_size_setting') );
		add_filter( 'woocommerce_get_image_size_classic', array($this, 'get_image_size_classic') );

		

	}

	public function on_init(){
	global $woocommerce;
	 $image_size = get_option('classic_image_size', array());

        $size = array();

        $size['width'] = isset($image_size['width']) && !empty($image_size['width']) ? $image_size['width'] : '540';
        $size['height'] = isset($image_size['height']) && !empty($image_size['height']) ? $image_size['height'] : '720';
        $size['crop'] = isset($image_size['crop']) ? $image_size['crop'] : 0;
		
        $image_size = apply_filters('woocommerce_get_image_size_classic_image_size', $size);

        add_image_size('classic_image_size', apply_filters('woocommerce_classic_size_width_default', $image_size['width']), apply_filters('woocommerce_classic_size_height_default', $image_size['height']), $image_size['crop']);
	}

	public function classic_image_size_setting($settings) {

                $setting = array(
                    'title' => __('Single Product Image Classic', 'woothemes'),
                    'desc' => __('This is the size used by the main image classic layout on the product page.', 'woothemes'),
                    'id' => 'classic_image_size',
                    'css' => '',
                    'type' => 'image_width',
                    'std' => '540',
                    'desc_tip' => true,
                    'default' => array(
                        'crop' => false,
                        'width' => 540,
                        'height' => 720
                    ),               
                );

                $index = count( $settings ) - 1;

				$settings[$index + 1] = $settings[$index];
				$settings[$index] = $setting;
				return $settings;
	}


	public function get_image_size_classic( $size ) {
				$image_size = get_option( 'classic_image_size', array() );
				$size = array();

				$size['width'] = isset( $image_size['width'] ) && !empty( $image_size['width'] ) ? $image_size['width'] : '540';
				$size['height'] = isset( $image_size['height'] ) && !empty( $image_size['height'] ) ? $image_size['height'] : '720';
				$size['crop'] = isset( $image_size['crop'] ) ? 1 : 0;

				$image_size = apply_filters( 'woocommerce_get_image_size_classic_image_size', $size );
				
				//Need to remove the filter because woocommerce will disable the input field. 
				remove_filter( 'woocommerce_get_image_size_classic', array($this, 'get_image_size_classic') );
				
				return $image_size;
	}


}

new WC_ProductClassic();

/*-----------------------------------------------------------------------------------*/
/*  Check WooCommerce is installed first */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'checked_environment' ) ) {
	add_action('plugins_loaded', 'checked_environment');

	function checked_environment() {
		if (!class_exists('woocommerce')) wp_die('WooCommerce must be installed');
	}
}

/*-----------------------------------------------------------------------------------*/
/*  Disable WooCommerce styles  */
/*-----------------------------------------------------------------------------------*/
if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) >= 0 ) {
	// WooCommerce 2.1 or above is active
	add_filter( 'woocommerce_enqueue_styles', '__return_false' );
} else {
	// WooCommerce is less than 2.1
	define( 'WOOCOMMERCE_USE_CSS', false );
}