<?php
/**
 * Loop - Portfolio
 *
 * This is a custom loop file, containing the looping logic for use in the "portfolio" page template, 
 * as well as the "portfolio-gallery" taxonomy archive screens. The custom query is only run on the page
 * template, as we already have the data we need when on the taxonomy archive screens.
 *
 * @package WooFramework
 * @subpackage Template
 */

global $woo_options;
global $more; $more = 0;

 
/* Make sure our thumbnail dimensions come through from the theme options. */
 

if ( ! is_tax()   ) {

$galleries = array();
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1; 
$query_args = array(
				'post_type' => 'portfolio', 
				'paged' => $paged, 
				'posts_per_page' => -1
			);

/* Setup portfolio galleries navigation. */

$exclude_str = '';
if ( isset( $woo_options['woo_portfolio_excludenav'] ) && ( $woo_options['woo_portfolio_excludenav'] != '' ) ) {
	$exclude_str = $woo_options['woo_portfolio_excludenav'];
}

// Allow child themes/plugins to filter here.
$exclude_str = apply_filters( 'woo_portfolio_gallery_exclude', $exclude_str );

/* Optionally exclude navigation items. */
if ( $exclude_str != '' ) {
	$to_exclude = explode( ',', $exclude_str );
	
	if ( is_array( $to_exclude ) ) {
		foreach ( $to_exclude as $k => $v ) {
			$to_exclude[$k] = str_replace( ' ', '', $v );
		}
		
		/* Remove the galleries to be excluded. */
		foreach ( $galleries as $k => $v ) {
			if ( in_array( $v->slug, $to_exclude ) ) {
				unset( $galleries[$k] );
			}
		}
	}
}
 
 		   
query_posts( $query_args );
 
} // End IF Statement ( is_tax() )

/* The Loop. */	
if ( have_posts() ) { $count = 0;

?>
<div id="portfolio">
<?php 
	$terms = get_the_terms( $post->ID, 'portfolio-gallery' ); ?>
   <div class="nav_port_iso">
   	 <?php 
	if ( ! is_tax()   ) {
   	 	isotope_categories();
   	}
   	  ?>
 </div>

<?php if ($woo_options['woo_portfolio_page_ver'] == 'true') {?>

	<div class="portfolio-items port_mason">
		<div class="grid-sizer"></div>

<?php } else {?>
	<div class="portfolio-items port_layout">
<?php } /*end if else mason*/


	while ( have_posts() ) { the_post(); $count++;
	
	/* Get the settings for this portfolio item. */
	$settings = woo_portfolio_item_settings( $post->ID );
	
	/* If the theme option is set to link to the single portfolio item, adjust the $settings. */
	if ( isset( $woo_options['woo_portfolio_linkto'] ) && ( $woo_options['woo_portfolio_linkto'] == 'post' ) ) {
		$settings['full'] = get_permalink( $post->ID );
		$settings['rel'] = '';
	}
	else{
		$settings['rel'] = 'rel="lightbox[portfolio-gallery]"';

	}
?>

<div <?php post_class( $settings['css_classes'] ); ?> >
	<div class="port-item">	
<?php 
			if ( has_post_thumbnail() ) {
		?>
		 <div class="view view-sixth banner">
			<?php 
				if ($woo_options['woo_portfolio_page_ver'] == 'true') {
					echo '<div class="image-mason-port">';
					the_post_thumbnail('full');
					echo '</div>';
				}
				else {
					echo '<div class="image-layout-port">';
					the_post_thumbnail('thumbnail-lookbook-land');
					echo '</div>';
				}
			?>
	<div class="mask-blog">
      <div class="overlay-blog custom_back"></div>
      </div>
     <div class="borderbanner-blog custom_bor">
       <span>
				
<?php 
if ($woo_options['woo_portfolio_linkto'] == 'lightbox') {
	echo '<a '. $settings['rel'].' title="'. $settings['caption'].'" href="'. $settings['large'].'" class="thumb">';
	_e( 'VIEW',  'woothemes' ); 
	echo '</a>';
}
else {
	echo '<a href="'.get_permalink( $post->ID ).'" class="thumb">';
	_e( 'READ MORE',  'woothemes' ); 
	echo '</a>';
}

?>
 			 </span>
      </div>
   </div> 
<span class="category-portfolio"><?php echo get_the_term_list( $post->ID, 'portfolio-gallery', ''); ?></span>

			<h3 class="port_title"><a href="<?php the_permalink(get_the_id()); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
		<?php
				// Output image gallery for lightbox
            	if ( ! empty( $settings['gallery'] ) ) {
                	foreach ( array_slice( $settings['gallery'], 1 ) as $img => $attachment ) {
                		echo '


                		<a ' . $settings['rel'] . ' title="' . $attachment['caption'] . '" href="' . $attachment['url'] . '" class="gallery-image"><img src="' . esc_url( $attachment['url'] ) . '" alt="' . esc_attr( $attachment['alt'] ) . '"/></a>' . "\n";	                    
                	}
                }
			} // End IF Statement
		?>
		</div><!-- .port-item-->
		</div><!--/.group .post .portfolio-img-->
<?php
	} // End WHILE Loop
?>
	</div><!--/.portfolio-items-->
</div><!--/#portfolio-->
<?php
} else {
	get_template_part( 'content', 'noposts' );
} // End IF Statement

rewind_posts();

woo_pagenav();
?>