<?php
/**
 * Single Post Template
 *
 * This template is the default page template. It is used to display content when someone is viewing a
 * singular view of a post ('post' post_type).
 * @link http://codex.wordpress.org/Post_Types#Post
 *
 * @package WooFramework
 * @subpackage Template
 */
global $woo_options;

get_header();
?>
       
    <!-- #content Starts -->
	<?php woo_content_before(); ?>
    <div id="content" class="col-full">
    
    	<div id="main-sidebar-container">    

            <!-- #main Starts -->
            <?php woo_main_before(); ?>
            <section id="main">                       
<?php
	woo_loop_before();
	 global $woo_options;
	  global $post;
 
 $title_before = '<h3 class="title single_title">';
 $title_after = '</h3>';
 
 if ( ! is_single() ) {
 
 	$title_before = '<h3 class="blog-title">';
 	$title_after = '</h3>';
 
	$title_before = $title_before . '<a href="' . get_permalink( get_the_ID() ) . '" rel="bookmark" title="' . the_title_attribute( array( 'echo' => 0 ) ) . '">';
	$title_after = '</a>' . $title_after;
 
 }
 
 $page_link_args = apply_filters( 'woothemes_pagelinks_args', array( 'before' => '<div class="page-link">' . __( 'Pages:', 'woothemes' ), 'after' => '</div>' ) );
 
 woo_post_before();
?>
<article <?php post_class(); ?>>
 <?php


 if ( $woo_options['woo_thumb_single'] == 'true') { 
 the_post_thumbnail('full'); 
} 

 ?> 
<?php
	// woo_post_meta();
?>
<?php echo '<div class="blog-post-meta single-post-meta">
      <span class="small"> '.do_shortcode( '[post_date after=" /"]' ) . do_shortcode( '[post_comments]' ) .'</span></div>'; ?>
	<header>
		<?php the_title( $title_before, $title_after ); ?>
	</header>

	<section class="entry">
	 
	<?php
while ( have_posts() ) : the_post();
?>
<div class="info_single_post">
	<p><?php _e('By' , 'woothemes'); ?> <span class="info_single_post_admin"><?php the_author(); ?></span></p>
<p>
<?php 
$category = get_the_term_list( $post->ID, 'category', ' ', ', '); 
$tag = get_the_term_list( $post->ID, 'post_tag', '', ', '); 
$tag2 = get_the_term_list( $post->ID, 'post_tag', ''); 
	if (!empty($category)) { ?>
	<?php _e('Posted in' , 'woothemes'); ?> <span class="category_single"><?php echo $category ?></span>
	
<?php		
	}
	if (!empty($tag)) { ?>
	| <?php _e('Tags' , 'woothemes'); ?> : <span class="tag_single"><?php echo $tag  ?></span>
	
<?php		
	}
?>
	</p>
</div>
<?php
	the_content();
endwhile;
?>
	</section><!-- /.entry -->
<?php		

	if (!empty($tag)) { ?>
	<div class="tag_single_bottom_div">
	<span class="tag_single_bottom"><?php echo $tag2  ?></span>
	</div>
<?php		
	}
if ( $woo_options['woo_share_single_post'] == 'true' ) { 

?>

<div class="info-extra">
	<p><?php _e('Share this story','woothemes'); ?> </p>
	<?php 	global $post;
	$src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), false, '' ); ?>
 
<ul class="share-top">
<li><a href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>" target="_blank" class="product_share_facebook"><i class="ico-facebook"></i> </a></li>
<li><a href="https://twitter.com/share?url=<?php the_permalink(); ?>" target="_blank" class="product_share_twitter"><i class="ico-twitter"></i> </a></li>   
<li><a href="https://plus.google.com/share?url={URL}" onclick="javascript:window.open(this.href,
'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"><i class="ico-google-plus"></i> </a></li>
<li><a href="//pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo $src[0]; ?>&description=<?php the_title(); ?>" target="_blank" class="product_share_pinterest"><i class="ico-pinterest"></i> </a></li>
<li><a href="//pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo $src[0]; ?>&description=<?php the_title(); ?>" target="_blank" class="product_share_pinterest"><i class="ico-linkedin"></i> </a></li>
</ul>
</div>

<?php }
if (isset($woo_options['woo_disable_post_author']) && $woo_options['woo_disable_post_author'] == 'false' ) {

woo_custom_get_the_author();

} 

?>


	<div class="fix"></div>
<?php
	// woo_post_inside_after();
?>

</article><!-- /.post -->

<?php
	woo_post_after();

 
 wp_reset_query(); 
if ( $woo_options['woo_rel_single_post'] == 'true' ) {
wp_enqueue_script( 'owlcarousel' );
wp_enqueue_script( 'owl-main' );
$orig_post = $post;
global $post;
$tags = wp_get_post_tags($post->ID);
if ($tags) {
	$tag_ids = array();
	foreach($tags as $individual_tag){ $tag_ids[] = $individual_tag->term_id;}
	$args=array(
		'tag__in' => $tag_ids,
		'post__not_in' => array($post->ID),
		'post_type' => 'post',
		'ignore_sticky_posts'=> 1
	);
	$my_query = new wp_query( $args );
		if( $my_query->have_posts() ) {
	 echo '<h3 class="blog-title rel-title-single">'. __('Related Posts' , 'woothemes' ).'</h3><div class="border"></div><div class="clear"></div>';
	 echo '<div id="related_post" class="owl-carousel">';
			while( $my_query->have_posts() ) {
				$my_query->the_post(); ?>
			  		<div <?php post_class('blog-grig-page last-class-blog'); ?>>
					<?php
					get_template_part( 'content', 'postGrid' );
					echo "</div>";
			}
	 echo "</div>";
		}
	}
$post = $orig_post;
wp_reset_query(); 
}
?>
<div class="clear"></div>
<?php

	$comm = '';
	if ( isset( $woo_options[ 'woo_comments' ] ) ) $comm = $woo_options[ 'woo_comments' ];
	if ( ( $comm == 'post' || $comm == 'both' ) && is_single() ) { comments_template(); }
?>

	<?php woo_loop_after(); ?>
     
            </section><!-- /#main -->
            <?php woo_main_after(); ?>
    
            <?php get_sidebar(); ?>

		</div><!-- /#main-sidebar-container -->         

		<?php get_sidebar('alt'); ?>

    </div><!-- /#content -->
	<?php woo_content_after(); ?>

<?php get_footer(); ?>