<?php
/**
 * Template Name: Contact Form ver 2
 *
 * The contact form page template displays the a
 * simple contact form in your website's content area.
 *
 * @package WooFramework
 * @subpackage Template
 */

global $woo_options;
get_header();

$nameError = '';
$emailError = '';
$commentError = '';
$mathCheck = '';

//If the form is submitted
if( isset( $_POST['submitted'] ) ) {

	//Check to see if the honeypot captcha field was filled in
	if( trim( $_POST['checking'] ) !== '' ) {
		$captchaError = true;
	} else {

		// Check math field
		if( $_POST['mathCheck'] != 9 && strcasecmp( $_POST['mathCheck'], 'nine' ) != 0  ) {
			$mathCheck = __( 'You got the maths wrong.', 'woothemes' );
			$hasError = true;
		} else {
			$math = trim( $_POST['mathCheck'] );
		}

		//Check to make sure that the name field is not empty
		if( trim( $_POST['contactName'] ) === '' ) {
			$nameError =  __( 'You forgot to enter your name.', 'woothemes' );
			$hasError = true;
		} else {
			$name = strip_tags( trim( $_POST['contactName'] ) );
		}

		//Check to make sure sure that a valid email address is submitted
		if( trim( $_POST['email'] ) === '' )  {
			$emailError = __( 'You forgot to enter your email address.', 'woothemes' );
			$hasError = true;
		} else if ( ! eregi( "^[A-Z0-9._%-]+@[A-Z0-9._%-]+\.[A-Z]{2,4}$", trim($_POST['email'] ) ) ) {
			$emailError = __( 'You entered an invalid email address.', 'woothemes' );
			$hasError = true;
		} else {
			$email = sanitize_email( trim( $_POST['email'] ) );
		}

		//Check to make sure comments were entered
		if( trim( $_POST['comments'] ) === '' ) {
			$commentError = __( 'You forgot to enter your message.', 'woothemes' );
			$hasError = true;
		} else {
			$comments = sanitize_text_field( stripslashes( trim( $_POST['comments'] ) ) );
		}

		//If there is no error, send the email
		if( ! isset( $hasError ) ) {

			$emailTo = get_option( 'woo_contactform_email' );
			$subject = __( 'Contact Form Submission from ', 'woothemes' ).$name;
			$sendCopy = trim( $_POST['sendCopy'] );
			$body = sprintf( __( "Name: %s \n\nEmail: %s \n\nComments: %s", 'woothemes' ), $name, $email, $comments );
			$headers = __( 'From: ', 'woothemes') . "$name <$email>" . "\r\n" . __( 'Reply-To: ', 'woothemes' ) . $email;

			wp_mail( $emailTo, $subject, $body, $headers );

			if( $sendCopy == true ) {
				$subject = __( 'You emailed ', 'woothemes' ) . get_bloginfo( 'title' );
				$headers = __( 'From: ', 'woothemes' ) . "$name <$emailTo>";
				wp_mail( $email, $subject, $body, $headers );
			}

			$emailSent = true;

		}
	}
}
?>
<script type="text/javascript">
<!--//--><![CDATA[//><!--
jQuery(document).ready(function() {
	jQuery( 'form#contactForm').submit(function() {
		jQuery( 'form#contactForm .error').remove();
		var hasError = false;
		jQuery( '.requiredField').each(function() {
			if(jQuery(this).hasClass('math')) {
				if( jQuery.trim(jQuery(this).val()) != 9 && jQuery.trim(jQuery(this).val()).toLowerCase() != 'nine' ) {
					jQuery(this).parent().append( '<span class="error"><?php _e( 'You got the maths wrong', 'woothemes' ); ?>.</span>' );
					jQuery(this).addClass( 'inputError' );
					hasError = true;
				}
			} else {
				if(jQuery.trim(jQuery(this).val()) == '') {
					var labelText = jQuery(this).prev( 'label').text();
					jQuery(this).parent().append( '<span class="error"><?php _e( 'You forgot to enter your', 'woothemes' ); ?> '+pText+'.</span>' );
					jQuery(this).addClass( 'inputError' );
					hasError = true;
				} else if(jQuery(this).hasClass( 'email')) {
					var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
					if(!emailReg.test(jQuery.trim(jQuery(this).val()))) {
						var labelText = jQuery(this).prev( 'label').text();
						jQuery(this).parent().append( '<span class="error"><?php _e( 'You entered an invalid', 'woothemes' ); ?> '+pText+'.</span>' );
						jQuery(this).addClass( 'inputError' );
						hasError = true;
					}
				}
			}
		});
		if(!hasError) {
			var formInput = jQuery(this).serialize();
			jQuery.post(jQuery(this).attr( 'action'),formInput, function(data){
				jQuery( 'form#contactForm').slideUp( "fast", function() {
					jQuery(this).before( '<div class="woo-sc-box tick"><p><?php _e( '<strong>Thanks!</strong> Your email was successfully sent.', 'woothemes' ); ?></p><div>' );
				});
			});
		}

		return false;

	});
});
//-->!]]>
</script>

   <?php woo_content_before(); ?>
    <div id="content" class="col-full">

		<!-- <div id="main-sidebar-container"> -->

		<!-- #main Starts -->
		<?php woo_main_before(); ?>
		<section id="main">

		<?php woo_loop_before(); ?>
		<!-- Post Starts -->
		<?php woo_post_before(); ?>

            <div id="contact-page" class="page">

            <?php woo_post_inside_before(); ?>



            <?php if( isset( $emailSent ) && $emailSent == true ) { ?>

                <p class="info"><?php _e( 'Your email was successfully sent.', 'woothemes' ); ?></p>

            <?php } else { ?>

                <?php if ( have_posts() ) { ?>

                <?php while ( have_posts() ) { the_post(); ?>

              	<section class="entry">
              		   <?php $geocoords = $woo_options['woo_contactform_map_coords']; ?>
                		<?php if ($geocoords != '') { ?>
                		<div class="ver2_map">
                		<?php woo_maps_contact_output("geocoords=$geocoords"); ?>
                		</div>
                		<?php } ?>


					 <div class="clear"></div>


              		<div class="contact-content">
					<h4 class="contact-title">

					<?php _e( 'CONTACT US', 'woothemes' ); ?></h4>
					<div class="border"></div>
					 <div class="clear"></div>
	                        <?php the_content(); ?>

                			  <?php if( isset( $hasError ) || isset( $captchaError ) ) { ?>
                        <p class="alert"><?php _e( 'There was an error submitting the form.', 'woothemes' ); ?></p>
                    <?php } ?>

                    <?php if ( get_option( 'woo_contactform_email' ) == '' ) { ?>
                        <?php echo do_shortcode( '[box type="alert"]' . __( 'E-mail has not been setup properly. Please add your contact e-mail!', 'woothemes' ) . '[/box]' );  ?>
                    <?php } ?>


                    <form action="<?php the_permalink(); ?>" id="contactForm" method="post">

                        <ul class="forms">
                            <li><p> <?php _e( 'Name', 'woothemes' ); ?> </p>
                                <input type="text" name="contactName" id="contactName" value="<?php if( isset( $_POST['contactName'] ) ) { echo esc_attr( $_POST['contactName'] ); } ?>" class="txt requiredField" />
                                <?php if($nameError != '') { ?>
                                    <span class="error"><?php echo $nameError ;?></span>
                                <?php } ?>
                            </li>

                            <li><p><?php _e( 'Email', 'woothemes' ); ?></p>
                                <input type="text" name="email" id="email" value="<?php if( isset( $_POST['email'] ) ) { echo esc_attr( $_POST['email'] ); } ?>" class="txt requiredField email" />
                                <?php if($emailError != '') { ?>
                                    <span class="error"><?php echo $emailError;?></span>
                                <?php } ?>
                            </li>

                            <li class="textarea"><p><?php _e( 'Message', 'woothemes' ); ?></p>
                                <textarea name="comments" id="commentsText" rows="20" cols="30" class="requiredField"><?php if( isset( $_POST['comments'] ) ) { echo esc_textarea( $_POST['comments'] ); } ?></textarea>
                                <?php if( $commentError != '' ) { ?>
                                    <span class="error"><?php echo $commentError; ?></span>
                                <?php } ?>
                            </li>

                            <li><p><?php _e( 'Solve:', 'woothemes' ); ?> 3 + 6</p>
                                <input type="text" name="mathCheck" id="mathCheck" value="<?php if( isset( $_POST['mathCheck'] ) ) { echo esc_attr( $_POST['mathCheck'] ); } ?>" class="txt requiredField math" />
                                <?php if($mathCheck != '') { ?>
                                    <span class="error"><?php echo $mathCheck;?></span>
                                <?php } ?>
                            </li>

                            <div class="cb"><input type="checkbox" name="sendCopy" id="sendCopy" value="true"<?php if( isset( $_POST['sendCopy'] ) && $_POST['sendCopy'] == true ) { echo ' checked="checked"'; } ?> /><label for="sendCopy"><?php _e( 'Send a copy of this email to yourself', 'woothemes' ); ?></label></div>

                            <div class="buttons"><input type="hidden" name="submitted" id="submitted" value="true" /><input class="submit button" type="submit" value="<?php _e( 'Send Message', 'woothemes' ); ?>" /></div>
                              <li class="screenReader"><label for="checking" class="screenReader"><?php _e( 'If you want to submit this form, do not enter anything in this field', 'woothemes' ); ?></label><input type="text" name="checking" id="checking" class="screenReader" value="<?php if( isset( $_POST['checking'] ) ) { echo esc_attr( $_POST['checking'] ); } ?>" /></li>
                        </ul>
                    </form>
						</div>    <!-- /.contact content -->

						 <div class="contact-maps">
              			<h4 class="contact-title">
<?php _e( 'WHERE WE ARE', 'woothemes' ); ?>
              				</h4>
					<div class="border"></div>
					 <div class="clear"></div>

                		<div class="location-twitter">
    							<?php if ( isset( $woo_options['woo_contact_panel'] ) && $woo_options['woo_contact_panel'] == 'true' ) { ?>
						    	<section id="office-location"<?php if ( ( isset( $woo_options['woo_contact_twitter'] ) && $woo_options['woo_contact_twitter'] != '' ) || ( isset($woo_options['woo_contact_subscribe_and_connect']) && $woo_options['woo_contact_subscribe_and_connect'] == 'true' ) ) { ?> class="col-left"<?php } ?>>
									<?php if (isset($woo_options['woo_contact_title'])) { ?><h4><?php echo stripslashes( $woo_options['woo_contact_title'] ); ?></h4><?php } ?>
									<ul>
										<?php if (isset($woo_options['woo_contact_title']) && $woo_options['woo_contact_title'] != '' ) { ?><li><?php echo stripslashes( $woo_options['woo_contact_address'] ); ?></li><?php } ?>
										<?php if (isset($woo_options['woo_contact_number']) && $woo_options['woo_contact_number'] != '' ) { ?><li><?php _e('Tel:','woothemes'); ?> <?php echo $woo_options['woo_contact_number']; ?></li><?php } ?>
										<?php if (isset($woo_options['woo_contact_fax']) && $woo_options['woo_contact_fax'] != '' ) { ?><li><?php _e('Fax:','woothemes'); ?> <?php echo $woo_options['woo_contact_fax']; ?></li><?php } ?>
										<?php if (isset($woo_options['woo_contactform_email']) && $woo_options['woo_contactform_email'] != '' ) { ?><li><?php _e('Email:','woothemes'); ?> <a href="mailto:<?php echo $woo_options['woo_contactform_email']; ?>"><?php echo $woo_options['woo_contactform_email']; ?></a></li><?php } ?>
									</ul>
						    	</section>
						    	<?php } ?>
						    	</div><!-- /.location-twitter -->
						    		<div class="contact-social<?php if ( ( isset( $woo_options['woo_contact_panel'] ) && $woo_options['woo_contact_panel'] == 'true' ) && ( ( isset( $woo_options['woo_contact_twitter'] ) && $woo_options['woo_contact_twitter'] != '' ) || ( isset($woo_options['woo_contact_subscribe_and_connect']) && $woo_options['woo_contact_subscribe_and_connect'] == 'true' ) ) ) { ?> <?php } ?>">


						    		<?php if ( isset($woo_options['woo_contact_subscribe_and_connect']) && $woo_options['woo_contact_subscribe_and_connect'] == 'true' ) { woo_subscribe_connect( 'true' ); } ?>

						    	</div>
						</div>    <!-- /.contact maps -->


                        </section>


                    <?php
                    		} // End WHILE Loop
                    	}
                    }
                    ?>
                    <div class="fix"></div>
				<?php woo_post_inside_after(); ?>

            </div><!-- /#contact-page -->

           <?php woo_post_after(); ?>

            </section><!-- /#main -->
            <?php woo_main_after(); ?>

            <?php //get_sidebar(); ?>

		<!-- </div>/#main-sidebar-container -->

		<?php //get_sidebar( 'alt' ); ?>

    </div><!-- /#content -->
	<?php woo_content_after(); ?>

<?php get_footer(); ?>