<?php
/**
 * Checkout Form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wc_print_notices();
?>

<div class="col2checkout-set">

<div class="col-1">

<?php if ( WC()->cart->coupons_enabled() ) : ?>	
<h3 class="woo_coupon_header "><?php _e('Have a coupon?', 'woocommerce') ?></h3>
 <div class="gbtr_coupon_method_content ">
 	<a href="#" class="showcoupon"><?php _e( 'Click here to enter your code', 'woocommerce' ) ?> </a>
<form class="checkout_coupon" method="post" style="display:none">

	<p class="form-row form-row-first">
		<input type="text" name="coupon_code" class="input-text" placeholder="<?php _e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
	</p>

	<p class="form-row form-row-last">
		<input type="submit" class="button" name="apply_coupon" value="<?php _e( 'Apply Coupon', 'woocommerce' ); ?>" />
	</p>

	<div class="clear"></div>
</form>
</div>
<?php endif; ?>

<?php if (!is_user_logged_in() && get_option('woocommerce_enable_signup_and_login_from_checkout')=="yes") : ?>

    <h3 class="gbtr_checkout_method_header accordion_header"><?php _e('Checkout Method', 'woothemes'); ?></h3>
    
    <div class="gbtr_checkout_method_content accordion_content">
        
        <div class="first_col">
        	<h4><?php _e('Returning Customers', 'woothemes'); ?></h4>
            <?php
			wc_get_template('checkout/form-login-checkout.php', array(
				'redirect' => get_permalink(wc_get_page_id('checkout'))
			));
			?>
        </div>
        
        <div class="sec_col">
        	<h4><?php _e('New Customers', 'woothemes'); ?></h4>
            <div id="checkout_method_radio_guest_wrapper"><input name="checkout_method_radio" id="checkout_method_radio_guest" type="radio" value="guest" /><label for="checkout_method_radio_guest"><?php _e('Checkout as Guest', 'woothemes'); ?></label></div>
            <div id="checkout_method_radio_account_wrapper"><input name="checkout_method_radio" id="checkout_method_radio_account" type="radio" value="account" /><label for="checkout_method_radio_account"><?php _e('Create an Account with Us', 'woothemes'); ?></label></div>
            <input type="button" class="button_checkout_method_continue button" name="button_checkout_method_continue" value="<?php _e('Continue', 'woothemes'); ?>" />
        </div>
        
        <div class="clear"></div>
    
    </div>

<?php endif; ?>

</div> <!-- col-1 -->

<?php do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout
if ( ! $checkout->enable_signup && ! $checkout->enable_guest_checkout && ! is_user_logged_in() ) {
	echo apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) );
	return;
}

// filter hook for include new pages inside the payment method
$get_checkout_url = apply_filters( 'woocommerce_get_checkout_url', WC()->cart->get_checkout_url() ); ?>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( $get_checkout_url ); ?>" enctype="multipart/form-data">

	<?php if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>

		<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

		<div id="customer_details">

		<div class="col-1">

				<?php do_action( 'woocommerce_checkout_billing' ); ?>
	
				<?php do_action( 'woocommerce_checkout_shipping' ); ?>

		</div>

		<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

	
	<?php endif; ?>

	<div class="col-2"> 
	
	<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

		<div id="order_review" class="woocommerce-checkout-review-order">

		<div id="order_summary">
		<h3 id="order_review_heading"><?php _e( 'Your order', 'woocommerce' ); ?></h3>
		<?php do_action( 'woocommerce_checkout_order_review' ); ?>
		</div>
		<br>
		<?php do_action( 'dahzcommerce_checkout_payment_method' ); ?>
	    </div>

	<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
	</div>

</form>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>

</div>