<?php
/**
 * Login Form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.2.6
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $woo_options; ?>

<?php $settings = woo_get_dynamic_values( 
						array( 
						'acc_head_login' => __('Already Have an Account?', 'woothemes'),
		 				'acc_subhead_login' => __('I\'m a returning customer', 'woothemes'),
		 				'acc_content_login' => '',
		 				'acc_button_login' => __('Existing Customer ? Click Here To Login', 'woothemes'),
		 				'acc_head_reg' => __('Register', 'woothemes'),
		 				'acc_subhead_reg' => sprintf( __('Set up your %s account', 'woothemes'), get_bloginfo() ),
		 				'acc_content_reg' => '',
		 				'acc_button_reg' => __('New Customer ? Click Here To Register', 'woothemes'),
		 				'fb_login_enable' => 'false',
		 				'fb_login_text' => __('Login / Register With Facebook', 'woothemes')
		 				          ) );
		 				           ?>

<?php wc_print_notices(); ?>

<?php do_action('woocommerce_before_customer_login_form'); ?>

<?php if (get_option('woocommerce_enable_myaccount_registration') ==='yes') : ?>

<script type="text/javascript">  
<!--//--><![CDATA[//><!--
jQuery(document).ready(function($)  
{  
    $('.customer-login, .btn-reg').hide();  
    $('#signup').click(function()  
    {  
    $('.customer-login, .btn-reg').slideUp('slow');  
    $('.customer-register, .btn-log').slideDown('slow');  
    });  
    $('#login').click(function()  
    {  
        $('.customer-register, .btn-log').slideUp('slow'); 
        $('.customer-login, .btn-reg').slideDown('slow');  
    });   
});  
//--><!]]>
</script>  

<div class="col2log-set" id="customer_login">

	<div class="col-2 customer-login">

<?php endif; ?>

		<h4><?php _e( 'Already Have an Account?', 'woothemes' ); ?></h4>
		<p class="sub-heading"><?php _e( 'I\'m a returning customer' , 'woothemes') ?> </p>
		<form method="post" class="login">

		<?php do_action( 'woocommerce_login_form_start' ); ?>

			<p class="form-row form-row-first">
				<label for="username"><?php _e( 'Username or email', 'woocommerce' ); ?> <span class="required">*</span></label>
				<input type="text" class="input-text" name="username" id="username" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
			</p>
			<p class="form-row form-row-last">
				<label for="password"><?php _e( 'Password', 'woocommerce' ); ?> <span class="required">*</span></label>
				<input class="input-text" type="password" name="password" id="password" />
			</p>

			<?php do_action( 'woocommerce_login_form' ); ?>

			<div class="clear"></div>

			<p class="form-row">
				<a class="lost_password fr" href="<?php
				
				echo esc_url( wc_lostpassword_url() )
				// $lost_password_page_id = woocommerce_get_page_id( 'lost_password' );

				// if ( $lost_password_page_id )
				// 	echo esc_url( get_permalink( $lost_password_page_id ) );
				// else
				// 	echo esc_url( wp_lostpassword_url( home_url() ) );

				?>"><?php _e( 'Lost your Password?', 'woocommerce' ); ?></a>
			</p>
			<p class="form-row">
				<?php wp_nonce_field( 'woocommerce-login' ); ?>
				<input type="submit" class="button" name="login" value="<?php _e( 'Login', 'woocommerce' ); ?>" />
				<?php if($settings['fb_login_enable'] == 'true') : ?>
				<h4><?php _e('Or','woothemes'); ?></h4>
				<?php echo do_shortcode( '[facebook_login_button text="'.$settings['fb_login_text'].'"]'); ?>
			    <?php endif; ?>
			</p>

			<?php do_action( 'woocommerce_login_form_end' ); ?>

		</form>

<?php if (get_option('woocommerce_enable_myaccount_registration') === 'yes') : ?>

	</div>

	<div class="col-1 customer-register">

		<h4><?php _e( 'Register', 'woothemes' ); ?></h4>
		<p class="sub-heading"><?php echo sprintf(__('Set up your %s account', 'woothemes'), get_bloginfo() ) ?> </p>
		<form method="post" class="register">

			<?php do_action( 'woocommerce_register_form_start' ); ?>
			
			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

				<p class="form-row form-row-first">
					<label for="reg_username"><?php _e( 'Username', 'woocommerce' ); ?> <span class="required">*</span></label>
					<input type="text" class="input-text" name="username" id="reg_username" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
				</p>

			<?php endif; ?>

			<p class="form-row form-row-last">
				<label for="reg_email"><?php _e( 'Email', 'woocommerce' ); ?> <span class="required">*</span></label>
				<input type="email" class="input-text" name="email" id="reg_email" value="<?php if ( ! empty( $_POST['email'] ) ) echo esc_attr( $_POST['email'] ); ?>" />
			</p>

			<div class="clear"></div>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

			<p class="form-row form-row-first">
					<label for="reg_password"><?php _e( 'Password', 'woocommerce' ); ?> <span class="required">*</span></label>
					<input type="password" class="input-text" name="password" id="reg_password" />
			</p>

			<?php endif; ?>


			<div class="clear"></div>

			<!-- Spam Trap -->
			<div style="left:-999em; position:absolute;"><label for="trap"><?php _e( 'Anti-spam', 'woocommerce' ); ?></label><input type="text" name="email_2" id="trap" tabindex="-1" /></div>
			
			<?php do_action( 'woocommerce_register_form' ); ?>
			<?php do_action( 'register_form' ); ?>

			<p class="form-row">
				<?php wp_nonce_field( 'woocommerce-register' ); ?>
				<input type="submit" class="button" name="register" value="<?php _e( 'Register', 'woocommerce' ); ?>" />
				<?php if($settings['fb_login_enable'] == 'true') : ?>
				<h4><?php _e('Or','woothemes'); ?></h4>
				<?php echo do_shortcode( '[facebook_login_button text="'.$settings['fb_login_text'].'"]'); ?>
				<?php endif; ?>
			</p>

			<?php do_action( 'woocommerce_register_form_end' ); ?>

		</form>

	</div>

</div>

<div class="btn-swap-login-register">
			
<div class="btn-log">
 <h4><?php echo $settings['acc_head_login']; ?></h4>
 <p class="sub-heading"><?php echo $settings['acc_subhead_login']; ?> </p>
 <p><?php echo $settings['acc_content_login']; ?></p>	
 <input type="submit" class="button"  id="login" value="<?php echo $settings['acc_button_login']; ?>" >
</div>
 <div class="btn-reg">
 <h4><?php echo $settings['acc_head_reg']; ?></h4>
 <p class="sub-heading"><?php echo $settings['acc_subhead_reg']; ?></p>
  <p><?php echo $settings['acc_content_reg']; ?></p>	
 <input type="submit" class="button"  id="signup" value="<?php echo $settings['acc_button_reg']; ?>" > 
</div>

</div>

<?php endif; ?>

<?php do_action('woocommerce_after_customer_login_form'); ?>
