<?php
/**
 * Single Product Image 
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.14
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $post, $woocommerce, $product, $woo_options;
if(  !class_exists('Mobile_Detect') ) {
require_once get_template_directory().'/includes/Mobile_Detect.php';
} 
$detect = new Mobile_Detect;
?>
<div class="images">

<?php
			if ( has_post_thumbnail() ) {

				$image_title = esc_attr( get_the_title( get_post_thumbnail_id() ) );
				$image_link  = wp_get_attachment_url( get_post_thumbnail_id() );
				$image       = get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ), array(
					'title' => $image_title, 'id' =>'zoom1'
					) );

				$attachment_count = count( $product->get_gallery_attachment_ids() );

				if ( $attachment_count > 0 ) {
					$gallery = '[product-gallery]';
				} else {
					$gallery = '';
				}
?>

<?php if(isset($woo_options['woo_enable_cloud_zoom']) && $woo_options['woo_enable_cloud_zoom'] == 'true') { ?>

	<?php if($detect->isMobile() || $detect->isTablet()) :

    	$output_image = apply_filters( 'woocommerce_single_product_image_html', sprintf( '<a href="%s" itemprop="image" class="woocommerce-main-image zoom" title="%s" data-rel="prettyPhoto' . $gallery . '">%s</a>', $image_link, $image_title, $image ), $post->ID ); 
    ?>

    <?php else: ?>

	<?php wp_enqueue_script( 'elevate-zoom' ); ?>
	<script>
		jQuery(document).ready(function($){	
		$("#zoom1").attr("data-zoom-image", "<?php echo wp_get_attachment_url( get_post_thumbnail_id() ) ?>");
		$("#zoom1").elevateZoom({
						responsive: true,
						loadingIcon:"<?php echo get_template_directory_uri().'/images/loading.png'; ?>",
						gallery:'zoom-gallery',
						cursor: 'pointer', 
						galleryActiveClass:'active',
						imageCrossfade: true,
						zoomWindowFadeIn: 500,
						zoomWindowFadeOut: 500,
						lensFadeIn: 500,
						lensFadeOut: 500,
						zoomWindowHeight: 440, 
						zoomWindowWidth: 560,
						zoomWindowOffetx: 90,
						borderSize: 1,
						borderColour: '#dbdbdb',
						tint:true,
						tintColour:'#FFF',
						tintOpacity:0.5								
						});
			});
    </script>
    
   <?php $output_image = apply_filters( 'woocommerce_single_product_image_html', sprintf( '%s', $image ), $post->ID ); ?>
   	
   <?php endif; ?>

    <?php  } else { ?>
    
    <?php 
    	$output_image = apply_filters( 'woocommerce_single_product_image_html', sprintf( '<a href="%s" itemprop="image" class="woocommerce-main-image zoom" title="%s" data-rel="prettyPhoto' . $gallery . '">%s</a>', $image_link, $image_title, $image ), $post->ID ); 
    ?>

<?php } ?>


		<?php

				echo $output_image;

			} else {

				echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<img src="%s" alt="Placeholder" />', wc_placeholder_img_src() ), $post->ID );

			}


		?>

		<?php do_action( 'woocommerce_product_thumbnails' ); ?>
		
		<?php woocommerce_template_single_meta(); ?>

</div>
