<?php
/**
 * Single Product Thumbnails
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $post, $product, $woocommerce, $woo_options;
if(  !class_exists('Mobile_Detect') ) {
require_once  get_template_directory().'/includes/Mobile_Detect.php';
}
$detect = new Mobile_Detect;
$attachment_ids = $product->get_gallery_attachment_ids();

if ( $attachment_ids ) {
	wp_enqueue_style( 'swiper' );
	wp_enqueue_script( 'swiper' );
	$id = ( 'true' == $woo_options['woo_enable_cloud_zoom'] ) ? 'zoom-gallery' : 'zoom-off';
	?>
	<div id="<?php echo $id ?>" class="thumbnails" style="min-height:<?php  $height = get_option('shop_thumbnail_image_size'); echo ($height['height']+2).'px'; ?>!important">
	<ul class="swiper-wrapper"><?php
    	if($woo_options['woo_single_product_mode_layout'] == 'modern'){
    		$image_zoom = wp_get_attachment_image_src( get_post_thumbnail_id() , apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ) );
			$carousel_js = '<script>
		jQuery(function($){


if (laGlobals.isMobile) { 
 	 var mySwiper = $(".thumbnails").swiper({
    mode:"horizontal",
    slidesPerView: 5,
    mousewheelControl: true
  			});
	} else {
		if (!laGlobals.isMobile) {
			var mySwiper = $(".thumbnails").swiper({
    mode:"vertical",
    slidesPerView: 5,
    mousewheelControl: true,
  			});
		} 
	}

		});
	</script>';
			} else{
				if ($woo_options['woo_single_product_mode_layout'] == 'classic'){
					$image_zoom = wp_get_attachment_image_src( get_post_thumbnail_id() , apply_filters( 'single_product_large_thumbnail_size', 'classic_image_size' ) );
			$carousel_js = '<script>
		jQuery(function($){
  var mySwiper = $(".thumbnails").swiper({
    mode:"horizontal",
    slidesPerView: 5,
    mousewheelControl: true,
  			});
		});
	</script>';
				}
			}

			if( $woo_options['woo_enable_cloud_zoom'] == 'true') {
				if($detect->isMobile() || $detect->isTablet()){
				$effect =  ' rel="prettyPhoto[product-gallery]" ';
				$classes = array( 'zoom' );
				echo $carousel_js ;
				} else {
				$effect =   'data-image='.$image_zoom[0].' data-zoom-image='. wp_get_attachment_url( get_post_thumbnail_id() ) .' ' ;
				$classes = array( 'cloud-zoom-gallery' );
				$id = 'id=zoom1'; 
				echo $carousel_js ;
				}
			} else {
				if($woo_options['woo_enable_cloud_zoom'] == 'false'){
				$effect =  ' rel="prettyPhoto[product-gallery]" ';
				$classes = array( 'zoom' );
				$id = ''; 
				echo $carousel_js ;}
			}

		$loop = 0;
		$columns = apply_filters( 'woocommerce_product_thumbnails_columns', 3 );

		if (count($attachment_ids) > 0 && $woo_options['woo_enable_cloud_zoom'] == 'true') {

			$image       = wp_get_attachment_image(  get_post_thumbnail_id() , apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ), '', $id );
			$image_class = esc_attr( implode( ' ', $classes ) );
			$image_title = esc_attr( get_the_title(  get_post_thumbnail_id()  ) );

			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<li class="swiper-slide"><a href="'.wp_get_attachment_url( get_post_thumbnail_id() ).'" class="%s" title="%s"  '. $effect .' >%s</a></li>', $image_class, $image_title, $image ), $image, $post->ID, $image_class );
			}

		foreach ( $attachment_ids as $attachment_id ) {

			if($woo_options['woo_single_product_mode_layout'] == 'modern'){
			$image_zoom = wp_get_attachment_image_src( $attachment_id, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ) );
			} else{
				if ($woo_options['woo_single_product_mode_layout'] == 'classic'){
			$image_zoom = wp_get_attachment_image_src( $attachment_id, apply_filters( 'single_product_large_thumbnail_size', 'classic_image_size' ) );
				}
			}

			if( $woo_options['woo_enable_cloud_zoom'] == 'true') {
				if($detect->isMobile() || $detect->isTablet()){
				$effect =  ' rel="prettyPhoto[product-gallery]" ';
				$classes = array( 'zoom' );
				} else {
				$effect =   'data-image='.$image_zoom[0].' data-zoom-image='. wp_get_attachment_url( $attachment_id ) .' ' ;
				$classes = array( 'cloud-zoom-gallery' );
				$id = 'id=zoom1'; 
				}
			}

			if ( $loop == 0 || $loop % $columns == 0 )
				$classes[] = 'first-thumb';

			if ( ( $loop + 1 ) % $columns == 0 )
				$classes[] = 'last-thumb';

			$image_link = wp_get_attachment_url( $attachment_id );

			if ( ! $image_link )
				continue;

			$image       = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ), '', $id );
			$image_class = esc_attr( implode( ' ', $classes ) );
			$image_title = esc_attr( get_the_title( $attachment_id ) );

			if ( get_post_meta( $attachment_id, '_woocommerce_exclude_image', true ) == 1 ) 
                    continue;
			
			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<li class="swiper-slide"><a href="%s" class="%s" title="%s"  '. $effect .' >%s</a></li>', $image_link, $image_class, $image_title, $image ), $attachment_id, $post->ID, $image_class );
			
			$loop++;
		}

	?></ul></div>
	<?php
}