<?php
/**
 * Single Product tabs
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Filter tabs and allow third parties to add their own
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $tabs ) ) : 

wp_enqueue_script( 'responsive-tab' ); ?>

	<?php $settings = woo_get_dynamic_values(array( 'single_product_mode_layout' => '' )); 
	  if( 'modern' == $settings['single_product_mode_layout'] ) { ?>
		
		<script>	
			jQuery(document).ready(function(){	
			jQuery('.woocommerceTabs').easyResponsiveTabs({
			       	 	type: 'default', 
			       	 	width: 'auto', 
			       		fit: true,
			       		closed: false,     
			         });
			});
		</script>
	<?php } else { 
		
		if( 'classic' == $settings['single_product_mode_layout'] ) { ?>

		
		<script>	
			jQuery(document).ready(function(){	
			jQuery('.woocommerceTabs').addClass('classic');
			jQuery('.woocommerceTabs').easyResponsiveTabs({
			       	 	 type: 'accordion',
           				 width: 'auto',
           				 fit: true,
           				 closed: true,
			         });
			});
		</script>
<?php	}

	} ?>

	<div class="woocommerceTabs">
		<ul class="resp-tabs-list">
			<?php foreach ( $tabs as $key => $tab ) : ?>

				<li class="<?php echo $key ?>_tab">
					<a id="#tab-<?php echo $key ?>"><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', $tab['title'], $key ) ?></a>
				</li>

			<?php endforeach; ?>
		</ul>
		<div class="resp-tabs-container">
		<?php foreach ( $tabs as $key => $tab ) : ?>

			<div id="tab-<?php echo $key ?>">
				<?php call_user_func( $tab['callback'], $key, $tab ) ?>
			</div>

		<?php endforeach; ?>
		</div>
	</div>
	
<?php endif; ?>