// =============================================================================
// ASSETS/JS/ADMIN/TINYMCE.JS
// -----------------------------------------------------------------------------
// TinyMCE specific functions.
// =============================================================================

(function() {

    tinymce.PluginManager.add( 'DahzThemeShortcodes', function( editor, url ) {
        editor.addButton( 'DahzThemeShortcodes', {
            title: 'Insert Shortcode',
            icon: false,
            type: 'menubutton',
            menu: [
                { // Blockquote
                    text: 'Blockquote',
                    onclick: function() {
                        editor.windowManager.open({
                            title: 'Blockquote Shortcode',
                            body: [
                                // Blockquote type
                                {
                                    type: 'listbox',
                                    name: 'version',
                                    label: 'Version',
                                    'values': [
                                                { text: 'Version 1', value: '1' },
                                                { text: 'Version 2', value: '2' },
                                              ]
                                },
                                // Border width
                                {
                                    type: 'textbox',
                                    name: 'border',
                                    label: 'Border Width',
                                    value: '4px'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Available when you choose Version 2.'
                                },
                                // Border color
                                {
                                    type: 'textbox',
                                    name: 'border_color',
                                    label: 'Border Color',
                                    value: '#000000'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Available when you choose Version 2. Insert hex code here \"#000000\" or css color name. e.g. red, yellow, green, etc.'
                                },
                                // Content
                                {
                                    type: 'textbox',
                                    name: 'content',
                                    label: 'Content',
                                    value: 'Lorem ipsum dolor sit amet.',
                                    multiline: true,
                                    minWidth: 300,
                                    minHeight: 100
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: "",
                                    onPostRender : function() {
                                        this.getEl().innerHTML =
                                            "Write the content."; }
                                }
                            ],
                            onsubmit: function( e ) {
                                editor.insertContent( '[blockquote_sty ver="' + e.data.version + '" size="' + e.data.border + '" color="' + e.data.border_color + '"]' + e.data.content + '[/blockquote_sty]');
                            }
                        })
                    }
                },
                { // Columns
                    text:'Columns',
                    onclick: function() {
                        editor.windowManager.open({
                            title: 'Columns Shortcode',
                            body: [
                                    {
                                      type: 'listbox',
                                      name: 'columnListboxName',
                                      label: 'Add Column',
                                      'values': [
                                                  {text: 'Two Column', value: 'two_col'},
                                                  {text: 'Three Column', value: 'three_col'},
                                                  {text: 'Four Column', value: 'four_col'},
                                                  {text: 'Five Column', value: 'five_col'},
                                                  {text: 'Six Column', value: 'six_col'},
                                                ]
                                    }
                            ],
                            onsubmit: function( e ) {
                                if (e.data.columnListboxName == 'two_col') {
                                    editor.insertContent( '[twocol_one] content [/twocol_one][twocol_one_last] content [/twocol_one_last]');
                                } else if (e.data.columnListboxName == 'three_col') {
                                    editor.insertContent( '[threecol_one] content [/threecol_one][threecol_one] content [/threecol_one][threecol_one_last] content [/threecol_one_last]');
                                } else if (e.data.columnListboxName == 'four_col') {
                                    editor.insertContent( '[fourcol_one] content [/fourcol_one][fourcol_one] content [/fourcol_one][fourcol_one] content [/fourcol_one][fourcol_one_last] content [/fourcol_one_last]');
                                } else if (e.data.columnListboxName == 'five_col') {
                                    editor.insertContent( '[fivecol_one] content [/fivecol_one][fivecol_one] content [/fivecol_one][fivecol_one] content [/fivecol_one][fivecol_one] content [/fivecol_one][fivecol_one_last] content [/fivecol_one_last]');
                                } else if (e.data.columnListboxName == 'six_col') {
                                    editor.insertContent( '[sixcol_one] content [/sixcol_one][sixcol_one] content [/sixcol_one][sixcol_one] content [/sixcol_one][sixcol_one] content [/sixcol_one][sixcol_one] content [/sixcol_one][sixcol_one_last] content [/sixcol_one_last]');
                                }
                            }
                        });
                    }
                },
                { // Dropcap
                    text:'Dropcap',
                    onclick: function() {
                        editor.windowManager.open({
                            title: 'Dropcap Shortcode',
                            body: [
                                // Letter color
                                {
                                    type: 'textbox',
                                    name: 'font_color',
                                    label: 'Font Color',
                                    value: '#ffffff'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Insert hex code here \"#000000\" or css color name. e.g. red, yellow, green, etc.'
                                },
                                // Letter background color
                                {
                                    type: 'textbox',
                                    name: 'bg_color',
                                    label: 'Background Color',
                                    value: '#0f0f0f'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Insert hex code here \"#000000\" or css color name. e.g. red, yellow, green, etc.'
                                },
                                // Letter weight
                                {
                                  type: 'listbox',
                                  name: 'ltr_weight',
                                  label: 'Letter Weight',
                                  'values': [
                                              { text: 'Normal', value: '400' },
                                              { text: 'Bold', value: '600' }
                                            ]
                                },
                                {
                                  type: 'label',
                                  name: 'someHelpText',
                                  multiline: true,
                                  style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                  text: "",
                                },
                                // Letter
                                {
                                    type: 'textbox',
                                    name: 'ltr_txt',
                                    label: 'Letter',
                                    value: 'L'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: ''
                                }
                            ],
                            onsubmit: function( e ) {
                                editor.insertContent( '[dropcap_sty color="' + e.data.font_color + '" back="' + e.data.bg_color + '" font_weight="' + e.data.ltr_weight + '"]' + e.data.ltr_txt + '[/dropcap_sty]');
                            }
                        });
                    }
                },
                { // Facebook Login
                    text: 'Facebook Login',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Table Shortcode',
                            body: [
                                {
                                    type: 'textbox',
                                    name: 'txt',
                                    label: 'Text',
                                    value: 'Login / Register with Facebook'
                                }
                            ],
                            onsubmit: function( e ) {
                                editor.insertContent('[facebook_login_button text="' + e.data.txt + '"]');
                            }
                        } );
                    }
                },
                { // Highlight
                    text: 'Highlight',
                    onclick: function() {
                        editor.windowManager.open({
                            title: 'Highlight Shortcode',
                            body: [
                                // Background color
                                {
                                    type: 'textbox',
                                    name: 'bg_color',
                                    label: 'Background Color',
                                    value: '#000000'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Insert hex code here \"#000000\" or css color name. e.g. red, yellow, green, etc.'
                                },
                                // Text color
                                {
                                    type: 'textbox',
                                    name: 'txt_color',
                                    label: 'Text Color',
                                    value: '#ffffff'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Insert hex code here \"#000000\" or css color name. e.g. red, yellow, green, etc.'
                                },
                                // Letter or Text
                                {
                                    type: 'textbox',
                                    name: 'txt',
                                    label: 'Letter',
                                    value: 'example'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Insert your custom word, letter, or dummy text.'
                                }
                            ],
                            onsubmit: function( e ) {
                                editor.insertContent( '[highlight_sty color="' + e.data.txt_color + '" back="' + e.data.bg_color + '"]' + e.data.txt + '[/highlight_sty]');
                            }
                        })
                    }
                },
                { // List
                    text:'List',
                    onclick: function() {
                        editor.windowManager.open({
                            title: 'List Shortcode',
                            body: [
                                // List Type
                                {
                                    type: 'listbox',
                                    name: 'type',
                                    label: 'List Type',
                                    'values': [
                                                { text: 'Standard', value: '' },
                                                { text: 'Vertical', value: 'vertical' },
                                              ]
                                },
                                // Separator
                                {
                                    type: 'listbox',
                                    name: 'separator',
                                    label: 'Show Separator',
                                    'values': [
                                                { text: 'No', value: 'false' },
                                                { text: 'Yes', value: 'true' }
                                              ]
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Active when you choose vertical type.'
                                },
                                // Separator Color
                                {
                                    type: 'textbox',
                                    name: 'sep_col',
                                    label: 'Separator Color',
                                    value: '#000000',
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Active when you choose show separator.'
                                },
                                // Icon List
                                {
                                    type: 'textbox',
                                    name: 'icon',
                                    label: 'Insert Icon',
                                    value: 'fa fa-leaf'
                                },
                                // Items list count
                                {
                                    type: 'textbox',
                                    name: 'list_count',
                                    label: 'Item List',
                                    value: '4'
                                },
                                // Border Width
                                {
                                    type: 'textbox',
                                    name: 'border_width',
                                    label: 'Border Width',
                                    value: '1px'
                                },
                                // Border Style
                                {
                                    type: 'listbox',
                                    name: 'border_style',
                                    label: 'Border Style',
                                    'values': [
                                                { text: 'None', value: 'none' },
                                                { text: 'Solid', value: 'solid' },
                                                { text: 'Dotted', value: 'dotted' },
                                                { text: 'Dashed', value: 'dashed' },
                                                { text: 'Double', value: 'double' }
                                              ]
                                },
                                // Border Color
                                {
                                    type: 'textbox',
                                    name: 'border_color',
                                    label: 'Border Color',
                                    value: '#000000'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Insert hex code here \"#000000\" or css color name. e.g. red, yellow, green, etc.'
                                }
                            ],
                            onsubmit: function( e ) {
                                if ( e.data.separator == 'true' ) {
                                    var show_sep = 'separator="' + e.data.separator + '"',
                                        sep_clr  = 'separator_color="' + e.data.sep_col + '"';
                                } else {
                                    var show_sep = '',
                                        sep_clr  = '';
                                }

                                if ( e.data.type == 'vertical' ) {
                                    var type = 'type="' + e.data.type + '"';
                                } else {
                                    var type = '';
                                }

                                editor.insertContent( '[list ' + type + ' border="' + e.data.border_width + '" border_style="' + e.data.border_style + '" border_color="' + e.data.border_color + '"]' );
                                    for ( var i = 0; i < e.data.list_count; i++ ) {
                                        if ( e.data.type == '' ) {
                                            editor.insertContent( '[list_item icon="' + e.data.icon + '"] Content [/list_item]' );
                                        } else {
                                            editor.insertContent( '[list_item_ver ' + show_sep + ' ' + sep_clr + ' icon="' + e.data.icon + '"] Content [/list_item_ver]' );
                                        }
                                    }
                                editor.insertContent( '[/list]' );
                            }
                        });
                    }
                },
                { // Button
                    text:'Button',
                    onclick: function() {
                        editor.windowManager.open({
                            title: 'Button Shortcode',
                            body: [
                                // button url
                                {
                                    type: 'textbox',
                                    name: 'url',
                                    label: 'Url',
                                    value: 'http://example.com'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Link for button.'
                                },
                                // button link target
                                {
                                    type: 'listbox',
                                    name: 'target',
                                    label: 'Open Link in New Tab',
                                    'values': [
                                                { text: 'Yes', value: 'false' },
                                                { text: 'No', value: 'true' }
                                              ]
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: ''
                                },
                                // button size
                                {
                                    type: 'listbox',
                                    name: 'size',
                                    label: 'Size',
                                    'values': [
                                                { text: 'Small', value: 'small' },
                                                { text: 'Large', value: 'large' }
                                              ]
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Button size.'
                                },
                                // button color preset
                                {
                                    type: 'listbox',
                                    name: 'bg_color1',
                                    label: 'Background Color',
                                    'values': [
                                                { text: 'Red', value: 'red' },
                                                { text: 'Orange', value: 'orange' },
                                                { text: 'Green', value: 'green' },
                                                { text: 'Aqua', value: 'aqua' },
                                                { text: 'Teal', value: 'teal' },
                                                { text: 'Purple', value: 'purple' },
                                                { text: 'Pink', value: 'pink' },
                                                { text: 'Silver', value: 'silver' },
                                                { text: 'Brown', value: 'brown' },
                                                { text: 'Gold', value: 'gold' },
                                                { text: 'Custom Color', value: 'custom' },
                                                { text: 'Transparent', value: 'transparent' }
                                              ]
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Button color.'
                                },
                                // button color custom
                                {
                                    type: 'textbox',
                                    name: 'bg_color2',
                                    label: 'Background Hex Color',
                                    value: '#000000'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Active if you choose \"custom color\". Insert hex code here \"#000000\" or css color name. e.g. red, yellow, green, etc.'
                                },
                                // border color
                                {
                                    type: 'textbox',
                                    name: 'border',
                                    label: 'Border Color',
                                    value: '#000000'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Active if you choose \"transparent background\". Insert hex code here \"#000000\" or css color name. e.g. red, yellow, green, etc.'
                                },
                                // font color
                                {
                                    type: 'textbox',
                                    name: 'font_color',
                                    label: 'Font Color',
                                    value: '#ffffff'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Insert hex code here \"#000000\" or css color name. e.g. red, yellow, green, etc.'
                                },
                                // button text
                                {
                                    type: 'textbox',
                                    name: 'btn_txt',
                                    label: 'Button Text',
                                    value: 'Button'
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: ''
                                },
                                // Extra class
                                {
                                    type: 'textbox',
                                    name: 'classes',
                                    label: 'Extra Class',
                                    value: ''
                                },
                                {
                                    type: 'label',
                                    name: 'someHelpText',
                                    multiline: true,
                                    style: 'padding: 5px 0;font-size: 11px;font-style: italic;color: #999;left:auto;text-align:right;',
                                    text: 'Style particular content element differently - add a class name and refer to it in custom CSS.'
                                },
                            ],
                            onsubmit: function( e ) {
                                var cstm_bgc = e.data.bg_color1 == 'custom' ? e.data.bg_color2 : e.data.bg_color1;
                                editor.insertContent( '[button link="' + e.data.url + '" window="' + e.data.target + '" size="' + e.data.size + '" bg_color="' + cstm_bgc + '" border="' + e.data.border + '" color="' + e.data.font_color + '" class="' + e.data.classes + '"]' + e.data.btn_txt + '[/button]');
                            }
                        });
                    }
                },
                { // Table
                    text: 'Table',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Table Shortcode',
                            body: [
                                {
                                    type: 'listbox',
                                    name: 'type',
                                    label: 'Table Type',
                                    'values': [
                                                { text: 'Type 1', value: '1' },
                                                { text: 'Type 2', value: '2' },
                                                { text: 'Type 3', value: '3' }
                                              ]
                                },
                                {
                                    type: 'textbox',
                                    name: 'table_row',
                                    label: 'Number of row',
                                    value: '4'
                                },
                                {
                                    type: 'textbox',
                                    name: 'table_coloumn',
                                    label: 'Number of column',
                                    value: '4'
                                }
                            ],
                            onsubmit: function( e ) {
                                editor.insertContent('[table ver="' + e.data.type + '"]');
                                    for (i = 0; i < e.data.table_row; i++) {
                                        editor.insertContent('[table_tr]');
                                        for (j = 0; j < e.data.table_coloumn; j++) {
                                            editor.insertContent('[table_td] content [/table_td]');
                                        }
                                        editor.insertContent('[/table_tr]');
                                    }
                                editor.insertContent('[/table]');
                            }
                        } );
                    }
                },
                { // Tooltips
                    text: 'Tooltip',
                    onclick: function() {
                        editor.windowManager.open({
                            title: 'Tooltip Shortcode',
                            body: [
                                // Text
                                {
                                    type: 'textbox',
                                    name: 'txt',
                                    label: 'Tooltip Text',
                                    value: ''
                                },
                                // Url
                                {
                                    type: 'textbox',
                                    name: 'url',
                                    label: 'Tooltip Url',
                                    value: ''
                                },
                                // title
                                {
                                    type: 'textbox',
                                    name: 'title',
                                    label: 'Tooltip Hover Title',
                                    value: ''
                                },
                                // target
                                {
                                    type: 'listbox',
                                    name: 'target',
                                    label: 'Open In',
                                    'values': [
                                        { text: 'Same Window', value: '_self' },
                                        { text: 'New Window', value: '_blank' },
                                    ]
                                },
                            ],
                            onsubmit: function( e ) {
                                editor.insertContent( '[tooltip text="' + e.data.txt + '" link="' + e.data.url + '" tooltip="' + e.data.title + '" target="' + e.data.target + '"]' );
                            }
                        });
                    }
                },
            ]
        } ); // editor.addButton
    } ); // tinymce.PluginManager.add

})( jQuery );