<?php
 /**
  * 24.portfolio
  *
  * Show portfolio
  *
  * @example
  *
  *
  *
**/
function df_portfolio_sc( $atts) {

    extract( shortcode_atts( array(
        'post_per_page' => '-1',
        'col'           => 'port-col-1'
    ), $atts ) );

    global $post, $more, $woo_options;

    $more = 0;

    $args = array(
        'post_type'      => 'portfolio',
        'posts_per_page' => $post_per_page
    );

    query_posts( $args );

    ob_start();

    if( have_posts() ) : $count = 0; ?>

        <div id="portfolio" class="<?php echo $col; ?>">

            <?php $terms = get_the_terms( $post->ID, 'portfolio-gallery' ); ?>

            <div class="nav_port_iso">
                <?php isotope_categories() ;?>
            </div>

            <?php if ( $woo_options['woo_portfolio_page_ver'] == 'true' ) : ?>

                <div class="portfolio-items port_mason">

                    <div class="grid-sizer"></div>

            <?php else : ?>

                <div class="portfolio-items port_layout">

            <?php endif; /*end if else mason*/ ?>

            <?php while ( have_posts() ) : the_post();
                $settings = woo_portfolio_item_settings( $post->ID );
                if ( isset( $woo_options['woo_portfolio_linkto'] ) && ( $woo_options['woo_portfolio_linkto'] == 'post' ) ) :
                    $settings['large'] = get_permalink( $post->ID );
                    $settings['rel']   = '';
                endif; ?>

                <div <?php post_class( $settings['css_classes'] ); ?>>

                    <div class="port-item">

                        <?php if ( has_post_thumbnail( ) ) { ?>

                            <div class="view view-sixth banner">

                            <?php if ($woo_options['woo_portfolio_page_ver'] == 'true') {
                                      echo '<div class="image-mason-port">';
                                      the_post_thumbnail('full');
                                      echo '</div>';
                                  } else {
                                      echo '<div class="image-layout-port">';
                                      the_post_thumbnail('thumbnail-lookbook-land');
                                      echo '</div>';
                                  } ?>

                                  <div class="mask-blog">
                                      <div class="overlay-blog custom_back"></div>
                                  </div>

                                  <div class="borderbanner-blog custom_bor">
                                      <span>

<?php
if ($woo_options['woo_portfolio_linkto'] == 'lightbox') {
  echo '<a '. $settings['rel'].' title="'. $settings['caption'].'" href="'. $settings['large'].'" class="thumb">';
  _e( 'VIEW',  'woothemes' );
  echo '</a>';
}
else {
  echo '<a href="'.get_permalink( $post->ID ).'" class="thumb">';
  _e( 'READ MORE',  'woothemes' );
  echo '</a>';
}

?>
       </span>>
      </div>
   </div>
<span class="category-portfolio"><?php echo get_the_term_list( $post->ID, 'portfolio-gallery', ''); ?></span>

      <h3 class="port_title"><a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
    <?php
        // Output image gallery for lightbox
              if ( ! empty( $settings['gallery'] ) ) {
                  foreach ( array_slice( $settings['gallery'], 1 ) as $img => $attachment ) {
                    echo '


                    <a ' . $settings['rel'] . ' title="' . $attachment['caption'] . '" href="' . $attachment['url'] . '" class="gallery-image"><img src="' . esc_url( $attachment['url'] ) . '" alt="' . esc_attr( $attachment['alt'] ) . '" width="0" height="0" /></a>' . "\n";
                  }
                }
      } // End IF Statement
    ?>
    </div><!--.port-item-->
    </div><!--/.group .post .portfolio-img-->
    <?php
    endwhile;
    ?>
  </div><!--/.portfolio-items-->
</div><!--/#portfolio-->
    <?php
  endif;
  wp_reset_query();
return ob_get_clean();



}
add_shortcode( 'portfolio', 'df_portfolio_sc' );