<?php

/**
 *  8. Teaser, callout, box & teaserbox
 *
 *   Show the callout and teaser
 *
 * @example
 *   [teaser img="" button="true OR false" link="" button_text="" style="" bgcolor="" color_text="" target="_self OR _blank" align="left/center/right"]Your Content [/teaser]
 *   [teaserbox title="" img="" button="" link="" button_text="" style="" color="" color_text="" align="" border_color="" pos_border="" width_border="" text_color="" background_color=""]Your Content[/teaserbox]
 *   [callout title="" background_color="" border_color="" target="" link="" button_text="" style="" color="" color_text="" pos_x=""]Your Content [/callout]
 *   [box align="" border_color=""]Your Content[/box]
**/

function df_teaser_sc( $atts, $content = null ) {
    $output_img = $teaser = '';

    extract( shortcode_atts( array(
        'img'         => '',
        'button'      => 'false',
        'link'        => '',
        'button_text' => '',
        'style'       => '',
        'bgcolor'     => '',
        'color_text'  => '',
        'target'      => '_self',
        'title'       => ''
    ), $atts ) );

    $img = explode( ',', $img );

    foreach ( $img as $attach_id ) :
        $image_src   = wp_get_attachment_image_src( $attach_id, 'full' );
        $output_img .= $image_src[0];
    endforeach;

    $return_img = $output_img == '' ? esc_url( get_template_directory_uri().'/images/dummy/teaser.jpg' ) : esc_url( $output_img );

    if ( $button == 'true' ) :
        $teaser .= '<div class="teaser">';
        $teaser .= '<div class="teaser-img">';
        $teaser .= '<a href="' . esc_url( $link ) . '"" target="' . esc_attr( $target ) . '">';
        $teaser .= '<img src="' . $return_img . '" />';
        $teaser .= '</a>';
        $teaser .= '</div>';
        $teaser .= '<h3 class="title-sc">' . esc_attr( $title ) . '</h3>';
        $teaser .= do_shortcode( $content );
        $teaser .= '<span class="teaser-butt">';
        $teaser .= '<a href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '" class="woo-sc-button ' . $style . '" style="background-color:' . $bgcolor . ';color:' . $color_text . ';">';
        $teaser .= $button_text;
        $teaser .= '</a>';
        $teaser .= '</span>';
        $teaser .= '</div>';
    else :
        $teaser .= '<div class="teaser">';
        $teaser .= '<div class="teaser-img">';
        $teaser .= '<a href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">';
        $teaser .= '<img src="' . $return_img . '" />';
        $teaser .= '</a>';
        $teaser .= '</div>';
        $teaser .= '<h3 class="title-sc">' . esc_attr( $title ) . '</h3>';
        $teaser .= do_shortcode( $content );
        $teaser .= '</div>';
    endif;

    return $teaser;
}

add_shortcode( 'teaser', 'df_teaser_sc' );

/*-----------------------------------------------------------------------------------*/

function df_teaserbox_sc( $atts, $content = null ) {
    $output_img = $teaser = '';

    extract( shortcode_atts( array(
        'title'            => '',
        'img'              => '',
        'button'           => 'false',
        'link'             => '',
        'button_text'      => '',
        'style'            => '',
        'bgcolor'          => '',
        'color_text'       => '',
        'align'            => 'center',
        'border_color'     => '',
        'pos_border'       =>'45%',
        'width_border'     =>'100px',
        'text_color'       => '',
        'background_color' => '',
        'back_image'       => 'false'
    ), $atts ) );

    $img = explode( ',', $img );

    foreach ( $img as $attach_id ) :
        $image_src   = wp_get_attachment_image_src( $attach_id, 'full' );
        $output_img .= $image_src[0];
    endforeach;

    $return_img = $output_img == '' ? esc_url( get_template_directory_uri().'/images/dummy/teaserbox.jpg' ) : esc_url( $output_img );

    if ( $button == 'true' ) :

        if ( $back_image == 'false' ) :
            $teaser .= '<div class="teaserbox2" style="text-align:' . $align . ';border-color:' . $border_color . ';color:' . $text_color . ';background-color:' . $background_color . '">';
            $teaser .= '<h3 class="title-sc" style="color:' . $text_color . '">' . $title . '</h3>';
            $teaser .= '<div class="border-teaser" style="border-color:' . $border_color . ';"></div>';
            $teaser .= do_shortcode( $content );
            $teaser .= '<span class="teaser-butt">';
            $teaser .= '<a href="' . esc_url( $link ) . '" class="woo-sc-button ' . esc_attr( $style ) . '" style="background-color:' . $bgcolor . ';color:' . $color_text . ';">';
            $teaser .= $button_text;
            $teaser .= '</a>';
            $teaser .= '</span>';
            $teaser .= '</div>';
        else :
            $teaser .= '<div class="teaserbox" style="text-align:' . $align . ';border-color:' . $border_color . ';color:' . $text_color . ';background:url(' . $return_img . ') no-repeat;background-size: cover;">';
            $teaser .= '<h3 class="title-sc" style="color:' . $text_color . '">' . $title . '</h3>';
            $teaser .= '<div class="border-teaser" style="border-color:'.$border_color.'; "></div>';
            $teaser .= do_shortcode( $content );
            $teaser .= '<span class="teaser-butt">';
            $teaser .= '<a href="' . esc_url( $link ) . '" class="woo-sc-button ' . esc_attr( $style ) . '" style="background-color:' . $bgcolor . ';color:' . $color_text . ';">';
            $teaser .= $button_text;
            $teaser .= '</a>';
            $teaser .= '</span>';
            $teaser .= '</div>';
        endif;

    else :

        if ( $back_image == 'false' ) :
            $teaser .= '<div class="teaserbox2" style="text-align:' . $align . ';border-color:' . $border_color . ';color:' . $text_color . ';background-color:' . $background_color . '">';
            $teaser .= '<h3 class="title-sc" style="color:' . $text_color . '">' . $title . '</h3>';
            $teaser .= '<div class="border-teaser" style="border-color:' . $border_color . ';"></div>';
            $teaser .= do_shortcode( $content );
            $teaser .= '</div>';
        else :
            $teaser .= '<div class="teaserbox" style="text-align:' . $align . ';border-color:' . $border_color . ';color:' . $text_color . ';background:url(' . $return_img . ') no-repeat;background-size:cover;">';
            $teaser .= '<h3 class="title-sc" style="color:' . $text_color . '">' . $title . '</h3>';
            $teaser .= '<div class="border-teaser" style="border-color:' . $border_color . ';"></div>';
            $teaser .= do_shortcode( $content );
            $teaser .= '</div>';
        endif;

    endif;

    return $teaser;
}
add_shortcode( 'teaserbox', 'df_teaserbox_sc' );