<?php
// don't load directly
if (!defined('ABSPATH')) die('-1');

/*-----------------------------------------------------------------------------------*/
/* Visual Composer Setup 															 */
/*-----------------------------------------------------------------------------------*/

// Set WPB VC as Theme
if ( function_exists( 'vc_set_as_theme' ) ) { vc_set_as_theme( true ); }

// Disable WPB VC edit frontend
if ( function_exists( 'vc_disable_frontend' ) ) { vc_disable_frontend(); }

/**
 * Override Template WPB VC - since version 4.0
 */
if ( function_exists( 'vc_set_shortcodes_templates_dir' ) ) {
	$temp_dir = trailingslashit( trailingslashit( DF_SHORTCODES_PATH ) . 'vc-mod/vc-templates' );
	vc_set_shortcodes_templates_dir( $temp_dir );
}

if (! function_exists( 'df_shortcodes_enqueue_admin_scripts' ) ) {
	function df_shortcodes_enqueue_admin_scripts() {
		wp_register_style( 'df-vc-ui-admin-style', DF_SHORTCODES_URL . 'assets/css/vc-ui.css' );
   		wp_enqueue_style( 'df-vc-ui-admin-style' );
	}
	add_action( 'admin_footer', 'df_shortcodes_enqueue_admin_scripts' );
}

require_once dirname(__FILE__) . '/vc_mod-extend.php';
require_once dirname(__FILE__) . '/vc_mod-update.php';
require_once dirname(__FILE__) . '/vc_mod-remove.php';