<?php

/**
 *
 * @example
 *
 * [banner img="" button= "true or false" link="" button_text="" text="" style="" color="" color_text="" pos_x="" pos_y="" hover="true or false" target="" heading="" text="" heading_top=""  heading_color="#fff" border_color="#fff" rgba="0,0,0,0.9" ]
**/

function df_banner_sc( $atts, $content = null ) {
    $output_img = $banner = '';

    extract( shortcode_atts( array(
        'img'           => '',
        'button'        => 'false',
        'link'          => '',
        'button_text'   => '',
        'style'         => '',
        'color'         => '',
        'color_text'    => '',
        'hover'         => 'false',
        'target'        => '_self',
        'heading'       => 'h1',
        'text'          => '',
        'heading_color' => '',
        'border_color'  => '',
        'rgba'          => ''
    ), $atts ) );

    $img = explode( ',', $img );

    foreach ( $img as $attach_id ) :
        $image_src  = wp_get_attachment_image_src( $attach_id, 'full' );
        $output_img = $image_src[0];
    endforeach;

    if ( $output_img == '' ) :
        $return_img = esc_url( get_template_directory_uri() . '/images/dummy/banner.jpg' );
    else :
        $return_img = esc_url( $output_img );
    endif;

    if ( $button == 'true' && $hover == 'false' ) :
        $inline_banner_css = 'style="background-color:' . $color . ';color:' . $color_text . ';margin:0px;"';

        $banner .= '<div class="banner banner_hov">';
        $banner .= '<img src="' . $return_img . '" />';
        $banner .= '<a href="' . esc_url( $link ) . '" target="' . $target . '" class="woo-sc-button ' . $style . '" ' . $inline_banner_css . '>' . $button_text . '</a>';
        $banner .= '</div>';
    elseif ( $button == 'true' && $hover == 'true' ) :
        $inline_banner_css = 'style="background-color:' . $color . ';color:' . $color_text . ';"';

        $banner .= '<div class="banner_hov">';
        $banner .= '<div class="view view-sixth banner">';
        $banner .= '<img src="' . $return_img . '" />';
        $banner .= '<div class="mask">';
        $banner .= '<div class="overlay" style="background-color: ' . $rgba . ';"></div>';
        $banner .= '</div>';
        $banner .= '<div class="borderbanner">';
        $banner .= '<span style="border:2px solid ' . $border_color . ';">';
        $banner .= '<a href="' . esc_url( $link ) . '" target="' . $target . '"  style="color:' . $heading_color . '"> <' . $heading . ' class="title-sc" style="color:' . $heading_color . '">' . $text . '</' . $heading . '></a>';
        $banner .= '<a href="' . esc_url( $link ) . '" target="' . $target . '" class="woo-sc-button ' . $style . '" ' . $inline_banner_css . '>' . $button_text . '</a>';
        $banner .= '</span>';
        $banner .= '</div></div></div>';
    elseif ( $button == 'false' && $hover == 'true' ) :
        $banner .= '<div class="view view-sixth banner banner_hov">';
        $banner .= '<img src="' . $return_img . '" />';
        $banner .= '<div class="mask">';
        $banner .= '<div class="overlay" style="background-color: ' . $rgba . ';"></div>';
        $banner .= '</div>';
        $banner .= '<div class="borderbanner">';
        $banner .= '<span style="border:2px solid ' . $border_color . ';">';
        $banner .= '<a href="' . esc_url( $link ) . '" target="' . $target . '"  style="color:' . $heading_color . '"><' . $heading . ' class="title-sc" style="color:' . $heading_color . '">' . $text . '</' . $heading . '></' . $heading . '></a>';
        $banner .= '</span>';
        $banner .= '</div>';
        $banner .= '</div>';
    else :
        $banner .= '<div class="banner banner_hov">';
        $banner .= '<img src="' . $return_img . '" />';
        $banner .= '</div>';
    endif;

    return $banner;
}
add_shortcode( 'banner', 'df_banner_sc' );