<?php

/**
  * 9. Blog
  *
  *
  *
  * @example
  * [bloglist title="blog below" showtitle="yes"  version="2"  ]
  * [blog title="blog below" showtitle="yes" posts="10" col="4"]
**/

/*-----------------------------------------------------------------------------------*/
/*  Latest Blog                                                                      */
/*-----------------------------------------------------------------------------------*/
/* Blog Grid Version */
function df_blog_latest_sc( $atts ) {
    extract( shortcode_atts( array(
        'posts'      => '',
        'title'      => 'Latest From The Blog',
        'show_title' => 'no',
        'categories' => 'all',
        'col'        => '2'
    ), $atts ) );

    global $post;

    $args = array(
        'post_type'           => 'post',
        'posts_per_page'      => $posts,
        'order'               => 'DESC',
        'ignore_sticky_posts' => 1,
        'orderby'             => 'date',
        'post_status'         => 'publish'
    );

    if ( $categories != 'all' ) :

        /* string to array */
        $str = $categories;
        $arr = explode( ',', $str );

        $args['tax_query'][] = array(
            'taxonomy' => 'category',
            'field'    => 'slug',
            'terms'    => $arr
        );

    endif;

    query_posts( $args );

    $out = '';

    if( have_posts() ) :

        if ( $show_title == 'yes' ) :
            $out .= '<h3 class="title-sc blog-title-sc">' . esc_attr( $title ) . '</h3>';
        endif;

        $out .= '<div class="latest-blog">';

        switch ( $col ) :
            case '2': $div = 'col2'; break;
            case '3': $div = 'col3'; break;
            case '4': $div = 'col4'; break;
            default: $div = 'col2'; break;
        endswitch;

        $i = 1; $j = 1;

        while ( have_posts() ) : the_post();

            if ( $col == '3' && $i % 3 == 0 ) :

                $out .= '<div class="blog-item ' . $div . ' last-class-blog">';

            elseif ( $col == '4' && $i % 4 == 0 ) :

                $out .= '<div class="blog-item ' . $div . ' last-class-blog">';

            elseif ( $col == '2' && $i % 2 == 0 ) :

                $out .= '<div class="blog-item ' . $div . ' last-class-blog">';

            else :

                $out .= '<div class="blog-item ' . $div . '">';

            endif;

            $j += 1;

            if ( has_post_thumbnail() ) :
                /* Get Image */
                $blog_thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'thumbnail-sc-blog' );

                /* Print out blog html */
                $out .= '<div class="blog-item-mask">';
                $out .= '<div class="view view-sixth banner">';
                $out .= '<img src="' . esc_url( $blog_thumbnail[0] ) . '" class="thumbnail"/>';
                $out .= '<div class="mask-blog">';
                $out .= '<div class="overlay-blog"></div>';
                $out .= '</div>';
                $out .= '<div class="borderbanner-blog">';
                $out .= '<span>';
                $out .= '<h4 class="title-sc">';
                $out .= '<a href="' . esc_url( get_permalink() ) . '" title="' . get_the_title() . '" class="blog-link ">' . __( 'READ MORE', 'woothemes' ) . '</a></h4>';
                $out .= '</span>';
                $out .= '</div>';
                $out .= '</div>';
                $out .= '</div>';
            endif;

            $out .= '<div class="blog-item-description">';
            $out .= '<div class="blog-post-meta meta_sc">';
            $out .= '<span class="small">' . do_shortcode( '[post_date after=" /"]' ) . do_shortcode( '[post_comments]' ) .'</span></div>';
            $out .= '<h3 class="title-sc"><a href="' . esc_url( get_permalink() ) . '" title="' . get_the_title() . '">' . get_the_title() . '</a></h3>';
            $out .= '<div class="blog-list-item-excerpt"><p>' . labomba_word_trim( get_the_excerpt(), '10', '...' ) . '</p></div>';
            $out .= '</div>';

            if ( $col == '3' && $i % 3 == 0 ) :
                $out .='<div class="blog-border"></div></div><div class="fix"></div>';
            elseif ( $col == '4' && $i % 4 == 0 ) :
                $out .='<div class="blog-border"></div></div><div class="fix"></div>';
            elseif ( $col == '2' && $i % 2 == 0 ) :
                $out .='<div class="blog-border"></div></div><div class="fix"></div>';
            else :
                $out .='<div class="blog-border"></div></div>';
            endif;

            $i += 1;

        endwhile;

        $out .= '</div><div class="clear"></div>';

    endif;

    wp_reset_query();

    return $out;
}
add_shortcode( 'blog', 'df_blog_latest_sc' );

/* Blog List Version */
function df_bloglist_sc( $atts ) {

    extract( shortcode_atts( array(
        'posts'      => '4',
        'title'      => 'Latest Blog Entries',
        'show_title' => 'no',
        'categories' => 'all',
        'version'    => '1',
    ), $atts ) );

    global $post;

    $args = array(
        'post_type'           => 'post',
        'posts_per_page'      => $posts,
        'ignore_sticky_posts' => 1,
        'order'               => 'DESC',
        'orderby'             => 'date',
        'post_status'         => 'publish'
    );

    if ( $categories != 'all' ) :

        // string to array
        $str = $categories;
        $arr = explode( ',', $str );

        $args['tax_query'][] = array(
            'taxonomy' => 'category',
            'field'    => 'slug',
            'terms'    => $arr
        );
    endif;

    query_posts( $args );

    $out = '';

    if ( $version == '2' ) :

        if ( have_posts() ) :

            if( $show_title == 'yes' ) :
                $out .= '<h3 class="title-sc blog-title-sc">' . esc_attr( $title ) . '</h3>';
            endif;

            while ( have_posts() ) : the_post();

                if ( has_post_thumbnail() ) :
                    /* Get Image */
                    $blog_thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'thumbnail-sc-blog' );
                endif;

                /* Print out blog html */
                $out .= '<div class="latest-blog-list clearfix">';
                $out .= '<div class="blog-list-item-description ver2">';

                if ( has_post_thumbnail() ) :
                    $out .= '<div class="blog-list-image blog-list-img1">';
                    $out .= '<img src="' . esc_url( $blog_thumbnail[0] ) . '" class="thumbnail">';
                    $out .= '</div>';
                endif;

                $out .= '<div class="blog-post-meta">';
                $out .= '<span class="small">' . do_shortcode( '[post_date]' ) . '/ ' . do_shortcode( '[post_comments]' ) . '</span></div>';
                $out .= '<h3 class="title-sc"><a href="' . esc_url( get_permalink() ) . '" title="' . get_the_title() . '">' . get_the_title() .'</a></h3>';
                $out .= '<div class="blog-list-item-excerpt"><p>' . labomba_word_trim( get_the_excerpt(), '100' ) . '... </p></div>';
                $out .= '</div>';
                $out .= '</div>';

            endwhile;

            $out .= '<div class="clear"></div>';

        endif;

    else :

        if( have_posts() ) :

          if ( $show_title == 'yes' ) :
              $out .= '<h3 class="title-sc blog-title-sc">' . esc_attr( $title ) . '</h3>';
          endif;

          while ( have_posts() ) : the_post();

              if ( has_post_thumbnail() ) :
                  /* Get Image */
                  $blog_thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'thumbnail-sc-blog' );
              endif;

              $out .= '<div class="latest-blog-list clearfix">';
              $out .= '<div class="blog-list-item-description">';

              if ( has_post_thumbnail() ) :
                  $out .= '<div class="blog-list-image blog-list-img1">';
                  $out .= '<img src="' . esc_url( $blog_thumbnail[0] ) . '" class="thumbnail">';
                  $out .= '</div>';
              endif;

              $out .= '<div class="blog-post-meta">';
              $out .= '<span class="small">' . do_shortcode( '[post_date]' ) . '/ ' . do_shortcode( '[post_comments]' ) . '</span></div>';
              $out .= '<h3 class="title-sc"><a href="' . esc_url( get_permalink() ) .'" title="' . get_the_title() . '">' . get_the_title() . '</a></h3>';
              $out .= '<div class="blog-list-item-excerpt"><p>' . labomba_word_trim( get_the_excerpt(), '100' ) . '... </p></div>';
              $out .= '</div>';
              $out .= '</div>';

          endwhile;

          $out .= '<div class="clear"></div>';

        endif;

    endif;

    wp_reset_query();

    return $out;
}
add_shortcode('bloglist', 'df_bloglist_sc');