<?php

function df_box_sc( $atts, $content = null ) {
    $output_img = $boxes = '';

    extract( shortcode_atts( array(
        'align'        => 'center',
        'border_color' => '#dbdbdb',
        'ver'          => '1',
        'img'          => '',
        'back'         => '#000',
        'href'         => '',
        'href_text'    => '',
        'target'       => '_self',
        'href_color'   => '',
        'back_image'   => 'false'
    ), $atts ) );

    $img = explode( ',', $img );

    foreach ( $img as $attach_id ) :
        $image_src   = wp_get_attachment_image_src( $attach_id, 'full' );
        $output_img .= $image_src[0];
    endforeach;

    $return_img = $output_img == '' ? esc_url( get_template_directory_uri() . '/images/dummy/box.jpg' ) : esc_url( $output_img );

    $link = $href != '' ? '<p class="link" style="border-color:' . $border_color . '"><a href="' . $href . '" target="' . $target . '" style="color:' . $href_color . ';text-align:center;display:block;">' . $href_text . '</a></p>' : '';

    if ( $ver == '2' ) :

        if ( $back_image == 'false' ) :
            $boxes .= '<div class="box2" style="text-align:' . $align . ';border-color:' . $border_color . ';background:' . $back . '">';
            $boxes .= '<div class="boxinnner" style="border-color:' . $border_color . ';">';
            $boxes .= '<div>' . do_shortcode( $content ) . '</div>';
            $boxes .= $link;
            $boxes .= '</div>';
            $boxes .= '</div>';
        else :
            $boxes .= '<div class="box2" style="text-align:' . $align . ';border-color:' . $border_color . ';background:url(' . $return_img . ') no-repeat;background-size: cover;">';
            $boxes .= '<div class="boxinnner" style="border-color:' . $border_color . ';">';
            $boxes .= '<div>' . do_shortcode( $content ) . '</div>';
            $boxes .= $link;
            $boxes .= '</div>';
            $boxes .= '</div>';
        endif;

    else :

        $boxes .= '<div class="box" style="text-align:' . $align . ';border-color:' . $border_color . ';">';
        $boxes .= '<div class="boxinnner" style="border-color:' . $border_color . ';">';
        $boxes .= do_shortcode( $content );
        $boxes .= '</div>';
        $boxes .= '</div>';

    endif;

    return $boxes;
}
add_shortcode( 'box', 'df_box_sc' );