<?php

/**
  *
  * Show Parallax bg
  *
  * @example
  *
  *
  *   [parallax img_bg=""  height="" padding="" margin="" width="" width="" img_pos="" speed="" float="" img_el="" margin_el="" class_el="" img_pos_el="" speed_el=""  width_el="" height_el=""] your content [/parallax]
**/

function df_parallax_sc( $atts, $content = null ) {

    $temp = $output_img = $output_img_el = '';

    extract( shortcode_atts( array(
        'img_bg'      => '',
        'height'      => '480px',
        'margin'      => '',
        'padding'     => '20px 0',
        'width'       => '100%',
        'class'       => 'parout',
        'img_pos'     => '50%',
        'speed'       => '0.5',
        'float'       => 'none',
        'img_el'      => '',
        'margin_el'   => '',
        'class_el'    => 'parin',
        'top_img_el'  => '0px',
        'left_img_el' => '40%',
        'img_pos_el'  => '50%',
        'speed_el'    => '0.5',
        'width_el'    => '980px',
        'height_el'   => '100%'
    ), $atts ) );

    $var  = '.' . $class;
    $var2 = '.' . $class_el;

    $img_bg = explode( ',', $img_bg ); $i = -1;

    foreach ( $img_bg as $attach_id ) { $i++;
        $image_src   = wp_get_attachment_image_src( $attach_id, 'full' );
        $output_img .= esc_url( $image_src[0] );
    }

    $img_el = explode( ',', $img_el ); $i = -1;

    foreach ( $img_el as $attach_id ) { $i++;
        $image_src      = wp_get_attachment_image_src( $attach_id, 'full' );
        $output_img_el .= esc_url( $image_src[0] );
    } ?>

    <script>
        jQuery( document ).ready( function( $ ) {

            var fullscreenPar   = jQuery('.one-col #parallax .parallax_out'),
                containerPar    = jQuery('#main, #main-shop'),
                ParOffsetl      = containerPar.offset().left,
                containerPar2   = jQuery('#parallax .parallax_content '),
                windowWidth     = jQuery(window).width(),
                containerPar3   = jQuery('#main').width(),
                containerInPar  = jQuery('.one-col #parallax .parallax_in'),
                containerSecpar = jQuery('.one-col #parallax .parallax_sec');

            if ( windowWidth > 799 ) {
                $('<?php echo $var;?>').parallax('<?php echo $img_pos;?>', '<?php echo $speed;?>');
                $('<?php echo $var2;?>').parallax('<?php echo $img_pos_el;?>', '<?php echo $speed_el;?>');
            }

            if ( windowWidth > 1600 ) {

                totwidthl = ParOffsetl;

                fullscreenPar.find( '.one-col #parallax .parallax_out' ).css( 'width', windowWidth );

                fullscreenPar.css( 'margin-left', '-' + totwidthl + 'px' );
                fullscreenPar.css( 'padding-right', function( index ) {
                    totwidth = ParOffsetl * 5;
                    return totwidth;
                });

                containerPar2.css( 'margin-left', ParOffsetl );

            } else if ( windowWidth > 900 ) {

                totwidthl = ParOffsetl;

                fullscreenPar.find( '.one-col #parallax .parallax_out' ).css( 'width', windowWidth );

                fullscreenPar.css( 'margin-left', '-' + totwidthl + 'px' );
                fullscreenPar.css( 'padding-right', function( index ) {
                    totwidth = ParOffsetl * 10;
                    return totwidth;
                });

                containerPar2.css( 'margin-left', ParOffsetl );

            } else if ( windowWidth > 799 ) {

                totwidthl     = ParOffsetl + ( 980 * 0.0285715 );
                widthInPar    = containerPar3 - ( containerPar3 * 0.0285715 );
                widthSecPar   = containerPar3 - ( containerPar3 * 0.4 );
                heightSecPar  = containerPar3 - ( containerPar3 * 0.5 );
                LeftSecPar    = containerPar3 / 3;

                fullscreenPar.find( '.one-col #parallax .parallax_out' ).css( 'width', windowWidth );

                fullscreenPar.css( 'margin-left', '-' + totwidthl + 'px' );
                fullscreenPar.css( 'padding-right', function( index ) {
                    totwidth = ParOffsetl * 10;
                    return totwidth;
                });

                containerInPar.css( 'width', 'auto' );
                containerSecpar.css( 'width', widthSecPar + 'px' );
                containerSecpar.css( 'height', heightSecPar + 'px' );
                containerSecpar.css( 'left', LeftSecPar + 'px' );
                containerPar2.css( 'padding-left', ParOffsetl );

            } else {

                totwidth3     = ParOffsetl + ( containerPar3 * 0.0285715 );
                widthInPar    = containerPar3 - ( containerPar3 * 0.0285715 );
                widthSecPar   = containerPar3 - ( containerPar3 * 0.3 );
                heightSecPar  = containerPar3 - ( containerPar3 * 0.3 );
                LeftSecPar    = containerPar3 / 25;

                fullscreenPar.find( '.one-col #parallax .parallax_out' ).css( 'width', windowWidth );
                fullscreenPar.css( 'margin-left', '-' + totwidth3 + 'px' );
                containerInPar.css( 'width', widthInPar + 'px' );
                containerSecpar.css( 'width', widthInPar + 'px' );
                containerSecpar.css( 'left', LeftSecPar + 'px' );

                if ( windowWidth > 501 ) {
                    containerSecpar.css( 'height', heightSecPar + 'px' );
                } else if ( windowWidth <= 500 && windowWidth > 400 ) {
                    heightSecPar = heightSecPar + 75;
                    containerSecpar.css( 'height', heightSecPar + 'px' );
                } else if ( windowWidth <= 400 && windowWidth > 321 ) {
                    containerSecpar.css( 'width', 300 + 'px' );
                    containerSecpar.css( 'background-size', 'contain' );
                    containerSecpar.css( 'height', heightSecPar + 'px' );
                } else if ( windowWidth <= 320 ) {
                    containerSecpar.css( 'width', 300 + 'px' );
                    containerSecpar.css( 'background-size', 'contain' );
                    containerSecpar.css( 'height', heightSecPar + 'px' );
                }
            }
        });
    </script>

    <?php

    if ( $output_img_el != '' ) {
        $temp = '<div class="parallax_sec ' . esc_attr( $class_el ) . '" style="background:url(' . $output_img_el . ') 50% 0 no-repeat;margin:' . $margin_el . ' ;width:' . $width_el . ';height:' . $height_el . ';top:' . $top_img_el . ';left:' . $left_img_el . '"></div>';
    }

    $out  = '<div id="parallax" ><div class="parallax_out ' . esc_attr( $class ) . '" style="background:url(' . $output_img . ') 50% 0 no-repeat fixed;margin:' . $margin . ';height:' . $height . ';">';
    $out .= '<div class="parallax_content">';
    $out .= $temp;
    $out .= '<div class="parallax_in" style="padding:' . $padding . ';width:' . $width . ';float:' . $float . '">';
    $out .= do_shortcode( $content );
    $out .= '</div>';
    $out .= '</div>';
    $out .= '</div>';
    $out .= '</div>';

    return $out;

}

add_shortcode( 'parallax', 'df_parallax_sc' );