<?php

/**
  *
  * Show the testimonial
  *
  * @example
  * [testimonial author="author name" img="image link" ver="1/2/3/4"] your content[/testimonial]
  *
**/
/*-----------------------------------------------------------------------------------*/
/* Testimonial
/*-----------------------------------------------------------------------------------*/

function df_testimonial_sc( $atts, $content = null ) {

    $output_img = $testi = '';

    extract( shortcode_atts( array(
        'author' => '',
        'img'    => '',
        'ver'    => '1'
    ), $atts ) );

    $img = explode( ',', $img );
    $i   = -1;

    foreach ( $img as $attach_id ) : $i++;

        $image_src   = wp_get_attachment_image_src( $attach_id, 'thumbnail-testimonial' );
        $output_img .= esc_url( $image_src[0] );

    endforeach;

    $return_img = $output_img == '' ? esc_url( get_template_directory_uri() . '/images/dummy/testimonial.jpg' ) : $output_img;


    if ( $ver == '1' ) :
        $testi .= '<div class="testimonial">';
        $testi .= '<div class="testi-border"></div>';
        $testi .= '<div class="testi-ico"><em class="ico-quote9"></em></div>';
        $testi .= '<div class="testimonial-text">';
        $testi .= '<em>' . do_shortcode( $content ) . '</em>';
        $testi .= '</div>';
        $testi .= '<div class="testimonial-author">';
        $testi .= '<img src="' . $return_img . '">';
        $testi .= '<span>' . $author . '</span>';
        $testi .= '</div>';
        $testi .= '</div><div class="clear"></div>';
    elseif ( $ver == '2' ) :
        $testi .= '<div class="testimonial2">';
        $testi .= '<div class="testimonial2-text">';
        $testi .= '<em>' . do_shortcode( $content ) . '</em>';
        $testi .= '</div>';
        $testi .= '<div class="testi-name">';
        $testi .= '<span>' . $author . '</span>';
        $testi .= '<div class="testi-name-tri"></div>';
        $testi .= '</div>';
        $testi .= '</div>';
        $testi .= '<div class="testimonial-author2">';
        $testi .= '<img src="' . $return_img . '">';
        $testi .= '</div>';
        $testi .= '<div class="clear"></div>';
    elseif ( $ver == '3' ) :
        $testi .= '<div class="testimonial-author3">';
        $testi .= '<img src="' . $return_img . '">';
        $testi .= '</div><div class="testimonial3">';
        $testi .= '<div class="testimonial3-text">';
        $testi .= '<em>' . do_shortcode( $content ) . '</em>';
        $testi .= '</div>';
        $testi .= '<div class="testi-name3">';
        $testi .= '<div class="testi-name-tri3"></div>';
        $testi .= '<span>' . $author . '</span>';
        $testi .= '</div>';
        $testi .= '</div>';
        $testi .= '<div class="clear"></div>';
    elseif ( $ver == '4' ) :
        $testi .= '<div class="testimonial4">';
        $testi .= '<div class="testimonial4-text">';
        $testi .= '<em>' . do_shortcode( $content ) . '</em>';
        $testi .= '</div>';
        $testi .= '<div class="testi-name-tri4"></div>';
        $testi .= '<div class="testimonial-author4">';
        $testi .= '<div class="testimonial-img4">';
        $testi .= '<img src="' .$return_img. '">';
        $testi .= '</div>';
        $testi .= '<div class="testi-name4">';
        $testi .= '<span>' . $author . '</span>';
        $testi .= '</div>';
        $testi .= '</div>';
        $testi .= '</div>';
        $testi .= '<div class="clear"></div>';
    elseif ( $ver == '5' ) :
        $testi .= '<div class="testimonial5">';
        $testi .= '<div class ="testi-ico"><em class="ico-quote9"></em></div>';
        $testi .= '<div class="testimonial-text">';
        $testi .= '<em>' . do_shortcode( $content ) . '</em>';
        $testi .= '</div>';
        $testi .= '<div class="testimonial-author">';
        $testi .= '<img src="' . $return_img . '">';
        $testi .= '<span>' . $author . '</span>';
        $testi .= '</div>';
        $testi .= '</div><div class="clear"></div>';
    else :
        $testi .= '<div class="testimonial">';
        $testi .= '<div class="testi-border"></div>';
        $testi .= '<div class ="testi-ico"><em class="ico-quote9"></em></div>';
        $testi .= '<div class="testimonial-text">';
        $testi .= '<em>' . do_shortcode( $content ) . '</em>';
        $testi .= '</div>';
        $testi .= '<div class="testimonial-author">';
        $testi .= '<img src="' . $return_img . '">';
        $testi .= '<span>' . $author . '</span>';
        $testi .= '</div>';
        $testi .= '</div><div class="clear"></div>';
    endif;

    return $testi;
}

add_shortcode('testimonial', 'df_testimonial_sc');