<?php
// don't load directly
if ( !defined( 'ABSPATH' ) ) { die( '-1' ); }

// Check if visual composer is activated
if ( ! class_exists('Vc_Manager') ) { return; }


// Removing Unwanted Shortcodes
// =============================================================================
if ( ! function_exists( 'df_vc_remove_default_shortcodes' ) ) {
    function df_vc_remove_default_shortcodes() {
        vc_remove_element( 'vc_gmaps' );
        vc_remove_element( 'vc_facebook' );
        vc_remove_element( 'vc_tweetmeme' );
        vc_remove_element( 'vc_googleplus' );
        vc_remove_element( 'vc_pinterest' );
        vc_remove_element( 'vc_images_carousel' );
        vc_remove_element( 'vc_posts_grid' );
        vc_remove_element( 'vc_carousel' );
        vc_remove_element( 'vc_cta_button' );
        vc_remove_element( 'vc_cta_button2' );
        vc_remove_element( 'vc_raw_html' );
        vc_remove_element( 'vc_raw_js' );
        vc_remove_element( 'vc_flickr' );
        vc_remove_element( 'vc_wp_search' );
        vc_remove_element( 'vc_wp_meta' );
        vc_remove_element( 'vc_wp_recentcomments' );
        vc_remove_element( 'vc_wp_calendar' );
        vc_remove_element( 'vc_wp_pages' );
        vc_remove_element( 'vc_wp_tagcloud' );
        vc_remove_element( 'vc_wp_custommenu' );
        vc_remove_element( 'vc_wp_text' );
        vc_remove_element( 'vc_wp_posts' );
        vc_remove_element( 'vc_wp_links' );
        vc_remove_element( 'vc_wp_categories' );
        vc_remove_element( 'vc_wp_archives' );
        vc_remove_element( 'vc_wp_rss' );

        /* When Woocommerce Active */
        if ( is_woocommerce_activated() ):
            vc_remove_element( 'woocommerce_cart' );
            vc_remove_element( 'woocommerce_checkout' );
            vc_remove_element( 'woocommerce_order_tracking' );
            vc_remove_element( 'woocommerce_my_account' );
            vc_remove_element( 'recent_products' );
            vc_remove_element( 'featured_products' );
            vc_remove_element( 'product' );
            vc_remove_element( 'products' );
            vc_remove_element( 'add_to_cart' );
            vc_remove_element( 'add_to_cart_url' );
            vc_remove_element( 'product_page' );
            vc_remove_element( 'product_category' );
            vc_remove_element( 'product_categories' );
            vc_remove_element( 'sale_products' );
            vc_remove_element( 'best_selling_products' );
            vc_remove_element( 'top_rated_products' );
            vc_remove_element( 'product_attribute' );
        endif;
    }
    add_action( 'admin_init', 'df_vc_remove_default_shortcodes' );
}


// Remove Teaser Metabox
// =============================================================================
if ( is_admin() ) {
    if ( ! function_exists( 'df_vc_remove_teaser_metabox' ) ) {
        function df_vc_remove_teaser_metabox() {
            $post_types = get_post_types( '', 'names' );

            foreach ( $post_types as $post_type ) {
                remove_meta_box( 'vc_teaser',  $post_type, 'side' );
            }
        }
        add_action( 'do_meta_boxes', 'df_vc_remove_teaser_metabox' );
    }
}