<?php
/**
 * Error Content Template
 *
 * This template is the content template for error screens. It is used to display a message
 * to the viewer when no appropriate page can be found by WordPress.
 *
 * @package WooFramework
 * @subpackage Template
 */

/**
 * Settings for this template file.
 *
 * This is where the specify the HTML tags for the title.
 * These options can be filtered via a child theme.
 *
 * @link http://codex.wordpress.org/Plugin_API#Filters
 */
  global $woo_options;
 $title_before = '<h1 class="title-404">';
 $title_after = '</h1>';
  $error_img = '';
 
 $page_link_args = apply_filters( 'woothemes_pagelinks_args', array( 'before' => '<div class="page-link">' . __( 'Pages:', 'woothemes' ), 'after' => '</div>' ) );
 
 woo_post_before();
?>
<article >
<?php woo_post_inside_before();	
	
	if(isset($woo_options['woo_content_error_image']) && $woo_options['woo_content_error_image']){
		$error_img .= '<img src='.esc_url( $woo_options['woo_content_error_image']).'>';
	} else {
		$error_img .= '<img src='.get_template_directory_uri().'/images/404.png>';
	}
	$error_img = $title_before . apply_filters( 'woo_404_title', $error_img, 'woothemes'  ) . $title_after;
	echo '<header>'.$error_img.'</header>';

?>
	
	<section class="entry">
	     <?php

	    	$html ='';
	    	$site_url = esc_url(home_url('/'));
	    	if (isset($woo_options['woo_content_error_page']) && $woo_options['woo_content_error_page'] ) {	  	
	   		$html .= stripslashes($woo_options['woo_content_error_page']);
	   	} else {
	   		$html .= sprintf( __('The page you are trying to reach does not exist, or has been moved. Return To the <a href="%s" style="font-weight:bold;">Homepage</a>.', 'woothemes'), $site_url);
		}
		 $html = apply_filters('woo_404_content', $html, 'woothemes' );
		 echo $html;
	    	

	    	if ( isset($woo_options['woo_post_content']) && $woo_options['woo_post_content'] == 'content' || is_singular() ) wp_link_pages( $page_link_args );
	    ?>
	</section><!-- /.entry -->
<?php
	woo_post_inside_after();
?>
</article><!-- /.post -->
<?php
	woo_post_after();
?>