<?php
/**
 * Post Content Template
 *
 * This template is the default page content template. It is used to display the content of the
 * `single.php` template file, contextually, as well as in archive lists or search results.
 *
 * @package WooFramework
 * @subpackage Template
 */
 global $woo_options;

 	$title_before = '<h3 class="blog-title">';
 	$title_after = '</h3>';
 
	$title_before = $title_before . '<a href="' . get_permalink( get_the_ID() ) . '" rel="bookmark" title="' . the_title_attribute( array( 'echo' => 0 ) ) . '">';
	$title_after = '</a>' . $title_after;
 
  $page_link_args = apply_filters( 'woothemes_pagelinks_args', array( 'before' => '<div class="page-link">' . __( 'Pages:', 'woothemes' ), 'after' => '</div>' ) );
 
  woo_post_before();
 
  $woo_options['woo_blog_grid_thumb_width'] = 308;
  $woo_options['woo_blog_grid_thumb_height'] = 231;
?>

<div class="blog-item-grid">
  <div class="view view-sixth banner">

     <?php
      if ( !is_singular() ){
        echo '<div class="image-grid-post">';
        echo '<a href="' . get_permalink( get_the_ID() ) . '" rel="bookmark" title="">';
        the_post_thumbnail('thumbnail-lookbook-land');
        echo '</a>';
        echo '</div>';
      }else{
        echo '<div class="image-lookbook-post">';
        echo '<a href="' . get_permalink( get_the_ID() ) . '" rel="bookmark" title="">';
        the_post_thumbnail('thumbnail-lookbook');
        echo '</a>';
        echo '</div>';
      }
    ?>

    <div class="mask-blog">
      <div class="overlay-blog custom_back"></div>
    </div>

    <div class="borderbanner-blog custom_bor">
       <span> <a  href="<?php the_permalink(); ?>" title="<?php get_the_title(); ?>" class="blog-link">
         <?php _e('READ MORE','woothemes');?> </a>  
         </span>
    </div>

  </div> <!--  view view-sixth banner  -->
  
  <div class="blog-item-description">
      <div class="blog-post-meta ep_post_meta">
        <?php echo '<div class="blog-post-meta">
                    <span class="small"> '.do_shortcode( '[post_date after=" /"]' ) . do_shortcode( '[post_comments]' ) .'</span></div>'; 
        ?>
      </div>
    <a href="<?php the_permalink(); ?>" title="<?php get_the_title(); ?>">
        <?php the_title( $title_before, $title_after ); ?></a>
      <div class="blog-list-item-excerpt">
        <p> 
          <?php 
           if (!is_single()) {
          echo labomba_word_trim(get_the_excerpt(), '10', '...'); 
          }
          ?>
        </p> 
      </div>
          
  </div> 
</div><!-- /.blog-item-grid -->
