<?php

/*-----------------------------------------------------------------------------------*/
/* Start WooThemes Functions - Please refrain from editing this section */
/*-----------------------------------------------------------------------------------*/

// Set path to WooFramework and theme specific functions
$functions_path = get_template_directory() . '/functions/';
$includes_path = get_template_directory() . '/includes/';

// Don't load alt stylesheet from WooFramework
if ( ! function_exists( 'woo_output_alt_stylesheet' ) ) {
	function woo_output_alt_stylesheet () {}
}
// Don't load shortcode stylesheet from WooFramework
if ( ! function_exists( 'woo_shortcode_stylesheet' ) ) {
	function woo_shortcode_stylesheet () {}
}
// WooFramework
require_once ( $functions_path . 'admin-init.php' );	// Framework Init

/*-----------------------------------------------------------------------------------*/
/* Load the theme-specific files, with support for overriding via a child theme.
/*-----------------------------------------------------------------------------------*/

$includes = array(
	'includes/theme-options.php', 			// Options panel settings and custom settings
	'includes/theme-functions.php', 		// Custom theme functions
	'includes/theme-actions.php', 			// Theme actions & user defined hooks
	'includes/theme-comments.php', 			// Custom comments/pingback loop
	'includes/theme-js.php', 				// Load JavaScript via wp_enqueue_script
	'includes/sidebar-init.php', 			// Initialize widgetized areas
	'includes/theme-widgets.php',			// Theme widgets
	'includes/theme-advanced.php',			// Advanced Theme Functions
	'includes/theme-shortcodes.php',	 	// Custom theme shortcodes
);

// Allow child themes/plugins to add widgets to be loaded.
$includes = apply_filters( 'woo_includes', $includes );

foreach ( $includes as $i ) {
	locate_template( $i, true );
}

// Load WooCommerce functions, if applicable.
if ( is_woocommerce_activated() ) {
	locate_template( 'includes/theme-woocommerce.php', true );
}

/*-----------------------------------------------------------------------------------*/
/* You can add custom functions below */
/*-----------------------------------------------------------------------------------*/


/**
 * WooCommerce Extra Feature
 * --------------------------
 *
 * Change number of related products on product page
 * Set your own value for 'posts_per_page'
 *
 */ 
function woo_related_products_limit() {
  global $product;
	
	$args['posts_per_page'] = 20;
	return $args;
}
 add_filter( 'woocommerce_output_related_products_args', 'wc_related_products' );
	function wc_related_products() {
		$products_max 	= -1;
		$products_cols 	= 4;
		$args = apply_filters( 'labomba_related_products_args', array(
			'posts_per_page' => $products_max,
			'columns'        => $products_cols,
		) );
		return $args;
}





/*-----------------------------------------------------------------------------------*/
/* Don't add any code below here or the sky will fall down */
/*-----------------------------------------------------------------------------------*/
?>