<?php global $woo_options, $woocommerce; ?>
<?php woo_top(); ?>
<div id="wrapper">

	<div id="inner-wrapper">

	<?php woo_header_before(); ?>

<div class="header-1">

	<header id="header" class="col-full">

  <?php	$settings = woo_get_dynamic_values( array( 'logo' => '', 'retina_logo' => '', 'width_logo' => '', 'height_logo' => '' ) );
	// Setup the tag to be used for the header area (`h1` on the front page and `span` on all others).
	$heading_tag = 'span';
	if ( is_home() || is_front_page() ) { $heading_tag = 'h1'; }

	// Get our website's name, description and URL. We use them several times below so lets get them once.
	$site_title = get_bloginfo( 'name' );
	$site_url = home_url( '/' );
	$site_description = get_bloginfo( 'description' );
?>
	<div id="logo">
<?php
	// Website heading/logo and description text.
	if ( ( '' != $settings['logo'] ) ) {
		$logo_url = $settings['logo'];
		if ( is_ssl() ) $logo_url = str_replace( 'http://', 'https://', $logo_url );

		echo '<a href="' . esc_url( $site_url ) . '" title="' . esc_attr( $site_description ) . '"><img src="' . esc_url( $logo_url ) . '" alt="' . esc_attr( $site_title ) . '" class="logo-normal" /></a>' . "\n";
		// Opt Retina Logo
		if( ( '' != $settings['retina_logo'] ) ){
			$retina_logo_url = $settings['retina_logo'];
		echo '<a href="' . esc_url( $site_url ) . '" title="' . esc_attr( $site_description ) . '"><img src="' . esc_url( $retina_logo_url ) . '" width="'. $settings['width_logo'] .'" height="'. $settings['height_logo'] .'" alt="' . esc_attr( $site_title ) . '" class="logo-retina" /></a>' . "\n";
			 }
	} // End IF Statement

	echo '<' . $heading_tag . ' class="site-title"><a href="' . esc_url( $site_url ) . '">' . $site_title . '</a></' . $heading_tag . '>' . "\n";
	if ( $site_description ) { echo '<span class="site-description">' . $site_description . '</span>' . "\n"; }
?>
	</div>

		<?php woo_header_inside(); ?>

	</header>

	<?php woo_nav_before();?>

	<?php woo_nav_inside(); /*mobile and primary menu hook*/ ?>

	<?php woo_nav_after(); ?>

	<?php
	$custom_header_txt = isset( $woo_options['woo_custom_header_text'] ) ? $woo_options['woo_custom_header_text'] : '';

	if ( function_exists( 'icl_register_string' ) ) {
		icl_register_string( 'LaBomba Header Text', 'header text – ' . $custom_header_txt, $custom_header_txt );
	}

	$icl_t = function_exists( 'icl_t' );

	$custom_header_text = $icl_t ? icl_t( 'LaBomba Header Text', 'Header text – ' . $custom_header_txt, $custom_header_txt ) : $custom_header_txt;
  	?>

  	<?php if( $custom_header_text != '' ) : ?>
 		<div id="custom-header-text" class="col-full"><?php echo do_shortcode( $custom_header_text ); ?></div>
	<?php endif; ?>

</div><!-- //.header-1 -->

<?php woo_header_after(); ?>
