<?php
// Register widgetized areas
if ( ! function_exists( 'the_widgets_init' ) ) {
	function the_widgets_init() {
	    if ( ! function_exists( 'register_sidebars' ) )
	        return;
	
		// Widgetized sidebars
	    register_sidebar( array( 'name' => __( 'Primary', 'woothemes' ), 'id' => 'primary', 'description' => __( 'The default primary sidebar for your website, used in two or three-column layouts.', 'woothemes' ), 'before_widget' => '<div id="%1$s" class="widget %2$s">', 'after_widget' => '</div>', 'before_title' => '<h3>', 'after_title' => '</h3>' ) );
	    register_sidebar( array( 'name' => __( 'Secondary', 'woothemes' ), 'id' => 'secondary', 'description' => __( 'A secondary sidebar for your website, used in three-column layouts.', 'woothemes' ), 'before_widget' => '<div id="%1$s" class="widget %2$s">', 'after_widget' => '</div>', 'before_title' => '<h3>', 'after_title' => '</h3>' ) );
	
		// Footer widgetized areas
		$total = get_option( 'woo_footer_sidebars', 4 );
		if ( ! $total ) $total = 4;
		for ( $i = 1; $i <= intval( $total ); $i++ ) {
			register_sidebar( array( 'name' => sprintf( __( 'Footer %d', 'woothemes' ), $i ), 'id' => sprintf( 'footer-%d', $i ), 'description' => sprintf( __( 'Widgetized Footer Region %d.', 'woothemes' ), $i ), 'before_widget' => '<div id="%1$s" class="widget %2$s">', 'after_widget' => '</div>', 'before_title' => '<h3>', 'after_title' => '</h3>' ) );
		}

		// Extra Footer widgetized areas
		$total = get_option( 'woo_extra_footer_sidebars', 6 );
		if ( ! $total ) $total = 6;
		for ( $i = 1; $i <= intval( $total ); $i++ ) {
			register_sidebar( array( 'name' => sprintf( __( 'Extra Footer %d', 'woothemes' ), $i ), 'id' => sprintf( 'extra-footer-%d', $i ), 'description' => sprintf( __( 'Widgetized Extra Footer Region %d.', 'woothemes' ), $i ), 'before_widget' => '<div id="%1$s" class="widget %2$s">', 'after_widget' => '</div>', 'before_title' => '<h3>', 'after_title' => '</h3>' ) );
		}

		if(is_woocommerce_activated()) {
		 register_sidebar(array( 'name' => 'Shop','id' => 'shop', 'description' => __('A Shop Sidebar for your website', 'woothemes') , 'before_widget' => '<div id="%1$s" class="widget %2$s">','after_widget' => '</div>','before_title' => '<h3>','after_title' => '</h3>'));
		}

	   	register_sidebar( array( 'name' => __( 'Contact', 'woothemes' ), 'id' => 'contact', 'description' => __( 'A contact sidebar for your website, used in two or three-column layouts.', 'woothemes' ), 'before_widget' => '<div id="%1$s" class="widget %2$s">', 'after_widget' => '</div>', 'before_title' => '<h3>', 'after_title' => '</h3>' ) );	
					

		//if woocommerce active run this widget
	  //   if( class_exists('woocommerce') ) {
	  //    register_sidebar(array('name' => __( 'Attribute filtering', 'woothemes' ), 'id' => 'attribute', 'description' => __( ' for Woocommerce Layered Nav Widget.', 'woothemes' ), 'before_widget' => '', 'after_widget' => '','before_title' => '', 'after_title' => ''
   //  		    ) );
	 	// }
	 	
	} // End the_widgets_init()
}

add_action( 'init', 'the_widgets_init' );  
?>