<?php
	$woo_options = get_option( 'woo_options' );

/*------------------------------------------------------------------------------------

TABLE OF CONTENTS

- Theme Setup
- Woo Conditionals
- Add Google Maps to HEAD
- Load style.css in the <head>
- Add custom styling
- Add layout to body_class output
- WooSlider Setup
- WooSlider Magazine template
- Navigation
- Post More
- Video Embed
- Single Post Author
- Yoast Breadcrumbs
- Subscribe & Connect
- Optional Top Navigation (WP Menus)
- Footer Widgetized Areas
- Add customisable footer areas
- Add customisable post meta
- Add Post Thumbnail to Single posts on Archives
- Post Inside After
- Modify the default "comment" form field.
- Add theme default comment form fields.
- Add theme default comment form arguments.
- Activate shortcode compatibility in our new custom areas.
- woo_content_templates_magazine()
- woo_feedburner_link()
- Help WooTumblog to recognise if it's on the "Magazine" page template
- Enqueue Dynamic CSS
- Load responsive IE scripts
- Load site width CSS in the header
- Function to optionally remove responsive design and load in fallback CSS styling.
- Remove responsive design in IE8
- Adjust the homepage query, if using the "Magazine" page template as the homepage.
- Enable Tumblog
- Full width header
- Full width footer
- Full Width Markup Functions
- Full width body classes
- Optionally load custom logo.
- Optionally load the mobile navigation toggle.
- Optionally load top ad section into the header.

------------------------------------------------------------------------------------*/

// Check for and enqueue custom styles, if necessary.
add_action( 'wp_head', 'woo_enqueue_custom_styling', 9999 );

// Add layout to body_class output
add_filter( 'body_class','woo_layout_body_class', 10 );

// Navigation
//add_action( 'woo_header_after','woo_nav', 10 );

// Subscribe links in navigation
add_action( 'woo_top_bar_content','woo_nav_subscribe', 20 );

// Woo Conditionals
add_action( 'woo_head', 'woo_conditionals', 10 );

// Author Box
add_action( 'wp_head', 'woo_author', 10 );

// Single post navigation
add_action( 'woo_post_after', 'woo_postnav', 10 );

// Add Google Fonts output to HEAD
add_action( 'wp_head', 'woo_google_webfonts', 10 );

// Subscribe & Connect
add_action( 'wp_head', 'woo_subscribe_connect_action', 10 );

// Optional Top Navigation (WP Menus)
add_action( 'woo_top', 'woo_top_navigation', 10 );

// Remove responsive design
// if ( isset( $woo_options['woo_remove_responsive'] ) && $woo_options['woo_remove_responsive'] == 'true' ) {
// 	add_action( 'init', 'woo_remove_responsive_design', 10 );
// }

// Remove the banner warning about static home page
if ( is_admin() && current_user_can( 'manage_options' ) && ( 0 < intval( get_option( 'page_on_front' ) ) ) ) {
	remove_action( 'wooframework_container_inside', 'wooframework_add_static_front_page_banner' );
}

//remove_action( 'admin_notices', 'woothemes_updater_notice' );

/*-----------------------------------------------------------------------------------*/
/* Theme Setup */
/*-----------------------------------------------------------------------------------*/
/**
 * Theme Setup
 *
 * This is the general theme setup, where we add_theme_support(), create global variables
 * and setup default generic filters and actions to be used across our theme.
 *
 * @package WooFramework
 * @subpackage Logic
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 *
 * Used to set the width of images and content. Should be equal to the width the theme
 * is designed for, generally via the style.css stylesheet.
 */

if ( ! isset( $content_width ) ) $content_width = 640;

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support for post thumbnails.
 *
 * To override woothemes_setup() in a child theme, add your own woothemes_setup to your child theme's
 * functions.php file.
 *
 * @uses add_theme_support() To add support for post thumbnails and automatic feed links.
 * @uses add_editor_style() To style the visual editor.
 */

add_action( 'after_setup_theme', 'woothemes_setup' );

if ( ! function_exists( 'woothemes_setup' ) ) {
	function woothemes_setup () {
		// This theme styles the visual editor with editor-style.css to match the theme style.
		add_editor_style();

		// This theme uses post thumbnails
		add_theme_support( 'post-thumbnails' );

		// Add default posts and comments RSS feed links to head
		add_theme_support( 'automatic-feed-links' );

		// This theme supports WooCommerce, woo!
		add_theme_support( 'woocommerce' );

	} // End woothemes_setup()
}

/*-----------------------------------------------------------------------------------*/
/* Woo Conditionals */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woo_conditionals' ) ) {
	function woo_conditionals () {
		// Video Embed
		if( is_single() && ( 'portfolio' != get_post_type() ) ) {
			add_action( 'woo_post_inside_before', 'canvas_get_embed' );
		}

		// Post More
		if ( ! is_singular() && ! is_404() || is_page_template( 'template-blog.php' ) || is_page_template( 'template-magazine.php' ) ) {
			add_action( 'woo_post_inside_after', 'woo_post_more' );
		}

		// Tumblog Content
		// if ( 'true' == get_option( 'woo_woo_tumblog_switch' ) ) {
		// 	add_action( 'woo_tumblog_content_before', 'woo_tumblog_content' );
		// 	add_action( 'woo_tumblog_content_after', 'woo_tumblog_content' );
		// }
	} // End woo_conditionals()
}

/*-----------------------------------------------------------------------------------*/
/* Add Google Maps to HEAD */
/*-----------------------------------------------------------------------------------*/

add_action( 'woo_head', 'woo_google_maps', 10 ); // Add custom styling to HEAD

if ( ! function_exists( 'woo_google_maps' ) ) {
	function woo_google_maps() {
		if ( is_page_template( 'template-contact.php' ) || is_page_template( 'template-contactver2.php' ) ) {
			$maps_url = 'http://maps.google.com/maps/api/js?sensor=false';
			if ( is_ssl() ) $maps_url = str_replace( 'http://', 'https://', $maps_url );
		?>
			<script type="text/javascript" src="<?php echo esc_url( $maps_url ); ?>"></script>
		<?php
		}
	} // End woo_google_maps()
}

/*-----------------------------------------------------------------------------------*/
/* Load style.css in the <head> */
/*-----------------------------------------------------------------------------------*/

if ( ! is_admin() ) { add_action( 'wp_enqueue_scripts', 'woo_load_frontend_css', 20 ); }

if ( ! function_exists( 'woo_load_frontend_css' ) ) {
	function woo_load_frontend_css () {
		wp_register_style( 'theme-stylesheet', get_stylesheet_uri(), array(), '1.0.0', 'all' );
		wp_enqueue_style( 'theme-stylesheet' );
		// wp_register_style( 'responsive-media', THEME_URI . '/css/responsive.css');
		// wp_enqueue_style( 'responsive-media' );
		wp_register_style( 'woo-layout', THEME_URI . '/css/layout.css' );
		wp_enqueue_style( 'woo-layout' );
	} // End woo_load_frontend_css()
}

/*-----------------------------------------------------------------------------------*/
/* Load responsive <meta> tags in the <head> */
/*-----------------------------------------------------------------------------------*/

add_action( 'wp_head', 'woo_load_responsive_meta_tags', 10 );

if ( ! function_exists( 'woo_load_responsive_meta_tags' ) ) {
function woo_load_responsive_meta_tags () {
	$html = '';

	$html .= "\n" . '<!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame -->' . "\n";
	$html .= '<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />' . "\n";

	/* Remove this if not responsive design */
	$html .= "\n" . '<!--  Mobile viewport scale -->' . "\n";
	$html .= '<meta content="initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" name="viewport"/>' . "\n";

	echo $html;
} // End woo_load_responsive_meta_tags()
}

global $default_google_fonts;
$default_google_fonts = array( 'Open Sans', 'Playfair Display');

/*-----------------------------------------------------------------------------------*/
/* // Add custom styling */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woo_custom_styling' ) ) {
function woo_custom_styling() {
	global $woo_options;

	$output = '';
	$default_google_font = false;

	/* Logo */
	if ( isset( $woo_options['woo_logo'] ) && $woo_options['woo_logo'] ) { $output .= '#logo .site-title, #logo .site-description { display:none; }' . "\n"; }

    /* Logo Retina */
	if( isset( $woo_options['woo_retina_logo'] ) != '' ) {
	 	$output .= '
			@media only screen and (-webkit-min-device-pixel-ratio: 2),
			only screen and (min-device-pixel-ratio: 2),
			only screen and (min-resolution: 2dppx) {
				#logo .logo-normal{ display: none; }
				#logo .logo-retina{ display: inline; }
			}' . "\n";
    }

	// if ( isset( $woo_options['woo_ad_top'] ) && 'true' == $woo_options['woo_ad_top'] ) $output .= '#logo {float:left; }' . "\n";

	if ( class_exists( 'WooCommerce' ) && isset( $woo_options['woo_enable_share_single_product'] ) && 'true' == $woo_options['woo_enable_share_single_product'] ){
		$output .=
		'@media only screen and (min-width: 768px) {
		 .woocommerce header.single-title-wrap { overflow:hidden; }
		 .woocommerce h1.product_title {float: left;width: 77.5%;}
		 .woocommerce header.single-title-wrap .social {overflow:auto;width:22.45%;}
		 }' . "\n";
	}

    /* Header Layout */
	if( isset( $woo_options['woo_header_layout'] ) && $woo_options['woo_header_layout'] == 'v4' ) {
		$headerv4 	 = '';
		$headerv4_bg = $woo_options['woo_headerv4_background'];
		$headerv4_op = $woo_options['woo_headerv4_opacity'];
	    if( $headerv4_bg ) { $headerv4 .= 'background: '.$headerv4_bg.';'; }
		if( $headerv4_op ) { $headerv4 .= 'opacity: 0.'.$headerv4_op.';'; }
		$output .= '.header-4:before {'. $headerv4 . '}' . "\n";
	}

	// Check if we are wanting to generate the custom styling or not.
	if ( isset( $woo_options['woo_style_disable'] ) && $woo_options['woo_style_disable'] == 'true' ) {
		if ( $output != '' ) {
			echo $output;
		} else {
			/* Load default Google Fonts */
			global $default_google_fonts;
			if ( is_array( $default_google_fonts ) && count( $default_google_fonts ) > 0 ) :
				$count = 0;
				foreach ( $default_google_fonts as $font ) { $count++;
					$woo_options[ 'woo_default_google_font_'.$count ] = array( 'face' => $font );
				}
				$default_google_font = true;

			endif;
		}

		return;
	}

	// Layout styling
	$bg 			 = $woo_options['woo_style_bg'];
	$bg_image 	 	 = $woo_options['woo_style_bg_image'];
	$bg_image_repeat = $woo_options['woo_style_bg_image_repeat'];
	$bg_image_pos 	 = $woo_options['woo_style_bg_image_pos'];
	$bg_image_attach = $woo_options['woo_style_bg_image_attach'];
	$border_top 	 = $woo_options['woo_border_top'];
	$border_general  = $woo_options['woo_style_border'];

	/* Custom Body Background */
	$body = '';
	if ( $bg ) { $body .= 'background-color:' . $bg . ';'; }
	if ( $bg_image ) { $body .= 'background-image:url(' . $bg_image . ');';	}
	if ( $bg_image_repeat && $bg_image != '' ) { $body .= 'background-repeat:' . $bg_image_repeat . ';'; }
	if ( $bg_image_pos && $bg_image != '' ) { $body .= 'background-position:' . $bg_image_pos . ';'; }
	if ( $bg_image_attach && $bg_image != '' ) { $body .= 'background-attachment:' . $bg_image_attach . ';'; }
	if ( $border_top && $border_top['width'] >= 0 ) { $body .= 'border-top:' . $border_top["width"]. 'px ' . $border_top["style"] . ' ' . $border_top["color"] . ';'; }
	if ( $body != '' ) { $output .= 'body {' . $body . '}'. "\n"; }

	if ( $border_general ) {
		$output .= 'hr, .entry img, img.thumbnail, .entry .wp-caption, #footer-widgets, #comments, #comments-title, .comment-container, #comments .comment.thread-even, #comments ul.children li, .entry h1, .post, .border_title, #author-profile {
			border-color:' . $border_general . '!important;
		}'. "\n";
		if ( class_exists( 'WooCommerce' ) ) :
			$output .= '#product-archive, .woocommerce-summary-wrap, .woocommerceTabs, .woocommerceTabs .resp-tab-content, .woocommerce .single-title-wrap, .woocommerce .related header, .woocommerce .upsells header, .woocommerce .cross-sells header, .woocommerce .recently-viewed header,
			.woocommerce th, .woocommerce td, .cart_totals table {
				border-color:' . $border_general . '!important;
			}';
		endif;
	}

	// page loader styling
    $loading_animation_bg_color = isset( $woo_options['woo_page_loader_color'] ) ? $woo_options['woo_page_loader_color'] : '#FFFFFF';

   	if ( $loading_animation_bg_color ) {
		$output .= '.ajax_loader { background:' . $loading_animation_bg_color . '; }' . "\n";
	}

	// General styling
	$link 		  = $woo_options['woo_link_color'];
	$hover 		  = $woo_options['woo_link_hover_color'];
	$button 	  = $woo_options['woo_button_color'];
	$button_hover = $woo_options['woo_button_hover_color'];
	$mask 		  = $woo_options['woo_style_mask_bg'];
	$opa_mask 	  = $woo_options['woo_opa_mask'];
	$bor_mask 	  = $woo_options['woo_mask_border'];
	$font_mask 	  = $woo_options['woo_mask_font'];

	/* Link */
	if ( $link ) {
		$output .= 'a:link, a:visited { color:' . $link . '}' . "\n";
		$output .= '#tabs #tab-tags a, .tagcloud a { background:' . $link . ';border-color:' . $link . ';color: #ffffff; }' . "\n";
	}
	if ( $hover ) {
		$output .= 'a:hover, .post-more a:hover, .post-meta a:hover, .post p.tags a:hover, .widget #tabs li a:hover { color:' . $hover . '; }' . "\n";
		$output .= '#tabs #tab-tags a:hover, .tagcloud a:hover { background:' . $hover . ';border-color:' . $hover . '; }' . "\n";
		$output .= '.tag_single_bottom a:hover { background:' . $hover . ';border-color:' . $hover . '; }' . "\n";
	}
	if ( $button ) {
		$output .= 'body #wrapper #content .button, body #wrapper #content .button:visited, body #wrapper #content .reply a, body #wrapper #content #respond .form-submit input#submit, input[type=submit] {border: none; background:'.$button.'}' . "\n";
	}
	if ( $button_hover ) {
		$output .= 'body #wrapper #content .button:hover, body #wrapper #content .reply a:hover, body #wrapper #content #respond .form-submit input#submit:hover, input[type=submit]:hover {border: none; background:'.$button_hover.'}' . "\n";
	}

		if ($mask)
			$output .= '.overlay-blog {background-color:'.$mask.'!important}' . "\n";

		if ($opa_mask)
			$output .= '.overlay-blog {opacity:'.$opa_mask.'!important}' . "\n";

		if ($bor_mask && $bor_mask['width'] >= 0)
			$output .= ' .banner .borderbanner-blog span {border:'.$bor_mask["width"].'px '.$bor_mask["style"].' '.$bor_mask["color"].'!important;}';

			if ( $font_mask )
			$output .= '.borderbanner-blog span a {font:'.$font_mask["style"].' '.$font_mask["size"].$font_mask["unit"].'/1.2em '.stripslashes($font_mask["face"]).'!important;color:'.$font_mask["color"].'!important;}';
		// Header styling
		//$header_bg = $woo_options['woo_header_bg'];
		// $header_bg_image = $woo_options['woo_header_bg_image'];
		// $header_bg_image_repeat = $woo_options['woo_header_bg_image_repeat'];
		// $header_border = $woo_options['woo_header_border'];
		// $header_margin_top = $woo_options['woo_header_margin_top'];
		// $header_margin_bottom = $woo_options['woo_header_margin_bottom'];
		// $header_padding_top = $woo_options['woo_header_padding_top'];
		// $header_padding_bottom = $woo_options['woo_header_padding_bottom'];
		// $header_padding_left = $woo_options['woo_header_padding_left'];
		// $header_padding_right = $woo_options['woo_header_padding_right'];
		$font_logo = $woo_options['woo_font_logo'];
		$font_desc = $woo_options['woo_font_desc'];

		//$header_css = '';
		// if ( $header_bg )
		// 	$header_css .= 'background-color:'.$header_bg.';';
		// if ( $header_bg_image )
		// 	$header_css .= 'background-image:url('.$header_bg_image.');';
		// if ( $header_bg_image_repeat )
		// 	$header_css .= 'background-repeat:'.$header_bg_image_repeat.';background-position:left top;';
		// if ( $header_margin_top <> '' || $header_margin_bottom <> '' )
		// 	$header_css .= 'margin-top:'.$header_margin_top.'px;margin-bottom:'.$header_margin_bottom.'px;';
		// if ( $header_padding_top <> '' || $header_padding_bottom <> '' )
		// 	$header_css .= 'padding-top:'.$header_padding_top.'px;padding-bottom:'.$header_padding_bottom.'px;';
		// if ( $header_border && $header_border['width'] >= 0)
		// 	$header_css .= 'border:'.$header_border["width"].'px '.$header_border["style"].' '.$header_border["color"].';';
		/*if ( $header_border && $header_border['width'] > 0) {
			$width = get_option('woo_layout_width') - $header_border['width']*2;
			if ( $width > 0 )
				$header_css .= 'width:'.$width.'px;';
		}*/
		// if ( $header_css != '' )
		// 	$output .= '#header {'. $header_css . '}'. "\n";

		// if ( $header_padding_left <> '' )
		// 	$output .= '#logo {padding-left:'.$header_padding_left.'px;}';
		// if ( $header_padding_right <> '' )
		// 	$output .= '#topad {padding-right:'.$header_padding_right.'px;}'. "\n";
		if ( $font_logo )
			$output .= '#logo .site-title a {' . woo_generate_font_css( $font_logo ) . '}' . "\n";
		if ( $font_desc )
			$output .= '#logo .site-description {' . woo_generate_font_css( $font_desc ) . '}' . "\n";

		// Boxed styling
		$boxed = $woo_options['woo_layout_boxed'];
		$box_bg = $woo_options['woo_style_box_bg'];
		$box_margin_top = $woo_options['woo_box_margin_top'];
		$box_margin_bottom = $woo_options['woo_box_margin_bottom'];
		$box_border_tb = $woo_options['woo_box_border_tb'];
		$box_border_lr = $woo_options['woo_box_border_lr'];
		$box_border_radius = $woo_options['woo_box_border_radius'];
		$box_shadow = $woo_options['woo_box_shadow'];

		$wrapper = '';
		//if ($boxed == "true") {
		// 	//$wrapper .= 'margin:0 auto;padding:0 0 20px 0;width:'.get_option('woo_layout_width').';';
		// 	if ( get_option('woo_layout_width') == '980px' )
		// 		$wrapper .= 'padding-left:20px; padding-right:20px;';
		// 	else
		//		$wrapper .= 'padding-left:30px; padding-right:30px;';
	   // }
		if ($boxed == "true" && $box_bg)
			$wrapper .= 'background-color:'.$box_bg.';';
		if ($boxed == "true" && ($box_margin_top || $box_margin_bottom) )
			$wrapper .= 'margin-top:'.$box_margin_top.'px;margin-bottom:'.$box_margin_bottom.'px;';
		if ($boxed == "true" && $box_border_tb["width"] > 0 )
			$wrapper .= 'border-top:'.$box_border_tb["width"].'px '.$box_border_tb["style"].' '.$box_border_tb["color"].';border-bottom:'.$box_border_tb["width"].'px '.$box_border_tb["style"].' '.$box_border_tb["color"].';';
		if ($boxed == "true" && $box_border_lr["width"] > 0 )
			$wrapper .= 'border-left:'.$box_border_lr["width"].'px '.$box_border_lr["style"].' '.$box_border_lr["color"].';border-right:'.$box_border_lr["width"].'px '.$box_border_lr["style"].' '.$box_border_lr["color"].';';
		if ( $boxed == "true" && $box_border_radius )
			$wrapper .= 'border-radius:'.$box_border_radius.';';
		if ( $boxed == "true" && $box_shadow == "true" )
			$wrapper .= 'box-shadow: 0px 1px 5px rgba(0,0,0,.1);';

		if ( $wrapper != '' )
			$output .= '#wrapper {'. $wrapper . '} .col-full { width: auto; } @media only screen and (max-width:767px) { #inner-wrapper { margin:0; border-radius:none; padding-left:1em; padding-right: 1em; border: none; } } '. "\n";
		    $output .= '.woocommerce #social-dropdown{background-color:'.$box_bg.';}';


		// Full width layout
		if ( $boxed != "true" && (isset( $woo_options['woo_header_full_width'] ) && ( $woo_options['woo_header_full_width']  == 'true'  )  ||  isset( $woo_options['woo_footer_full_width'] ) && ( $woo_options['woo_footer_full_width'] == 'true' ) ) ) {

			if ( isset( $woo_options['woo_header_full_width'] ) && $woo_options['woo_header_full_width'] == 'true' ) {

				$full_head_bg = $woo_options['woo_full_header_full_width_bg'];
				$full_header_bg_image = $woo_options['woo_full_header_bg_image'];
				$full_header_bg_image_repeat = $woo_options['woo_full_header_bg_image_repeat'];
				$full_nav_bg = $woo_options['woo_nav_bg'];
				//$full_nav_border = $woo_options['woo_nav_divider_border'];
				//$full_nav_border_top = $woo_options['woo_nav_border_top'];
				$full_nav_border_bot = $woo_options['woo_nav_border_bot'];

				if ( $full_head_bg )
					$output .= '#header-container{background-color:' . $full_head_bg . ';}';

				if ( $full_header_bg_image )
					$output .= '#header-container{background-image:url('.$full_header_bg_image.');background-repeat:'.$full_header_bg_image_repeat.';background-position:top center;}';

				if ( $full_nav_bg )
					$output .= '#nav-container{background:' . $full_nav_bg . ';}';

				if ( $full_nav_border_bot && $full_nav_border_bot["width"] >= 0 )
					$output .= 'border-bottom:'.$full_nav_border_bot["width"].'px '.$full_nav_border_bot["style"].' '.$full_nav_border_bot["color"].';border-left:none;border-right:none;}';

				// if ( $full_nav_border && $full_nav_border["width"] >= 0 )
				// 	$output .= '#nav-container #navigation ul#main-nav > li:first-child{border-left: '.$full_nav_border["width"].'px '.$full_nav_border["style"].' '.$full_nav_border["color"].';}';

			}

			if ( isset( $woo_options['woo_footer_full_width'] ) && ( 'true' == $woo_options['woo_footer_full_width'] ) ) {

				$full_foot_widget_bg = $woo_options['woo_foot_full_width_widget_bg'];
				$full_foot_bg = $woo_options['woo_footer_full_width_bg'];
				$footer_bg = $woo_options['woo_footer_bg'];
				//$full_footer_border_top = $woo_options['woo_footer_border_top'];

				if ( $full_foot_widget_bg )
					$output .= '#footer-widgets-container{background-color:' . $full_foot_widget_bg . '}';
				//#footer-widgets{border:none;}

				if ( $full_foot_bg )
					$output .= '#footer-container{background-color:' . $full_foot_bg . '}';

				//if ( $full_footer_border_top && $full_footer_border_top["width"] >= 0 )
					// $output .= '#footer-container-bottom{border-top:'.$full_footer_border_top["width"].'px '.$full_footer_border_top["style"].' '.$full_footer_border_top["color"].';}';

			}
			$output .= "\n";

		}

		$font_contact = $woo_options['woo_font_h3_contact'];
		if ( $font_contact ){
			$output .= '.page-template-template-contact-php .contact-content h4, .page-template-template-contact-php .contact-maps h4.contact-title,.page-template-template-contactver2-php .contact-maps h4.contact-title, .page-template-template-contact-php .contact-maps h4.contact-title ,.page-template-template-contactver2-php .contact-content h4.contact-title { ' . woo_generate_font_css( $font_contact, 1.2 ) . ' }';

		}

		// misc Typography
		$font_text = $woo_options['woo_font_text'];
		$font_h1 = $woo_options['woo_font_h1'];
		$font_h2 = $woo_options['woo_font_h2'];
		$font_h3 = $woo_options['woo_font_h3'];
		$font_h4 = $woo_options['woo_font_h4'];
		$font_h5 = $woo_options['woo_font_h5'];
		$font_h6 = $woo_options['woo_font_h6'];

		if ( $font_text )
			$output .= 'body, p { ' . woo_generate_font_css( $font_text, 1.5 ) . ' }' . "\n";
		if ( $font_h1 )
			$output .= 'h1 { ' . woo_generate_font_css( $font_h1, 1.2 ) . ' }';
		if ( $font_h2 )
			$output .= 'h2 { ' . woo_generate_font_css( $font_h2, 1.2 ) . ' }';
		if ( $font_h3 )
			$output .= 'h3 { ' . woo_generate_font_css( $font_h3, 1.2 ) . ' }';
		if ( $font_h4 )
			$output .= 'h4 { ' . woo_generate_font_css( $font_h4, 1.2 ) . ' }';
		if ( $font_h5 )
			$output .= 'h5 { ' . woo_generate_font_css( $font_h5, 1.2 ) . ' }';
		if ( $font_h6 )
			$output .= 'h6 { ' . woo_generate_font_css( $font_h6, 1.2 ) . ' }' . "\n";
		// edit adit 12-11-2013
		// sc Typography

		// $font_text_sc = $woo_options['woo_font_text_sc'];
		$font_h1_sc = $woo_options['woo_font_h1_sc'];
		$font_h2_sc = $woo_options['woo_font_h2_sc'];
		$font_h3_sc = $woo_options['woo_font_h3_sc'];
		$font_h4_sc = $woo_options['woo_font_h4_sc'];
		$font_h5_sc = $woo_options['woo_font_h5_sc'];
		$font_h6_sc = $woo_options['woo_font_h6_sc'];

		// if ( $font_text_sc )
		// 	$output .= 'body, p, span { ' . woo_generate_font_css( $font_text_sc, 1.5 ) . ' }' . "\n";
		if ( $font_h1_sc )
			$output .= 'h1.title-sc {font:'.$font_h1_sc["style"].' '.$font_h1_sc["size"].$font_h1_sc["unit"].'/1.2em '.stripslashes($font_h1_sc["face"]).'!important;color:'.$font_h1_sc["color"].'!important;}';
		if ( $font_h2_sc )
			$output .= 'h2.title-sc {font:'.$font_h2_sc["style"].' '.$font_h2_sc["size"].$font_h2_sc["unit"].'/1.2em '.stripslashes($font_h2_sc["face"]).'!important;color:'.$font_h2_sc["color"].'!important;}';
		if ( $font_h3_sc )
			$output .= 'h3.title-sc {font:'.$font_h3_sc["style"].' '.$font_h3_sc["size"].$font_h3_sc["unit"].'/1.2em '.stripslashes($font_h3_sc["face"]).'!important;color:'.$font_h3_sc["color"].'!important;}';
		if ( $font_h4_sc )
			$output .= 'h4.title-sc {font:'.$font_h4_sc["style"].' '.$font_h4_sc["size"].$font_h4_sc["unit"].'/1.2em '.stripslashes($font_h4_sc["face"]).'!important;color:'.$font_h4_sc["color"].'!important;}';
		if ( $font_h5_sc )
			$output .= 'h5.title-sc {font:'.$font_h5_sc["style"].' '.$font_h5_sc["size"].$font_h5_sc["unit"].'/1.2em '.stripslashes($font_h5_sc["face"]).'!important;color:'.$font_h5_sc["color"].'!important;}';
		if ( $font_h6_sc )
			$output .= 'h6.title-sc {font:'.$font_h6_sc["style"].' '.$font_h6_sc["size"].$font_h6_sc["unit"].'/1.2em '.stripslashes($font_h6_sc["face"]).'!important;color:'.$font_h6_sc["color"].'!important;}' . "\n";

		// Post Styling
		$font_post_title = $woo_options['woo_font_post_title'];
		$font_post_meta = $woo_options['woo_font_post_meta'];
		$font_post_text = $woo_options['woo_font_post_text'];
		$post_author_border_top = $woo_options['woo_post_author_border_top'];
		$post_author_border_bottom = $woo_options['woo_post_author_border_bottom'];
		$post_author_border_lr = $woo_options['woo_post_author_border_lr'];
		$post_author_border_radius = $woo_options['woo_post_author_border_radius'];
		$post_author_bg = $woo_options['woo_post_author_bg'];
		$font_portfolio = $woo_options['woo_font_h3_portfolio'];
		$font_blog = $woo_options['woo_font_h3_blog'];


		if ( $font_portfolio )
			$output .= 'h3.port_title { ' . woo_generate_font_css( $font_portfolio, 1.2 ) . ' }';
		if ( $font_blog )
			$output .= 'h3.blog-title, #comments h3 { ' . woo_generate_font_css( $font_blog, 1.2 ) . ' }';


		if ( $font_post_title ){
			$font_mask = $font_post_title;
			//$output .= '.page-title, .post .title, .page .title, h1.product_title {'.woo_generate_font_css( $font_post_title, 1.2 ).'}' . "\n";
			$output .= '.page-title, .post .title, .page .title, .product_title { font:'.$font_mask["style"].' '.$font_mask["size"].$font_mask["unit"].'/1.2em "'.stripslashes($font_mask["face"]).'" !important;color:'.$font_mask["color"].'!important; }'  . "\n";

			$output .= '.post .title a:link, .post .title a:visited, .page .title a:link, .page .title a:visited {color:'.$font_post_title["color"].'}' . "\n";
			}
		if ( $font_post_meta )
			$output .= '.post-meta, .blog-post-meta, .entry .info_single_post p { ' . woo_generate_font_css( $font_post_meta, 1.5 ) . ' }' . "\n";

		if ( $font_post_text )
			$output .= '.entry, .entry p { ' . woo_generate_font_css( $font_post_text, 1.5 ) . ' }' . "\n";

		$post_author = '';
		if ( $post_author_border_top )
			$post_author .= 'border-top:'.$post_author_border_top["width"].'px '.$post_author_border_top["style"].' '.$post_author_border_top["color"].';';
		if ( $post_author_border_bottom )
			$post_author .= 'border-bottom:'.$post_author_border_bottom["width"].'px '.$post_author_border_bottom["style"].' '.$post_author_border_bottom["color"].';';
		if ( $post_author_border_lr )
			$post_author .= 'border-left:'.$post_author_border_lr["width"].'px '.$post_author_border_lr["style"].' '.$post_author_border_lr["color"].';border-right:'.$post_author_border_lr["width"].'px '.$post_author_border_lr["style"].' '.$post_author_border_lr["color"].';';
		if ( $post_author_border_radius )
			$post_author .= 'border-radius:'.$post_author_border_radius.';-moz-border-radius:'.$post_author_border_radius.';-webkit-border-radius:'.$post_author_border_radius.';';
		if ( $post_author_bg )
			$post_author .= 'background-color:'.$post_author_bg;

		if ( $post_author )
			$output .= '#post-author, #connect {'.$post_author .'}' . "\n";

		// Page Nav Styling
		$pagenav_font = $woo_options['woo_pagenav_font'];
		$pagenav_bg = $woo_options['woo_pagenav_bg'];
		$pagenav_bg_hov = $woo_options['woo_pagenav_bg_hov'];
		$pagenav_border_top = $woo_options['woo_pagenav_border_top'];
		$pagenav_border_bottom = $woo_options['woo_pagenav_border_bottom'];

		$pagenav_css = '';
		if ( $pagenav_bg )
			$output .= '.nav-entries span, .woo-pagination span:not(.dots), nav-entries-custom span{background:'.$pagenav_bg.'!important;}';
			if ( $pagenav_bg_hov )
			$output .= '.nav-entries a:hover, .woo-pagination a:hover, nav-entries-custom a:hover{background:'.$pagenav_bg_hov.'!important;}';
		if ( $pagenav_border_top && $pagenav_border_top["width"] > 0 )
			$pagenav_css .= 'border-top:'.$pagenav_border_top["width"].'px '.$pagenav_border_top["style"].' '.$pagenav_border_top["color"].';';
		if ( $pagenav_border_bottom && $pagenav_border_bottom["width"] > 0 )
			$pagenav_css .= 'border-bottom:'.$pagenav_border_bottom["width"].'px '.$pagenav_border_bottom["style"].' '.$pagenav_border_bottom["color"].';';

		if ( $pagenav_css != '' )
			$output .= '.nav-entries, .woo-pagination, nav-entries-custom {'. $pagenav_css . ' padding: 12px 0px; }'. "\n";
		// if ( $pagenav_font ) {
		// 	$output .= '.nav-entries a, .woo-pagination a, nav-entries-custom a { ' . woo_generate_font_css( $pagenav_font ) . ' }' . "\n";
		// 	$output .= '.woo-pagination a, .woo-pagination a:hover, nav-entries-custom a:hover {color:'.$pagenav_font["color"].'!important}' . "\n";
		// }

			if ( $pagenav_font){
			$output .= '.nav-entries a, .woo-pagination a, .woo-pagination span.current, .nav-entries-custom a span, .single .nav-prev a, .single .nav-next a{font:'.$pagenav_font["style"].' '.$pagenav_font["size"].$pagenav_font["unit"].'/1.2em '.stripslashes($pagenav_font["face"]).'!important;color:'.$pagenav_font["color"].'!important;}';

			}
		// Widget Styling
		$widget_font_title = $woo_options['woo_widget_font_title'];
		$widget_font_text = $woo_options['woo_widget_font_text'];
		$widget_padding_tb = $woo_options['woo_widget_padding_tb'];
		$widget_padding_lr = $woo_options['woo_widget_padding_lr'];
		$widget_bg = $woo_options['woo_widget_bg'];
		$widget_border = $woo_options['woo_widget_border'];
		$widget_title_border = $woo_options['woo_widget_title_border'];
		$widget_border_radius = $woo_options['woo_widget_border_radius'];

		$h3_css = '';
		if ( $widget_font_title )
			$h3_css .= 'font:'.$widget_font_title["style"].' '.$widget_font_title["size"].$widget_font_title["unit"].'/1.2em '.stripslashes($widget_font_title["face"]).';color:'.$widget_font_title["color"].';';
		if ( $widget_title_border )
			$h3_css .= 'border-bottom:'.$widget_title_border["width"].'px '.$widget_title_border["style"].' '.$widget_title_border["color"].';';
		if ( isset( $widget_title_border["width"] ) AND $widget_title_border["width"] == 0 )
			$h3_css .= 'margin-bottom:0;';

		if ( $h3_css != '' )
			$output .= '.widget h3 {'. $h3_css . '}'. "\n";

		if ( $widget_title_border )
			$output .= '#twitter li { border-color: '.$widget_title_border["color"].';}'. "\n";

		if ( $widget_font_text )
			$output .= '.widget p, .widget .textwidget { ' . woo_generate_font_css( $widget_font_text, 1.5 ) . ' }' . "\n";

		$widget_css = '';
		if ( $widget_font_text )
			$widget_css .= 'font:'.$widget_font_text["style"].' '.$widget_font_text["size"].$widget_font_text["unit"].'/1.5em '.stripslashes($widget_font_text["face"]).';color:'.$widget_font_text["color"].';';
		if ( $widget_padding_tb || $widget_padding_lr )
			$widget_css .= 'padding:'.$widget_padding_tb.'px '.$widget_padding_lr.'px;';
		if ( $widget_bg )
			$widget_css .= 'background-color:'.$widget_bg.';';
		if ( $widget_border["width"] > 0 )
			$widget_css .= 'border:'.$widget_border["width"].'px '.$widget_border["style"].' '.$widget_border["color"].';';
		if ( $widget_border_radius )
			$widget_css .= 'border-radius:'.$widget_border_radius.';-moz-border-radius:'.$widget_border_radius.';-webkit-border-radius:'.$widget_border_radius.';';

		if ( $widget_css != '' ) {
			$output .= '.widget {'. $widget_css . '}'. "\n";
		}

		if ( $widget_border["width"] > 0 ) {
			$output .= '#tabs .inside ul { border:'.$widget_border["width"].'px '.$widget_border["style"].' '.$widget_border["color"].'; border-width: 1px 0 1px 0; }'. "\n";
			$output .= '.widget_recent_comments li, #twitter li, .wpb_widgetised_column li, .widget_nav_menu li, .widget_categories li, .widget_archive li, .widget_meta li, .widget_pages li, .widget_product_categories li { border-color:' . $widget_border["color"] . '; }'. "\n";
		}

		// Tabs Widget
		$widget_tabs_bg = $woo_options['woo_widget_tabs_bg'];
		$widget_tabs_bg_inside = $woo_options['woo_widget_tabs_bg_inside'];
		$widget_tabs_font = $woo_options['woo_widget_tabs_font'];
		$widget_tabs_font_meta = $woo_options['woo_widget_tabs_font_meta'];

		if ( $widget_tabs_bg )
			$output .= '#tabs, .widget_woodojo_tabs .tabbable {background-color:'.$widget_tabs_bg.';}'. "\n";
		if ( $widget_tabs_bg_inside )
			$output .= '#tabs .inside, #tabs ul.wooTabs li a.selected, #tabs ul.wooTabs li a:hover {background-color:'.$widget_tabs_bg_inside.';}'. "\n";
		if ( $widget_tabs_font )
			$output .= '#tabs .inside li a, .widget_woodojo_tabs .tabbable .tab-pane li a { ' . woo_generate_font_css( $widget_tabs_font, 1.5 ) . ' }'. "\n";
		if ( $widget_tabs_font_meta )
			$output .= '#tabs .inside li span.meta, .widget_woodojo_tabs .tabbable .tab-pane li span.meta { ' . woo_generate_font_css( $widget_tabs_font_meta, 1.5 ) . ' }'. "\n";
			$output .= '#tabs ul.wooTabs li a, .widget_woodojo_tabs .tabbable .nav-tabs li a { ' . woo_generate_font_css( $widget_tabs_font_meta, 2 ) . ' }'. "\n";

		//Navigation
		$nav_bg = isset( $woo_options['woo_nav_bg'] ) ? $woo_options['woo_nav_bg'] : '';
		$nav_font = isset( $woo_options['woo_nav_font'] ) ? $woo_options['woo_nav_font'] : '';
		$nav_hover = isset( $woo_options['woo_nav_hover'] ) ? $woo_options['woo_nav_hover'] : '';
		$nav_hover_bg = isset( $woo_options['woo_nav_hover_bg'] ) ? $woo_options['woo_nav_hover_bg'] : '';
		$nav_currentitem = isset( $woo_options['woo_nav_currentitem'] ) ? $woo_options['woo_nav_currentitem'] : '';
		$nav_currentitem_bg = isset( $woo_options['woo_nav_currentitem_bg'] ) ? $woo_options['woo_nav_currentitem_bg'] : '';
		//$nav_divider_border = isset( $woo_options['woo_nav_divider_border'] ) ? $woo_options['woo_nav_divider_border'] : '';
		$nav_dropdown_border = isset( $woo_options['woo_nav_dropdown_border'] ) ? $woo_options['woo_nav_dropdown_border'] : '';
		//$nav_border_lr = isset( $woo_options['woo_nav_border_lr'] ) ? $woo_options['woo_nav_border_lr'] : '';
		//$nav_border_radius = isset( $woo_options['woo_nav_border_radius'] ) ? $woo_options['woo_nav_border_radius'] : '';
		//$nav_border_top = isset( $woo_options['woo_nav_border_top'] ) ? $woo_options['woo_nav_border_top'] : '';
		$nav_border_bot = isset( $woo_options['woo_nav_border_bot'] ) ? $woo_options['woo_nav_border_bot'] : '';

		$top_nav_bg = isset( $woo_options['woo_top_nav_bg'] ) ? $woo_options['woo_top_nav_bg'] : '';
		$top_nav_bg_hover = isset( $woo_options['woo_top_nav_bg_hover'] ) ? $woo_options['woo_top_nav_bg_hover'] : '';
		$top_nav_hover = isset( $woo_options['woo_top_nav_hover'] ) ? $woo_options['woo_top_nav_hover'] : '';
		$top_nav_hover_bg = isset( $woo_options['woo_top_nav_hover_bg'] ) ? $woo_options['woo_top_nav_hover_bg'] : '';
		$top_nav_font = isset( $woo_options['woo_top_nav_font'] ) ? $woo_options['woo_top_nav_font'] : '';
		$top_callus_font = isset( $woo_options['woo_top_callus_font'] ) ? $woo_options['woo_top_callus_font'] : '';

		global $is_IE;
		if ( !$is_IE )
			$output .= '@media only screen and (min-width:768px) {' . "\n";
		if ( $nav_font )
			$output .= 'ul.nav li a, #top ul.nav li a { ' . woo_generate_font_css( $nav_font ) . ' } #top ul.rss li a:before { color:' . $nav_font['color'] . ';}' . "\n";
		if ( $nav_hover )
			$output .= '#navigation ul.nav > li a:hover, #navigation ul.nav > li:hover a, #navigation ul.nav li ul li a { color:'.$nav_hover.'!important; }' . "\n";
		if ( $nav_hover_bg )
			$output .= '#navigation ul.nav > li a:hover, #navigation ul.nav > li:hover, #navigation ul.nav li ul {background-color:'.$nav_hover_bg.'!important}' . "\n";

		if ( $nav_dropdown_border && $nav_dropdown_border["width"] >= 0 ) {
			$output .= '#navigation ul.nav li ul  { border: '.$nav_dropdown_border["width"].'px '.$nav_dropdown_border["style"].' '.$nav_dropdown_border["color"].'; }' . "\n";
			if ($nav_dropdown_border["width"] == 0) {
				$output .= '#navigation ul.nav > li > ul  { left: 0; }' . "\n";
			}
		}

		// if ( $nav_divider_border && $nav_divider_border["width"] >= 0 ) {
		// 	$output .= '#navigation ul.nav > li  { border-right: '.$nav_divider_border["width"].'px '.$nav_divider_border["style"].' '.$nav_divider_border["color"].'; }';
		// 	if ($nav_divider_border["width"] == 0) {
		// 		$output .= '#navigation ul.nav > li > ul  { left: 0; }' . "\n";
		// 	}
		// }

		// If we have a hover colour and don't have a current item colour, we use the hover colour as current item colour.
		if ( $nav_currentitem_bg == '' && $nav_hover != '' ) { $nav_currentitem_bg = $nav_hover; }

		if ( $nav_currentitem_bg ) {
			$output .= '#navigation ul.nav li.current_page_item > a, #navigation ul.nav li.current_page_parent > a, #navigation ul.nav li.current-menu-ancestor > a, #navigation ul.nav li.current-cat > a, #navigation ul.nav li.current-menu-item > a { background-color:' . $nav_currentitem_bg . '; }' . "\n";
		}

		if ( $nav_currentitem ) {
			$output .= '#navigation ul.nav li.current_page_item > a, #navigation ul.nav li.current_page_parent > a, #navigation ul.nav li.current-menu-ancestor > a, #navigation ul.nav li.current-cat > a, #navigation ul.nav li.current-menu-item > a { color:' . $nav_currentitem . '; }' . "\n";
		}

		$navigation_css = '';
		if ( $nav_bg )
			$navigation_css .= 'background:'.$nav_bg.';';
		// if ( $nav_border_top && $nav_border_top["width"] >= 0 )
		if ( $nav_border_bot && $nav_border_bot["width"] >= 0 )
         	$navigation_css .= 'border-bottom:'.$nav_border_bot["width"].'px '.$nav_border_bot["style"].' '.$nav_border_bot["color"].';';
		// 	$navigation_css .= 'border-top:'.$nav_border_top["width"].'px '.$nav_border_top["style"].' '.$nav_border_top["color"].';border-bottom:'.$nav_border_bot["width"].'px '.$nav_border_bot["style"].' '.$nav_border_bot["color"].';border-left:'.$nav_border_lr["width"].'px '.$nav_border_lr["style"].' '.$nav_border_lr["color"].';border-right:'.$nav_border_lr["width"].'px '.$nav_border_lr["style"].' '.$nav_border_lr["color"].';';
		if ( $nav_border_bot && $nav_border_bot["width"] == 0 )
			$output .= '#navigation  { box-shadow: none; -moz-box-shadow: none; -webkit-box-shadow: none; }';
		// if ( $nav_border_radius )
		// 	$navigation_css .= 'border-radius:'.$nav_border_radius.'; -moz-border-radius:'.$nav_border_radius.'; -webkit-border-radius:'.$nav_border_radius.';';

		// if ( $nav_border_radius )
		// 	$output .= '#navigation ul li:first-child, #navigation ul li:first-child a { border-radius:'.$nav_border_radius.' 0 0 '.$nav_border_radius.'; -moz-border-radius:'.$nav_border_radius.' 0 0 '.$nav_border_radius.'; -webkit-border-radius:'.$nav_border_radius.' 0 0 '.$nav_border_radius.'; }' . "\n";

		if ( $navigation_css != '' )
			$output .= '#navigation {'. $navigation_css . '}'. "\n";

		if ( $top_nav_bg )
			$output .= '#top, #top ul.top-navigation li ul li a:hover { background:'.$top_nav_bg.' !important;}'. "\n";

		if ( $top_nav_bg_hover )
			$output .= '#top:hover { background:'.$top_nav_bg_hover.' !important;}'. "\n";

		if ( $top_nav_hover )
			$output .= '#top ul.top-navigation li > a:hover, #top ul.top-navigation li.current_page_item > a, #top ul.top-navigation li.current_page_parent > a,#top ul.top-navigation li.current-menu-ancestor > a,#top ul.top-navigation li.current-cat > a,#top ul.top-navigation li.current-menu-item > a,#top ul.top-navigation li.sfHover, #top ul.top-navigation li ul, #top ul.top-navigation > li:hover a, #top ul.top-navigation li ul li a { color:'.$top_nav_hover.'!important;}'. "\n";

		if ( $top_nav_hover_bg )
			$output .= '#top ul.top-navigation li > a:hover, #top ul.top-navigation li.current_page_item > a, #top ul.top-navigation li.current_page_parent > a,#top ul.top-navigation li.current-menu-ancestor > a,#top ul.top-navigation li.current-cat > a,#top ul.top-navigation li.current-menu-item > a,#top ul.top-navigation li.sfHover, #top ul.top-navigation li ul, #top ul.top-navigation > li:hover { background:'.$top_nav_hover_bg.';}'. "\n";

		if ( $top_nav_font ) {
			$output .= '#top ul.top-navigation li a, #top ul.rss a, #top .cart-contents, #top ul.rss { ' . woo_generate_font_css( $top_nav_font, 1.3 ) . ' }' . "\n";
			if ( isset( $top_nav_font['color'] ) && strlen( $top_nav_font['color'] ) == 7 ) {
				$output .= '#top ul.top-navigation li.parent > a:after { border-top-color:'. esc_attr( $top_nav_font['color'] ) .';}'. "\n";
			}
		}

		if( $top_callus_font ){
			$output .= '#top .callus {'. woo_generate_font_css( $top_callus_font, 1.6 ) .'}'. "\n";
		}
		if ( !$is_IE )
			$output .= '}' . "\n";

		// Footer
		$footer_font = $woo_options['woo_footer_font'];
		$footer_bg = $woo_options['woo_footer_bg'];
		$footer_border_top = $woo_options['woo_footer_border_top'];
		$footer_border_bottom = $woo_options['woo_footer_border_bottom'];
		$footer_border_lr = $woo_options['woo_footer_border_lr'];
		$footer_border_radius = $woo_options['woo_footer_border_radius'];

		if ( $footer_font )
			$output .= '#footer, #footer p { ' . woo_generate_font_css( $footer_font, 1.4 ) . ' }' . "\n";
		$footer_css = '';
		if ( $footer_bg )
			$footer_css .= 'background-color:'.$footer_bg.';';
		if ( $footer_border_top )
			$footer_css .= 'border-top:'.$footer_border_top["width"].'px '.$footer_border_top["style"].' '.$footer_border_top["color"].';';
		if ( $footer_border_bottom )
			$footer_css .= 'border-bottom:'.$footer_border_bottom["width"].'px '.$footer_border_bottom["style"].' '.$footer_border_bottom["color"].';';
		if ( $footer_border_lr )
			$footer_css .= 'border-left:'.$footer_border_lr["width"].'px '.$footer_border_lr["style"].' '.$footer_border_lr["color"].';border-right:'.$footer_border_lr["width"].'px '.$footer_border_lr["style"].' '.$footer_border_lr["color"].';';
		if ( $footer_border_radius )
			$footer_css .= 'border-radius:'.$footer_border_radius.'; -moz-border-radius:'.$footer_border_radius.'; -webkit-border-radius:'.$footer_border_radius.';';

		if ( $footer_css != '' )
			$output .= '#footer-container-bottom {'. $footer_css . '}' . "\n";


		// Archive Header
		$woo_archive_header_font = $woo_options['woo_archive_header_font'];
		if ( $woo_archive_header_font ){

			$output .= '.archive .title {font:'.$woo_archive_header_font["style"].' '.$woo_archive_header_font["size"].$woo_archive_header_font["unit"].'/1.2em '.stripslashes($woo_archive_header_font["face"]).'!important;color:'.$woo_archive_header_font["color"].'!important;}';
			}

			$output .= '.archive_header {border-bottom:'.$woo_options['woo_archive_header_border_bottom']["width"].'px '.$woo_options['woo_archive_header_border_bottom']["style"].' '.$woo_options['woo_archive_header_border_bottom']["color"].';}'. "\n";
		if ( $woo_options['woo_archive_header_disable_rss'] == "true" )
			$output .= '.archive_header .catrss { display:none; }' . "\n";
//end edit adit 8-11-2013

	// Output styles
	if (isset($output)) {
		// $output = "\n<!-- Woo Custom Styling -->\n<style type=\"text/css\">\n" . $output . "</style>\n<!-- /Woo Custom Styling -->\n\n";
		echo $output;
	} elseif($default_google_font)  {
			// Enable Google Fonts stylesheet in HEAD
			if (function_exists( 'woo_google_webfonts')) woo_google_webfonts();

		}
} // End woo_custom_styling()
}


/*-----------------------------------------------------------------------------------*/
/* Add custom typograhpy to HEAD title sc*/
/*-----------------------------------------------------------------------------------*/



add_action( 'woo_head','woo_custom_typography', 10 ); // Add custom typography to HEAD

if ( ! function_exists( 'woo_custom_typography' ) ) {
	function woo_custom_typography() {

		// Get options
		global $woo_options;

		// Reset
		$output = '';
		$default_google_font = false;


			// Load default Google Fonts
			global $default_google_fonts;
			if ( is_array( $default_google_fonts) and count( $default_google_fonts ) > 0 ) :

				$count = 0;
				foreach ( $default_google_fonts as $font ) {
					$count++;
					$woo_options[ 'woo_default_google_font_'.$count ] = array( 'face' => $font );
				}
				$default_google_font = true;

			endif;



		// Output styles
		if (isset($output) && $output != '') {

			// Load Google Fonts stylesheet in HEAD
			if (function_exists( 'woo_google_webfonts')) woo_google_webfonts();

			$output = "\n" . "<!-- Woo Custom Shortcode Typography -->\n<style type=\"text/css\">\n" . $output . "</style>\n";
			echo $output;

		// Check if default google font is set and load Google Fonts stylesheet in HEAD
		} elseif ( $default_google_font ) {

			// Enable Google Fonts stylesheet in HEAD
			if (function_exists( 'woo_google_webfonts')) woo_google_webfonts();

		}

	} // End woo_custom_typography()
}

add_action( 'wp_head', 'woo_google_webfonts', 10 );				// Add Google Fonts output to HEAD

// Returns proper font css output
if ( ! function_exists( 'woo_generate_font_css' ) ) {
	function woo_generate_font_css( $option, $em = '1' ) {

		// Test if font-face is a Google font
		global $google_fonts;
		foreach ( $google_fonts as $google_font ) {

			// Add single quotation marks to font name and default arial sans-serif ending
			if ( $option['face'] == $google_font['name'] )
				$option['face'] = "'" . $option['face'] . "', arial, sans-serif";

		} // END foreach

		if ( !@$option['style'] && !@$option['size'] && !@$option['unit'] && !@$option['color'] )
			return 'font-family: '.stripslashes($option["face"]).';';
		else
			return 'font:'.$option['style'].' '.$option['size'].$option['unit'].'/'.$em.'em '.stripslashes($option['face']).';color:'.$option['color'].';';
	} // End woo_generate_font_css()
}

add_action('wp_head', 'woo_alt_custom_favicon', 10);

if (!function_exists('woo_alt_custom_favicon')) {
function woo_alt_custom_favicon(){
 $settings = woo_get_dynamic_values( array( 'custom_favicon_iphone' =>  '', 'custom_favicon_iphone_retina' => '', 'custom_favicon_ipad' => '', 'custom_favicon_ipad_retina' => '' ));
 echo "\n".'<!-- Custom Retina Favicon -->'. "\n";
 if( $settings['custom_favicon_iphone'] != "") { echo '<link rel="apple-touch-icon" href=" '. $settings['custom_favicon_iphone'] .'"> '. "\n" ; }

 if( $settings['custom_favicon_iphone_retina'] != "") { echo '<link rel="apple-touch-icon" sizes="114x114" href=" '.  $settings['custom_favicon_iphone_retina'] .' "> '. "\n"; }

 if( $settings['custom_favicon_ipad'] != "") { echo '<link rel="apple-touch-icon" sizes="72x72" href="'. $settings['custom_favicon_ipad'] .'"> '. "\n";}

 if( $settings['custom_favicon_ipad_retina'] != "") { echo'<link rel="apple-touch-icon" sizes="144x144" href="'. $settings['custom_favicon_ipad_retina'] .'"> '. "\n"; }
	}
}

/*-----------------------------------------------------------------------------------*/
/* Add layout to body_class output */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woo_layout_body_class' ) ) {
	function woo_layout_body_class( $classes ) {
		global $post, $wp_query, $woo_options;
		$layout = '';

		// Single post layout
		if ( is_singular() ) {

			// Get layout setting from single post Custom Settings panel
			$layout = get_post_meta( $post->ID, 'layout', true );

			// Set to single post layout if selected
			if ( $layout != '' ) {
				$woo_options['woo_layout'] = $layout;

			// Portfolio single post layout option.
			} elseif ( get_post_type() == 'portfolio' ) {
				$portfolio_single_layout = get_option( 'woo_portfolio_layout_single' );
				if ( $portfolio_single_layout != '' ) {
					$layout = $portfolio_single_layout;
					$woo_options['woo_layout'] = $portfolio_single_layout;
				}

			}
		}

		// Set default global layout
		if ( $layout == '' ) {
			$layout = get_option( 'woo_layout' );
				if ( $layout == '' )
					$layout = 'two-col-left';
		}

		// Portfolio gallery layout option.
		if ( is_tax( 'portfolio-gallery' ) || is_post_type_archive( 'portfolio' ) || is_page_template( 'template-portfolio.php' ) ) {
			$portfolio_gallery_layout = get_option( 'woo_portfolio_layout' );
			if ( $portfolio_gallery_layout != '' ) {
				$layout = $portfolio_gallery_layout;
			}
		}

		if ( is_tax( 'portfolio-gallery' ) || is_post_type_archive( 'portfolio' ) || is_page_template( 'template-portfolio.php' ) || ( is_singular() && get_post_type() == 'portfolio' ) ) {
			$classes[] = 'portfolio-component';
		}

		// WooCommerce Layout
		if ( class_exists( 'woocommerce' ) && function_exists( 'is_shop' )  && function_exists( 'is_cart' ) && function_exists( 'is_checkout' ) && function_exists( 'is_account_page' ) && ( is_woocommerce() || is_shop() || is_cart() || is_checkout() || is_account_page() ) ) {

			// Set default layout
			$woocommerce_layout = get_option( 'woo_wc_layout' );
			if ( $woocommerce_layout != '' ) {
				$layout = $woocommerce_layout;
				$woo_options['woo_layout'] = $woocommerce_layout;
			}

		if ( is_woocommerce_activated() ) {

			if ( is_product() ) {
				$layout = 'one-col';
			}

			 if( ( is_user_logged_in() && is_page_template('page-my-account.php') ) && !( is_shop() || is_product() || is_product_category() || is_product_tag() || is_cart() || is_checkout() ) ) {
			 	$classes[] = 'two-col-right';
			 }

		}

			// WooCommerce single post/page
			if ( is_singular() ) {

				// Get layout setting from single post Custom Settings panel
				$single_layout = get_post_meta( $post->ID, 'layout', true );

				// Set to single post layout if selected
				if ( $single_layout != '' ) {
					$woo_options['woo_layout'] = $single_layout;
					$layout = $single_layout;
				}
			}

		}

		// Specify site width
		$width = intval( str_replace( 'px', '', get_option( 'woo_layout_width', '980' ) ) );

		// Add classes to body_class() output
		$classes[] = $layout;
		$classes[] = 'width-' . $width;
		$classes[] = $layout . '-' . $width;
		return $classes;
	} // End woo_layout_body_class()
}

// add category nicenames in body and post class
	function woo_woocommerce_post_class($classes) {
	    global $woo_options;
	    if (class_exists( 'woocommerce' )){

	    	if (isset($woo_options['woo_single_product_mode_layout']) && $woo_options['woo_single_product_mode_layout'] == 'modern' && is_product()) {
				$classes[] = 'product-layout-modern';
			} else {
				if(isset($woo_options['woo_single_product_mode_layout']) && $woo_options['woo_single_product_mode_layout'] == 'classic' && is_product()) {
				$classes[] = 'product-layout-classic';
				}
			}
	   }
	        return $classes;
	}
	add_filter('post_class', 'woo_woocommerce_post_class');



/*-----------------------------------------------------------------------------------*/
/* Navigation */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woo_nav' ) ) {
function woo_nav() {
	global $woo_options, $woocommerce;
	woo_nav_before();
?>
<nav id="navigation" class="col-full" role="navigation">

	<section class="menus">

	<?php woo_nav_inside(); ?>

	<a href="<?php echo home_url(); ?>" class="nav-home"><span><?php _e( 'Home', 'woothemes' ); ?></span></a>

	<?php
	$settings = array( 'header_cart_link' => 'false', 'header_cart_total' => 'false' );
	$settings = woo_get_dynamic_values( $settings );
	if ( is_woocommerce_activated() && 'true' == $settings['header_cart_link'] ) { ?>
	<h3><?php _e('My Cart', 'woothemes' ); ?></h3>
    	<ul class="cart">
    		<li>
    			<a class="cart-contents" href="<?php echo esc_url( $woocommerce->cart->get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'woothemes' ); ?>">

    				<?php if ( $settings['header_cart_total'] == 'true' ) { echo sprintf( _n('%d item', '%d items', $woocommerce->cart->cart_contents_count, 'woothemes' ), $woocommerce->cart->cart_contents_count ); ?> - <?php echo $woocommerce->cart->get_cart_total(); } ?>

    			</a>
    		</li>
   	</ul>
   	 <?php } ?>

	<?php
	if ( function_exists( 'has_nav_menu' ) && has_nav_menu( 'primary-menu' ) ) {
		echo '<h3>' . woo_get_menu_name( 'primary-menu' ) . '</h3>';
		//wp_nav_menu( array( 'sort_column' => 'menu_order', 'container' => 'ul', 'menu_id' => 'main-nav', 'menu_class' => 'nav fl', 'theme_location' => 'primary-menu' ) );
		df_navbar_menu( array(
            'menu_wraper'       => '<ul id="main-nav" class="nav fl">%MENU_ITEMS%' . "\n" . '</ul>',
            'menu_items'        =>  "\n" . '<li class="%ITEM_CLASS%"><a href="%ITEM_HREF%"%ESC_ITEM_TITLE%>%ICON%<span>%ITEM_TITLE%%SPAN_DESCRIPTION%</span></a>%SUBMENU%</li> ',
            'submenu'           => '<ul class="sub-nav">%ITEM%</ul>',
            'params'            => array( 'act_class' => 'act', 'please_be_mega_menu' => true ),
        ) );
	} else {
	?>
		<ul id="main-nav" class="nav fl">
			<?php
			if ( get_option( 'woo_custom_nav_menu' ) == 'true' ) {
				if ( function_exists( 'woo_custom_navigation_output' ) ) { woo_custom_navigation_output( 'name=Woo Menu 1' ); }
			} else { ?>

				<?php if ( is_page() ) { $highlight = 'page_item'; } else { $highlight = 'page_item current_page_item'; } ?>
				<li class="<?php echo esc_attr( $highlight ); ?>"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php _e( 'Home', 'woothemes' ); ?></a></li>
				<?php wp_list_pages( 'sort_column=menu_order&depth=6&title_li=&exclude=' ); ?>
			<?php } ?>
		</ul><!-- /#nav -->
		<div class="clear"></div>
	<?php } ?>
	</section><!-- /.menus -->

	<a href="#top" class="nav-close"><span><?php _e('Return to Content', 'woothemes' ); ?></span></a>

</nav>
<?php
	woo_nav_after();
} // End woo_nav()
}

/*-----------------------------------------------------------------------------------*/
/* Add subscription links to the navigation bar */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_nav_subscribe' ) ) {
function woo_nav_subscribe() {
	global $woo_options;
	$class = '';
	if ( isset( $woo_options['woo_header_cart_link'] ) && 'true' == $woo_options['woo_header_cart_link'] )
		$class = ' cart-enabled';

	if ( ( isset( $woo_options['woo_nav_rss'] ) ) && ( $woo_options['woo_nav_rss'] == 'true' ) || ( isset( $woo_options['woo_subscribe_email'] ) ) && ( $woo_options['woo_subscribe_email'] ) ) { ?>
	<ul class="rss fr<?php echo $class; ?>">
		<?php if ( ( isset( $woo_options['woo_subscribe_email'] ) ) && ( $woo_options['woo_subscribe_email'] ) ) { ?>
		<li class="sub-email"><a href="<?php echo esc_url( $woo_options['woo_subscribe_email'] ); ?>"></a></li>
		<?php } ?>
		<?php if ( isset( $woo_options['woo_nav_rss'] ) && ( $woo_options['woo_nav_rss'] == 'true' ) ) { ?>
		<li class="sub-rss"><a href="<?php if ( $woo_options['woo_feed_url'] ) { echo esc_url( $woo_options['woo_feed_url'] ); } else { echo esc_url( get_bloginfo_rss( 'rss2_url' ) ); } ?>"></a></li>
		<?php } ?>
	</ul>
	<?php }
} // End woo_nav_subscribe()
}

/*-----------------------------------------------------------------------------------*/
/* Post More  */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_post_more' ) ) {
function woo_post_more() {
	if ( get_option( 'woo_disable_post_more' ) != 'true' ) {

	$html = '';

	if ( get_option('woo_post_content') == 'excerpt' ) { $html .= '[view_full_article] '; }
	$html .= '[post_comments]';

	$html = apply_filters( 'woo_post_more', $html );

		if ( $html != '' ) {
?>
	<div class="post-more">
		<?php
			echo $html;
		?>
	</div>
<?php
		}
	}
} // End woo_post_more()
}

/*-----------------------------------------------------------------------------------*/
/* Video Embed  */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'canvas_get_embed' ) ) {
function canvas_get_embed() {
	global $post;
	// Setup height & width of embed
		$layout = get_post_meta($post->ID, "style_single_port", true);
		if ($layout== '1') {
			$width = '644';
			$height = '343';
		}
		else {
			$width = '980';
			$height = '500';
		}
	$embed = woo_embed( 'width=' . $width . '&height=' . $height );
	if ( '' != $embed ) {
?>
<div class="post-embed">
	<?php echo $embed; ?>
</div><!-- /.post-embed -->
<?php
	}
} // End canvas_get_embed()
}


/*-----------------------------------------------------------------------------------*/
/* Author Box */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woo_author' ) ) {
function woo_author () {
	// Author box single post page
	if ( is_single() && get_option( 'woo_disable_post_author' ) != 'true' ) { add_action( 'woo_post_inside_after', 'woo_author_box', 10 ); }
	// Author box author page
	if ( is_author() ) { add_action( 'woo_loop_before', 'woo_author_box', 10 ); }
} // End woo_author()
}


/*-----------------------------------------------------------------------------------*/
/* Single Post Author */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woo_author_box' ) ) {
function woo_author_box () {
	global $post;
	$author_id=$post->post_author;
?>
<aside id="post-author">
	<div class="profile-image"><?php echo get_avatar( $author_id, '80' ); ?></div>
	<div class="profile-content">
		<h4><?php printf( esc_attr__( 'About %s', 'woothemes' ), get_the_author_meta( 'display_name', $author_id ) ); ?></h4>
		<?php echo get_the_author_meta( 'description', $author_id ); ?>
		<?php if ( is_singular() ) { ?>
		<div class="profile-link">
			<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID', $author_id ) ) ); ?>">
				<?php printf( __( 'View all posts by %s <span class="meta-nav">&rarr;</span>', 'woothemes' ), get_the_author_meta( 'display_name', $author_id ) ); ?>
			</a>
		</div><!--#profile-link-->
		<?php } ?>
	</div>
	<div class="fix"></div>
</aside>
<?php
} // End woo_author_box()
}


/*-----------------------------------------------------------------------------------*/
/* Breadcrumb display */
/*-----------------------------------------------------------------------------------*/

add_action('woo_main_before','woo_display_breadcrumbs',10);
if (!function_exists( 'woo_display_breadcrumbs')) {
	function woo_display_breadcrumbs() {
		global $woo_options;
		if ( isset( $woo_options['woo_breadcrumbs_show'] ) && $woo_options['woo_breadcrumbs_show'] == 'true' && ! (is_home()) && !(is_front_page()) && !( is_page_template( 'template-home.php' )) && !(is_page_template( 'template-contactver2.php' )) && !(is_page_template( 'template-lookbook.php' ))) {
		echo '<section id="breadcrumbs">';
		echo '<div class="inner">';
			woo_breadcrumbs();
		echo '</div>';
		echo '</section><!--/#breadcrumbs -->';
		}
	} // End woo_display_breadcrumbs()
} // End IF Statement


// Customise the breadcrumb
add_filter( 'woo_breadcrumbs_args', 'woo_custom_breadcrumbs_args', 10 );

if (!function_exists('woo_custom_breadcrumbs_args')) {
	function woo_custom_breadcrumbs_args ( $args ) {
		$args = array('separator' => '/', 'before' => '', 'show_home' => sprintf( __('Home', 'woothemes' )),);
		return $args;
	} // End woo_custom_breadcrumbs_args()
}


/*-----------------------------------------------------------------------------------*/
/* Subscribe & Connect  */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woo_subscribe_connect_action' ) ) {
function woo_subscribe_connect_action() {
	if ( is_single() && 'true' == get_option( 'woo_connect' ) ) { add_action('woo_post_inside_after', 'woo_subscribe_connect'); }
} // End woo_subscribe_connect_action()
}


/*-----------------------------------------------------------------------------------*/
/* Optional Top Navigation (WP Menus)  */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woo_top_navigation' ) ) {
function woo_top_navigation() {
global $woo_options;
	if ( isset($woo_options['woo_check_topbar']) && $woo_options['woo_check_topbar'] == "true") {
?>
<div class="universe-search" style="position: fixed;">
	<div class="universe-search-close ent-text"></div>
	<div class="col-full">
<!-- <div class="universe-search-help"><span class="universe-search-help-count">0</span> results. <br>How about another try?</div> -->
		<div class="universe-search-form">
			<span class="universe-search-icon ent-text"></span>
			<div style="position: relative; padding-bottom: 1em;">
				<input type="text" id="searchfrm" name="search" class="universe-search-input" placeholder="<?php _e('Start typing to get your search on...', 'woothemes'); ?>" value="" style="background-color: transparent; background-position: initial initial; background-repeat: initial initial;" autocomplete="off" spellcheck="false" dir="ltr">
				<div style="position: absolute; height: 0px; width: 740px; top: 0px; left: 55px; padding: 15px 0px 0px; margin: 0px 0px 0px 30px; font-family: DNRL; font-size: 40px; font-style: normal; line-height: normal; font-weight: normal; letter-spacing: -3px; background-color: rgb(255, 255, 255); color: rgb(204, 204, 204);"></div>
				<span class="suggest-more" style="position: absolute; top: 20px; left: 740px; display: none; font-size: 40px; font-family: DNRL; color: rgb(204, 204, 204);"></span>
			</div>
		</div>
	    <div id="jp-container-search" class="jp-container-search">
			<div class="universe-search-results"></div>
		</div>

		<div class="universe-search-pagination" style="display:none">
			<ol class="universe-search-pagination-list"> </ol>
		</div>
	</div>
</div>

	<div id="top">
		<div class="col-full">
			<div class="fl">
				<?php
				$woo_custom_callus = isset( $woo_options['woo_text_callus'] ) ? $woo_options['woo_text_callus'] : '';

				if (function_exists('icl_register_string')) {
					icl_register_string('LaBomba Callus Text', 'callus text – ' . $woo_custom_callus, $woo_custom_callus );
				}

				$icl_t = function_exists('icl_t');

				$callus = $icl_t ? icl_t('LaBomba Callus Text', 'callus text – ' . $woo_custom_callus, $woo_custom_callus) : $woo_custom_callus;

				if ( $woo_custom_callus )  { ?>
				<?php if( $callus != '' ) : ?>
					<div class="callus"><?php echo stripslashes($callus); ?></div>
				<?php endif; ?>
				<?php } ?>
			</div>


			<div class="fr">

				<?php do_action('woo_top_bar_content'); ?>

				<?php if ( class_exists( 'YITH_WCWL_UI' ) && isset($woo_options['woo_wishlist_topbar']) && $woo_options['woo_wishlist_topbar'] == 'true' ) : ?>
			    	<ul class="wishlist-contents fr">
					 	<?php echo woo_dahz_get_wishlist(); ?>
				 	</ul>
			    <?php endif; ?>

				<div class="search-contents fr" >
					<div class="fa fa-search"></div>
				</div>


				<?php
				if ( function_exists( 'has_nav_menu' ) && has_nav_menu( 'top-menu' ) ) {
					echo '<h3 class="top-menu">' . woo_get_menu_name( 'top-menu' ) . '</h3>';
					wp_nav_menu( array( 'depth' => 6, 'sort_column' => 'menu_order', 'container' => 'ul', 'menu_id' => 'top-nav', 'menu_class' => 'nav top-navigation fr', 'theme_location' => 'top-menu' ) );
				}
				?>

			</div>
		</div> <!-- .col-full -->


		 	<?php
		 	$float_menu = isset( $woo_options['woo_float_menu'] ) ? $woo_options['woo_float_menu'] : '';

 			if ( $float_menu == "true" ) {

				echo "<div class='ico-responsive top-icon'></div>";

				$settings = woo_get_dynamic_values( array( 'logo' => '' ) );
				$site_title = get_bloginfo( 'name' );
				$site_url = home_url( '/' );
				$site_description = get_bloginfo( 'description' ); ?>

				<div id="logo">
					<?php
					// Website heading/logo and description text.
					if ( ( '' != $settings['logo'] ) ) {
						$logo_url = $settings['logo'];
						if ( is_ssl() ) $logo_url = str_replace( 'http://', 'https://', $logo_url );

						echo '<a href="' . esc_url( $site_url ) . '" title="' . esc_attr( $site_description ) . '"><img src="' . esc_url( $logo_url ) . '" alt="' . esc_attr( $site_title ) . '" /></a>' . "\n";
					} // End IF Statement
					?>
				</div>

				<div id="wrapper">
					<div id="inner-wrapper">
						<nav id="navigation" class="float-menu" role="navigation">
							<section class="menus">
								<?php
								df_navbar_menu( array(
						            'menu_wraper'       => '<ul id="main-nav" class="nav top-nav-custom">%MENU_ITEMS%' . "\n" . '</ul>',
						            'menu_items'        =>  "\n" . '<li class="%ITEM_CLASS%"><a href="%ITEM_HREF%"%ESC_ITEM_TITLE%>%ICON%<span>%ITEM_TITLE%%SPAN_DESCRIPTION%</span></a>%SUBMENU%</li> ',
						            'submenu'           => '<ul class="sub-nav">%ITEM%</ul>',
						            'params'            => array( 'act_class' => 'act', 'please_be_mega_menu' => true ),
						        ) ); ?>
							</section>
						</nav>
					</div>
				</div>

			<?php }/*end if woo float*/  ?>

		</div> <!-- #top --> 
<?php
 } 

} // End woo_top_navigation()
}

/*-----------------------------------------------------------------------------------*/
/* Footer Widgetized Areas  */
/*-----------------------------------------------------------------------------------*/

add_action( 'woo_footer_top', 'woo_footer_sidebars', 30 );

if ( ! function_exists( 'woo_footer_sidebars' ) ) {
function woo_footer_sidebars() {
	$settings = woo_get_dynamic_values( array( 'biz_disable_footer_widgets' => '', 'footer_sidebars' => '4' ) );

	$footer_sidebar_total = 4;
	$has_footer_sidebars = false;

	// Check if we have footer sidebars to display.
	for ( $i = 1; $i <= $footer_sidebar_total; $i++ ) {
		if ( woo_active_sidebar( 'footer-' . $i ) && ( $has_footer_sidebars == false ) ) {
			$has_footer_sidebars = true;
		}
	}

	// If footer sidebars are available, we're on the "Business" page template and we want to disable them, do so.
	if ( $has_footer_sidebars && is_page_template( 'template-biz.php' ) && ( 'true' == $settings['biz_disable_footer_widgets'] ) ) {
		$has_footer_sidebars = false;
	}

	$total = $settings['footer_sidebars'];
	if ( '0' == $settings['footer_sidebars'] ) { $total = 0; } // Make sure the footer widgets don't display if the "none" option is set under "Theme Options".

	// Lastly, we display the sidebars.
	if ( $has_footer_sidebars &&  $total > 0 ) {
?>
<section id="footer-widgets" class="col-full col-<?php echo esc_attr( intval( $total ) ); ?>">
	<?php $i = 0; while ( $i < intval( $total ) ) { $i++; ?>
		<?php if ( woo_active_sidebar( 'footer-' . $i ) ) { ?>
	<div class="block footer-widget-<?php echo $i; ?>">
    	<?php woo_sidebar( 'footer-' . $i ); ?>
	</div>
        <?php } ?>
	<?php } // End WHILE Loop ?>
	<div class="fix"></div>
</section><!--/#footer-widgets-->
<?php

	} // End IF Statement
} // End woo_footer_sidebars()
}

/*-----------------------------------------------------------------------------------*/
/* EXTRA Footer Widgetized Areas  */
/*-----------------------------------------------------------------------------------*/

add_action( 'woo_footer_before', 'woo_extra_footer_sidebars' , 20);

if ( ! function_exists( 'woo_extra_footer_sidebars' ) ) {
function woo_extra_footer_sidebars() {
	$settings = woo_get_dynamic_values( array( 'biz_disable_footer_widgets' => '', 'extra_footer_sidebars' => '6' ) );

	$footer_sidebar_total = 6;
	$has_footer_sidebars = false;

	// Check if we have extra footer sidebars to display.
	for ( $i = 1; $i <= $footer_sidebar_total; $i++ ) {
		if ( woo_active_sidebar( 'extra-footer-' . $i ) && ( $has_footer_sidebars == false ) ) {
			$has_footer_sidebars = true;
		}
	}

	// If footer sidebars are available, we're on the "Business" page template and we want to disable them, do so.
	if ( $has_footer_sidebars && is_page_template( 'template-biz.php' ) && ( 'true' == $settings['biz_disable_footer_widgets'] ) ) {
		$has_footer_sidebars = false;
	}

	$total = $settings['extra_footer_sidebars'];
	if ( '0' == $settings['extra_footer_sidebars'] ) { $total = 0; } // Make sure the extra footer widgets don't display if the "none" option is set under "Theme Options".

	// Lastly, we display the sidebars.
	if ( $has_footer_sidebars &&  $total > 0 ) {
?>
<section id="extra-footer-widgets" class="col-full col-<?php echo esc_attr( intval( $total ) ); ?>">
	<?php $i = 0; while ( $i < intval( $total ) ) { $i++; ?>
		<?php if ( woo_active_sidebar( 'extra-footer-' . $i ) ) { ?>
	<div class="block extra-footer-widget-<?php echo $i; ?>">
    	<?php woo_sidebar( 'extra-footer-' . $i ); ?>
	</div>
        <?php } ?>
	<?php } // End WHILE Loop ?>
	<div class="fix"></div>
</section><!--/#footer-widgets-->
<?php

	} // End IF Statement
} // End woo_extra_footer_sidebars()
}

/*-----------------------------------------------------------------------------------*/
/* Add customisable footer areas */
/*-----------------------------------------------------------------------------------*/

/**
 * Add customisable footer areas.
 *
 * @package WooFramework
 * @subpackage Actions
 */

if ( ! function_exists( 'woo_footer_left' ) ) {
function woo_footer_left () {
	$settings = woo_get_dynamic_values( array( 'footer_left' => 'true', 'footer_left_text' => '[site_copyright]' ) );

	woo_do_atomic( 'woo_footer_left_before' );

	$html = '';

	if( 'true' == $settings['footer_left'] ) {
		$html .= '<p>' . stripslashes( $settings['footer_left_text'] ) . '</p>';
	} else {
		$html .= '[site_copyright]';
	}

	$html = apply_filters( 'woo_footer_left', $html );

	echo $html;

	woo_do_atomic( 'woo_footer_left_after' );
} // End woo_footer_left()
}

if ( ! function_exists( 'woo_footer_right' ) ) {
function woo_footer_right () {
	$settings = woo_get_dynamic_values( array( 'footer_right' => 'true', 'footer_right_text' => '[site_credit]' ) );

	woo_do_atomic( 'woo_footer_right_before' );

	$html = '';

	if( 'true' == $settings['footer_right'] ) {
		$html .= '<p>' . stripslashes( $settings['footer_right_text'] )  . '</p>';
	} else {
		$html .= '[site_credit]';
	}

	$html = apply_filters( 'woo_footer_right', $html );

	echo $html;

	woo_do_atomic( 'woo_footer_right_after' );
} // End woo_footer_right()
}

/*-----------------------------------------------------------------------------------*/
/* Add customisable post meta */
/*-----------------------------------------------------------------------------------*/

/**
 * Add customisable post meta.
 *
 * Add customisable post meta, using shortcodes,
 * to be added/modified where necessary.
 *
 * @package WooFramework
 * @subpackage Actions
 */

if ( ! function_exists( 'woo_post_meta' ) ) {
function woo_post_meta() {
	if ( is_page() ) { return; }

	$post_info = '<span class="small">' . __( 'By', 'woothemes' ) . '</span> [post_author_posts_link] <span class="small">' . _x( 'on', 'post datetime', 'woothemes' ) . '</span> [post_date] <span class="small">' . __( 'in', 'woothemes' ) . '</span> [post_categories before=""] ';
printf( '<div class="post-meta">%s</div>' . "\n", apply_filters( 'woo_filter_post_meta', $post_info ) );

} // End woo_post_meta()
}

/*-----------------------------------------------------------------------------------*/
/* Add Post Thumbnail to Single posts on Archives */
/*-----------------------------------------------------------------------------------*/

/**
 * Add Post Thumbnail to Single posts on Archives
 *
 * Add code to the woo_post_inside_before() hook.
 *
 * @package WooFramework
 * @subpackage Actions
 */

 add_action( 'woo_post_inside_before', 'woo_display_post_image', 10 );

if ( ! function_exists( 'woo_display_post_image' ) ) {
function woo_display_post_image() {
	global $woo_options;

	$display_image = false;

	$width = isset($woo_options['woo_thumb_w']);
	$height = isset($woo_options['woo_thumb_h']);
	$align = isset($woo_options['woo_thumb_align']);

	if ( is_single() && isset( $woo_options['woo_thumb_single'] ) && ( $woo_options['woo_thumb_single'] == 'true' ) ) {
		$width = $woo_options['woo_single_w'];
		$height = $woo_options['woo_single_h'];
		$align = $woo_options['woo_thumb_align_single'];
		$display_image = true;
	}

	if ( get_option('woo_woo_tumblog_switch') == 'true' ) { $is_tumblog = woo_tumblog_test(); } else { $is_tumblog = false; }
	if ( $is_tumblog || ( is_single() && @$woo_options['woo_thumb_single'] == 'false' ) ) { $display_image = false; }
	if ( $display_image == true && ! woo_embed( '' ) ) { woo_image( 'width=' . $width . '&height=' . $height . '&class=thumbnail ' . $align ); }
} // End woo_display_post_image()
}

/*-----------------------------------------------------------------------------------*/
/* Post Inside After */
/*-----------------------------------------------------------------------------------*/
/**
 * Post Inside After
 *
 * Add code to the woo_post_inside_after() hook.
 *
 * @package WooFramework
 * @subpackage Actions
 */

 add_action( 'woo_post_inside_after_singular-post', 'woo_post_inside_after_default', 10 );

if ( ! function_exists( 'woo_post_inside_after_default' ) ) {
function woo_post_inside_after_default() {

	$post_info ='[post_tags before=""]';
	printf( '<div class="post-utility">%s</div>' . "\n", apply_filters( 'woo_post_inside_after_default', $post_info ) );

} // End woo_post_inside_after_default()
}

/*-----------------------------------------------------------------------------------*/
/* Modify the default "comment" form field. */
/*-----------------------------------------------------------------------------------*/
/**
 * Modify the default "comment" form field.
 *
 * @package WooFramework
 * @subpackage Filters
 */

  add_filter( 'comment_form_field_comment', 'woo_comment_form_comment', 10 );

if ( ! function_exists( 'woo_comment_form_comment' ) ) {
function woo_comment_form_comment ( $field ) {
	$field = str_replace( '<label ', '<label class="hide" ', $field );
	$field = str_replace( 'cols="45"', 'cols="50"', $field );
	$field = str_replace( 'rows="8"', 'rows="10"', $field );

	return $field;
} // End woo_comment_form_comment()
}

/*-----------------------------------------------------------------------------------*/
/* Add theme default comment form fields. */
/*-----------------------------------------------------------------------------------*/
/**
 * Add theme default comment form fields.
 *
 * @package WooFramework
 * @subpackage Filters
 */

add_filter( 'comment_form_default_fields', 'woo_comment_form_fields', 10 );

if ( ! function_exists( 'woo_comment_form_fields' ) ) {
function woo_comment_form_fields ( $fields ) {
	$commenter = wp_get_current_commenter();

$req = get_option( 'require_name_email' );
$aria_req = ( $req ? " aria-required='true'" : '' );

	$fields =  array(
	'author' => '<p class="comment-form-author">' .
				'<label for="author">' . __( 'Name', 'woothemes' ) . ( $req ? ' <span class="required">' . __( '*', 'woothemes' ) . '</span><br />' : '' ) . '</label> ' . '<input id="author" name="author" type="text" class="txt" tabindex="1" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></p>',
	'email'  => '<p class="comment-form-email">' .
				'<label for="email">' . __( 'Email ', 'woothemes' ) . ( $req ? ' <span class="required">' . __( '*', 'woothemes' ) . '</span><br />' : '' ) . '</label> ' . '<input id="email" name="email" type="text" class="txt" tabindex="2" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /></p>',
	'url'    => '<p class="comment-form-url">' .
	            '<label for="url">' . __( 'Website', 'woothemes' ) . '</label><br /><input id="url" name="url" type="text" class="txt" tabindex="3" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></p>',
);

	return $fields;
} // End woo_comment_form_fields()
}

/*-----------------------------------------------------------------------------------*/
/* Add theme default comment form arguments. */
/*-----------------------------------------------------------------------------------*/
/**
 * Add theme default comment form arguments.
 *
 * @package WooFramework
 * @subpackage Filters
 */

add_filter( 'comment_form_defaults', 'woo_comment_form_args', 10 );

if ( ! function_exists( 'woo_comment_form_args' ) ) {
	function woo_comment_form_args ( $args ) {
		// Add tabindex of "field count + 1" to the comment textarea. This lets us cater for additional fields and have a dynamic tab index.
		$tabindex = count( $args['fields'] ) + 1;
		$args['comment_field'] = str_replace( '<textarea ', '<span class="comment_form">' . __( 'Comment', 'woothemes' ) . '<span><textarea tabindex="' . $tabindex . '" ', $args['comment_field'] );

		// Adjust tabindex for "submit" button.
		$tabindex++;

		$args['label_submit'] = __( 'Submit Comment', 'woothemes' );
		$args['comment_notes_before'] = '';
		$args['comment_notes_after'] = '';
		$args['cancel_reply_link'] = __( 'Click here to cancel reply.', 'woothemes' );

		return $args;
	} // End woo_comment_form_args()
}


/*-----------------------------------------------------------------------------------*/
/* Activate shortcode compatibility in our new custom areas. */
/*-----------------------------------------------------------------------------------*/
/**
 * Activate shortcode compatibility in our new custom areas.
 *
 * @package WooFramework
 * @subpackage Filters
 */
 	$sections = array( 'woo_filter_post_meta', 'woo_post_inside_after_default', 'woo_post_more', 'woo_footer_left', 'woo_footer_right' );

 	foreach ( $sections as $s ) { add_filter( $s, 'do_shortcode', 20 ); }


/*-----------------------------------------------------------------------------------*/
/* woo_feedburner_link() */
/*-----------------------------------------------------------------------------------*/
/**
 * woo_feedburner_link()
 *
 * Replace the default RSS feed link with the Feedburner URL, if one
 * has been provided by the user.
 *
 * @package WooFramework
 * @subpackage Filters
 */

add_filter( 'feed_link', 'woo_feedburner_link', 10 );

if ( ! function_exists( 'woo_feedburner_link' ) ) {
function woo_feedburner_link ( $output, $feed = null ) {
	global $woo_options;

	$default = get_default_feed();

	if ( ! $feed ) $feed = $default;

	if ( isset( $woo_options['woo_feed_url'] ) && $woo_options['woo_feed_url'] && ( $feed == $default ) && ( ! stristr( $output, 'comments' ) ) ) $output = $woo_options['woo_feed_url'];

	return esc_url( $output );
} // End woo_feedburner_link()
}

/*-----------------------------------------------------------------------------------*/
/* Enqueue dynamic CSS */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_enqueue_custom_styling' ) ) {
	function woo_enqueue_custom_styling() {
		echo "\n" . '<!-- Custom CSS Styling -->' . "\n";
		echo '<style type="text/css">' . "\n";
		woo_custom_styling();
		echo '</style>' . "\n";
	} // End woo_enqueue_custom_styling()
}

/*-----------------------------------------------------------------------------------*/
/* Load site width CSS in the header */
/*-----------------------------------------------------------------------------------*/

add_action( 'wp_head', 'woo_load_site_width_css', 9 );

if ( ! function_exists( 'woo_load_site_width_css' ) ) {
function woo_load_site_width_css () {
	$settings = woo_get_dynamic_values( array( 'layout_width' => 980 ) );
    $layout_width = intval( $settings['layout_width'] );
    if ( 0 < $layout_width && 980 != $layout_width ) { /* Has legitimate width */ } else { return; } // Use default width from stylesheet
?>

<!-- Adjust the website width -->
<style type="text/css">
	.col-full, #wrapper { max-width: <?php echo intval( $layout_width ); ?>px !important; }
</style>

<?php
} // End woo_load_site_width_css()
}

/*-----------------------------------------------------------------------------------*/
/* Function to optionally remove responsive design and load in fallback CSS styling. */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_remove_responsive_design' ) ) {
/**
 * Trigger items for removing responsive design from Canvas.
 * @since  5.0.13
 * @return void
 */
function woo_remove_responsive_design () {
	remove_action( 'wp_head', 'woo_load_site_width_css', 10 );
	// Load in CSS file for non-responsive layouts.
	wp_enqueue_style( 'non-responsive' );
	// Load non-responsive site width CSS.
	add_action( 'wp_enqueue_scripts', 'woo_load_site_width_css_nomedia', 10 );
	// Remove mobile viewport scale meta tag
	remove_action( 'wp_head', 'woo_load_responsive_meta_tags', 10 );
} // End woo_remove_responsive_design()
}

if ( ! function_exists( 'woo_load_site_width_css_nomedia' ) ) {
/**
 * Load the layout width CSS without a media query wrapping it.
 * @since  5.0.13
 * @return void
 */
function woo_load_site_width_css_nomedia () {
	$settings = woo_get_dynamic_values( array( 'layout_width' => 980 ) );
    $layout_width = intval( $settings['layout_width'] );
    if ( 0 < $layout_width ) { /* Has legitimate width */ } else { $layout_width = 980; } // Default Width
?>
<style type="text/css">.col-full, #wrapper { width: <?php echo intval( $layout_width ); ?>px; max-width: <?php echo intval( $layout_width ); ?>px; } #inner-wrapper { padding: 0; } body.full-width #header, #nav-container, body.full-width #content, body.full-width #footer-widgets, body.full-width #footer { padding-left: 0; padding-right: 0; } body.fixed-mobile #top, body.fixed-mobile #header-container, body.fixed-mobile #footer-container, body.fixed-mobile #nav-container, body.fixed-mobile #footer-widgets-container { min-width: <?php echo intval( $layout_width ); ?>px; padding: 0 1em; } body.full-width #content { width: auto; padding: 0 1em;}</style>
<?php
} // End woo_load_site_width_css_nomedia()
}

if ( ! function_exists( 'woo_load_responsive_design_removal' ) ) {
/**
 * Trigger the removal of the responsive design in Canvas. Must be hooked onto "init".
 * @since  5.0.13
 * @uses  woo_remove_responsive_design()
 * @return void
 */
function woo_load_responsive_design_removal () {
	add_action( 'wp_enqueue_styles', 'woo_remove_responsive_design', 10 );
} // End woo_load_responsive_design_removal()
}

/*-----------------------------------------------------------------------------------*/
/* Load non-responsive.css for IE8 */
/*-----------------------------------------------------------------------------------*/

add_action( 'wp_head', 'woo_load_non_responsive_css', 8 );

if ( ! function_exists( 'woo_load_non_responsive_css' ) ) {
	function woo_load_non_responsive_css() {
		// Load conditional CSS for IE8
		echo '<!--[if lt IE 9]>'. "\n";
		echo '<link href="'. esc_url( THEME_URI . '/css/non-responsive.css' ) . '" rel="stylesheet" type="text/css" />' . "\n";
		// Load the site width in addition to max-width to make it fixed
		woo_load_site_width_css_nomedia();
		echo '<![endif]-->'. "\n";
	}
}

/*-----------------------------------------------------------------------------------*/
/* Adjust the homepage query, if using the "Magazine" page template as the homepage. */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_modify_magazine_homepage_query' ) ) {
function woo_modify_magazine_homepage_query ( $q ) {
	if ( ! is_admin() && $q->is_main_query() && ( 0 < $q->query_vars['page_id'] ) && ( $q->query_vars['page_id'] == get_option( 'page_on_front' ) ) && ( 'template-magazine.php' == get_post_meta( intval( $q->query_vars['page_id'] ), '_wp_page_template', true ) ) ) {

		$settings = woo_get_dynamic_values( array( 'magazine_limit' => get_option( 'posts_per_page' ) ) );

		$q->set( 'posts_per_page', intval( $settings['magazine_limit'] ) );
		$q->set( 'paged', intval( $q->query_vars['page'] ) );

		$q->parse_query();
	}
	return $q;
} // End woo_modify_magazine_homepage_query()
}

add_filter( 'pre_get_posts', 'woo_modify_magazine_homepage_query' );

/*-----------------------------------------------------------------------------------*/
/* Full width header */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_full_width_header' ) ) {
function woo_full_width_header() {
	 $settings = woo_get_dynamic_values( array( 'header_full_width' => '', 'layout_boxed' => '' ) );

	if ( 'true' == $settings['layout_boxed'] ) return;
	if ( 'true' != $settings['header_full_width'] ) return;


	// Add header container
	add_action( 'woo_header_before', 'woo_header_container_start' );
	add_action( 'woo_header_after', 'woo_header_container_end', 8 );

	// Add navigation container
	add_action( 'woo_nav_before', 'woo_nav_container_start' );
	add_action( 'woo_nav_after', 'woo_nav_container_end' );
} // End woo_full_width_header()
}

add_action( 'get_header', 'woo_full_width_header', 10 );

/*-----------------------------------------------------------------------------------*/
/* Full width footer */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_full_width_footer' ) ) {
function woo_full_width_footer() {
	$settings = woo_get_dynamic_values( array( 'footer_full_width' => '', 'layout_boxed' => '' ) );

	if ( 'true' == $settings['layout_boxed'] ) return;
	if ( 'true' != $settings['footer_full_width'] ) return;

	// Add footer widget container
	add_action( 'woo_footer_top', 'woo_footer_widgets_container_start', 8 );
	add_action( 'woo_footer_before', 'woo_footer_widgets_container_end' );

	// Add footer container
	add_action( 'woo_footer_before', 'woo_footer_container_start' );
	add_action( 'woo_footer_after', 'woo_footer_container_end' );
} // End woo_full_width_footer()
}

add_action( 'get_header', 'woo_full_width_footer', 10 );

/*-----------------------------------------------------------------------------------*/
/* Full Width Markup Functions */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_header_container_start' ) ) {
function woo_header_container_start () {
?>
    <!--#header-container-->
    <div id="header-container">
<?php
} // End woo_header_container_start()
}

if ( ! function_exists( 'woo_header_container_end' ) ) {
function woo_header_container_end () {
?>
    </div><!--/#header-container-->
<?php
} // End woo_header_container_end()
}

if ( ! function_exists( 'woo_nav_container_start' ) ) {
function woo_nav_container_start () {
?>
    <!--#nav-container-->
    <div id="nav-container">
<?php
} // End woo_nav_container_start()
}

if ( ! function_exists( 'woo_nav_container_end' ) ) {
function woo_nav_container_end () {
?>
    </div><!--/#nav-container-->
<?php
} // End woo_nav_container_end()
}

if ( ! function_exists( 'woo_footer_widgets_container_start' ) ) {
function woo_footer_widgets_container_start () {
?>
    <!--#footer-widgets-container-->
    <div id="footer-widgets-container">
<?php
} // End woo_footer_widgets_container_start()
}

if ( ! function_exists( 'woo_footer_widgets_container_end' ) ) {
function woo_footer_widgets_container_end () {
?>
	</div><!--/#footer_widgets_container_end-->
<?php
}
}

if ( ! function_exists( 'woo_footer_container_start' ) ) {
function woo_footer_container_start () { ?>
    <!--#footer_container_start-->
    <div id="footer-container">
<?php
} // End woo_footer_container_start()
}

if ( ! function_exists( 'woo_footer_container_end' ) ) {
function woo_footer_container_end () { ?>
    </div><!--/#footer_container_end-->
<?php
} // End woo_footer_container_end()
}

/*-----------------------------------------------------------------------------------*/
/* Full width body classes */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_add_full_width_class' ) ) {
function woo_add_full_width_class ( $classes ) {
	$settings = woo_get_dynamic_values( array( 'header_full_width' => 'false', 'footer_full_width' => 'false', 'layout_boxed' => '' ) );
	if ( 'true' == $settings['layout_boxed'] ) return $classes; // Don't add the full width CSS classes if boxed layout is enabled.

	if ( 'true' == $settings['header_full_width'] || 'true' == $settings['footer_full_width'] ) {
		$classes[] = 'full-width';

		if ( 'true' == $settings['header_full_width'] ) {
			$classes[] = 'full-header';
		}

		if ( 'true' == $settings['footer_full_width'] ) {
			$classes[] = 'full-footer';
		}
	}

	if(  is_page_template('template-home.php') ) {

		 if(get_post_meta( get_the_ID(), '_revolutionslider', true ) != '0' || get_post_meta( get_the_ID(), '_flexslide-group', true ) != '0'){
		 	$classes[] = 'has-slider';
		 }
	}

	return $classes;
} // End woo_add_full_width_class()
}

add_filter( 'body_class', 'woo_add_full_width_class', 10 );


/*-----------------------------------------------------------------------------------*/
/* Optionally load custom logo. */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_logo' ) ) {
function woo_logo () {
	$settings = woo_get_dynamic_values( array( 'logo' => '' ) );
	// Setup the tag to be used for the header area (`h1` on the front page and `span` on all others).
	$heading_tag = 'span';
	if ( is_home() || is_front_page() ) { $heading_tag = 'h1'; }

	// Get our website's name, description and URL. We use them several times below so lets get them once.
	$site_title = get_bloginfo( 'name' );
	$site_url = home_url( '/' );
	$site_description = get_bloginfo( 'description' );
?>
<div id="logo">
<?php
	// Website heading/logo and description text.
	if ( ( '' != $settings['logo'] ) ) {
		$logo_url = $settings['logo'];
		if ( is_ssl() ) $logo_url = str_replace( 'http://', 'https://', $logo_url );

		echo '<a href="' . esc_url( $site_url ) . '" title="' . esc_attr( $site_description ) . '"><img src="' . esc_url( $logo_url ) . '" alt="' . esc_attr( $site_title ) . '" /></a>' . "\n";
	} // End IF Statement

	echo '<' . $heading_tag . ' class="site-title"><a href="' . esc_url( $site_url ) . '">' . $site_title . '</a></' . $heading_tag . '>' . "\n";
	if ( $site_description ) { echo '<span class="site-description">' . $site_description . '</span>' . "\n"; }
?>
</div>
<?php
} // End woo_logo()
}

//add_action( 'woo_header_inside', 'woo_logo', 10 );

/*-----------------------------------------------------------------------------------*/
/* Optionally load the mobile navigation toggle. */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_nav_toggle' ) ) {
function woo_nav_toggle () {
?>
<div class="div-nav-toggle">
<h3 class="nav-toggle icon"><a href="#navigation">
	<?php
	$settings = woo_get_dynamic_values( array( 'mom_logo' => '' ) );
	if ( ( '' != $settings['mom_logo'] ) ) {
		$mom_logo_url = $settings['mom_logo'];
		if ( is_ssl() ) $mom_logo_url = str_replace( 'http://', 'https://', $mom_logo_url );
		echo ' <img src="' . esc_url( $mom_logo_url ) . '" alt="" /> ' . "\n";
	} // End IF Statement
	else {
		 _e("Navigation", "woothemes");
	}

		?>
</a></h3>
</div>
<?php
} // End woo_nav_toggle()
}

add_action( 'woo_top', 'woo_nav_toggle', 20 );


/* Sharing meta images */
if ( ! function_exists( 'woo_share_meta_head' ) ) {
function woo_share_meta_head() {
	global $post;
  	if (has_post_thumbnail( $post->ID ) ): ?>
	<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' ); ?>
	<!-- Facebook Share Meta -->
	<meta property="og:title" content="<?php esc_attr( the_title() ); ?>" />
	<meta property="og:image" content="<?php echo $image[0]; ?>" />
	<meta property="og:url" content="<?php the_permalink(); ?>" />
	<meta property="og:description" content="<?php echo strip_tags(get_the_excerpt()); ?>" />
    <!-- Twitter Share Meta -->
    <meta name="twitter:url"	 content="<?php the_permalink(); ?>">
    <meta name="twitter:title"	 content="<?php esc_attr(the_title()); ?>">
    <meta name="twitter:description" content="<?php echo strip_tags(get_the_excerpt()); ?>">
    <meta name="twitter:image:src"	 content="<?php echo $image[0]; ?>">
    <!-- Googleplus Share Meta -->
    <meta itemprop="name" content="<?php esc_attr(the_title()); ?>"/>
	<meta itemprop="description" content="<?php echo strip_tags(get_the_excerpt()); ?>"/>
	<meta itemprop="image" content="<?php echo $image[0]; ?>"/>
	<?php endif;
}
add_action('wp_head', 'woo_share_meta_head');
}


require_once 'headers/custom-menu-admin.class.php' ;
$mega_menu = new Df_Mega_Menu();

/*-----------------------------------------------------------------------------------*/
/* Navbar for header 1 2 3 4 desktop. */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'df_labomba_menu_dekstop' ) ) {
function df_labomba_menu_dekstop() {
	?>
<nav id="navigation" class="col-full df-desktop-navigation" role="navigation">
	<section class="menus">
	<?php
	if ( function_exists( 'has_nav_menu' ) && has_nav_menu( 'primary-menu' ) ) {
		echo '<h3>' . woo_get_menu_name( 'primary-menu' ) . '</h3>';

        df_navbar_menu( array(
            'menu_wraper'       => '<ul id="main-nav" class="nav">%MENU_ITEMS%' . "\n" . '</ul>',
            'menu_items'        =>  "\n" . '<li class="%ITEM_CLASS%"><a href="%ITEM_HREF%"%ESC_ITEM_TITLE%>%ICON%<span>%ITEM_TITLE%%SPAN_DESCRIPTION%</span></a>%SUBMENU%</li> ',
            'submenu'           => '<ul class="sub-nav">%ITEM%</ul>',
            'params'            => array( 'act_class' => 'act', 'please_be_mega_menu' => true ),
        ) );

	} else {
	?>
		<ul id="main-nav" class="nav fl">
			<?php
			if ( get_option( 'woo_custom_nav_menu' ) == 'true' ) {
				if ( function_exists( 'woo_custom_navigation_output' ) ) { woo_custom_navigation_output( 'name=Woo Menu 1' ); }
			} else { ?>

				<?php if ( is_page() ) { $highlight = 'page_item'; } else { $highlight = 'page_item current_page_item'; } ?>
				<li class="<?php echo esc_attr( $highlight ); ?>"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php _e( 'Home', 'woothemes' ); ?></a></li>
				<?php wp_list_pages( 'sort_column=menu_order&depth=6&title_li=&exclude=' ); ?>
			<?php } ?>
		</ul><!-- /#nav -->
		<div class="clear"></div>
	<?php } ?>
    <!-- </div> -->

	</section><!-- /.menus -->

</nav>
<?php
}
add_action('woo_nav_inside', 'df_labomba_menu_dekstop');
}
/*-----------------------------------------------------------------------------------*/
/* Navbar for header 1 2 3 4 mobile. */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'df_labomba_menu_mobile' ) ) {
function df_labomba_menu_mobile() {
	?>
<nav id="navigation" class="col-full df-mobile-navigation" role="navigation">
<div id="jp-container-nav" class="jp-container-nav">
	<section class="menus">
		<form role="search" method="get" id="searchform" action="<?php echo home_url( '/' ); ?>" class="search_mobile">
		    <div class="search_mobile_input">
		        <input type="text" value="" name="s" id="s" placeholder="<?php _e('Search','woothemes'); ?>" style="background-color: transparent; background-position: initial initial; background-repeat: initial initial;" autocomplete="off" spellcheck="false"/>
		    </div>
		</form>
	<a href="<?php echo home_url(); ?>" class="nav-home"><span><?php _e( 'Home', 'woothemes' ); ?></span></a>
	<?php
	$settings = array( 'header_cart_link' => 'false', 'header_cart_total' => 'false' );
	$settings = woo_get_dynamic_values( $settings );
	if ( is_woocommerce_activated() && 'true' == $settings['header_cart_link'] ) { ?>
	<h3><?php _e('My Cart', 'woothemes' ); ?></h3>
    	<ul class="cart">
    		<li>
    			<a class="cart-contents" href="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'woothemes' ); ?>">

    				<?php if ( $settings['header_cart_total'] == 'true' ) { echo sprintf( _n('%d item', '%d items', WC()->cart->cart_contents_count, 'woothemes' ), WC()->cart->cart_contents_count ); ?> - <?php echo WC()->cart->get_cart_total(); } ?>

    			</a>
    		</li>
   	</ul>
   	 <?php
   	}  /*is_woocommerce_activated*/

	if ( function_exists( 'has_nav_menu' ) && has_nav_menu( 'primary-menu' ) ) {
		echo '<h3>' . woo_get_menu_name( 'primary-menu' ) . '</h3>';

        df_navbar_menu( array(
            'menu_wraper'       => '<ul id="main-nav" class="nav">%MENU_ITEMS%' . "\n" . '</ul>',
            'menu_items'        =>  "\n" . '<li class="%ITEM_CLASS%"><a href="%ITEM_HREF%"%ESC_ITEM_TITLE%>%ICON%<span>%ITEM_TITLE%%SPAN_DESCRIPTION%</span></a>%SUBMENU%</li> ',
            'submenu'           => '<ul class="sub-nav">%ITEM%</ul>',
            'params'            => array( 'act_class' => 'act', 'please_be_mega_menu' => true ),
        ) );

	} else {
	?>
		<ul id="main-nav" class="nav fl">
			<?php
			if ( get_option( 'woo_custom_nav_menu' ) == 'true' ) {
				if ( function_exists( 'woo_custom_navigation_output' ) ) { woo_custom_navigation_output( 'name=Woo Menu 1' ); }
			} else { ?>

				<?php if ( is_page() ) { $highlight = 'page_item'; } else { $highlight = 'page_item current_page_item'; } ?>
				<li class="<?php echo esc_attr( $highlight ); ?>"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php _e( 'Home', 'woothemes' ); ?></a></li>
				<?php wp_list_pages( 'sort_column=menu_order&depth=6&title_li=&exclude=' ); ?>
			<?php } ?>
		</ul><!-- /#nav -->
		<div class="clear"></div>
	<?php } ?>
    <!-- </div> -->

	</section><!-- /.menus -->
	<a href="#top" class="nav-close"><span><?php _e('Return to Content', 'woothemes' ); ?></span></a>
</div>
</nav>

<?php
}
add_action('woo_nav_inside', 'df_labomba_menu_mobile');
}

/*-----------------------------------------------------------------------------------*/
/* END */
/*-----------------------------------------------------------------------------------*/


