<?php

/*-------------------------------------------------------------------------------------

TABLE OF CONTENTS

- Page / Post navigation
- WooTabs - Popular Posts
- WooTabs - Latest Posts
- WooTabs - Latest Comments
- Post Meta
- WordPress 3.0 New Features Support
- Custom Post Type: Portfolio Item (Portfolio Component)
- Subscribe & Connect
- Archive Title
- Get Post image attachments
- Woo Portfolio Navigation
- Woo Portfolio Item Extras (Testimonial and Link)
- Woo Portfolio Item Settings
- Woo Portfolio, show portfolio galleries in portfolio item breadcrumbs
- Woo Portfolio, change the "post more" content for portfolio items.
- Woo Portfolio, get image dimensions based on layout and website width settings.
- Exclude categories from displaying on the "Blog" page template.
- Exclude categories from displaying on the homepage.
- Add custom CSS class to the <body> tag if the lightbox option is enabled.
- Load PrettyPhoto JavaScript and CSS if the lightbox option is enabled.
- Google maps (for contact template)
- Add custom CSS class to the <body> tag if the boxed layout option is enabled.
- Is IE
- Check if WooCommerce is activated
- Get a menu name

-------------------------------------------------------------------------------------*/
remove_action( 'wooframework_container_inside', 'wooframework_add_woodojo_banner' );
remove_action( 'wooframework_container_inside', 'wooframework_add_wooseosbm_banner' );

/*-----------------------------------------------------------------------------------*/
/* Page / Post navigation */
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'woo_pagenav' ) ) :

	function woo_pagenav() {

		global $woo_options, $wp_query, $paged, $page;

		$paging_type = isset( $woo_options['woo_pagination_type'] ) ? $woo_options['woo_pagination_type'] : 'paginated_links';

		// If the user has set the option to use simple paging links, display those. By default, display the pagination.
		if ( $paging_type == 'simple' ) : ?>

			<?php if ( get_next_posts_link() || get_previous_posts_link() ) : ?>

    		  	<div class="nav-entries-custom">
                	<?php next_posts_link( '<span class="nav-prev-custom fl"><i class="fa fa-angle-left"></i> '. __( 'Previous', 'woothemes' ) . '</span>' ); ?>
                	<?php previous_posts_link( '<span class="nav-next-custom fr">'. __( 'Next', '`' ) . ' <i class="fa fa-angle-right"></i></span>' ); ?>
	                <div class="fix"></div>
            	</div>

			<?php endif; // End IF Statement ?>

		<?php elseif ( $paging_type == 'custom' || $paging_type == 'custom2' ) : ?>

			<div class="nav-entries-custom">
                <?php next_posts_link( '<span class="nav-prev-custom fl"><i class="fa fa-angle-left"></i> '. __( 'Previous', 'woothemes' ) . '</span>' ); ?>
                <?php previous_posts_link( '<span class="nav-next-custom fr">'. __( 'Next', '`' ) . ' <i class="fa fa-angle-right"></i></span>' ); ?>
                <div class="fix"></div>
            </div>

		<?php else : ?>

			<?php woo_pagination(); ?>

		<?php endif; // End IF Statement

	} // End woo_pagenav()

endif; // End IF Statement

/*-----------------------------------------------------------------------------------*/
/* Shortcode fix
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_shortcode_fix' ) ) {
function woo_shortcode_fix($content){
	    $array = array(
	        '<p>[' => '[',
	        ']</p>' => ']',
	        ']<br />' => ']'
	    );

	    $content = strtr($content, $array);
	    return $content;
}
add_filter('the_content', 'woo_shortcode_fix');
}

/*-----------------------------------------------------------------------------------*/
/* custom pagination for mansory + infinite scroll */
/*-----------------------------------------------------------------------------------*/
if (!function_exists('woo_pagenav_blog')) {
	function woo_pagenav_blog() {

		global $woo_options, $wp_query, $paged, $page;
		if(@$woo_options['woo_pagination_type'] == 'custom2'){
			?>
			  <div class="nav-entries-custom2">
                <?php next_posts_link( '<span class="nav-prev-custom">'. __( 'More Post', 'woothemes' ) . '</span>' ); ?>
                	<?php // woo_pagination(); ?>
                <div class="fix"></div>
            </div>

			<?php

		} // End IF Statement

	} // End woo_pagenav_blog()
} // End IF Statement


if (!function_exists('woo_postnav')) {
	function woo_postnav() {
		if ( is_single() ) {
		?>
	        <div class="post-entries">
	            <div class="nav-prev fl"><?php previous_post_link( '%link', '<i class="fa fa-angle-left"></i><span  >'. __( ' Previous Post', 'woothemes' ) . '</span>' ) ?></div>
	            <div class="nav-next fr"><?php next_post_link( '%link', '<span >'. __( 'Next Post', 'woothemes' ) . '</span> <i class="fa fa-angle-right"></i>' ) ?></div>
	            <div class="fix"></div>
	        </div>

		<?php
		}
	}
}


/*-----------------------------------------------------------------------------------*/
/* WooTabs - Popular Posts */
/* See /includes/widgets/widget-woo-tabs.php */
/*-----------------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/* WooTabs - Latest Posts */
/* See /includes/widgets/widget-woo-tabs.php */
/*-----------------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/* WooTabs - Latest Comments */
/* See /includes/widgets/widget-woo-tabs.php */
/*-----------------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/* WordPress 3.0 New Features Support */
/*-----------------------------------------------------------------------------------*/

if ( function_exists('wp_nav_menu') ) {
	add_theme_support( 'nav-menus' );
	register_nav_menus( array( 'primary-menu' => __( 'Primary Menu', 'woothemes' ) ) );
	register_nav_menus( array( 'top-menu' => __( 'Top Menu', 'woothemes' ) ) );
	register_nav_menus( array( 'myaccount-menu' => __( 'My Account Menu', 'woothemes' ) ) );
}

/*-----------------------------------------------------------------------------------*/
/* Custom Post Type - Portfolio Item (Portfolio Component) */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_add_portfolio' ) ) {
	function woo_add_portfolio() {

		global $woo_options;

		// "Portfolio Item" Custom Post Type
		$labels = array(
			'name' => _x( 'Portfolio', 'post type general name', 'woothemes' ),
			'singular_name' => _x( 'Portfolio Item', 'post type singular name', 'woothemes' ),
			'add_new' => _x( 'Add New', 'slide', 'woothemes' ),
			'add_new_item' => __( 'Add New Portfolio Item', 'woothemes' ),
			'edit_item' => __( 'Edit Portfolio Item', 'woothemes' ),
			'new_item' => __( 'New Portfolio Item', 'woothemes' ),
			'view_item' => __( 'View Portfolio Item', 'woothemes' ),
			'search_items' => __( 'Search Portfolio Items', 'woothemes' ),
			'not_found' =>  __( 'No portfolio items found', 'woothemes' ),
			'not_found_in_trash' => __( 'No portfolio items found in Trash', 'woothemes' ),
			'parent_item_colon' => ''
		);

		$portfolioitems_rewrite = get_option( 'woo_portfolioitems_rewrite' );
 		if( empty( $portfolioitems_rewrite ) ) { $portfolioitems_rewrite = 'portfolio-items'; }

		$args = array(
			'labels' => $labels,
			'public' => true,
			'publicly_queryable' => true,
			'show_ui' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => $portfolioitems_rewrite ),
			'capability_type' => 'post',
			'hierarchical' => false,
			'menu_icon' => THEME_URI .'/includes/images/portfolio.png',
			'menu_position' => null,
			'has_archive' => true,
			'taxonomies' => array( 'portfolio-gallery' ),
			'supports' => array( 'title','editor','thumbnail' )
		);

		if ( isset( $woo_options['woo_portfolio_excludesearch'] ) && ( $woo_options['woo_portfolio_excludesearch'] == 'true' ) ) {
			$args['exclude_from_search'] = true;
		}

		register_post_type( 'portfolio', $args );

		// "Portfolio Galleries" Custom Taxonomy
		$labels = array(
			'name' => _x( 'Portfolio Galleries', 'taxonomy general name', 'woothemes' ),
			'singular_name' => _x( 'Portfolio Gallery', 'taxonomy singular name','woothemes' ),
			'search_items' =>  __( 'Search Portfolio Galleries', 'woothemes' ),
			'all_items' => __( 'All Portfolio Galleries', 'woothemes' ),
			'parent_item' => __( 'Parent Portfolio Gallery', 'woothemes' ),
			'parent_item_colon' => __( 'Parent Portfolio Gallery:', 'woothemes' ),
			'edit_item' => __( 'Edit Portfolio Gallery', 'woothemes' ),
			'update_item' => __( 'Update Portfolio Gallery', 'woothemes' ),
			'add_new_item' => __( 'Add New Portfolio Gallery', 'woothemes' ),
			'new_item_name' => __( 'New Portfolio Gallery Name', 'woothemes' ),
			'menu_name' => __( 'Portfolio Galleries', 'woothemes' )
		);

		$args = array(
			'hierarchical' => true,
			'labels' => $labels,
			'show_ui' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => 'portfolio-gallery' )
		);

		register_taxonomy( 'portfolio-gallery', array( 'portfolio' ), $args );
	}

	add_action( 'init', 'woo_add_portfolio' );
}

/*-----------------------------------------------------------------------------------*/
/* Featured Slider: Hook Into Content */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_featured_slider_loader' ) ) {
function woo_featured_slider_loader () {

	if ( is_page_template('template-home.php') ) {

		if ( get_post_meta( get_the_ID(), '_banner', true ) == 'true' ) {

			if ( get_post_meta( get_the_ID(), '_revolutionslider', true ) != '0' ) {

				if( class_exists('RevSlider') ) {
					putRevSlider( get_post_meta( get_the_ID(), '_revolutionslider', true ) );
				}

			} // end slidertype = revslider
	    }

	}

} // End woo_featured_slider_loader()
}

add_action( 'woo_content_before', 'woo_featured_slider_loader' );


/*-----------------------------------------------------------------------------------*/
/* Subscribe / Connect */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('woo_subscribe_connect')) {
	function woo_subscribe_connect($widget = 'false', $title = '', $form = '', $social = '') {

		//Setup default variables, overriding them if the "Theme Options" have been saved.
		$settings = array(
						'connect' => 'false',
						'connect_title' => __('Subscribe','woothemes'),
						'connect_related' => 'true',
						'connect_content' => __( 'Subscribe to our e-mail newsletter to receive updates.', 'woothemes' ),
						'connect_newsletter_id' => '',
						'connect_mailchimp_list_url' => '',
						'feed_url' => '',
						'connect_rss' => '',
						'connect_twitter' => '',
						'connect_facebook' => '',
						'connect_youtube' => '',
						'connect_flickr' => '',
						'connect_linkedin' => '',
						'connect_delicious' => '',
						'connect_rss' => '',
						'connect_googleplus' => '',
						'connect_dribbble' => '',
						'connect_instagram' => '',
						'connect_vimeo' => '',
						'connect_pinterest' => ''
						);
		$settings = woo_get_dynamic_values( $settings );

		$locale = get_locale();
		if ( '' == $locale )
			$locale = 'en_US';

		// Setup title
		if ( $widget != 'true' )
			$title = $settings[ 'connect_title' ];

		// Setup related post (not in widget)
		$related_posts = '';
		if ( $settings[ 'connect_related' ] == "true" AND $widget != "true" )
			$related_posts = do_shortcode( '[related_posts limit="5"]' );

?>
	<?php if ( $settings[ 'connect' ] == "true" OR $widget == 'true' ) : ?>
	<aside id="connect">
		<h3><?php if ( $title ) echo stripslashes( $title ); else _e('Subscribe','woothemes'); ?></h3>

		<div <?php if ( $related_posts != '' ) echo 'class="col-left"'; ?>>
			<p><?php if ( $settings['connect_content'] != '') echo stripslashes( $settings['connect_content'] ); else _e( 'Subscribe to our e-mail newsletter to receive updates.', 'woothemes' ); ?></p>

			<?php if ( $settings['connect_newsletter_id'] != "" AND $form != 'on' ) : ?>
			<form class="newsletter-form<?php if ( $related_posts == '' ) echo ' fl'; ?>" action="http://feedburner.google.com/fb/a/mailverify" method="post" target="popupwindow" onsubmit="window.open('http://feedburner.google.com/fb/a/mailverify?uri=<?php echo $settings['connect_newsletter_id']; ?>', 'popupwindow', 'scrollbars=yes,width=550,height=520');return true">
				<input class="email" type="text" name="email" value="<?php _e('E-mail','woothemes'); ?>" onfocus="if (this.value == '<?php _e('E-mail','woothemes'); ?>') {this.value = '';}" onblur="if (this.value == '') {this.value = '<?php _e('E-mail','woothemes'); ?>';}" />
				<input type="hidden" value="<?php echo $settings['connect_newsletter_id']; ?>" name="uri"/>
				<input type="hidden" value="<?php echo esc_attr( get_bloginfo('name') ); ?>" name="title"/>
				<input type="hidden" name="loc" value="en_US"/>
				<input class="submit button" type="submit" name="submit" value="<?php _e('Submit', 'woothemes'); ?>" />
			</form>
			<?php endif; ?>

			<?php if ( $settings['connect_mailchimp_list_url'] != "" AND $form != 'on' AND $settings['connect_newsletter_id'] == "" ) : ?>
			<!-- Begin MailChimp Signup Form -->
			<div id="mc_embed_signup">
				<form class="newsletter-form<?php if ( $related_posts == '' ) echo ' fl'; ?>" action="<?php echo $settings['connect_mailchimp_list_url']; ?>" method="post" target="popupwindow" onsubmit="window.open('<?php echo $settings['connect_mailchimp_list_url']; ?>', 'popupwindow', 'scrollbars=yes,width=650,height=520');return true">
					<input type="text" name="EMAIL" class="required email" value="<?php _e('E-mail','woothemes'); ?>"  id="mce-EMAIL" onfocus="if (this.value == '<?php _e('E-mail','woothemes'); ?>') {this.value = '';}" onblur="if (this.value == '') {this.value = '<?php _e('E-mail','woothemes'); ?>';}">
					<input type="submit" value="<?php _e('Submit', 'woothemes'); ?>" name="subscribe" id="mc-embedded-subscribe" class="btn submit button">
				</form>
			</div>
			<!--End mc_embed_signup-->
			<?php endif; ?>

			<?php if ( $social != 'on' ) : ?>
			<div class="social_widget<?php if ( $related_posts == '' AND $settings['connect_newsletter_id' ] != "" ) echo ' fr'; ?>">
		   		<?php if ( $settings['connect_rss' ] == "true" ) { ?>
		   		<a href="<?php if ( $settings['feed_url'] ) { echo esc_url( $settings['feed_url'] ); } else { echo get_bloginfo_rss('rss2_url'); } ?>" class="social_icon_medium" title="RSS"> <em class="ico-rss"></em> </a>

		   		<?php } if ( $settings['connect_twitter' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_twitter'] ); ?>" class="social_icon_medium" title="Twitter"><em class="ico-twitter"></em></a>

		   		<?php } if ( $settings['connect_facebook' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_facebook'] ); ?>" class="social_icon_medium" title="Facebook"><em class="ico-facebook"></em></a>

		   		<?php } if ( $settings['connect_youtube' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_youtube'] ); ?>" class="social_icon_medium" title="YouTube"><em class="ico-youtube"></em></a>

		   		<?php } if ( $settings['connect_flickr' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_flickr'] ); ?>" class="social_icon_medium" title="Flickr"><em class="ico-flickr"></em></a>

		   		<?php } if ( $settings['connect_linkedin' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_linkedin'] ); ?>" class="social_icon_medium" title="LinkedIn"><em class="ico-linkedin"></em></a>

		   		<?php } if ( $settings['connect_delicious' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_delicious'] ); ?>" class="social_icon_medium" title="Delicious"><em class="ico-delicious"></em></a>

		   		<?php } if ( $settings['connect_googleplus' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_googleplus'] ); ?>" class="social_icon_medium" title="Google+"><em class="ico-google-plus"></em></a>

				<?php } if ( $settings['connect_dribbble' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_dribbble'] ); ?>" class="social_icon_medium" title="Dribble"><em class="ico-dribble"></em></a>

				<?php } if ( $settings['connect_instagram' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_instagram'] ); ?>" class="social_icon_medium" title="Instagram"><em class="ico-instagram"></em></a>

				<?php } if ( $settings['connect_vimeo' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_vimeo'] ); ?>" class="social_icon_medium" title="Vimeo"><em class="ico-vimeo"></em></a>

				<?php } if ( $settings['connect_pinterest' ] != "" ) { ?>
		   		<a target="_blank" href="<?php echo esc_url( $settings['connect_pinterest'] ); ?>" class="social_icon_medium" title="Pinterest"><em class="ico-pinterest"></em></a>

				<?php } ?>
			</div>
			<?php endif; ?>

		</div><!-- col-left -->

		<?php if ( $settings['connect_related'] == "true" AND $related_posts != '' ) : ?>
		<div class="related-posts col-right">
			<h4><?php _e('Related Posts:', 'woothemes'); ?></h4>
			<?php echo $related_posts; ?>
		</div><!-- col-right -->
		<?php wp_reset_query(); endif; ?>

        <div class="fix"></div>
	</aside>
	<?php endif; ?>
<?php
	}
}
/*-----------------------------------------------------------------------------------*/
/* Archive Title */
/*-----------------------------------------------------------------------------------*/
/**
 * Archive Title
 *
 * The main page title, used on the various post archive templates.
 *
 * @since 4.0
 *
 * @param string $before Optional. Content to prepend to the title.
 * @param string $after Optional. Content to append to the title.
 * @param bool $echo Optional, default to true.Whether to display or return.
 * @return null|string Null on no title. String if $echo parameter is false.
 *
 * @package WooFramework
 * @subpackage Template
 */

 if ( ! function_exists( 'woo_archive_title' ) ) {

 	function woo_archive_title ( $before = '', $after = '', $echo = true ) {

 		global $wp_query;

 		if ( is_category() || is_tag() || is_tax() ) {

 			$taxonomy_obj = $wp_query->get_queried_object();
			$term_id = $taxonomy_obj->term_id;
			$taxonomy_short_name = $taxonomy_obj->taxonomy;

			$taxonomy_raw_obj = get_taxonomy( $taxonomy_short_name );

 		} // End IF Statement

		$title = '';
		$delimiter = ' | ';
		$date_format = get_option( 'date_format' );

		// Category Archive
		if ( is_category() ) {

			$title = '<span class="fl cat">' . __( 'Archive', 'woothemes' ) . $delimiter . single_cat_title( '', false ) . '</span> <span class="fr catrss">';
			$cat_obj = $wp_query->get_queried_object();
			$cat_id = $cat_obj->cat_ID;
			$title .= '<a href="' . get_term_feed_link( $term_id, $taxonomy_short_name, '' ) . '" class="fa fa-rss fa-large" ></a></span>';

			$has_title = true;
		}

		// Day Archive
		if ( is_day() ) {

			$title = __( 'Archive', 'woothemes' ) . $delimiter . get_the_time( $date_format );
		}

		// Month Archive
		if ( is_month() ) {

			$date_format = apply_filters( 'woo_archive_title_date_format', 'F, Y' );
			$title = __( 'Archive', 'woothemes' ) . $delimiter . get_the_time( $date_format );
		}

		// Year Archive
		if ( is_year() ) {

			$date_format = apply_filters( 'woo_archive_title_date_format', 'Y' );
			$title = __( 'Archive', 'woothemes' ) . $delimiter . get_the_time( $date_format );
		}

		// Author Archive
		if ( is_author() ) {

			$title = __( 'Author Archive', 'woothemes' ) . $delimiter . get_the_author_meta( 'display_name', get_query_var( 'author' ) );
		}

		// Tag Archive
		if ( is_tag() ) {

			$title = __( 'Tag Archives', 'woothemes' ) . $delimiter . single_tag_title( '', false );
		}

		// Post Type Archive
		if ( function_exists( 'is_post_type_archive' ) && is_post_type_archive() ) {

			/* Get the post type object. */
			$post_type_object = get_post_type_object( get_query_var( 'post_type' ) );

			$title = $post_type_object->labels->name . ' ' . __( 'Archive', 'woothemes' );
		}

		// Post Format Archive
		if ( get_query_var( 'taxonomy' ) == 'post_format' ) {

			$post_format = str_replace( 'post-format-', '', get_query_var( 'post_format' ) );

			$title = get_post_format_string( $post_format ) . ' ' . __( ' Archives', 'woothemes' );
		}

		// General Taxonomy Archive
		if ( is_tax() ) {

			$title = sprintf( __( '%1$s Archives: %2$s', 'woothemes' ), $taxonomy_raw_obj->labels->name, $taxonomy_obj->name );

		}

		if ( strlen($title) == 0 )
		return;

		$title = $before . $title . $after;

		// Allow for external filters to manipulate the title value.
		$title = apply_filters( 'woo_archive_title', $title, $before, $after );

		if ( $echo )
			echo $title;
		else
			return $title;

 	} // End woo_archive_title()

 } // End IF Statement

/*-----------------------------------------------------------------------------------*/
/* Get Post image attachments */
/*-----------------------------------------------------------------------------------*/
/*
Description:

This function will get all the attached post images that have been uploaded via the
WP post image upload and return them in an array.

*/
function woo_get_post_images($offset = 1) {

	// Arguments
	$repeat = 100; 				// Number of maximum attachments to get
	$photo_size = 'large';		// The WP "size" to use for the large image

	global $post;

	$output = array();

	$id = get_the_id();
	$attachments = get_children( array(
	'post_parent' => $id,
	'numberposts' => $repeat,
	'post_type' => 'attachment',
	'post_mime_type' => 'image',
	'order' => 'ASC',
	'orderby' => 'menu_order date' )
	);
	if ( !empty($attachments) ) :
		$output = array();
		$count = 0;
		foreach ( $attachments as $att_id => $attachment ) {
			$count++;
			if ($count <= $offset) continue;
			$url = wp_get_attachment_image_src($att_id, $photo_size, true);
				$output[] = array( 'url' => $url[0], 'caption' => $attachment->post_excerpt, 'id' => $att_id, 'alt' => get_post_meta( $att_id, '_wp_attachment_image_alt', true ) );
		}
	endif;
	return $output;
} // End woo_get_post_images()

/*-----------------------------------------------------------------------------------*/
/* Woo Portfolio Navigation */
/*-----------------------------------------------------------------------------------*/

	if ( ! function_exists( 'woo_portfolio_navigation' ) ) {
		function woo_portfolio_navigation ( $galleries ) {

			// Sanity check.
			if ( ! is_array( $galleries ) || ( count( $galleries ) <= 0 ) ) { return; }

			global $woo_options;

			$settings = array(
							'id' => 'port-tags',
							'display_all' => true
							 );

			$settings = apply_filters( 'woo_portfolio_navigation_args', $settings );

			// Prepare the anchor tags of the various gallery items.
			$gallery_anchors = '';

			foreach ( $galleries as $g ) {
				$gallery_anchors .= '<a href="#' . $g->slug . '" rel="' . $g->slug . '" class="navigation-slug-' . $g->slug . ' navigation-id-' . $g->term_id . '">' . $g->name . '</a>' . "\n";
			}

			$html = '<div id="' . $settings['id'] . '" class="port-tags">' . "\n";
				$html .= '<div class="fl">' . "\n";
					$html .= '<span class="port-cat">' . "\n";

					// Display label, if one is set.


					// Display "All", if set to "true".
					if ( $settings['display_all'] == 'all' ) { $html .= '<a href="#" rel="all" class="current">' . __( 'All', 'woothemes' ) . '</a> '; }

					// Add the gallery anchors in.
					$html .= $gallery_anchors;

					$html .= '</span>' . "\n";
				$html .= '</div><!--/.fl-->' . "\n";
				$html .= '<div class="fix"></div>' . "\n";
			$html .= '</div><!--/#' . $settings['id'] . ' .port-tags-->' . "\n";


			$html = apply_filters( 'woo_portfolio_navigation', $html );

			echo $html;

		} // End woo_portfolio_navigation()
	}
/*-----------------------------------------------------------------------------------*/
/* Woo blog Navigation */
/*-----------------------------------------------------------------------------------*/

	if ( ! function_exists( 'woo_blog_navigation' ) ) {
		function woo_blog_navigation ( $categories ) {

			// Sanity check.
			if ( ! is_array( $categories ) || ( count( $categories ) <= 0 ) ) { return; }

			global $woo_options;

			$settings = array(
							'id' => 'port-tags',
							'display_all' => true
							 );

			$categories = apply_filters( 'woo_blog_navigation_args', $categories );

			// Prepare the anchor tags of the various gallery items.
			$category_anchors = '';

			foreach ( $category as $c ) {
				$category_anchors .= '<a href="#' . $c->slug . '" rel="' . $c->slug . '" class="navigation-slug-' . $c->slug . ' navigation-id-' . $c->term_id . '">' . $c->name . '</a>' . "\n";
			}

			$html = '<div id="' . $settings['id'] . '" class="port-tags">' . "\n";
				$html .= '<div class="fl">' . "\n";
					$html .= '<span class="port-cat">' . "\n";

					// Display label, if one is set.


					// Display "All", if set to "true".
					if ( $settings['display_all'] == 'all' ) { $html .= '<a href="#" rel="all" class="current">' . __( 'All', 'woothemes' ) . '</a> '; }

					// Add the gallery anchors in.
					$html .= $category_anchors;

					$html .= '</span>' . "\n";
				$html .= '</div><!--/.fl-->' . "\n";
				$html .= '<div class="fix"></div>' . "\n";
			$html .= '</div><!--/#' . $settings['id'] . ' .port-tags-->' . "\n";


			$html = apply_filters( 'woo_blog_navigation', $html );

			echo $html;

		} // End woo_blog_navigation()
	}

	if ( ! function_exists( 'isotope_categories' ) ) {

  function isotope_categories() {

    $terms = get_terms('portfolio-gallery');

    $html = '<ul id="options">';
    $html .= '<li><a href="#" data-option-value="*" data-filter="*" class="selected">All</a></li>';

    foreach ($terms as $term) {


        $html .= "<li><a href='#' data-filter='.{$term->slug}'>{$term->name}</a></li>";
    }

    $html .= '</ul>';

    echo $html;
	}
}
/*-----------------------------------------------------------------------------------*/
/* Woo Portfolio Item Extras (Testimonial and Link) */
/*-----------------------------------------------------------------------------------*/

	if ( ! function_exists( 'woo_portfolio_item_extras' ) ) {
		function woo_portfolio_item_extras ( $data ) {
				global $post;
			$settings = array(
								'id' => 'extras',
								'display_button' => true
							 );

			// Allow child themes/plugins to filter these settings.
			$settings = apply_filters( 'woo_portfolio_item_extras_settings', $settings, $data );

			$html = '';

			$html .= '<div id="' . $settings['id'] . '">' . "\n";

			if (  isset($data['client_name'])  || isset($data['date_project'])  || isset($data['display_url']) ) {

				$html = '';
				$html .= '<h3 class="port_title">'. __( 'Details',  'woothemes' ) .'</h3>';

				if ( isset($data['client_name'])  ) {
					$html .= '<span><p class="first_text">'. __( 'Client', 'woothemes' ) .'</p><p class="second_text">  ' . $data['client_name'] . "\n";
					$html .= '</p></span>' . "\n";
				} // End IF Statement

				if (isset($data['date_project'])  ) {
					$html .= '<span><p class="first_text">'. __( 'Date', 'woothemes' ) .'</p><p class="second_text"> ' . $data['date_project'] . "\n";
					$html .= '</p></span>' . "\n";
				} // End IF Statement

				 $html .= '<span class="des_last"><p class="first_text">'. __( 'Category', 'woothemes' ) .'</p><p class="second_text"> '
				 		. get_the_term_list( $post->ID, 'portfolio-gallery', '')
				 		.'</p></span>';


				if ( isset($data['display_url']) ) {
					$html .= '<div class="clear"></div><a class="button" href="' . $data['display_url'] . '">'
						  . __( 'Launch Project', 'woothemes' ) . '</a>' . "\n";
				}

			}

   			$html .= '</div><!--/#extras-->' . "\n";

   			// Allow child themes/plugins to filter this HTML.
   			$html = apply_filters( 'woo_portfolio_item_extras_html', $html, $data );

   			echo $html;

		} // End woo_portfolio_item_extras()
	}

/*-----------------------------------------------------------------------------------*/
/* Woo Portfolio Item Settings */
/* @uses woo_portfolio_image_dimensions() */
/*-----------------------------------------------------------------------------------*/

 	if ( ! function_exists( 'woo_portfolio_item_settings' ) ) {
		function woo_portfolio_item_settings ( $id ) {

			global $woo_options;

			// Sanity check.
			if ( ! is_numeric( $id ) ) { return; }

			$website_layout = 'two-col-left';
			$website_width = '960px';

			if ( isset( $woo_options['woo_layout'] ) ) { $website_layout = $woo_options['woo_layout']; }
			if ( isset( $woo_options['woo_layout_width'] ) ) { $website_width = $woo_options['woo_layout_width']; }

			$dimensions = woo_portfolio_image_dimensions( $website_layout, $website_width );

			$width = $dimensions['width'];
			$height = $dimensions['height'];

			$enable_gallery = false;
			if ( isset( $woo_options['woo_portfolio_gallery'] ) ) { $enable_gallery = $woo_options['woo_portfolio_gallery']; }

			$settings = array(
								'large' => '',
								'caption' => '',
								'rel' => '',
								'gallery' => array(),
								'css_classes' => 'group post portfolio-img',
								'embed' => '',
								'enable_gallery' => $enable_gallery,
								'testimonial' => '',
								'testimonial_author' => '',
								'display_url' => '',
								'width' => $width,
								'height' => $height
							 );

			$meta = get_post_custom( $id );

			// Check if there is a gallery in post.
			// woo_get_post_images is offset by 1 by default. Setting to offset by 0 to show all images.

        	$large = '';
        	if ( isset( $meta['portfolio-image'][0] ) ) {
        		$large = $meta['portfolio-image'][0];
        	}

        	$caption = '';
        	$gallery = '';
        	if ( $settings['enable_gallery'] == 'true' ) {

	        	$gallery = woo_get_post_images( '0' );
	        	if ( $gallery ) {
	        		// Get first uploaded image in gallery
	        		$large = $gallery[0]['url'];
	        		$caption = $gallery[0]['caption'];
	            }

            } // End IF Statement

            // If we only have one image, disable the gallery functionality.
            if ( is_array( $gallery ) && ( count( $gallery ) <= 1 ) ) {
           		$settings['enable_gallery'] = 'false';
            }

            // Check for a post thumbnail, if support for it is enabled.
            if ( ( $woo_options['woo_post_image_support'] == 'true' ) && current_theme_supports( 'post-thumbnails' ) ) {
            	$image_id = get_post_thumbnail_id( $id );
            	if ( intval( $image_id ) > 0 ) {
            		$large_data = wp_get_attachment_image_src( $image_id, 'large' );
            		if ( is_array( $large_data ) ) {
            			$large = $large_data[0];
            		}
            	}
            }

            // See if lightbox-url custom field has a value
            if ( isset( $meta['lightbox-url'] ) && ( $meta['lightbox-url'][0] != '' ) ) {
            	$large = $meta['lightbox-url'][0];
            }

	        // Set rel on anchor to show lightbox
	        if ( is_array( $gallery ) && ( count( $gallery ) <= 1 ) ) {
	      		$rel = 'rel="lightbox"';
			} else {
		  		$rel = 'rel="lightbox['. $id .']"';
			}

			// Create CSS classes string.
			$css = '';
			$galleries = array();
			$terms = get_the_terms( $id, 'portfolio-gallery' );
			if ( is_array( $terms ) && ( count( $terms ) > 0 ) ) { foreach ( $terms as $t ) { $galleries[] = $t->slug; } }
			$css = join( ' ', $galleries );

			// If on the single item screen, check for a video.
			if ( is_singular() ) { $settings['embed'] = woo_embed( 'width=540' ); }

			// Add testimonial information.
			// if ( isset( $meta['testimonial'] ) && ( $meta['testimonial'][0] != '' ) ) {
			// 	$settings['testimonial'] = $meta['testimonial'][0];
			// }

			// if ( isset( $meta['testimonial_author'] ) && ( $meta['testimonial_author'][0] != '' ) ) {
			// 	$settings['testimonial_author'] = $meta['testimonial_author'][0];
			// }

			// Add name client information.
			if ( isset( $meta['client_name'] ) && ( $meta['client_name'][0] != '' ) ) {
				$settings['client_name'] = $meta['client_name'][0];
			}

			 // Add date information.
			if ( isset( $meta['date_project'] ) && ( $meta['date_project'][0] != '' ) ) {
				$settings['date_project'] = $meta['date_project'][0];
			}

			// Look for a custom display URL of the portfolio item (used if it's a website, for example)
			if ( isset( $meta['url'] ) && ( $meta['url'][0] != '' ) ) {
				$settings['display_url'] = $meta['url'][0];
			}

			// Assign the values we have to our array.
			$settings['large'] = $large;
			$settings['caption'] = $caption;
			$settings['rel'] = $rel;
			$settings['gallery'] = $gallery;
			$settings['css_classes'] .= ' ' . $css;

			// Disable "enable_gallery" option is gallery is empty.
			if ( ! is_array( $settings['gallery'] ) || ( $settings['gallery'] == '' ) || ( count( $settings['gallery'] ) <= 0 ) ) {
				$settings['enable_gallery'] = 'false';
			}

			// Allow child themes/plugins to filter these settings.
			$settings = apply_filters( 'woo_portfolio_item_settings', $settings, $id );

			return $settings;

		} // End woo_portfolio_item_settings()
	}
/*-----------------------------------------------------------------------------------*/
/* Woo Portfolio, show portfolio galleries in portfolio item breadcrumbs */
/* Modify woo_breadcrumbs() Arguments Specific to this Theme */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woo_portfolio_filter_breadcrumbs_args' ) ) {
add_filter( 'woo_breadcrumbs_args', 'woo_portfolio_filter_breadcrumbs_args', 10 );

	function woo_portfolio_filter_breadcrumbs_args( $args ) {

		$args['singular_portfolio_taxonomy'] = 'portfolio-gallery';

		return $args;

	} // End woo_portfolio_filter_breadcrumbs_args()
}

/*-----------------------------------------------------------------------------------*/
/* Woo Portfolio, change the "post more" content for portfolio items. */
/*-----------------------------------------------------------------------------------*/

add_filter( 'woo_post_more', 'woo_portfolio_post_more', 20 );

function woo_portfolio_post_more ( $content ) {

	global $post;

	$new_content = $content;

	if ( get_post_type() != 'portfolio' ) { return $new_content; } // Skip the functionality if it's not a portfolio item.

	$taxonomy = 'portfolio-gallery';

	$terms = get_the_terms( $post->ID, $taxonomy );
	$term_links = array();
	$term_text = '';

	if ( is_array( $terms ) && ( count( $terms ) > 0 ) ) {
		foreach ( $terms as $t ) {
			$term_links[] = '<a href="' . get_term_link( $t->slug, $taxonomy ) . '">' . $t->name . '</a>';
		}

		$term_text = join( ', ', $term_links );
	}

	if ( $term_text != '' ) { $new_content = __( 'Posted In ', 'woothemes' ) . $term_text; }

	return $new_content;

} // End woo_portfolio_post_more()

/*-----------------------------------------------------------------------------------*/
/* Woo Portfolio, change the "post meta" content for portfolio items. */
/*-----------------------------------------------------------------------------------*/

add_filter( 'woo_filter_post_meta', 'woo_portfolio_post_meta', 20 );

function woo_portfolio_post_meta ( $content ) {

	global $post;

	if ( get_post_type() != 'portfolio' ) { return $content; } // Skip the functionality if it's not a portfolio item.

	$taxonomy = 'portfolio-gallery';

	$terms = get_the_terms( $post->ID, $taxonomy );
	$term_links = array();
	$term_text = '';

	if ( is_array( $terms ) && ( count( $terms ) > 0 ) ) {
		foreach ( $terms as $t ) {
			$term_links[] = '<a href="' . get_term_link( $t->slug, $taxonomy ) . '">' . $t->name . '</a>';
		}

		$term_text = join( ', ', $term_links );
	}

	$post_info = '<span class="small">' . __( 'By', 'woothemes' ) . '</span> [post_author_posts_link] <span class="small">' . _x( 'on', 'post datetime', 'woothemes' ) . '</span> [post_date]';

	if ( $term_text != '' ) { $post_info .= ' <span class="small">' . __( 'in', 'woothemes' ) . '</span> ' . $term_text; }

	$content = sprintf( '<div class="post-meta">%s</div>' . "\n", apply_filters( 'woo_filter_portfolio_post_meta', $post_info ) );

	return $content;

} // End woo_portfolio_post_meta()

/*-----------------------------------------------------------------------------------*/
/* Woo Portfolio, get image dimensions based on layout and website width settings. */
/*-----------------------------------------------------------------------------------*/

function woo_portfolio_image_dimensions ( $layout = 'one-col', $width = '960' ) {
	$dimensions = array( 'width' => 520, 'height' => 0, 'thumb_width' => 150, 'thumb_height' => 150 );

	// One Column.
	if ( 'one-col' == $layout ) {
		$dimensions['width'] = intval( $width );
	}

	// Two Column.
	if ( 'two-col' == substr( $layout, 0, 7 ) ) {
		$dimensions['width'] = 800;
	}

	// Three Column.
	if ( 'three-col' == substr( $layout, 0, 9 ) ) {
		$dimensions['width'] = 680;
	}

	// Allow child themes/plugins to filter these dimensions.
	$dimensions = apply_filters( 'woo_portfolio_gallery_dimensions', $dimensions );

	return $dimensions;
} // End woo_post_gallery_dimensions()


/*-----------------------------------------------------------------------------------*/
/* Exclude categories from displaying on the "Blog" page template.
/*-----------------------------------------------------------------------------------*/

// Exclude categories on the "Blog" page template.
add_filter( 'woo_blog_template_query_args', 'woo_exclude_categories_blogtemplate', 10 );

function woo_exclude_categories_blogtemplate ( $args ) {

	if ( ! function_exists( 'woo_prepare_category_ids_from_option' ) ) { return $args; }

	$excluded_cats = array();

	// Process the category data and convert all categories to IDs.
	$excluded_cats = woo_prepare_category_ids_from_option( 'woo_exclude_cats_blog' );

	// Homepage logic.
	if ( count( $excluded_cats ) > 0 ) {

		// Setup the categories as a string, because "category__not_in" doesn't seem to work
		// when using query_posts().

		foreach ( $excluded_cats as $k => $v ) { $excluded_cats[$k] = '-' . $v; }
		$cats = join( ',', $excluded_cats );

		$args['cat'] = $cats;
	}

	return $args;

} // End woo_exclude_categories_blogtemplate()

/*-----------------------------------------------------------------------------------*/
/* Exclude categories from displaying on the homepage.
/*-----------------------------------------------------------------------------------*/

// Exclude categories on the homepage.
add_filter( 'pre_get_posts', 'woo_exclude_categories_homepage', 10 );

function woo_exclude_categories_homepage ( $query ) {
	if ( ! function_exists( 'woo_prepare_category_ids_from_option' ) ) { return $query; }

	$excluded_cats = array();

	// Process the category data and convert all categories to IDs.
	$excluded_cats = woo_prepare_category_ids_from_option( 'woo_exclude_cats_home' );

	// Homepage logic.
	if ( $query->is_home() && ( count( $excluded_cats ) > 0 ) ) {
		$query->set( 'category__not_in', $excluded_cats );
	}

	$query->parse_query();

	return $query;
} // End woo_exclude_categories_homepage()


/*-----------------------------------------------------------------------------------*/
/* Add Google Analytics to Header. */
/*-----------------------------------------------------------------------------------*/

remove_action('wp_footer','woo_analytics' );
add_action( 'wp_head','woo_dahz_analytics' );
function woo_dahz_analytics(){
	$output = get_option( 'woo_google_analytics' );
	if ( $output != '' )
		echo stripslashes( $output ) . "\n";
} // End woo_google_analytics()


/*-----------------------------------------------------------------------------------*/
/* Add custom CSS class to the <body> tag if the lightbox option is enabled. */
/*-----------------------------------------------------------------------------------*/

add_filter( 'body_class', 'woo_add_lightbox_body_class', 10 );

function woo_add_lightbox_body_class ( $classes ) {
	global $woo_options;

	if ( isset( $woo_options['woo_enable_lightbox'] ) && $woo_options['woo_enable_lightbox'] == 'true' ) {
		$classes[] = 'has-lightbox';
	}

	return $classes;
} // End woo_add_lightbox_body_class()

/*-----------------------------------------------------------------------------------*/
/* Load PrettyPhoto JavaScript and CSS if the lightbox option is enabled. */
/*-----------------------------------------------------------------------------------*/

add_action( 'woothemes_add_javascript', 'woo_load_prettyphoto', 10 );
add_action( 'woothemes_add_css', 'woo_load_prettyphoto', 10 );

function woo_load_prettyphoto () {
	global $woo_options;

	if ( ! isset( $woo_options['woo_enable_lightbox'] ) || $woo_options['woo_enable_lightbox'] == 'false' ) { return; }

	$filter = current_filter();

	switch ( $filter ) {
		case 'woothemes_add_javascript':
			wp_enqueue_script( 'prettyPhoto' );
		break;

		case 'woothemes_add_css':
			// wp_enqueue_style( 'prettyPhoto' );
		break;
	}
} // End woo_load_prettyphoto()

/*-----------------------------------------------------------------------------------*/
/* Google Maps */
/*-----------------------------------------------------------------------------------*/

function woo_maps_contact_output($args){

	$key = get_option('woo_maps_apikey');

	// No More API Key needed

	if ( !is_array($args) )
		parse_str( $args, $args );

	extract($args);
	$mode = '';
	$streetview = 'off';
	$map_height = get_option('woo_maps_single_height');
	$featured_w = get_option('woo_home_featured_w');
	$featured_h = get_option('woo_home_featured_h');
	$zoom = get_option('woo_maps_default_mapzoom');
	$type = get_option('woo_maps_default_maptype');
	$marker_title = get_option('woo_contact_title');
	if ( $zoom == '' ) { $zoom = 6; }
	$lang = get_option('woo_maps_directions_locale');
	$locale = '';
	if(!empty($lang)){
		$locale = ',locale :"'.$lang.'"';
	}
	$extra_params = ',{travelMode:G_TRAVEL_MODE_WALKING,avoidHighways:true '.$locale.'}';

	if(empty($map_height)) { $map_height = 250;}

	if(is_home() && !empty($featured_h) && !empty($featured_w)){
	?>
    <div id="single_map_canvas" style="width:<?php echo intval( $featured_w ); ?>px; height: <?php echo intval( $featured_h ); ?>px"></div>
    <?php } else { ?>
    <div id="single_map_canvas" style="width:100%; height: <?php echo $map_height; ?>px"></div>
    <?php } ?>
    <script src="<?php echo esc_attr( esc_url( get_template_directory_uri() . '/includes/js/markers.js' ) ); ?>" type="text/javascript"></script>
    <script type="text/javascript">
		jQuery(document).ready(function(){
			function initialize() {


			<?php if($streetview == 'on'){ ?>


			<?php } else { ?>

			  	<?php switch ($type) {
			  			case 'G_NORMAL_MAP':
			  				$type = 'ROADMAP';
			  				break;
			  			case 'G_SATELLITE_MAP':
			  				$type = 'SATELLITE';
			  				break;
			  			case 'G_HYBRID_MAP':
			  				$type = 'HYBRID';
			  				break;
			  			case 'G_PHYSICAL_MAP':
			  				$type = 'TERRAIN';
			  				break;
			  			default:
			  				$type = 'ROADMAP';
			  				break;
			  	} ?>

			  	var myLatlng = new google.maps.LatLng(<?php echo $geocoords; ?>);
				var myOptions = {
				  zoom: <?php echo $zoom; ?>,
				  center: myLatlng,
				<?php if(get_option('woo_maps_scroll') == 'true'){ ?>
				  scrollwheel: false,
			  	<?php } ?>
				  mapTypeId: google.maps.MapTypeId.<?php echo $type; ?>
				};
			  	var map = new google.maps.Map(document.getElementById( 'single_map_canvas' ),  myOptions);

				<?php if($mode == 'directions'){ ?>
			  	directionsPanel = document.getElementById("featured-route");
 				directions = new GDirections(map, directionsPanel);
  				directions.load("from: <?php echo esc_js( $from ); ?> to: <?php echo esc_js( $to ); ?>" <?php if($walking == 'on'){ echo $extra_params;} ?>);
			  	<?php
			 	} else { ?>

			  		var point = new google.maps.LatLng(<?php echo $geocoords; ?>);
	  				var root = "<?php echo esc_js( esc_url( get_template_directory_uri() ) ); ?>";
	  				var callout = '<?php echo preg_replace("/[\n\r]/","<br/>",get_option('woo_maps_callout_text')); ?>';
	  				var the_link = '<?php echo get_permalink(get_the_id()); ?>';
	  				<?php $title = str_replace(array('&#8220;','&#8221;'),'"', $marker_title); ?>
	  				<?php $title = str_replace('&#8211;','-',$title); ?>
	  				<?php $title = str_replace('&#8217;',"`",$title); ?>
	  				<?php $title = str_replace('&#038;','&',$title); ?>
	  				var the_title = '<?php echo html_entity_decode($title) ?>';

	  			<?php
			 	if(is_page()){
			 		$custom = get_option('woo_cat_custom_marker_pages');
					if(!empty($custom)){
						$color = $custom;
					}
					else {
						$color = get_option('woo_cat_colors_pages');
						if (empty($color)) {
							$color = 'red';
						}
					}
			 	?>
			 		var color = '<?php echo $color; ?>';
			 		createMarker(map,point,root,the_link,the_title,color,callout);
			 	<?php } else { ?>
			 		var color = '<?php echo get_option('woo_cat_colors_pages'); ?>';
	  				createMarker(map,point,root,the_link,the_title,color,callout);
				<?php
				}
					if(isset($_POST['woo_maps_directions_search'])){ ?>

					directionsPanel = document.getElementById("featured-route");
 					directions = new GDirections(map, directionsPanel);
  					directions.load("from: <?php echo htmlspecialchars($_POST['woo_maps_directions_search']); ?> to: <?php echo $address; ?>" <?php if($walking == 'on'){ echo $extra_params;} ?>);



					directionsDisplay = new google.maps.DirectionsRenderer();
					directionsDisplay.setMap(map);
    				directionsDisplay.setPanel(document.getElementById("featured-route"));

					<?php if($walking == 'on'){ ?>
					var travelmodesetting = google.maps.DirectionsTravelMode.WALKING;
					<?php } else { ?>
					var travelmodesetting = google.maps.DirectionsTravelMode.DRIVING;
					<?php } ?>
					var start = '<?php echo htmlspecialchars($_POST['woo_maps_directions_search']); ?>';
					var end = '<?php echo $address; ?>';
					var request = {
       					origin:start,
        				destination:end,
        				travelMode: travelmodesetting
    				};
    				directionsService.route(request, function(response, status) {
      					if (status == google.maps.DirectionsStatus.OK) {
        					directionsDisplay.setDirections(response);
      					}
      				});

  					<?php } ?>
				<?php } ?>
			<?php } ?>


			  }
			  function handleNoFlash(errorCode) {
				  if (errorCode == FLASH_UNAVAILABLE) {
					alert("Error: Flash doesn't appear to be supported by your browser");
					return;
				  }
				 }



		initialize();

		});
	jQuery(window).load(function(){

		var newHeight = jQuery('#featured-content').height();
		newHeight = newHeight - 5;
		if(newHeight > 300){
			jQuery('#single_map_canvas').height(newHeight);
		}

	});

	</script>

<?php
}

/*-----------------------------------------------------------------------------------*/
/* Add custom CSS class to the <body> tag if the boxed layout option is enabled. */
/*-----------------------------------------------------------------------------------*/

add_filter( 'body_class', 'woo_add_boxedlayout_body_class', 10 );

function woo_add_boxedlayout_body_class ( $classes ) {
	global $woo_options;

	if ( isset( $woo_options['woo_style_disable'] ) && $woo_options['woo_style_disable'] != 'true' && isset( $woo_options['woo_layout_boxed'] ) && $woo_options['woo_layout_boxed'] == 'true' ) {
		$classes[] = 'boxed-layout';
	}


	// if (  isset( $woo_options['woo_layout_boxed'] ) && $woo_options['woo_layout_boxed'] == 'true' ) {
	// 	$classes[] = 'boxed-layout';
	//    }

	return $classes;
} // End woo_add_boxedlayout_body_class()


/*-----------------------------------------------------------------------------------*/
/* Is IE */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'is_ie' ) ) {
	function is_ie ( $version = '6.0' ) {
		$supported_versions = array( '6.0', '7.0', '8.0', '9.0' );
		$agent = substr( $_SERVER['HTTP_USER_AGENT'], 25, 4 );
		$current_version = substr( $_SERVER['HTTP_USER_AGENT'], 30, 3 );
		$response = false;
		if ( in_array( $version, $supported_versions ) && 'MSIE' == $agent && ( $version == $current_version ) ) {
			$response = true;
		}

		return $response;
	} // End is_ie()
}

/*-----------------------------------------------------------------------------------*/
/* Check if WooCommerce is activated */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'is_woocommerce_activated' ) ) {
	function is_woocommerce_activated() {
		if ( class_exists( 'woocommerce' ) ) { return true; } else { return false; }
	}
}

/*-----------------------------------------------------------------------------------*/
/**
 * woo_archive_description()
 *
 * Display a description, if available, for the archive being viewed (category, tag, other taxonomy).
 *
 * @since V1.0.0
 * @uses do_atomic(), get_queried_object(), term_description()
 * @echo string
 * @filter woo_archive_description
 */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'woo_archive_description' ) ) {
	function woo_archive_description ( $echo = true ) {
		do_action( 'woo_archive_description' );

		// Archive Description, if one is available.
		$term_obj = get_queried_object();
		$description = term_description( $term_obj->term_id, $term_obj->taxonomy );

		if ( $description != '' ) {
			// Allow child themes/plugins to filter here ( 1: text in DIV and paragraph, 2: term object )
			$description = apply_filters( 'woo_archive_description', '<div class="archive-description">' . $description . '</div><!--/.archive-description-->', $term_obj );
		}

		if ( $echo != true ) { return $description; }

		echo $description;
	} // End woo_archive_description()
}

/*-----------------------------------------------------------------------------------*/
/* Add body class if Fixed Mobile width enabled */
/*-----------------------------------------------------------------------------------*/

add_filter( 'body_class', 'woo_add_fixed_mobile_class', 10 );

function woo_add_fixed_mobile_class ( $classes ) {
	global $woo_options;

	if ( isset( $woo_options['woo_remove_responsive'] ) && $woo_options['woo_remove_responsive'] == 'true' ) {
		$classes[] = 'fixed-mobile';
	}

	return $classes;
} // End woo_add_fixed_mobile_class()

/*-----------------------------------------------------------------------------------*/
/* Get a menu name */
/*-----------------------------------------------------------------------------------*/

function woo_get_menu_name( $location ){
    if( ! has_nav_menu( $location ) ) return false;
    $menus = get_nav_menu_locations();
    $menu_title = wp_get_nav_menu_object( $menus[$location] ) -> name;
    return $menu_title;
}

/*-----------------------------------------------------------------------------------*/
/* Word trim */
/*-----------------------------------------------------------------------------------*/
	function labomba_word_trim($string, $count, $ellipsis = FALSE){
		  $words = explode(' ', $string);
		  if (count($words) > $count){
			    array_splice($words, $count);
			    $string = implode(' ', $words);

				if (is_string($ellipsis)){
						$string .= $ellipsis;
			    }
			    elseif ($ellipsis){
						$string .= '&hellip;';
			    }
		  }
		  return $string;
	}
/*-----------------------------------------------------------------------------------*/
/* Adding Default Thumbnail Sizes for different areas of the website
/*-----------------------------------------------------------------------------------*/

if( function_exists( 'add_theme_support' ) ) {

			add_image_size( 'thumbnail-slider-blog', 980, 480, true );
			add_image_size( 'thumbnail-full-blog', 980, 400, true );
		    add_image_size( 'thumbnail-sc-blog', 900, 675, true );
			add_image_size( 'thumbnail-lookbook', 750, 1000, true );
			add_image_size( 'thumbnail-lookbook-land', 667,500, true );
			add_image_size( 'thumbnail-lookbook-sm', 94, 125, true );
			add_image_size( 'thumbnail-testimonial', 300, 300, true );
			add_image_size( 'thumbnail-ajax-search', 56, 56, true );



	}
/*-----------------------------------------------------------------------------------*/
/* Ajax search header */
/*-----------------------------------------------------------------------------------*/

add_action('wp_head','woo_labomba_custom_head');
function woo_labomba_custom_head()
{
    echo '<script type="text/javascript">var ajaxurl = \''.admin_url('admin-ajax.php').'\';</script>';
}


add_action('wp_ajax_ajax_search', 'ajax_search');
add_action('wp_ajax_nopriv_ajax_search', 'ajax_search');

function ajax_search()
{
	global $post;
global $woo_options;
    $s = $_POST['s'];

$args = array(

	's' => $s,
	'showposts' => -1,
	'suppress_filters' => 0
);
    $query = new WP_Query($args);
    if($query->have_posts()) :
if (is_woocommerce_activated()) {
	if (isset($woo_options['woo_search_blog_post']) && $woo_options['woo_search_blog_post'] == 'true')  {

    echo "<div class='search_que_post'>";
	}
  }
  else {
    echo "<div class='search_que_post2'>";

  }
 echo "<div class='divider_search'></div>";

    while ($query->have_posts()) : $query->the_post(); ?>

		<?php
		$post_type = get_post_type( $post->ID );

		if ( $post_type == 'post'){
	if (isset($woo_options['woo_search_blog_post']) && $woo_options['woo_search_blog_post'] == 'true')  {

			?>

	    	 <div id="result-<?php echo $post->ID; ?>"  class="resl">
	    	 	<?php if ( isset($woo_options['woo_search_thumb']) && $woo_options['woo_search_thumb'] == 'true'  ) {
		         if ( has_post_thumbnail()) : ?>
		            <a class="image_thum_post" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
		               <?php  the_post_thumbnail('thumbnail-ajax-search'); ?>

		            </a>
		        <?php endif;  } ?>
		        <?php if ( has_post_thumbnail()) {?>
		         <div class="content">
		        <?php } else{ ?>
		         <div class="content_no_thumb">

		        <?php } ?>
		       <p><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></p>
		        	<?php echo labomba_word_trim(get_the_excerpt(), '20', '...'); ?></div>
		    </div>
		    <div class="fix"></div>
		<?php } }?>

    <?php endwhile;
	if (isset($woo_options['woo_search_blog_post']) && $woo_options['woo_search_blog_post'] == 'true')  {

   	if( function_exists('icl_translate') ) {
   	 echo "<h1 class='counter_search'>".sprintf( _n( icl_translate('wpml','singular',' Result from blog'), icl_translate('wpml','plural',' Results from blog'), 'woothemes' ) )."</h1></div> ";
   	} else {

   	 echo "<h1 class='counter_search'>".sprintf( _n( ' Result from blog', ' Results from blog', 'woothemes' ) )."</h1></div> ";

   	}

	};
   else : ?>
    <div id="result-not-found">
        <h1 class="counter_search"> <?php _e('Your search did not match any post. Try different keyword.','woothemes'); ?> </h1>
    </div>
    <?php
    endif;

if (is_woocommerce_activated()) {


     if($query->have_posts()) :
	if (isset($woo_options['woo_search_blog_post']) && $woo_options['woo_search_blog_post'] == 'true')  {

    	echo "<div class='search_que_prod' >";
 echo "<div class='divider_search'></div>";
	}
	else {
    	echo "<div class='search_que_prod2' >";

	}

    while ($query->have_posts()) : $query->the_post(); ?>

		<?php
		$post_type = get_post_type( $post->ID );

		if ( $post_type == 'product'){ ?>
	    	 <div id="result-<?php echo $post->ID; ?>" class="resl" >
	    	 <?php if ( isset($woo_options['woo_search_thumb']) && $woo_options['woo_search_thumb'] == 'true'  ){
		            if ( has_post_thumbnail()) : ?>
		            <a class="image_thum_prod" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
                		<?php the_post_thumbnail('thumbnail-ajax-search'); ?>
     	            </a>
		     <?php endif; } ?>

		        <?php $content = wpautop( get_post_meta( get_the_ID(), '_product_extra_description', true ), true )  ?>
		         <?php if ( has_post_thumbnail()) {?>
		         <div class="content">
		        <?php } else{ ?>
		         <div class="content_no_thumb">

		        <?php } ?>
		        <p><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></p>

		        	<?php echo labomba_word_trim(do_shortcode($content), '20', '...'); ?></div>
		    </div>
		    <div class="fix"></div>

		<?php } ?>
    <?php endwhile;

    if( function_exists('icl_translate') ) {
   	 echo "<h1 class='counter_search'>".sprintf( _n( icl_translate('wpml','singular','Product Found'), icl_translate('wpml','plural',' Products Found'), 'woothemes' ) )."</h1></div> ";
   	} else {

   	 echo "<h1 class='counter_search'>".sprintf( _n( ' Product Found', ' Products Found', 'woothemes' ) )."</h1></div> ";

   	}

    endif;
 }
    die();
}

/*-----------------------------------------------------------------------------------*/
/* Custom Post Type - Size guide Item  */
/*-----------------------------------------------------------------------------------*/
if (is_woocommerce_activated()) {
if ( ! function_exists( 'woo_add_size' ) ) {
	add_action( 'init', 'woo_add_size' );

	function woo_add_size() {
// "Size" Custom Post Type
		$labels = array(
			'name' => _x( 'Size', 'post type general name', 'woothemes' ),
			'singular_name' => _x( 'Size Item', 'post type singular name', 'woothemes' ),
			'add_new' => _x( 'Add New', 'slide', 'woothemes' ),
			'add_new_item' => __( 'Add New Size Item', 'woothemes' ),
			'edit_item' => __( 'Edit Size Item', 'woothemes' ),
			'new_item' => __( 'New Size Item', 'woothemes' ),
			'view_item' => __( 'View Size Item', 'woothemes' ),
			'search_items' => __( 'Search Size Items', 'woothemes' ),
			'not_found' =>  __( 'No Size items found', 'woothemes' ),
			'not_found_in_trash' => __( 'No Size items found in Trash', 'woothemes' ),
			'parent_item_colon' => ''
		);
 			$sizeitems_rewrite = 'size-items';

		$args = array(
			'labels' => $labels,
			'public' => true,
			'publicly_queryable' => true,
			'show_ui' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => $sizeitems_rewrite ),
			'capability_type' => 'post',
			'hierarchical' => false,
		    'menu_icon' => THEME_URI .'/includes/images/size.png',
			'menu_position' => null,
			'has_archive' => true,
			'taxonomies' => array( 'size-guide' ),
			'supports' => array( 'title','editor','thumbnail' )
		);



		register_post_type( 'size', $args );

		// "Size Categories" Custom Taxonomy
		$labels = array(
			'name' => _x( 'Size Categories', 'taxonomy general name', 'woothemes' ),
			'singular_name' => _x( 'Size Category', 'taxonomy singular name','woothemes' ),
			'search_items' =>  __( 'Search Size Categories', 'woothemes' ),
			'all_items' => __( 'All Size Categories', 'woothemes' ),
			'parent_item' => __( 'Parent Size Category', 'woothemes' ),
			'parent_item_colon' => __( 'Parent Size Category:', 'woothemes' ),
			'edit_item' => __( 'Edit Size Category', 'woothemes' ),
			'update_item' => __( 'Update Size Category', 'woothemes' ),
			'add_new_item' => __( 'Add New Size Category', 'woothemes' ),
			'new_item_name' => __( 'New Size Category Name', 'woothemes' ),
			'menu_name' => __( 'Size Category', 'woothemes' )
		);

		$args = array(
			'hierarchical' => true,
			'labels' => $labels,
			'show_ui' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => 'size-category' )
		);

		register_taxonomy( 'size-category', array( 'size' ), $args );
	}
}
}
/*-----------------------------------------------------------------------------------*/
/* Editor Pick  */
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists('woo_labomba_editor_pic') ){
function woo_labomba_editor_pic()
{

	global $woo_options;
	 if ( $woo_options['woo_editor_pic_blog'] == 'true'){
	 	wp_reset_query();

	 	if (is_page_template('template-blog.php') || is_page_template('template-blogFull.php') || is_page_template('template-blogGrid.php') || is_page_template('template-blogGridMan.php')) {
	 		 ?>
	 		   <div class="swiper-container-editor-pic">

	 		 <?php
	        get_template_part('includes/editorPick');
	        ?>



  </div>

	        <?php
	 	}

    }

}
}
/*-----------------------------------------------------------------------------------*/
/* Custom Post Type - Lookbook  */
/*-----------------------------------------------------------------------------------*/
if (is_woocommerce_activated()) {
if ( ! function_exists( 'woo_add_lookbook' ) ) {
	add_action( 'init', 'woo_add_lookbook' );

	function woo_add_lookbook() {
// "Lookbook" Custom Post Type
		$labels = array(
			'name' => _x( 'Lookbook', 'post type general name', 'woothemes' ),
			'singular_name' => _x( 'Lookbook Item', 'post type singular name', 'woothemes' ),
			'add_new' => _x( 'Add New', 'slide', 'woothemes' ),
			'add_new_item' => __( 'Add New Lookbook Item', 'woothemes' ),
			'edit_item' => __( 'Edit Lookbook Item', 'woothemes' ),
			'new_item' => __( 'New Lookbook Item', 'woothemes' ),
			'view_item' => __( 'View Lookbook Item', 'woothemes' ),
			'search_items' => __( 'Search Lookbook Items', 'woothemes' ),
			'not_found' =>  __( 'No Lookbook items found', 'woothemes' ),
			'not_found_in_trash' => __( 'No Lookbook items found in Trash', 'woothemes' ),
			'parent_item_colon' => ''
		);

  $lookbook = 'lookbook-items';

		$args = array(
			'labels' => $labels,
			'public' => true,
			'publicly_queryable' => true,
			'show_ui' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => $lookbook ),
			'capability_type' => 'post',
			'hierarchical' => false,
			'menu_icon' => THEME_URI .'/includes/images/lookbook.png',
			'menu_position' => null,
			'has_archive' => true,
			'taxonomies' => array( 'lookbook-item' ),
			'supports' => array( 'title','editor','thumbnail' )
		);



		register_post_type( 'lookbook', $args );

		// "lookbook Categories" Custom Taxonomy
		$labels = array(
			'name' => _x( 'Lookbook Categories', 'taxonomy general name', 'woothemes' ),
			'singular_name' => _x( 'Lookbook Category', 'taxonomy singular name','woothemes' ),
			'search_items' =>  __( 'Search Lookbook Categories', 'woothemes' ),
			'all_items' => __( 'All Lookbook Categories', 'woothemes' ),
			'parent_item' => __( 'Parent Lookbook Category', 'woothemes' ),
			'parent_item_colon' => __( 'Parent Lookbook Category:', 'woothemes' ),
			'edit_item' => __( 'Edit Lookbook Category', 'woothemes' ),
			'update_item' => __( 'Update Lookbook Category', 'woothemes' ),
			'add_new_item' => __( 'Add New Lookbook Category', 'woothemes' ),
			'new_item_name' => __( 'New Lookbook Category Name', 'woothemes' ),
			'menu_name' => __( 'Lookbook Category', 'woothemes' )
		);

		$args = array(
			'hierarchical' => true,
			'labels' => $labels,
			'show_ui' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => 'lookbook-category' )
		);

		register_taxonomy( 'lookbook-category', array( 'lookbook' ), $args );
		}
	}
}


function woo_custom_get_the_author() {
	?>

<div class="author_single_post">


		<div id="author-profile">
		<div class="auth-img">
		<?php
		            global $post;
		            $author_id=$post->post_author;
		            ?>
		<a  href="<?php echo get_author_posts_url(get_the_author_meta( 'ID' )); ?>">
		<?php echo get_avatar( $author_id, '40' ); ?>
		</a>
		</div>
		<div class="auth-des ">
				 <h3 class="blog-title"> <?php _e('About The ', 'woothemes');?><a  href="<?php echo get_author_posts_url(get_the_author_meta( 'ID' )); ?>"><?php echo get_the_author_meta( 'display_name', $author_id ); /* the_author_posts_link();*/ ?></a> </h3>
				<p itemprop="description" ><?php echo labomba_word_trim(get_the_author_meta( 'description' ),30,' ...'); ?></p>



		</div>
	</div>
</div><!-- end of div -->
<?php }


/*-----------------------------------------------------------------------------------*/
// Adding walker nav menu for mega menu
/*-----------------------------------------------------------------------------------*/

require_once 'headers/custom-menu.class.php' ;

function df_navbar_menu( $data = array() ) {
	$defaults = array(
		'menu_wraper' 		=> '<ul id="%MENU_ID%">%MENU_ITEMS%</ul>',
		'menu_items'		=> '<li class="testing %ITEM_CLASS%"><a href="%ITEM_HREF%" title="%ESC_ITEM_TITLE%">%ITEM_TITLE%</a>%SUBMENU%</li>',
		'submenu' 			=> '<div style="visibility: hidden; display: block;"><ul>%ITEM%</ul><i></i></div>',
		'parent_clicable'	=> true,
		'params'			=> array( 'act_class' => 'act' ),
		'force_fallback'	=> false,
		//'fallback_cb'		=> 'dt_page_menu',
		'fallback_cb'       => 'wp_page_menu',
		'echo'				=> true,
		'location'			=> 'primary-menu'
	);

	$options = wp_parse_args( $data, $defaults );

	$options['menu_wraper'] = str_replace(
		array(
			'%MENU_ID%',
			'%MENU_CLASS%',
			'%MENU_ITEMS%'
		),
		array(
			'%1$s',
			'%2$s',
			'%3$s'
		),
		$options['menu_wraper']
	);

	$options['menu_items'] = explode( '%SUBMENU%', $options['menu_items'] );
	$options['submenu'] = explode( '%ITEM%', $options['submenu'] );

	$options = apply_filters( 'df_navbar_menu_options', $options );

	$theme_location = $options['location'];
	$parent_clicable = apply_filters( 'df_navbar_menu-parent_clicable', $options['parent_clicable'] );

	$args = array(
		'container'				=> false,
		'menu_id'				=> 'mainmenu',
		//'fallback_cb'			=> $options['fallback_cb'],
		'theme_location'		=> $theme_location,
		'parent_clicable'		=> $parent_clicable,
		'menu_class'			=> false,
		'container_class'		=> false,
		'df_has_nav_menu'		=> has_nav_menu( $theme_location ),
		'df_item_wrap_start'	=> $options['menu_items'][0],
		'df_item_wrap_end'		=> $options['menu_items'][1],
		'df_submenu_wrap_start'	=> $options['submenu'][0],
		'df_submenu_wrap_end'	=> $options['submenu'][1],
		'items_wrap'			=> $options['menu_wraper'],
		'please_be_fat'			=> true
	);

	$args = array_merge( $args, $options['params'] );

	if ( $args['df_has_nav_menu'] ) {
		$walker_args = array(
			'theme_location' 	=> $theme_location,
			'parent_clicable' 	=> $parent_clicable
		);

		$args['walker'] = new Df_Walker_Nav_Menu( $walker_args );
	}

	return wp_nav_menu( $args );
}
/*------------------------------------------------------------------------------------ */
/* Page Loader                                                                         */
/* ----------------------------------------------------------------------------------- */
if(!function_exists('df_loading_spinners')) {
    function df_loading_spinners($return = false) {
    	global $woo_options;

        $loading_animation = $woo_options['woo_page_loader_animation'];
        $loading_animation_style = $woo_options['woo_page_loader_type'];

        if($loading_animation){
            switch ($loading_animation_style) {
                case "pulse":
                    $spinner_html = df_loading_spinner_pulse();
                break;
                case "double_pulse":
                    $spinner_html =  df_loading_spinner_double_pulse();
                break;
                case "cube":
                    $spinner_html =  df_loading_spinner_cube();
                break;
                case "rotating_cubes":
                    $spinner_html =  df_loading_spinner_rotating_cubes();
                break;
                case "stripes":
                    $spinner_html =  df_loading_spinner_stripes();
                break;
                case "wave":
                    $spinner_html =  df_loading_spinner_wave();
                break;
                case "two_rotating_circles":
                    $spinner_html =  df_loading_spinner_two_rotating_circles();
                break;
                case "five_rotating_circles":
                    $spinner_html =  df_loading_spinner_five_rotating_circles();
                break;
            }
        }else{
            $spinner_html = df_loading_spinner_pulse();
        }

        if($return === true) {
            return $spinner_html;
        }

        echo $spinner_html;
    }
}

if(!function_exists('df_loading_spinner_pulse')) {
    function df_loading_spinner_pulse() {
    	global $woo_options;
        $loading_animation_image = $woo_options['woo_page_loader_type_color'];

        $html = '';
        $html .= '<div class="pulse" style="background-color:'.$loading_animation_image.'"></div>';
        return $html;
    }
}

if(!function_exists('df_loading_spinner_double_pulse')) {
    function df_loading_spinner_double_pulse() {
    	global $woo_options;
        $loading_animation_image = $woo_options['woo_page_loader_type_color'];
        $html = '';
        $html .= '<div class="double_pulse">';
        $html .= '<div class="double-bounce1" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="double-bounce2" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '</div>';

        return $html;
    }
}

if(!function_exists('df_loading_spinner_cube')) {
    function df_loading_spinner_cube() {
    	global $woo_options;
        $loading_animation_image = $woo_options['woo_page_loader_type_color'];
        $html = '';
        $html .= '<div class="cube" style="background-color:'.$loading_animation_image.'"></div>';
        return $html;
    }
}

if(!function_exists('df_loading_spinner_rotating_cubes')) {
    function df_loading_spinner_rotating_cubes() {
    	global $woo_options;
        $loading_animation_image = $woo_options['woo_page_loader_type_color'];
        $html = '';
        $html .= '<div class="rotating_cubes">';
        $html .= '<div class="cube1" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="cube2" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '</div>';

        return $html;
    }
}

if(!function_exists('df_loading_spinner_stripes')) {
    function df_loading_spinner_stripes() {
    	global $woo_options;
        $loading_animation_image = $woo_options['woo_page_loader_type_color'];
        $html = '';
        $html .= '<div class="stripes">';
        $html .= '<div class="rect1" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="rect2" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="rect3" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="rect4" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="rect5" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '</div>';
        return $html;
    }
}

if(!function_exists('df_loading_spinner_wave')) {
    function df_loading_spinner_wave() {
    	global $woo_options;
        $loading_animation_image = $woo_options['woo_page_loader_type_color'];
        $html = '';
        $html .= '<div class="wave">';
        $html .= '<div class="bounce1" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="bounce2" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="bounce3" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '</div>';

        return $html;
    }
}

if(!function_exists('df_loading_spinner_two_rotating_circles')) {
    function df_loading_spinner_two_rotating_circles() {
    	global $woo_options;
        $loading_animation_image = $woo_options['woo_page_loader_type_color'];
        $html = '';
        $html .= '<div class="two_rotating_circles">';
        $html .= '<div class="dot1" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="dot2" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '</div>';

        return $html;
    }
}

if(!function_exists('df_loading_spinner_five_rotating_circles')) {
    function df_loading_spinner_five_rotating_circles() {
    	global $woo_options;
        $loading_animation_image = $woo_options['woo_page_loader_type_color'];
        $html = '';
        $html .= '<div class="five_rotating_circles">';
        $html .= '<div class="spinner-container container1">';
        $html .= '<div class="circle1" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="circle2" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="circle3" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="circle4" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '</div>';
        $html .= '<div class="spinner-container container2">';
        $html .= '<div class="circle1" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="circle2" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="circle3" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="circle4" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '</div>';
        $html .= '<div class="spinner-container container3">';
        $html .= '<div class="circle1" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="circle2" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="circle3" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '<div class="circle4" style="background-color:'.$loading_animation_image.'"></div>';
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }
}
/*-----------------------------------------------------------------------------------*/
// Plugins activation
/*-----------------------------------------------------------------------------------*/

require_once 'plugins/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'woo_labomba_register_required_plugins' );

if( !function_exists('woo_labomba_register_required_plugins') ) :
	function woo_labomba_register_required_plugins() {
		$plugins = array(
			array(
				'name'     				=> 'Visual Composer Page Builder', // The plugin name
				'slug'     				=> 'js_composer', // The plugin slug (typically the folder name)
				'source'   				=> THEME_URI . '/includes/plugins/js_composer.zip', // The plugin source
				'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> true, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     				=> 'Dahz DF Shortcodes', // The plugin name
				'slug'     				=> 'df-shortcodes', // The plugin slug (typically the folder name)
				'source'   				=> THEME_URI . '/includes/plugins/df-shortcodes.zip', // The plugin source
				'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> true, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     				=> 'Revolution Slider', // The plugin name
				'slug'     				=> 'revslider', // The plugin slug (typically the folder name)
				'source'   				=> THEME_URI . '/includes/plugins/revslider.zip', // The plugin source
				'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> true, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     				=> 'Sidebar Generator', // The plugin name
				'slug'     				=> 'sidebar-generator', // The plugin slug (typically the folder name)
				'source'   				=> THEME_URI . '/includes/plugins/sidebar-generator.zip', // The plugin source
				'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> true, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     				=> 'The Instagram Feed', // The plugin name
				'slug'     				=> 'instagram-feed', // The plugin slug (typically the folder name)
				'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'     				=> 'Twitter Stream', // The plugin name
				'slug'     				=> 'twitter-stream', // The plugin slug (typically the folder name)
				'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'     				=> 'Contact Form 7', // The plugin name
				'slug'     				=> 'contact-form-7', // The plugin slug (typically the folder name)
				'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'     				=> 'WooCommerce', // The plugin name
				'slug'     				=> 'woocommerce', // The plugin slug (typically the folder name)
				'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'     				=> 'Yith WooCommerce Wishlist', // The plugin name
				'slug'     				=> 'yith-woocommerce-wishlist', // The plugin slug (typically the folder name)
				'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'     				=> 'Nextend Facebook Connect', // The plugin name
				'slug'     				=> 'nextend-facebook-connect', // The plugin slug (typically the folder name)
				'required' 				=> false // If false, the plugin is only 'recommended' instead of required
			)

		);

		// Change this to your theme text domain, used for internationalising strings
		//$theme_text_domain = woothemes;

		/**
		 * Array of configuration settings. Amend each line as needed.
		 * If you want the default strings to be available under your own theme domain,
		 * leave the strings uncommented.
		 * Some of the strings are added into a sprintf, so see the comments at the
		 * end of each line for what each argument will be.
		 */
		$config = array(
			//'domain'       		=> $theme_text_domain,         	// Text domain - likely want to be the same as your theme.
			'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
			'parent_slug' 		=> 'themes.php', 				// Default parent menu slug
			'menu'         		=> 'install-required-plugins', 	// Menu slug
			'has_notices'      	=> true,                       	// Show admin notices or not
			'is_automatic'    	=> false,					   	// Automatically activate plugins after installation or not
			'message' 			=> '',							// Message to output right before the plugins table
			'strings'      		=> array(
				'page_title'                      => __( 'Install Required Plugins', 'woothemes' ),
				'menu_title'                      => __( 'Install Plugins', 'woothemes' ),
				'installing'                      => __( 'Installing Plugin: %s', 'woothemes' ), // %1$s = plugin name
				'oops'                            => __( 'Something went wrong with the plugin API.', 'woothemes' ),
				'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ), // %1$s = plugin name(s)
				'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_install'  		  => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s)
				'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
				'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_activate' 		  => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s)
				'notice_ask_to_update' 			  => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_update' 			  => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s)
				'install_link' 					  => _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
				'activate_link' 				  => _n_noop( 'Activate installed plugin', 'Activate installed plugins' ),
				'return'                          => __( 'Return to Required Plugins Installer', 'woothemes' ),
				'plugin_activated'                => __( 'Plugin activated successfully.', 'woothemes'),
				'complete' 						  => __( 'All plugins installed and activated successfully. %s', 'woothemes'), // %1$s = dashboard link
				'nag_type'						  => 'updated' // Determines admin notice type - can only be 'updated' or 'error'
		) );

		tgmpa( $plugins, $config );
	}

endif;

define( 'RWMB_URL', trailingslashit( THEME_URI . '/includes/meta-box' ) );
define( 'RWMB_DIR', trailingslashit( trailingslashit( dirname( __FILE__ ) ) . 'meta-box' ) );


require_once RWMB_DIR . 'meta-box.php';
require_once RWMB_DIR . 'config-meta-boxes.php';



/*-----------------------------------------------------------------------------------*/
/* END 																				 */
/*-----------------------------------------------------------------------------------*/