<?php

/********* Starting category Widget for Sidebar *********/

class Category_Widget extends WP_Widget {

	function Category_Widget(){
	  		$widget_ops = array( 'classname' => 'Category_Widget', 'description' => __('Show List of category.', 'woothemes'));
			WP_Widget::__construct( 'category', __('LaBomba: Display Category Product WooCommerce', 'woothemes'), $widget_ops );
	}

/********* Starting category Widget Function *********/

	function widget($args,  $instance)
	{
		extract($args);

		$title = apply_filters('widget_title', $instance['title']);
		if ( empty($title) ) {
				$title = '';
		}
		$parent =  $instance['parent'];
		if ( empty($parent) ) {
				$parent = '';
		}

		$args = wp_list_categories('taxonomy=product_cat&hide_empty=0&hierarchical=true&orderby=id&show_count=0&title_li=&use_desc_for_title=1&child_of='. $parent.'&echo=0');



	echo $before_widget;
			echo '<h3>';
					echo $title;
			echo '</h3>';



		echo   '
   <div class="category-acc">
					';
		echo $args;
		echo		'</div>
				 <!-- end of widget -->';
	echo $after_widget;
	}


/********* Starting category Widget Admin Form *********/

	function form($instance)
	{
		$instance = wp_parse_args( (array) $instance, array(
			'title' => 'Category',
			'parent' => '',
		 ) );

        $title= esc_attr($instance['title']);
        $parent= esc_attr($instance['parent']);

		?>
			<p>
	            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title', 'woothemes'); ?></label>
	            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>"  value="<?php echo $instance['title']; ?>" />
	        </p>
	        <p>
	            <label for="<?php echo $this->get_field_id('parent'); ?>"><?php _e('ID Parent Category', 'woothemes'); ?></label>
	            <input class="widefat" id="<?php echo $this->get_field_id('parent'); ?>" name="<?php echo $this->get_field_name('parent'); ?>" type="text" value="<?php echo $parent; ?>" />
	       		 <label for="<?php echo $this->get_field_id('parent'); ?>"><?php _e('( leave the blank if you want to show all category )', 'woothemes'); ?></label>
	       	 </p>
		<?php
	}

/********* Starting category Widget Update Function *********/

	function update($new_instance, $old_instance)
	{
        $instance=$old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['parent'] = strip_tags($new_instance['parent']);

        return $instance;

    }

}

if(is_woocommerce_activated()){
register_widget( 'Category_Widget' );
}