<?php
/*====================================================================================
 TABLE OF CONTENTS - WOOCOMMERCE-MOD/WC-CONTENT-PRODUCT.PHP
 =====================================================================================
 - Remove WC sidebar
 - WooCommerce layout overrides
 - Add the WC sidebar in the right place
 =====================================================================================*/

// Remove WC sidebar
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );

/* -----------------------------------------------------------------------------------------
* WooCommerce layout overrides
--------------------------------------------------------------------------------------------*/
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

if ( ! function_exists( 'woocommerce_canvas_before_content' ) ) {
	// WooCommerce layout overrides
	function woocommerce_canvas_before_content() {
		global $woo_options;
		$columns = ( ! isset( $woo_options['woocommerce_products_per_column'] ) && ( is_shop() || is_product_category() || is_product_tag() ) )
			 				?  'woocommerce-columns-3' :  (isset( $woo_options['woocommerce_products_per_column'] ) && ( is_shop()  || is_product_category() || is_product_tag() ) )
			 					? 'woocommerce-columns-' . ( $woo_options['woocommerce_products_per_column'] ) : '';

	?>
		<!-- #content Starts -->
		<?php woo_content_before(); ?>
	    <div id="content" class="col-full <?php echo esc_attr( $columns ); ?>">

	    	<div id="main-sidebar-container">

	            <!-- #main Starts -->
	            <?php woo_main_before(); ?>
	            <section id="main-shop" class="col-left">
	    <?php
	}
}
	add_action( 'woocommerce_before_main_content', 'woocommerce_canvas_before_content', 10 );

if ( ! function_exists( 'woocommerce_canvas_after_content' ) ) {
	// WooCommerce layout overrides
	function woocommerce_canvas_after_content() {
	?>
				</section><!-- /#main -->
	            <?php woo_main_after(); ?>

			</div><!-- /#main-sidebar-container -->

	    </div><!-- /#content -->
		<?php woo_content_after(); ?>
	    <?php
	}
}
	add_action( 'woocommerce_after_main_content', 'woocommerce_canvas_after_content', 20 );

/* -----------------------------------------------------------------------------------------
* Add the WC sidebar in the right place
--------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'woocommerce_get_sidebar' ) ) {

	function woocommerce_get_sidebar() {

		global $woo_options;

		if ( is_shop() || is_product_category() || is_product_tag() ) {
			get_sidebar('shop');
		}

		// Display the sidebar if full width option is disabled on product pages
		if ( is_product() ) {
		if ( isset($woo_options[ 'woocommerce_products_fullwidth' ]) && $woo_options[ 'woocommerce_products_fullwidth' ] == "true" ) :
			get_sidebar('shop');
		endif;
		}

	}
	add_action( 'woo_main_after', 'woocommerce_get_sidebar', 10 );
}

/*-------------------------------------------------------------------------------------------*/
/* BREADCRUMB */
/*-------------------------------------------------------------------------------------------*/

// Remove WC breadcrumb (we're using the WooFramework breadcrumb)
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);


remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
add_action('woocommerce_after_main_content', 'woocommerce_result_count', 01, 0);

if ( ! function_exists( 'woocommerceframework_add_search_fragment' ) ) {
	function woocommerceframework_add_search_fragment ( $settings ) {
		$settings['add_fragment'] = '&post_type=product';
		return $settings;
	} // End woocommerceframework_add_search_fragment()
}

add_filter( 'loop_shop_columns', 'wooframework_loop_columns' );
if ( ! function_exists( 'wooframework_loop_columns' ) ) {
	// Change columns in product loop to 3
	function wooframework_loop_columns() {
		global $woo_options;
		if( ! isset( $woo_options['woocommerce_products_per_column'] ) ){
			$cols = 3;
		} else {
		  	 $cols = $woo_options['woocommerce_products_per_column'];
		}
		return $cols;
	}

}


// Remove pagination - we're using WF pagination.
add_action( 'woocommerce_before_shop_loop','woocommerce_pagination', 35 );

// Number of products per page

add_filter('loop_shop_per_page', 'wooframework_products_per_page', 20);
if (!function_exists('wooframework_products_per_page')) {
	function wooframework_products_per_page() {
		global $woo_options;
	if( isset( $_GET['show_products'] ) ){
		if ($_GET['show_products'] === "all") {
			 return -1;
	    } else {
	    	return $_GET['show_products'];
	    }
	} else {
		if ( isset( $woo_options['woocommerce_products_per_page'] ) ) {
			return $woo_options['woocommerce_products_per_page'];
		}
	}
		}
}

function woocommerce_show_all_products(){
	global $woocommerce, $wp_query;
	if ( ! woocommerce_products_will_display() ) return;

	$per_page = $wp_query->get( 'posts_per_page' );
	$total   = $wp_query->found_posts;

if($total > $per_page):
	if(!is_paged()):
?>
<span><a class="show-all-products" href="?show_products=<?php echo $total;?>"><?php _e("View All", "woothemes"); ?></a></span>
<?php else: ?>
<span><a class="show-all-products" href="../../?show_products=<?php echo $total;?>"><?php _e("View All", "woothemes"); ?></a></span>
<?php
	endif;

endif;
}
add_action('woocommerce_before_shop_loop', 'woocommerce_show_all_products', 31);

function woocommerce_before_pagination(){
	echo '<nav class="woocommerce-pagination">';
}
function woocommerce_after_pagination(){
	echo '</nav>';
}
add_action('woocommerce_before_shop_loop','woocommerce_before_pagination',30 );
add_action('woocommerce_before_shop_loop','woocommerce_after_pagination',40 );

// Fix sidebar on shop page
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );

/* -----------------------------------------------------------------------------------------
* Custom image placeholder
--------------------------------------------------------------------------------------------*/
add_filter( 'woocommerce_placeholder_img_src', 'wooframework_wc_placeholder_img_src' );

if ( ! function_exists( 'wooframework_wc_placeholder_img_src' ) ) {
	function wooframework_wc_placeholder_img_src( $src ) {
		$settings = array( 'placeholder_url' => get_template_directory_uri() . '/images/wc-placeholder-cart.gif' );
		$settings = woo_get_dynamic_values( $settings );

		return esc_url( $settings['placeholder_url'] );
	} // End wooframework_wc_placeholder_img_src()
}