<?php
if ( ! defined( 'ABSPATH' ) ) exit;
/*====================================================================================
 TABLE OF CONTENTS - WOOCOMMERCE-MOD/WC-EXTRA.PHP
 =====================================================================================
 - WooCommerce Star Sidebar
 - WooCommerce Star Reviews
 - WooCommerce Checkout
 - Catalog Image Hover
 - Wishlists Topbar
 - Wishlists button
 =====================================================================================*/
remove_action( 'woocommerce_checkout_order_review', 'woocommerce_checkout_payment', 20 );
add_action( 'dahzcommerce_checkout_payment_method', 'woocommerce_checkout_payment', 10 );

if ( ! function_exists( 'woostore_star_sidebar' ) ) {
	// Adjust the star rating in the sidebar
	add_filter( 'woocommerce_star_rating_size_sidebar', 'woostore_star_sidebar' );

	function woostore_star_sidebar() {
		return 12;
	}
}

if ( ! function_exists( 'woostore_star_reviews' ) ) {
	// Adjust the star rating in the recent reviews
	add_filter( 'woocommerce_star_rating_size_recent_reviews', 'woostore_star_reviews' );

	function woostore_star_reviews() {
		return 12;
	}
}

if ( ! function_exists( 'woo_add_nav_cart_link' ) ) {
/**
 * Optionally display a header cart link next to the navigation menu.
 * @since  5.1.0
 * @return void
 */
function woo_add_nav_cart_link () {
	global $woocommerce;
	$settings = array( 'header_cart_link' => 'false', 'nav_rss' => 'false', 'header_cart_total' => 'false' );
	$settings = woo_get_dynamic_values( $settings );

	$class = 'cart fr';
	if ( 'false' == $settings['nav_rss'] ) { $class .= ' no-rss-link'; }
	if ( is_woocommerce_activated() && 'true' == $settings['header_cart_link'] ) { ?>
    	<ul class="<?php echo esc_attr( $class ); ?>">
    		<li class="container">
    			<a href="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>" class="view-cart"><span><?php _e('My Cart', 'woothemes'); ?></span></a>
    			<?php if ( 'true' == $settings['header_cart_total'] ) : ?>
    			<a class="cart-contents" href="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'woothemes' ); ?>">
    				<?php echo sprintf( _n('%d item', '%d items', WC()->cart->cart_contents_count, 'woothemes' ), WC()->cart->cart_contents_count );?> - <?php echo WC()->cart->get_cart_total(); ?>
    			</a> 
 				<?php endif; ?>
       			 <?php $cart_widget = new Woo_WooCommerce_Widget_Cart(); $cart_widget->widget(); ?>
    		</li>
   		</ul>
    <?php }
} // End woo_add_nav_cart_link()
}

add_action( 'woo_top_bar_content', 'woo_add_nav_cart_link', 10);

// Ensure cart contents update when products are added to the cart via AJAX
add_filter( 'add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );

if ( ! function_exists( 'woocommerce_header_add_to_cart_fragment' ) ) {
	function woocommerce_header_add_to_cart_fragment( $fragments ) {
		global $woocommerce;
		$settings = array( 'header_cart_link' => 'false', 'nav_rss' => 'false', 'header_cart_total' => 'false' );
		$settings = woo_get_dynamic_values( $settings );

		ob_start();
	?>
	<?php if ( 'true' == $settings['header_cart_total'] ) : ?>
		<a class="cart-contents" href="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>" title="<?php _e('View your shopping cart', 'woothemes'); ?>">
			<?php echo sprintf(_n('%d item', '%d items', WC()->cart->cart_contents_count, 'woothemes'), WC()->cart->cart_contents_count);?> - <?php echo WC()->cart->get_cart_total(); ?>
		</a>
	<?php endif; ?>
	<?php

		$fragments['a.cart-contents'] = ob_get_clean();

		return $fragments;
	} // End woocommerce_header_add_to_cart_fragment()
}

add_action( 'woocommerce_after_cart_totals', 'wooframework_proceed_to_checkout' );
if(!function_exists('wooframework_proceed_to_checkout')) {
	function wooframework_proceed_to_checkout(){ 
		global $woocommerce;  ?>
	 <a href="<?php echo esc_url( WC()->cart->get_checkout_url() ); ?>" class="fr checkout-button button alt"><span><?php _e('Proceed to Checkout &rarr;', 'woothemes'); ?></span></a>
	<?php }

}

/*-----------------------------------------------------------------------------------*/
/* Catalog Image Hover  */
/*-----------------------------------------------------------------------------------*/ 

function woocommerce_image_hover(){
	 	global $woo_options;
	if ( isset($woo_options['woo_enable_imghov']) && $woo_options['woo_enable_imghov'] == 'true' ) {
	 
							 
		// matiin disini
		add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_second_product_thumbnail' , 11 );
		add_filter( 'post_class', 'woocommerce_product_has_gallery' ) ;
	}
 
}
add_action('wp_head', 'woocommerce_image_hover');
  
function woocommerce_product_has_gallery( $classes ) {
	global $product;

	$post_type = get_post_type( get_the_ID() );

	if ( $post_type == 'product' ) {

		$attachment_ids = $product->get_gallery_attachment_ids();

		if ( $attachment_ids ) {
			$classes[] = 'pif-has-gallery';
		}
	}

	return $classes;
}

function woocommerce_template_loop_second_product_thumbnail() {
	global $product, $woocommerce;

	$attachment_ids = $product->get_gallery_attachment_ids();

	if ( $attachment_ids ) {
		$secondary_image_id = $attachment_ids['0'];
		echo wp_get_attachment_image( $secondary_image_id, 'shop_catalog', '', $attr = array( 'class' => 'secondary-image attachment-shop-catalog' ) );
	}
}

/*-----------------------------------------------------------------------------------*/
/* Wishlists Topbar  */
/*-----------------------------------------------------------------------------------*/ 
if ( ! function_exists( 'woo_dahz_get_wishlist' ) ) {
function woo_dahz_get_wishlist() {
		
		global $wpdb, $yith_wcwl, $woocommerce;

		$wishlist_output = "";
				
		if ( is_user_logged_in() ) {
		    $user_id = get_current_user_id();
		}
		
		$count = array();
		
		if( is_user_logged_in() ) {
		    $count = $wpdb->get_results( $wpdb->prepare( 'SELECT COUNT(*) as `cnt` FROM `' . YITH_WCWL_TABLE . '` WHERE `user_id` = %d', $user_id  ), ARRAY_A );
		    $count = $count[0]['cnt'];
		} elseif( yith_usecookies() ) {
		    $count[0]['cnt'] = count( yith_getcookie( 'yith_wcwl_products' ) );
		    $count = $count[0]['cnt'];
		} else {
		    $count[0]['cnt'] = count( $_SESSION['yith_wcwl_products'] );
		    $count = $count[0]['cnt'];
		}
		
		if (is_array($count)) {
			$count = 0;
		}
		$wishlist_output .= '<li class="wishlist-container"><a class="wishlist-link" href="'.$yith_wcwl->get_wishlist_url().'" title="'.__("View your wishlist", "woothemes").'">'.__('Wishlist', 'woothemes') .'<span>'.$count.'</span></a>';
		$wishlist_output .= '<ul class="wishlist-popup">';
		$wishlist_output .= '<li>';
		$wishlist_output .= '<div class="wishlist-bag">';
		
		$current_page = 1;
		$limit_sql = '';
		$count_limit = 0;
		
		if( is_user_logged_in() )
		    { $wishlist = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `" . YITH_WCWL_TABLE . "` WHERE `user_id` = %s" . $limit_sql, $user_id ), ARRAY_A ); }
		elseif( yith_usecookies() )
		    { $wishlist = yith_getcookie( 'yith_wcwl_products' ); }
		else
		    { $wishlist = isset( $_SESSION['yith_wcwl_products'] ) ? $_SESSION['yith_wcwl_products'] : array(); }
						  
     	$wishlist_title = get_option( 'yith_wcwl_wishlist_title' );
		if( !empty( $wishlist_title ) ) {		
		$wishlist_output .= '<p class="wishlist-header">'.$wishlist_title.'</p>';
		}
		$wishlist_output .= '<div id="jp-wishlist-container" class="jp-wishlist-container">';
		$wishlist_output .= '<div class="wishlist-item">';
		
		$wishlist_output .= do_action( 'yith_wcwl_before_wishlist' );
          
        if ( count( $wishlist ) > 0 ) :
           	
           	foreach( $wishlist as $values ) :   
                
                if ($count_limit < 4) {
                
	                if( !is_user_logged_in() ) {
	    				if( isset( $values['add-to-wishlist'] ) && is_numeric( $values['add-to-wishlist'] ) ) {
	    					$values['prod_id'] = $values['add-to-wishlist'];
	    					$values['ID'] = $values['add-to-wishlist'];
	    				} else {
	    					$values['prod_id'] = $values['product_id'];
	    					$values['ID'] = $values['product_id'];
	    				}
	    			}
	                                 
	                $product_obj = get_product( $values['prod_id'] );
	                
	                if( $product_obj !== false && $product_obj->exists() ) : 
	                
	                $wishlist_output .= '<div id="wishlist-'.$values['ID'].'" class="wishlist-product clearfix">';
	                
	                if ( has_post_thumbnail($product_obj->id) ) {
	                	$image_link  		= wp_get_attachment_url( get_post_thumbnail_id($product_obj->id) );                        	
	                	$image = wp_get_attachment_image_src(get_post_thumbnail_id($product_obj->id), array(90,90) );
	                	
	                	if ($image) {
	                		$wishlist_output .= '<a class="wishlist-product-image" href="'.esc_url( get_permalink( apply_filters( 'woocommerce_in_cart_product', $values['prod_id'] ) ) ).'"><img itemprop="image" src="'.$image[0].'" width="'.$image[1].'" height="'.$image[2].'" /></a>';                       
	                	}            			
	                } 
	               		                
	              
	                $wishlist_output .= '<a href="'.esc_url( get_permalink( apply_filters( 'woocommerce_in_cart_product', $values['prod_id'] ) ) ).'">'. apply_filters( 'woocommerce_in_cartproduct_obj_title', $product_obj->get_title(), $product_obj ) .'</a>';
	                
	                if( get_option( 'woocommerce_display_cart_prices_excluding_tax' ) == 'yes' ) {
	                $wishlist_output .= '<div class="price">'.apply_filters( 'woocommerce_cart_item_price_html', woocommerce_price( $product_obj->get_price_excluding_tax() ), $values, '' ).'</div>';
	               	} else {
	               	$wishlist_output .= '<div class="price">'.apply_filters( 'woocommerce_cart_item_price_html', woocommerce_price( $product_obj->get_price() ), $values, '' ).'</div>';
	                }
	                $wishlist_output .= '<div class="clear"></div>';  
	                $wishlist_output .= '</div>';                  
	                
	                endif;
					
					$count_limit++;
				}
								
            endforeach;

        else :
            $wishlist_output .= '<div class="wishlist-empty"><i class="fa fa-magic"></i>'. __( 'Your wishlist is currently empty.', 'woothemes' ) .'</div>';
        endif;
        
        $wishlist_output .= '</div>'."\n".'</div>';

		$wishlist_output .= '<div class="clear"></div>';
		
		$wishlist_output .= '<a href="'.$yith_wcwl->get_wishlist_url().'" class="button wishlist fl"><span>'.__('Browse wishlist', 'woothemes').'</span></a>';
		            	                
		$wishlist_output .= '</div>';
		
		
 		do_action( 'yith_wcwl_after_wishlist' );
 				
		// $wishlist_output .= '</div>';                                                                                                          
		$wishlist_output .= '</li>';
		$wishlist_output .= '</ul>';                                                                                                          
		$wishlist_output .= '</li>'; 
				
		return $wishlist_output;
	}
}

function dahz_wishlist_title(){
	$page_title = get_option('yith_wcwl_wishlist_title');

	echo '<h4>'.$page_title.'</h4>';
}
add_filter('yith_wcwl_wishlist_title', 'dahz_wishlist_title');
/*-----------------------------------------------------------------------------------*/
/* Wishlists button  */
/*-----------------------------------------------------------------------------------*/ 
function dahz_wishlist_button() {
	
		global $product, $yith_wcwl; 
		
		if ( class_exists( 'YITH_WCWL_UI' ) )  {
			$url = $yith_wcwl->get_wishlist_url();
			$product_type = $product->product_type;
			$exists = $yith_wcwl->is_product_in_wishlist( $product->id );
			
			$classes = get_option( 'yith_wcwl_use_button' ) == 'yes' ? 'class="add_to_wishlist single_add_to_wishlist button alt"' : 'class="add_to_wishlist"';
			
			$html  = '<div class="yith-wcwl-add-to-wishlist add-to-wishlist-'. $product->id .'">'; 
			    $html .= '<div class="yith-wcwl-add-button';  // the class attribute is closed in the next row
			    
			    $html .= $exists ? ' hide" style="display:none;"' : ' show"';
			    
			    $html .= '><a href="' . htmlspecialchars($yith_wcwl->get_addtowishlist_url()) . '" data-product-id="' . $product->id . '" data-product-type="' . $product_type . '" ' . $classes . ' >'.__('Add To Wishlist', 'woothemes').'</a>';
			    $html .= '</div>';
			
			$html .= '<div class="yith-wcwl-wishlistaddedbrowse hide" style="display:none;"><span class="feedback">' . __( 'added to wishlist.', 'woothemes' ) . '</span> <a href="' . $url . '"><i class="fa fa-ok"></i></a></div>';
			$html .= '<div class="yith-wcwl-wishlistexistsbrowse ' . ( $exists ? 'show' : 'hide' ) . '" style="display:' . ( $exists ? 'block' : 'none' ) . '"><a href="' . $url . '"><i class="fa fa-ok"></i></a></div>';
			$html .= '<div style="clear:both"></div><div class="yith-wcwl-wishlistaddresponse"></div>';
			
			$html .= '</div>';
			
			return $html;
			
		}
	
}