<?php
/**
 * Single Portfolio Item Template
 *
 * This template is the default portfolio item template. It is used to display content when someone is viewing a
 * singular view of a portfolio item ('portfolio' post_type).
 * @link http://codex.wordpress.org/Post_Types#Post
 *
 * @package WooFramework
 * @subpackage Template
 */

get_header();
global $woo_options, $more;
$more = 0;
wp_enqueue_script( 'owlcarousel' );
wp_enqueue_script( 'owl-main' );
$post_settings = woo_portfolio_item_settings( $post->ID );
       
    // content Starts
	woo_content_before(); ?>
    <div id="content" class="col-full">
    	<div id="main-sidebar-container">    
            <!-- #main Starts -->
            <?php woo_main_before(); ?>
			<section id="main">                       
	  <?php woo_loop_before();
			$layout = get_post_meta($post->ID, "style_single_port", true); 

			if ($layout== '1'){ ?> <!-- start if layout -->
				<div class="top-single-portfolio">
					<h1 class="title"><?php the_title(); ?></h1>
				</div>
			<?php if ( have_posts() ) { $count = 0;
					while ( have_posts() ) { the_post(); $count++;
						$portfolio_images = get_post_meta($post->ID, 'portfolio_meta_slider');
						$images_count = count($portfolio_images);
					echo "<div class='media-single-port'>";
					if($images_count > 0) {
					echo "<div id='post-gallery' class='portfolio-img'>
    						<div class='owl-container-porfolio'>";
						foreach($portfolio_images as $image) {
								echo wp_get_attachment_image($image, 'full', false, array( 'class' => 'photo' ));
						} 
				echo "</div></div>";
			}
			/* If we don't have a gallery and don't have a video embed code. */
			else if ($post_settings['enable_gallery'] == 'false') {
				
				if (has_post_thumbnail()) {
				echo '<div id="post-gallery-ver2" class="portfolio-img">';
					the_post_thumbnail('full'); 
				echo '</div><!--/#post-gallery .portfolio-img-->' . "\n";
				}
			}

			/* If we have a video embed code. */
			if ( $post_settings['embed'] != '' ) {
				canvas_get_embed(); }
			echo "</div>";?>

			<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	    	<section class="entry">
				<h3 class="port_title"><?php _e( 'Description',  'woothemes' );  ?></h3>
		    	<?php the_content(); 
				$testimonial = get_post_meta($post->ID, 'testimonial', true); 	
				$testimonial_auth = get_post_meta($post->ID, 'testimonial_author', true); 	
				$html = '';
				if ( $testimonial != '' ) { 
					$html .= '<blockquote class="blk2">' . $testimonial . '</blockquote>' . "\n"; 
				} // End IF Statement

				if ( $testimonial_auth != '' ) {
					$html .= '<cite class="portsite">' . $testimonial_auth . "\n";
					$html .= '</cite>' . "\n";
				} // End IF Statement 

				echo $html;
			/* Portfolio item extras (testimonial, website button, etc). */
			woo_portfolio_item_extras( $post_settings ); ?>
   		</section><!--/.entry-->
   	</div><!--/#post-->
<?php	
		}
	}
	woo_loop_after();
} if ($layout== '2'){?> <!-- end if start else-->
	 
	<div class="top-single-portfolio">
		<h1 class="title"><?php the_title(); ?></h1>
	</div>
	<?php 
	if ( have_posts() ) { $count = 0;
		while ( have_posts() ) { the_post(); $count++;
			$portfolio_images = get_post_meta($post->ID, 'portfolio_meta_slider');
			$images_count = count($portfolio_images);
			if($images_count > 0) {
				echo "<div id='post-gallery-ver2' class='portfolio-img'>
						<div class='owl-container-porfolio'>";
				foreach($portfolio_images as $image) { 	
					 echo wp_get_attachment_image($image, 'full', false, array( 'class' => 'photo' ));
				} 
				echo "</div></div>";
			}
			/* If we have a video embed code. */
			else if ( $post_settings['embed'] != '' ) {
				echo '<div class="embed-post-2">';
				canvas_get_embed();
				echo "</div>";
			}
			/* If we don't have a gallery and don't have a video embed code. */
			else  if ( $post_settings['enable_gallery'] == 'false' ) {
				if (has_post_thumbnail()) {
				echo '<div id="post-gallery-ver2" class="portfolio-img">';
					the_post_thumbnail('full'); 
				echo '</div><!--/#post-gallery .portfolio-img-->' . "\n";
				}

			} ?>

	<section class="entry">	
		<div class="port-des-ver2">
			<div class="port-des">
				<h3 class="port_title"><?php _e( 'Description',  'woothemes' );  ?> </h3>
		    	<?php the_content(); 
					$testimonial = get_post_meta($post->ID, 'testimonial', true); 	
					$testimonial_auth = get_post_meta($post->ID, 'testimonial_author', true); 	
					$html = '';
					if ( $testimonial != '' ) { 
						$html .= '<blockquote class="blk2">' . $testimonial . '</blockquote>' . "\n"; 
					} // End IF Statement
					if ( $testimonial_auth != '' ) {
						$html .= '<cite class="portsite">' . $testimonial_auth . "\n";
						$html .= '</cite>' . "\n";
					} // End IF Statement 
					echo $html;
				?>
		    </div>
		    <div class="port-ex">
				<?php
					/* Portfolio item extras (testimonial, website button, etc). */
					woo_portfolio_item_extras( $post_settings );
				?>
			</div>
	   	</div><!--/#post-->
	</section><!--/.entry-->

<?php	
		}
	}
	woo_loop_after();
} // end layout 2

if ($layout== '3') { ?> <!-- end if start else-->
	<div class="top-single-portfolio">
		<h1 class="title"><?php the_title(); ?></h1>
	</div>
	<?php 
	if ( have_posts() ) { $count = 0;
		while ( have_posts() ) { the_post(); $count++;
			$portfolio_images = get_post_meta($post->ID, 'portfolio_meta_slider');
			$images_count = count($portfolio_images);
			if($images_count > 0) {
				echo "<div id='post-gallery-ver2' class='portfolio-img port-full'>
					  		<div class='owl-container-porfolio'>";
					foreach($portfolio_images as $image) { 	
						echo wp_get_attachment_image($image, 'full', false, array( 'class' => 'photo' ));
					} 
				echo "</div></div>";
			}
			/* If we have a video embed code. */
			else if ( $post_settings['embed'] != '' ) {
				echo '<div id="video-single-porfolio" class="port-full-video">'; 
				canvas_get_embed();
				echo '</div>'; 
			}
			/* If we don't have a gallery and don't have a video embed code. */
			else  if ( $post_settings['enable_gallery'] == 'false' ) {
				if (has_post_thumbnail()) {
				echo '<div id="post-gallery-ver2" class="portfolio-img port-full">';
					the_post_thumbnail('full'); 
				echo '</div><!--/#post-gallery .portfolio-img-->' . "\n";
				}
			} ?>
	<section class="entry">	
		<div class="port-des-ver2">
			<div class="port-des">
				<h3 class="port_title"><?php _e( 'Description',  'woothemes' ); ?></h3>
		    	<?php the_content();
				$testimonial = get_post_meta($post->ID, 'testimonial', true); 	
				$testimonial_auth = get_post_meta($post->ID, 'testimonial_author', true); 	
				$html = '';
				if ( $testimonial != '' ) { 
					$html .= '<blockquote class="blk2">' . $testimonial . '</blockquote>' . "\n"; 
				} // End IF Statement
				if ( $testimonial_auth != '' ) {
					$html .= '<cite class="portsite">' . $testimonial_auth . "\n";
					$html .= '</cite>' . "\n";
				} // End IF Statement 
				echo $html; ?>
		    </div>
		    <div class="port-ex">
			<?php
				/* Portfolio item extras (testimonial, website button, etc). */
				woo_portfolio_item_extras( $post_settings );
			?>
			</div>
	   	</div><!--/#post-->
	</section><!--/.entry-->
<?php	
		}
	}
	woo_loop_after();
} // end else layout 3
  if ($layout== '4'){ ?> <!-- end if start else-->
	<div class="top-single-portfolio">
		<h1 class="title"><?php the_title(); ?></h1>
	</div>
	<?php if ( have_posts() ) { $count = 0;
			while ( have_posts() ) { the_post(); $count++; ?>
		    	<section class="entry">	
					<?php the_content(); ?>
		   		</section><!--/.entry-->
<?php	
			}
		}
	woo_loop_after(); } ?><!-- end else -->
<div class="end-portfolio"></div>

<?php
if ( $woo_options['woo_rel_proj'] == 'true' ) { 
	$term_list = wp_get_post_terms($post->ID, 'portfolio-gallery', array("fields" => "names"));
 
	$args = array(
	    'post_type' => 'portfolio',
	    'post_status' => 'publish',
	    'tax_query' => array(
	        array(
	            'taxonomy' => 'portfolio-gallery',
	            'field' => 'slug',
	            'terms' => $term_list
	        )
	    )
	);
	$my_query = new WP_Query( $args );

	if( $my_query->have_posts() ) { /*start if*/ ?>
		<div id="portfolio">
			<h3 class="port_title"><?php _e( 'Related Project', 'woothemes' ); ?></h3>
			<div class="clear"></div>
			<div class="portfolio-items portfolio">
			 
			<?php while( $my_query->have_posts() ) {/*start loop*/
					$my_query->the_post(); 

					/* Get the settings for this portfolio item. */
					$settings = woo_portfolio_item_settings( $post->ID );

					/* If the theme option is set to link to the single portfolio item, adjust the $settings. */
					if ( isset( $woo_options['woo_portfolio_linkto'] ) && ( $woo_options['woo_portfolio_linkto'] == 'post' ) ) {
						$settings['large'] = get_permalink( $post->ID );
						$settings['rel'] = '';
					} ?>
        	<div  >
			<?php
				/* Setup image for display and for checks, to avoid doing multiple queries. */
	 
				if ( has_post_thumbnail( ) ) { ?>
					<div class="view view-sixth banner">
						<?php 
							the_post_thumbnail('thumbnail-lookbook-land');

						?>
						<div class="mask-blog">
						    <div class="overlay-blog custom_back"></div>
					    </div>
     			<div class="borderbanner-blog custom_bor">
						       <span>
										
						<?php 
			 
							echo '<a href="'.get_permalink( $post->ID ).'" class="thumb">';
							_e( 'READ MORE',  'woothemes' ); 
							echo '</a>';

						?>
						 			 </span>
					    </div>
					</div>
					<span class="category-portfolio"><?php echo get_the_term_list( $post->ID, 'portfolio-gallery', '', ', '); ?></span>
					<h3 class="port_title"><a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
				<?php
					// Output image gallery for lightbox
	            	if ( ! empty( $settings['gallery'] ) ) {
	                	foreach ( array_slice( $settings['gallery'], 1 ) as $img => $attachment ) {
	                		echo '<a ' . $settings['rel'] . ' title="' . $attachment['caption'] . '" href="' . $attachment['url'] . '" class="gallery-image"><img src="' . esc_url( $attachment['url'] ) . '" alt="' . esc_attr( $attachment['alt'] ) . '"/></a>' . "\n";	                    
	                	}
	                }
				} // End IF Statement ?>
			</div><!--/.group .post .portfolio-img--> 
<?php }/*end loop*/	}/*end if*/	?>

</div><!--/.portfolio-items-->
</div><!--/#portfolio-->

<?php } ?>
</section><!-- /#main -->
        <?php woo_main_after(); 

        get_sidebar(); ?>

		</div><!-- /#main-sidebar-container -->         

		<?php get_sidebar( 'alt' ); ?>

    </div><!-- /#content -->
	<?php woo_content_after(); ?>

<?php get_footer(); ?>