<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive.
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

get_header('shop'); ?>

	<?php
		/**
		 * woocommerce_before_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		do_action('woocommerce_before_main_content');
	?>

	<?php
	global $wp_query, $woo_options;
	
       	$cat = $wp_query->get_queried_object();
       	if(is_product_category() ){
           			$thumbnail_id = get_woocommerce_term_meta( $cat->term_id, 'thumbnail_id', true );
            			$image = wp_get_attachment_url( $thumbnail_id );
     		} else {
   		if( isset( $woo_options['woo_headbanner_shop'] ) && $woo_options['woo_headbanner_shop'] == 'true' &&  !is_product_category() || !is_product_tag()  )  {
	           		$image = $woo_options['woo_headbanner_shop'];
     		   }
     		}

      	if($image && $image !=''){
            ?> <img class="shop-banner" src="<?php echo $image ?>" /> <?php
        		}    ?>

	    <?php do_action( 'woocommerce_archive_description' ); ?>

		<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>

			<header id="product-archive">
			 <h1 class="page-title"><span><?php woocommerce_page_title(); ?></span></h1>
			</header>

		<?php endif; ?>

		<?php if ( have_posts() ) : ?>

			<?php
				/**
				 * woocommerce_before_shop_loop hook
				 *
				 * @hooked woocommerce_result_count - 20
				 * @hooked woocommerce_catalog_ordering - 30
				 */
				do_action( 'woocommerce_before_shop_loop' );
			?>
			
			<?php woocommerce_product_loop_start(); ?>

				<?php woocommerce_product_subcategories(); ?>

				<?php while ( have_posts() ) : the_post(); ?>

					<?php woocommerce_get_template_part( 'content', 'product' ); ?>

				<?php endwhile; // end of the loop. ?>

			<?php woocommerce_product_loop_end(); ?>

			<?php
				/**
				 * woocommerce_after_shop_loop hook
				 *
				 * @hooked woocommerce_pagination - 10
				 */
				do_action( 'woocommerce_after_shop_loop' );
			?>

		<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

			<?php wc_get_template( 'loop/no-products-found.php' ); ?>

		<?php endif; ?>

	<?php
		/**
		 * woocommerce_after_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action('woocommerce_after_main_content');
	?>

	<?php
		/**
		 * woocommerce_sidebar hook
		 *
		 * @hooked woocommerce_get_sidebar - 10
		 */
		do_action('woocommerce_sidebar');
	?>

<?php get_footer('shop'); ?>