<?php
/**
 * Pagination - Show numbered pagination for catalog pages.
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.2.2
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $wp_query;

if ( ! woocommerce_products_will_display() )
	    return;

if ( $wp_query->max_num_pages <= 1 )
	return;
?>
<nav class="woo-pagination">
	<?php
		echo paginate_links( apply_filters( 'woocommerce_pagination_args', array(
			'base'         => esc_url( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
			'format'       => '',
			'current'      => max( 1, get_query_var( 'paged' ) ),
			'total'        => $wp_query->max_num_pages,
			'prev_text'    => '<i class="fa fa-caret-left"></i>',
			'next_text'    => '<i class="fa fa-caret-right"></i>',
			'type'         => 'plain',
			'end_size'     => 3,
			'mid_size'     => 3
		) ) );
	?>
</nav>