<?php
/**
 * Simple product add to cart
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $product, $woo_options;

if ( ! $product->is_purchasable() ) return;
?>

<?php
	// Availability
	// $availability = $product->get_availability();

	// if ($availability['availability']) :
	// 	echo apply_filters( 'woocommerce_stock_html', '<p class="stock ' . esc_attr( $availability['class'] ) . '">' . esc_html( $availability['availability'] ) . '</p>', $availability['availability'] );
 //    endif;
?>

<?php if ( $product->is_in_stock() ) : ?>

	<?php do_action('woocommerce_before_add_to_cart_form'); ?>

	<form <?php if( is_product() && $woo_options['woo_atc_ajax'] == 'true' ) { echo 'action="'.esc_url( $product->add_to_cart_url() ). '"'; } ?> id="simple-product-form" class="cart" method="post" enctype='multipart/form-data'>

	 	<?php do_action('woocommerce_before_add_to_cart_button'); ?>

	 	<?php
	 		if ( ! $product->is_sold_individually() )
	 			woocommerce_quantity_input( array(
	 				'min_value' => apply_filters( 'woocommerce_quantity_input_min', 1, $product ),
	 				'max_value' => apply_filters( 'woocommerce_quantity_input_max', $product->backorders_allowed() ? '' : $product->get_stock_quantity(), $product )
	 			) );
	 	?>
		<input type="hidden" name="add-to-cart" id="simple-product-id" value="<?php echo esc_attr( $product->id ); ?>"> 
	 	<button data-quantity="1" type="submit" class="single_add_to_cart_button button alt <?php if( is_product() && $woo_options['woo_atc_ajax'] == 'true' ){?> dt-simple-product <?php } ?>"><?php echo $product->single_add_to_cart_text(); ?></button>
	 	<?php do_action('woocommerce_after_add_to_cart_button'); ?>

	</form>

	<?php do_action('woocommerce_after_add_to_cart_form'); ?>

<?php endif; ?>