<?php
/**
 * Plugin Name: Dahz DF Shortcodes
 * Plugin URL: http://dahztheme.com/
 * Description:  Extensible shortcodes functionality for LaBomba theme and plugins ( strongly required ).
 * Version: 1.4.0
 * Author: Dahz
 * Author URI: http://dahztheme.com/
 */

// Define Constants
// =============================================================================

define( 'DF_SHORTCODES_URL',  trailingslashit( plugins_url( '', __FILE__ ) ) );
define( 'DF_SHORTCODES_PATH', trailingslashit( plugin_dir_path( __FILE__ ) ) );

if ( ! class_exists( 'df_Shortcodes' ) ) :

   class df_Shortcodes {

   	/* ============================= */
      /* Front-end Scripts & Styles    */
      /* ============================= */
   	function df_shortcodes_enqueue_styles() {
   		if( ! is_admin() ) :
   			wp_register_style( 'df-shortcodes-style', DF_SHORTCODES_URL . 'assets/css/shortcodes.min.css', NULL, '25042014' );
   			wp_enqueue_style( 'df-shortcodes-style' );
   		endif;
   	}

      function df_shortcodes_enqueue_scripts() {
         if( ! is_admin() ) :
            wp_register_script( 'gmaps', 'http://maps.google.com/maps/api/js?sensor=false', array( 'jquery' ), '', true );
            wp_register_script( 'df-shortcodes-script', DF_SHORTCODES_URL . 'assets/js/shortcodes.min.js', array( 'jquery' ), '25042014', true );
            wp_enqueue_script( 'df-shortcodes-script' );
         endif;
      }


   	function df_shortcodes_init() {
         require_once DF_SHORTCODES_PATH . 'shortcodes/shortcodes.php';
         require_once DF_SHORTCODES_PATH . '/vc-mod/vc_mod-setup.php';
   	}

   	/* ============================= */
      /* Add Admin Shortcode Button    */
   	/* ============================= */
      function df_shortcodes_init_button() {
         global $pagenow;

         if ( (current_user_can('edit_posts') &&  current_user_can('edit_pages') ) && get_user_option( 'rich_editing' ) == 'true' && ( in_array( $pagenow, array( 'post.php', 'post-new.php', 'page-new.php', 'page.php' ) ) ) ) {
            add_filter( 'mce_external_plugins', array( &$this, 'df_shortcodes_plugin' ) );
            add_filter( 'mce_buttons',          array( &$this, 'df_shortcodes_register_button' ) );
         }
      }

      function df_shortcodes_plugin( $plugin_array ) {
         $plugin_array['DahzThemeShortcodes'] = DF_SHORTCODES_URL .'assets/js/admin/tinymce.min.js';

         return $plugin_array;
      }

      function df_shortcodes_register_button( $buttons ) {
         array_push( $buttons, 'DahzThemeShortcodes' );

         return $buttons;
      }

      /* ============================= */
      /* Builder Shortcode Function    */
      /* ============================= */
   	function __construct() {
         add_action( 'wp_enqueue_scripts', array( &$this, 'df_shortcodes_enqueue_styles' ) );
         add_action( 'wp_enqueue_scripts', array( &$this, 'df_shortcodes_enqueue_scripts' ) );
   		add_action( 'init', array( &$this, 'df_shortcodes_init' ) );
   		add_action( 'init', array( &$this, 'df_shortcodes_init_button' ) );
   	}

   }

endif;

$df_shortcodes = new df_Shortcodes; // Start an instance of the plugin class