<?php
/*-----------------------------------------------------------------------------------*/
/* 3. Buttons - button
/*-----------------------------------------------------------------------------------*/
/*

Optional arguments:
 - size: small, large
 - style: info, alert, tick, download, note
 - color: red, green, black, grey OR custom hex color (e.g #000000)
 - border: border color (e.g. red or #000000)
 - text: black (for light color background on button)
 - class: custom class
 - link: button link (e.g http://www.woothemes.com)
 - window: true/false
*/
function df_shortcode_button( $atts, $content = null ) {
	extract( shortcode_atts( array(
        'size' 		=> '',
        'style' 	=> '',
        'bg_color'  => '',
        'color' 	=> '',
        'border' 	=> '',
        'text' 		=> '',
        'class' 	=> '',
        'link' 		=> '',
        'window' 	=> ''
	), $atts ) );


   	// Set custom background and border color
   	$color_output = '';
   	if ( $bg_color ) {
   		$preset_colors = array( 'red', 'orange', 'green', 'aqua', 'teal', 'purple', 'pink', 'silver', 'brown', 'gold' );
   		if ( in_array( $color, $preset_colors ) ) {
	   		$class .= ' ' . $bg_color;
   		} else {
		   	if ( $border ){
		   		$border_out = $border;
		   	} else {
		   		$border_out = $bg_color;
		   	}

	   		$color_output = 'style="color:' . $color . '!important;background:' . esc_attr( $bg_color ) . ';border:1px solid ' . esc_attr( $border_out ) . '"';

	   		// add custom class
	   		$class .= ' custom';
   		}
   	} else {
   		if ( $border )
		   		$border_out = $border;
		   	else
		   		$border_out = $bg_color;

	   		$color_output = 'style="color:' . $color . '!important;background:' . esc_attr( $bg_color ) . ';border:1px solid ' . esc_attr( $border_out ) . '"';

	   		// add custom class
	   		$class .= ' custom';
   	}

	$class_output = '';

	// Set text color
	if ( $text ) $class_output .= ' dark';
	// Set class
	if ( $class ) $class_output .= ' '.$class;
	// Set Size
	if ( $size ) $class_output .= ' '.$size;
	// Set window target
	if ( $window == 'false' ) $window = 'target="_blank" ';

   	$output = '<a ' . $window . 'href="' . esc_attr( esc_url( $link ) ) . '" class="woo-sc-button' . esc_attr( $class_output ) . '" ' . $color_output . '><span class="woo-' . esc_attr( $style ) . '">' . wp_kses_post( do_shortcode( $content ) ) . '</span></a>';
   	return $output;
} // End woo_shortcode_button()

add_shortcode( 'button', 'df_shortcode_button' );