<?php
/**
  * 13. list
  *
  * Show the list
  *
  * @example
  * [list][list_item icon="icon-heart"]1[/list_item][list_item icon="icon-eye-close"]2[/list_item][list_item icon="ico-facebook"]3[/list_item][/list]
  *
  *[list type="vertical" border_color="#dbdbdb" border="1px" border_style="solid none solid none"][list_item_ver icon="icon-heart"]30 days return[/list_item_ver][list_item_ver icon="icon-bar-chart"]Design in Germany[/list_item_ver][list_item_ver icon="icon-eye-close"]Free shipping Worldwide[/list_item_ver][list_item_ver icon="ico-facebook"]Secure payment[/list_item_ver][/list]
  *
  *[list type="vertical" border_color="#dbdbdb" border="1px" border_style="solid"][list_item_ver separator="true" icon="none"]30 days return[/list_item_ver][list_item_ver separator="true" icon="none"]Design in Germany[/list_item_ver][list_item_ver separator="true" icon="none"]Free shipping Worldwide[/list_item_ver][list_item_ver icon="none"]Secure payment[/list_item_ver][/list]
**/

function df_list_style_sc( $atts, $content = null ) {

    extract( shortcode_atts( array(
        'type'         => '',
        'border_color' => '',
        'border'       => '',
        'border_style' => ''
    ), $atts ) );

    $out = '<ul class="styled-list ' . $type . '" style="border:' . $border . ';border-style:' . $border_style . ';border-color:' . $border_color . '">' . do_shortcode( $content ) . '</ul>';

    return $out;
}
add_shortcode( 'list', 'df_list_style_sc' );
/*-----------------------------------------------------------------------------------*/

function df_item_list_ver_sc( $atts, $content = null ) {

    extract( shortcode_atts( array(
        'icon'            => 'icon-ok',
        'separator'       => 'false',
        'separator_color' => '#dbdbdb'
    ), $atts ) );

    if ( $separator == 'true' ) {
        $out = '<li class="ver" style="border-right:1px solid ' . $separator_color . '"><i class="' . $icon . '"></i>' . do_shortcode( $content ) . '</li>';
    } else {
        $out = '<li class="ver"><i class="' . $icon . '"></i>' . do_shortcode( $content ) . '</li>';
    }

    return $out;
}
add_shortcode( 'list_item_ver', 'df_item_list_ver_sc' );

/*-----------------------------------------------------------------------------------*/

function df_item_list_sc( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'icon' => 'icon-ok'
    ), $atts ) );

    $out = '<li><i class="' . $icon . '"></i>' . do_shortcode( $content ) . '</li>';

    return $out;
}
add_shortcode( 'list_item', 'df_item_list_sc' );