<?php
/**
  *
  * Show the Member
  *
  * @example
  * [member name="Your Name" role="Role" img="you image" twitter="your twitter account" facebook="your facebook account" google="your google account" tumblr="your tumblr account" mail="yourmail]your content[/member]
  *
**/
/*-----------------------------------------------------------------------------------*/
/*  Member
/*-----------------------------------------------------------------------------------*/

function df_member_sc( $atts, $content = null ) {

    $output_img = $output_img_el = '';

    extract( shortcode_atts( array(
        'img'      => '',
        'name'     => '',
        'role'     => '',
        'twitter'  => '',
        'facebook' => '',
        'google'   => '',
        'tumblr'   => '',
        'mail'     => '',
        'target'   => '_self',
        'back'     => '#000',
        'color'    => '#fff',
    ), $atts ) );

    $img = explode( ',', $img ); $i = -1;

    foreach ( $img as $attach_id ) : $i++;
        $image_src   = wp_get_attachment_image_src( $attach_id, 'thumbnail-sc-blog' );
        $output_img .= esc_url( $image_src[0] );
    endforeach;

    $return = $output_img == '' ? '<img src="' . esc_url( get_template_directory_uri() . '/images/dummy/member.jpg' ) . '">' : '<img src="' . $output_img . '" />';

    if ( $twitter != '' || $facebook != '' || $google != '' || $tumblr != '' || $mail != '' ) :
        $return7 = '<div class="member-social"><ul>';
        $return8 = '</ul></div>';

        if ( $twitter != '' ) {
            $return2 = '<li style="background-color:' . $back . '"><a href="' . esc_url( $twitter ) . '" class="ico-twitter" target="' . esc_attr( $target ) . '" title="Twitter" style="color:' . $color . '"></a></li>';
        } else {
            $return2 = '';
        }

        if ( $facebook != '' ) {
            $return3 = '<li style="background-color:' . $back . '"><a href="' . esc_url( $facebook ) . '" target="' . esc_attr( $target ) .'"class="ico-facebook" title="Facebook" style="color:' . $color . '"></a></li>';
        } else {
            $return3 = '';
        }

        if ( $google != '' ) {
            $return4 = '<li style="background-color:' . $back . '"><a href="' . esc_url( $google ) . '" target="' . esc_attr( $target ) . '" class="ico-google-plus" title="Google+" style="color:' . $color . '"></a></li>';
        } else {
            $return4 = '';
        }

        if ( $tumblr != '' ) {
            $return5 = '<li style="background-color:' . $back . '"><a href="' . esc_url( $tumblr ) . '" target="' . esc_attr( $target ) . '" class="ico-tumblr" title="Tumblr" style="color:' . $color . '"></a></li>';
        } else {
            $return5 = '';
        }

        if ( $mail != '' ) {
            $return6 = '<li style="background-color:' . $back . '"><a href="mailto:' . esc_url( $mail ) . '" class="ico-mail" title="Mail" style="color:' . $color . '"></a></li>';
        } else {
            $return6 = '';
        }

    else :
        $return2 = '';
        $return3 = '';
        $return4 = '';
        $return5 = '';
        $return6 = '';
        $return7 = '';
        $return8 = '';
    endif;

      return '<div class="member"><div class="member-image">' . $return . '</div>
        <h3 class="title-sc member-name">' . $name . '</h3>
        <p>' . $role . '</p><p>' . do_shortcode( $content ) . '</p>' . $return7 . '' . $return6 . '' . $return2 . '' . $return3 . '' . $return4 . '' . $return5 . '' . $return8 . '</div>';
}

add_shortcode( 'member', 'df_member_sc' );