<?php
/**
 **
 *
 *  1. Services
 *
 * @example
 *
 *    [our_services icon="First Image URL" style="style1/style2" title="First Item Title" link_name="" link_url="" align="" title=""]
 *   Description Goes Here
 *    [/our_services]
**/
// [our_services]
function df_our_services( $params = array(), $content = null ) {
    $our_services = '';

    extract( shortcode_atts( array(
        'icon'          => '',
        'version'       => '1',
        'link_name'     => '',
        'link_url'      => '',
        'style'         => 'style1',
        'target'        => '_self',
        'link_color'    => '',
        'border_color'  => '#dbdbdb',
        'align'         => 'left',
        'title'         => 'title',
        'button'        => 'false',
        'icon_color'    => '',
        'icon_bg'       => '',
    ), $params ) );

    $content = do_shortcode( $content );

    $but = $button == 'true' ? '<a href="' . $link_url . '" target="' . $target . '" style="color:' . $link_color . '" >' . $link_name . '</a>' : '';

    if ( $version == '3' ) :
        $our_services .= '<div class="shortcode_our_services3" style="border-color:' . $border_color . ';text-align:' . $align . '">';
        $our_services .= '<div class="shortcode_our_services_icon3">';
        $our_services .= '<div class="shortcode_our_services_icon3_in" style="background:' . $icon_bg . ';">';
        $our_services .= '<em class="' . $icon . '" style="color:' . $icon_color . ';"></em>';
        $our_services .= '</div>';
        $our_services .= '</div>';
        $our_services .= '<div class="shortcode_our_services_content3">';
        $our_services .= '<h2 class="title-sc">' . $title . '</h2>';
        $our_services .= '<p>' . $content . '</p>' . $but . '</div>';
        $our_services .= '</div>';
    elseif ( $version == '1' ) :
        $our_services .= '<div class="shortcode_our_services" style="text-align:' . $align . '">';
        $our_services .= '<div class="shortcode_our_services_icon">';
        $our_services .= '<div class="' . $style . '" style="background:' . $icon_bg . ';">';
        $our_services .= '<em class="' . $icon . ' " style="color:' . $icon_color . '"></em>';
        $our_services .= '</div>';
        $our_services .= '</div>';
        $our_services .= '<div class="shortcode_our_services_content">';
        $our_services .= '<h2 class="title-sc">' . $title . '</h2>';
        $our_services .= '<p>' . $content . '</p>' . $but . '</div>';
        $our_services .= '</div>';
    else :
        $our_services .= '<div class="shortcode_our_services2" style="text-align:' . $align . '">';
        $our_services .= '<div class="shortcode_our_services_icon2">';
        $our_services .= '<em class="' . $icon . '" style="color:' . $icon_color . '" ></em>';
        $our_services .= '</div>';
        $our_services .= '<div class="shortcode_our_services_content2">';
        $our_services .= '<h2 class="title-sc">' . $title . '</h2>';
        $our_services .= '<p>' . $content . '</p>';
        $our_services .= '<br />';
        $our_services .= '</div>' . $but . '</div>';
    endif;

    return $our_services;
}
add_shortcode("our_services", "df_our_services");


/**
 *
 *  2. Services list
 *
 * @example
 *
 *    [our_services_list icon="First Image URL" title="First Item Title" link_name="" link_url="" ]
 *   Description Goes Here
 *    [/our_services_list]
**/

function df_our_services_list( $params = array(), $content = null ) {
    $our_services_list = '';

    extract( shortcode_atts( array(
        'icon'       => '',
        'icon_color' => '',
        'title'      => '',
    ), $params ) );

    $content = do_shortcode( $content );

    $our_services_list .= '<div class="shortcode_our_services_list">';
    $our_services_list .= '<div class="shortcode_our_services_icon_list">';
    $our_services_list .= '<em class="' . $icon . '" style="color:' . $icon_color . '"></em>';
    $our_services_list .= '<span style="color:' . $icon_color . '">' . $title . '</span>';
    $our_services_list .= '</div>';
    $our_services_list .= '<div class="shortcode_our_services_p_list">';
    $our_services_list .= '<p>' . $content . '</p>';
    $our_services_list .= '</div>';
    $our_services_list .= '</div>';

    return $our_services_list;
}

add_shortcode( 'our_services_list', 'df_our_services_list' );