<?php

/**
  *  Dropcap
  *
  * Show the Dropcap
  *
  * @example
  * [dropcap_sty] Your content[/dropcap_sty]
  * [dropcap_sty color="#fff" back="#000"] Your content[/dropcap_sty]
**/

function df_dropcap_sty( $atts, $content = null ) {

    extract( shortcode_atts( array(
        'back'        => '',
        'color'       => '',
        'font_weight' => 'normal'
    ), $atts ) );

    if ( $back != '' ) {
        return '<span class="dropcap2" style="color:' . $color . '; background-color:' . $back . ';padding:5px;font-weight:' . $font_weight . ' ">' . do_shortcode( $content ) . '</span>';
    }
    return '<span class="dropcap2" style="color:' . $color . ';font-weight:' . $font_weight . '">' . do_shortcode( $content ) . '</span>';
} // End woo_shortcode_dropcap()

add_shortcode( 'dropcap_sty', 'df_dropcap_sty' );



/**
  * 15. Highlight
  *
  * Show the Highlight
  *
  * @example
  *  [highlight_sty back="#000" color="#fff"]Your content[/highlight_sty]
  *
**/

function df_highlight_sty ( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'back'  => '',
        'color' => ''
    ), $atts ) );

    return '<span class="shortcode-highlight" style="background-color:' . $back . ';color:' . $color . ';">' . do_shortcode( $content ) . '</span>';
} // End df_shortcode_highlight()

add_shortcode( 'highlight_sty', 'df_highlight_sty' );

/**
  * 16. Blockquotes
  *
  * Show the Blockquotes
  *
  * @example
  *  [blockquote_sty]Your content[/blockquote_sty]
  *  [blockquote_sty ver="2"]Your content[/blockquote_sty]
**/
function df_blockquote_sty( $atts, $content = null ) {

    extract( shortcode_atts( array(
        'size'  => '4px',
        'color' => '',
        'ver'   => '1',
    ), $atts ) );

    if ( $ver == '2' ) :
        return '<blockquote class="blk2" style="border-left:' . $size . ' solid ' . $color . ';">' . do_shortcode( $content ). '</blockquote>';
    else :
        return '<blockquote class="blk">' . do_shortcode( $content ) . '</blockquote> ';
    endif;
}

add_shortcode( 'blockquote_sty', 'df_blockquote_sty' );